# generated with Databricks CLI Version: Databricks CLI v0.228.0
# generated by datamodel-codegen:
#   filename:  transformed_schema.json

from __future__ import annotations

from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, Field, constr, InstanceOf
from typing_extensions import Literal


class Files(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    source: str


class Artifacts(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    build: Optional[str] = None
    executable: Optional[str] = None
    files: Optional[List[Files]] = None
    path: Optional[str] = None
    type: str


class DeploymentLock(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    enabled: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = None
    force: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = None


class Deployment(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    fail_on_active_runs: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = None
    lock: Optional[DeploymentLock] = None


class Git(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    branch: Optional[str] = None
    origin_url: Optional[str] = None


class Bundle(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    compute_id: Optional[str] = None
    databricks_cli_version: Optional[str] = None
    deployment: Optional[Deployment] = None
    git: Optional[Git] = None
    name: str


class ExperimentalPydabs(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    enabled: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = None
    import_: Optional[List[str]] = Field(None, alias='import')
    venv_path: Optional[str] = None


class Experimental(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    pydabs: Optional[ExperimentalPydabs] = None
    python_wheel_wrapper: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = None
    scripts: Optional[Dict[str, str]] = None
    use_legacy_run_as: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = None


class Permissions(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    group_name: Optional[str] = None
    level: str
    service_principal_name: Optional[str] = None
    user_name: Optional[str] = None


class Presets(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    jobs_max_concurrent_runs: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = None
    name_prefix: Optional[str] = None
    pipelines_development: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = None
    tags: Optional[Dict[str, str]] = None
    trigger_pause_status: Optional[str] = None


class ExperimentsPermissions(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    group_name: Optional[str] = None
    level: str
    service_principal_name: Optional[str] = None
    user_name: Optional[str] = None


class ExperimentsTags(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    key: Optional[str] = Field(None, description='The tag key.')
    value: Optional[str] = Field(None, description='The tag value.')


class Experiments(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    artifact_location: Optional[str] = Field(
        None, description='Location where artifacts for the experiment are stored.'
    )
    creation_time: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(None, description='Creation time')
    experiment_id: Optional[str] = Field(
        None, description='Unique identifier for the experiment.'
    )
    last_update_time: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(None, description='Last update time')
    lifecycle_stage: Optional[str] = Field(
        None,
        description='Current life cycle stage of the experiment: "active" or "deleted".\nDeleted experiments are not returned by APIs.',
    )
    name: Optional[str] = Field(
        None, description='Human readable name that identifies the experiment.'
    )
    permissions: Optional[List[ExperimentsPermissions]] = None
    tags: Optional[List[ExperimentsTags]] = Field(
        None, description='Tags: Additional metadata key-value pairs.'
    )


class JobsContinuous(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    pause_status: Optional[str] = Field(
        None,
        description='Indicate whether the continuous execution of the job is paused or not. Defaults to UNPAUSED.',
    )


class JobsDeployment(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    kind: str = Field(
        ...,
        description='The kind of deployment that manages the job.\n\n* `BUNDLE`: The job is managed by Databricks Asset Bundle.',
    )
    metadata_file_path: Optional[str] = Field(
        None, description='Path of the file that contains deployment metadata.'
    )


class JobsEmailNotifications(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    no_alert_for_skipped_runs: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If true, do not send email to recipients specified in `on_failure` if the run is skipped.',
    )
    on_duration_warning_threshold_exceeded: Optional[List[str]] = Field(
        None,
        description='A list of email addresses to be notified when the duration of a run exceeds the threshold specified for the `RUN_DURATION_SECONDS` metric in the `health` field. If no rule for the `RUN_DURATION_SECONDS` metric is specified in the `health` field for the job, notifications are not sent.',
    )
    on_failure: Optional[List[str]] = Field(
        None,
        description='A list of email addresses to be notified when a run unsuccessfully completes. A run is considered to have completed unsuccessfully if it ends with an `INTERNAL_ERROR` `life_cycle_state` or a `FAILED`, or `TIMED_OUT` result_state. If this is not specified on job creation, reset, or update the list is empty, and notifications are not sent.',
    )
    on_start: Optional[List[str]] = Field(
        None,
        description='A list of email addresses to be notified when a run begins. If not specified on job creation, reset, or update, the list is empty, and notifications are not sent.',
    )
    on_streaming_backlog_exceeded: Optional[List[str]] = Field(
        None,
        description='A list of email addresses to notify when any streaming backlog thresholds are exceeded for any stream.\nStreaming backlog thresholds can be set in the `health` field using the following metrics: `STREAMING_BACKLOG_BYTES`, `STREAMING_BACKLOG_RECORDS`, `STREAMING_BACKLOG_SECONDS`, or `STREAMING_BACKLOG_FILES`.\nAlerting is based on the 10-minute average of these metrics. If the issue persists, notifications are resent every 30 minutes.',
    )
    on_success: Optional[List[str]] = Field(
        None,
        description='A list of email addresses to be notified when a run successfully completes. A run is considered to have completed successfully if it ends with a `TERMINATED` `life_cycle_state` and a `SUCCESS` result_state. If not specified on job creation, reset, or update, the list is empty, and notifications are not sent.',
    )


class JobsEnvironmentsSpec(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    client: str = Field(
        ...,
        description='Client version used by the environment\nThe client is the user-facing environment of the runtime.\nEach client comes with a specific set of pre-installed libraries.\nThe version is a string, consisting of the major client version.',
    )
    dependencies: Optional[List[str]] = Field(
        None,
        description='List of pip dependencies, as supported by the version of pip in this environment.\nEach dependency is a pip requirement file line https://pip.pypa.io/en/stable/reference/requirements-file-format/\nAllowed dependency could be <requirement specifier>, <archive url/path>, <local project path>(WSFS or Volumes in Databricks), <vcs project url>\nE.g. dependencies: ["foo==0.0.1", "-r /Workspace/test/requirements.txt"]',
    )


class JobsEnvironments(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    environment_key: str = Field(
        ..., description='The key of an environment. It has to be unique within a job.'
    )
    spec: Optional[JobsEnvironmentsSpec] = None


class JobsGitSourceGitSnapshot(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    used_commit: Optional[str] = Field(
        None,
        description='Commit that was used to execute the run. If git_branch was specified, this points to the HEAD of the branch at the time of the run; if git_tag was specified, this points to the commit the tag points to.',
    )


class JobsGitSourceJobSource(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    dirty_state: Optional[str] = Field(
        None,
        description='Dirty state indicates the job is not fully synced with the job specification in the remote repository.\n\nPossible values are:\n* `NOT_SYNCED`: The job is not yet synced with the remote job specification. Import the remote job specification from UI to make the job fully synced.\n* `DISCONNECTED`: The job is temporary disconnected from the remote job specification and is allowed for live edit. Import the remote job specification again from UI to make the job fully synced.',
    )
    import_from_git_branch: str = Field(
        ..., description='Name of the branch which the job is imported from.'
    )
    job_config_path: str = Field(
        ...,
        description='Path of the job YAML file that contains the job specification.',
    )


class JobsGitSource(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    git_branch: Optional[str] = Field(
        None,
        description='Name of the branch to be checked out and used by this job. This field cannot be specified in conjunction with git_tag or git_commit.',
    )
    git_commit: Optional[str] = Field(
        None,
        description='Commit to be checked out and used by this job. This field cannot be specified in conjunction with git_branch or git_tag.',
    )
    git_provider: str = Field(
        ...,
        description='Unique identifier of the service used to host the Git repository. The value is case insensitive.',
    )
    git_snapshot: Optional[JobsGitSourceGitSnapshot] = None
    git_tag: Optional[str] = Field(
        None,
        description='Name of the tag to be checked out and used by this job. This field cannot be specified in conjunction with git_branch or git_commit.',
    )
    git_url: str = Field(
        ..., description='URL of the repository to be cloned by this job.'
    )
    job_source: Optional[JobsGitSourceJobSource] = None


class JobsHealthRules(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    metric: str
    op: str
    value: Union[
        float,
        constr(
            pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
        ),
    ] = Field(
        ...,
        description='Specifies the threshold value that the health metric should obey to satisfy the health rule.',
    )


class JobsHealth(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    rules: Optional[List[JobsHealthRules]] = None


class JobsJobClustersNewClusterAutoscale(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    max_workers: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='The maximum number of workers to which the cluster can scale up when overloaded.\nNote that `max_workers` must be strictly greater than `min_workers`.',
    )
    min_workers: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='The minimum number of workers to which the cluster can scale down when underutilized.\nIt is also the initial number of workers the cluster will have after creation.',
    )


class JobsJobClustersNewClusterAwsAttributes(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    availability: Optional[str] = None
    ebs_volume_count: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='The number of volumes launched for each instance. Users can choose up to 10 volumes.\nThis feature is only enabled for supported node types. Legacy node types cannot specify\ncustom EBS volumes.\nFor node types with no instance store, at least one EBS volume needs to be specified;\notherwise, cluster creation will fail.\n\nThese EBS volumes will be mounted at `/ebs0`, `/ebs1`, and etc.\nInstance store volumes will be mounted at `/local_disk0`, `/local_disk1`, and etc.\n\nIf EBS volumes are attached, Databricks will configure Spark to use only the EBS volumes for\nscratch storage because heterogenously sized scratch devices can lead to inefficient disk\nutilization. If no EBS volumes are attached, Databricks will configure Spark to use instance\nstore volumes.\n\nPlease note that if EBS volumes are specified, then the Spark configuration `spark.local.dir`\nwill be overridden.',
    )
    ebs_volume_iops: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If using gp3 volumes, what IOPS to use for the disk. If this is not set, the maximum performance of a gp2 volume with the same volume size will be used.',
    )
    ebs_volume_size: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='The size of each EBS volume (in GiB) launched for each instance. For general purpose\nSSD, this value must be within the range 100 - 4096. For throughput optimized HDD,\nthis value must be within the range 500 - 4096.',
    )
    ebs_volume_throughput: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If using gp3 volumes, what throughput to use for the disk. If this is not set, the maximum performance of a gp2 volume with the same volume size will be used.',
    )
    ebs_volume_type: Optional[str] = None
    first_on_demand: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='The first `first_on_demand` nodes of the cluster will be placed on on-demand instances.\nIf this value is greater than 0, the cluster driver node in particular will be placed on an\non-demand instance. If this value is greater than or equal to the current cluster size, all\nnodes will be placed on on-demand instances. If this value is less than the current cluster\nsize, `first_on_demand` nodes will be placed on on-demand instances and the remainder will\nbe placed on `availability` instances. Note that this value does not affect\ncluster size and cannot currently be mutated over the lifetime of a cluster.',
    )
    instance_profile_arn: Optional[str] = Field(
        None,
        description='Nodes for this cluster will only be placed on AWS instances with this instance profile. If\nommitted, nodes will be placed on instances without an IAM instance profile. The instance\nprofile must have previously been added to the Databricks environment by an account\nadministrator.\n\nThis feature may only be available to certain customer plans.\n\nIf this field is ommitted, we will pull in the default from the conf if it exists.',
    )
    spot_bid_price_percent: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description="The bid price for AWS spot instances, as a percentage of the corresponding instance type's\non-demand price.\nFor example, if this field is set to 50, and the cluster needs a new `r3.xlarge` spot\ninstance, then the bid price is half of the price of\non-demand `r3.xlarge` instances. Similarly, if this field is set to 200, the bid price is twice\nthe price of on-demand `r3.xlarge` instances. If not specified, the default value is 100.\nWhen spot instances are requested for this cluster, only spot instances whose bid price\npercentage matches this field will be considered.\nNote that, for safety, we enforce this field to be no more than 10000.\n\nThe default value and documentation here should be kept consistent with\nCommonConf.defaultSpotBidPricePercent and CommonConf.maxSpotBidPricePercent.",
    )
    zone_id: Optional[str] = Field(
        None,
        description='Identifier for the availability zone/datacenter in which the cluster resides.\nThis string will be of a form like "us-west-2a". The provided availability\nzone must be in the same region as the Databricks deployment. For example, "us-west-2a"\nis not a valid zone id if the Databricks deployment resides in the "us-east-1" region.\nThis is an optional field at cluster creation, and if not specified, a default zone will be used.\nIf the zone specified is "auto", will try to place cluster in a zone with high availability,\nand will retry placement in a different AZ if there is not enough capacity.\nThe list of available zones as well as the default value can be found by using the\n`List Zones` method.',
    )


class JobsJobClustersNewClusterAzureAttributesLogAnalyticsInfo(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    log_analytics_primary_key: Optional[str] = Field(
        None, description='<needs content added>'
    )
    log_analytics_workspace_id: Optional[str] = Field(
        None, description='<needs content added>'
    )


class JobsJobClustersNewClusterAzureAttributes(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    availability: Optional[str] = None
    first_on_demand: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='The first `first_on_demand` nodes of the cluster will be placed on on-demand instances.\nThis value should be greater than 0, to make sure the cluster driver node is placed on an\non-demand instance. If this value is greater than or equal to the current cluster size, all\nnodes will be placed on on-demand instances. If this value is less than the current cluster\nsize, `first_on_demand` nodes will be placed on on-demand instances and the remainder will\nbe placed on `availability` instances. Note that this value does not affect\ncluster size and cannot currently be mutated over the lifetime of a cluster.',
    )
    log_analytics_info: Optional[
        JobsJobClustersNewClusterAzureAttributesLogAnalyticsInfo
    ] = None
    spot_bid_max_price: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='The max bid price to be used for Azure spot instances.\nThe Max price for the bid cannot be higher than the on-demand price of the instance.\nIf not specified, the default value is -1, which specifies that the instance cannot be evicted\non the basis of price, and only on the basis of availability. Further, the value should > 0 or -1.',
    )


class JobsJobClustersNewClusterClusterLogConfDbfs(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination: str = Field(..., description='dbfs destination, e.g. `dbfs:/my/path`')


class JobsJobClustersNewClusterClusterLogConfS(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    canned_acl: Optional[str] = Field(
        None,
        description='(Optional) Set canned access control list for the logs, e.g. `bucket-owner-full-control`.\nIf `canned_cal` is set, please make sure the cluster iam role has `s3:PutObjectAcl` permission on\nthe destination bucket and prefix. The full list of possible canned acl can be found at\nhttp://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl.\nPlease also note that by default only the object owner gets full controls. If you are using cross account\nrole for writing data, you may want to set `bucket-owner-full-control` to make bucket owner able to\nread the logs.',
    )
    destination: str = Field(
        ...,
        description='S3 destination, e.g. `s3://my-bucket/some-prefix` Note that logs will be delivered using\ncluster iam role, please make sure you set cluster iam role and the role has write access to the\ndestination. Please also note that you cannot use AWS keys to deliver logs.',
    )
    enable_encryption: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='(Optional) Flag to enable server side encryption, `false` by default.',
    )
    encryption_type: Optional[str] = Field(
        None,
        description='(Optional) The encryption type, it could be `sse-s3` or `sse-kms`. It will be used only when\nencryption is enabled and the default type is `sse-s3`.',
    )
    endpoint: Optional[str] = Field(
        None,
        description='S3 endpoint, e.g. `https://s3-us-west-2.amazonaws.com`. Either region or endpoint needs to be set.\nIf both are set, endpoint will be used.',
    )
    kms_key: Optional[str] = Field(
        None,
        description='(Optional) Kms key which will be used if encryption is enabled and encryption type is set to `sse-kms`.',
    )
    region: Optional[str] = Field(
        None,
        description='S3 region, e.g. `us-west-2`. Either region or endpoint needs to be set. If both are set,\nendpoint will be used.',
    )


class JobsJobClustersNewClusterClusterLogConf(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    dbfs: Optional[JobsJobClustersNewClusterClusterLogConfDbfs] = None
    s3: Optional[JobsJobClustersNewClusterClusterLogConfS] = None


class JobsJobClustersNewClusterDockerImageBasicAuth(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    password: Optional[str] = Field(None, description='Password of the user')
    username: Optional[str] = Field(None, description='Name of the user')


class JobsJobClustersNewClusterDockerImage(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    basic_auth: Optional[JobsJobClustersNewClusterDockerImageBasicAuth] = None
    url: Optional[str] = Field(None, description='URL of the docker image.')


class JobsJobClustersNewClusterGcpAttributes(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    availability: Optional[str] = None
    boot_disk_size: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(None, description='boot disk size in GB')
    google_service_account: Optional[str] = Field(
        None,
        description='If provided, the cluster will impersonate the google service account when accessing\ngcloud services (like GCS). The google service account\nmust have previously been added to the Databricks environment by an account\nadministrator.',
    )
    local_ssd_count: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If provided, each node (workers and driver) in the cluster will have this number of local SSDs attached. Each local SSD is 375GB in size. Refer to [GCP documentation](https://cloud.google.com/compute/docs/disks/local-ssd#choose_number_local_ssds) for the supported number of local SSDs for each instance type.',
    )
    use_preemptible_executors: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='This field determines whether the spark executors will be scheduled to run on preemptible VMs (when set to true) versus standard compute engine VMs (when set to false; default).\nNote: Soon to be deprecated, use the availability field instead.',
    )
    zone_id: Optional[str] = Field(
        None,
        description='Identifier for the availability zone in which the cluster resides.\nThis can be one of the following:\n- "HA" => High availability, spread nodes across availability zones for a Databricks deployment region [default]\n- "AUTO" => Databricks picks an availability zone to schedule the cluster on.\n- A GCP availability zone => Pick One of the available zones for (machine type + region) from https://cloud.google.com/compute/docs/regions-zones.',
    )


class JobsJobClustersNewClusterInitScriptsAbfss(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination: str = Field(
        ...,
        description='abfss destination, e.g. `abfss://<container-name>@<storage-account-name>.dfs.core.windows.net/<directory-name>`.',
    )


class JobsJobClustersNewClusterInitScriptsDbfs(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination: str = Field(..., description='dbfs destination, e.g. `dbfs:/my/path`')


class JobsJobClustersNewClusterInitScriptsFile(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination: str = Field(
        ..., description='local file destination, e.g. `file:/my/local/file.sh`'
    )


class JobsJobClustersNewClusterInitScriptsGcs(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination: str = Field(
        ..., description='GCS destination/URI, e.g. `gs://my-bucket/some-prefix`'
    )


class JobsJobClustersNewClusterInitScriptsS(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    canned_acl: Optional[str] = Field(
        None,
        description='(Optional) Set canned access control list for the logs, e.g. `bucket-owner-full-control`.\nIf `canned_cal` is set, please make sure the cluster iam role has `s3:PutObjectAcl` permission on\nthe destination bucket and prefix. The full list of possible canned acl can be found at\nhttp://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl.\nPlease also note that by default only the object owner gets full controls. If you are using cross account\nrole for writing data, you may want to set `bucket-owner-full-control` to make bucket owner able to\nread the logs.',
    )
    destination: str = Field(
        ...,
        description='S3 destination, e.g. `s3://my-bucket/some-prefix` Note that logs will be delivered using\ncluster iam role, please make sure you set cluster iam role and the role has write access to the\ndestination. Please also note that you cannot use AWS keys to deliver logs.',
    )
    enable_encryption: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='(Optional) Flag to enable server side encryption, `false` by default.',
    )
    encryption_type: Optional[str] = Field(
        None,
        description='(Optional) The encryption type, it could be `sse-s3` or `sse-kms`. It will be used only when\nencryption is enabled and the default type is `sse-s3`.',
    )
    endpoint: Optional[str] = Field(
        None,
        description='S3 endpoint, e.g. `https://s3-us-west-2.amazonaws.com`. Either region or endpoint needs to be set.\nIf both are set, endpoint will be used.',
    )
    kms_key: Optional[str] = Field(
        None,
        description='(Optional) Kms key which will be used if encryption is enabled and encryption type is set to `sse-kms`.',
    )
    region: Optional[str] = Field(
        None,
        description='S3 region, e.g. `us-west-2`. Either region or endpoint needs to be set. If both are set,\nendpoint will be used.',
    )


class JobsJobClustersNewClusterInitScriptsVolumes(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination: str = Field(
        ...,
        description='Unity Catalog Volumes file destination, e.g. `/Volumes/my-init.sh`',
    )


class JobsJobClustersNewClusterInitScriptsWorkspace(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination: str = Field(
        ...,
        description='workspace files destination, e.g. `/Users/user1@databricks.com/my-init.sh`',
    )


class JobsJobClustersNewClusterInitScripts(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    abfss: Optional[JobsJobClustersNewClusterInitScriptsAbfss] = None
    dbfs: Optional[JobsJobClustersNewClusterInitScriptsDbfs] = None
    file: Optional[JobsJobClustersNewClusterInitScriptsFile] = None
    gcs: Optional[JobsJobClustersNewClusterInitScriptsGcs] = None
    s3: Optional[JobsJobClustersNewClusterInitScriptsS] = None
    volumes: Optional[JobsJobClustersNewClusterInitScriptsVolumes] = None
    workspace: Optional[JobsJobClustersNewClusterInitScriptsWorkspace] = None


class JobsJobClustersNewClusterWorkloadTypeClients(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    jobs: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(None, description='With jobs set, the cluster can be used for jobs')
    notebooks: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None, description='With notebooks set, this cluster can be used for notebooks'
    )


class JobsJobClustersNewClusterWorkloadType(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    clients: JobsJobClustersNewClusterWorkloadTypeClients


class JobsJobClustersNewCluster(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    apply_policy_default_values: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='When set to true, fixed and default values from the policy will be used for fields that are omitted. When set to false, only fixed values from the policy will be applied.',
    )
    autoscale: Optional[JobsJobClustersNewClusterAutoscale] = None
    autotermination_minutes: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='Automatically terminates the cluster after it is inactive for this time in minutes. If not set,\nthis cluster will not be automatically terminated. If specified, the threshold must be between\n10 and 10000 minutes.\nUsers can also set this value to 0 to explicitly disable automatic termination.',
    )
    aws_attributes: Optional[JobsJobClustersNewClusterAwsAttributes] = None
    azure_attributes: Optional[JobsJobClustersNewClusterAzureAttributes] = None
    cluster_log_conf: Optional[JobsJobClustersNewClusterClusterLogConf] = None
    cluster_name: Optional[str] = Field(
        None,
        description="Cluster name requested by the user. This doesn't have to be unique.\nIf not specified at creation, the cluster name will be an empty string.\n",
    )
    custom_tags: Optional[Dict[str, str]] = None
    data_security_mode: Optional[
        Literal[
            'LEGACY_TABLE_ACL',
            'LEGACY_PASSTHROUGH',
            'LEGACY_SINGLE_USER',
            'LEGACY_SINGLE_USER_STANDARD',
            'SINGLE_USER',
            'USER_ISOLATION',
            'NONE',
        ]
    ] = Field(
        'SINGLE_USER',
        description='The data security mode to use for clusters. Valid values are ["LEGACY_TABLE_ACL", "LEGACY_PASSTHROUGH", "LEGACY_SINGLE_USER", "LEGACY_SINGLE_USER_STANDARD", "SINGLE_USER", "USER_ISOLATION", "NONE"].',
    )
    docker_image: Optional[JobsJobClustersNewClusterDockerImage] = None
    driver_instance_pool_id: Optional[str] = Field(
        None,
        description='The optional ID of the instance pool for the driver of the cluster belongs.\nThe pool cluster uses the instance pool with id (instance_pool_id) if the driver pool is not\nassigned.',
    )
    driver_node_type_id: Optional[str] = Field(
        None,
        description='The node type of the Spark driver. Note that this field is optional;\nif unset, the driver node type will be set as the same value\nas `node_type_id` defined above.\n',
    )
    enable_elastic_disk: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='Autoscaling Local Storage: when enabled, this cluster will dynamically acquire additional disk\nspace when its Spark workers are running low on disk space. This feature requires specific AWS\npermissions to function correctly - refer to the User Guide for more details.',
    )
    enable_local_disk_encryption: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(None, description="Whether to enable LUKS on cluster VMs' local disks")
    gcp_attributes: Optional[JobsJobClustersNewClusterGcpAttributes] = None
    init_scripts: Optional[List[JobsJobClustersNewClusterInitScripts]] = Field(
        None,
        description='The configuration for storing init scripts. Any number of destinations can be specified. The scripts are executed sequentially in the order provided. If `cluster_log_conf` is specified, init script logs are sent to `<destination>/<cluster-ID>/init_scripts`.',
    )
    instance_pool_id: Optional[str] = Field(
        None,
        description='The optional ID of the instance pool to which the cluster belongs.',
    )
    node_type_id: Optional[str] = Field(
        None,
        description='This field encodes, through a single value, the resources available to each of\nthe Spark nodes in this cluster. For example, the Spark nodes can be provisioned\nand optimized for memory or compute intensive workloads. A list of available node\ntypes can be retrieved by using the :method:clusters/listNodeTypes API call.\n',
    )
    num_workers: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='Number of worker nodes that this cluster should have. A cluster has one Spark Driver\nand `num_workers` Executors for a total of `num_workers` + 1 Spark nodes.\n\nNote: When reading the properties of a cluster, this field reflects the desired number\nof workers rather than the actual current number of workers. For instance, if a cluster\nis resized from 5 to 10 workers, this field will immediately be updated to reflect\nthe target size of 10 workers, whereas the workers listed in `spark_info` will gradually\nincrease from 5 to 10 as the new nodes are provisioned.',
    )
    policy_id: Optional[str] = Field(
        None,
        description='The ID of the cluster policy used to create the cluster if applicable.',
    )
    runtime_engine: Optional[str] = None
    single_user_name: Optional[str] = Field(
        None, description='Single user name if data_security_mode is `SINGLE_USER`'
    )
    spark_conf: Optional[Dict[str, str]] = None
    spark_env_vars: Optional[Dict[str, str]] = None
    spark_version: Optional[str] = Field(
        None,
        description='The Spark version of the cluster, e.g. `3.3.x-scala2.11`.\nA list of available Spark versions can be retrieved by using\nthe :method:clusters/sparkVersions API call.\n',
    )
    ssh_public_keys: Optional[List[str]] = Field(
        None,
        description='SSH public key contents that will be added to each Spark node in this cluster. The\ncorresponding private keys can be used to login with the user name `ubuntu` on port `2200`.\nUp to 10 keys can be specified.',
    )
    workload_type: Optional[JobsJobClustersNewClusterWorkloadType] = None


class JobsJobClusters(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    job_cluster_key: str = Field(
        ...,
        description='A unique name for the job cluster. This field is required and must be unique within the job.\n`JobTaskSettings` may refer to this field to determine which cluster to launch for the task execution.',
    )
    new_cluster: JobsJobClustersNewCluster


class JobsNotificationSettings(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    no_alert_for_canceled_runs: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If true, do not send notifications to recipients specified in `on_failure` if the run is canceled.',
    )
    no_alert_for_skipped_runs: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If true, do not send notifications to recipients specified in `on_failure` if the run is skipped.',
    )


class JobsParameters(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    default: str = Field(..., description='Default value of the parameter.')
    name: str = Field(
        ...,
        description='The name of the defined parameter. May only contain alphanumeric characters, `_`, `-`, and `.`',
    )


class JobsPermissions(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    group_name: Optional[str] = None
    level: str
    service_principal_name: Optional[str] = None
    user_name: Optional[str] = None


class JobsQueue(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    enabled: Union[
        bool,
        constr(
            pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
        ),
    ] = Field(
        ...,
        description='If true, enable queueing for the job. This is a required field.',
    )


class JobsRunAs(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    service_principal_name: Optional[str] = Field(
        None,
        description='Application ID of an active service principal. Setting this field requires the `servicePrincipal/user` role.',
    )
    user_name: Optional[str] = Field(
        None,
        description='The email of an active workspace user. Non-admin users can only set this field to their own email.',
    )


class JobsSchedule(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    pause_status: Optional[str] = Field(
        None, description='Indicate whether this schedule is paused or not.'
    )
    quartz_cron_expression: str = Field(
        ...,
        description='A Cron expression using Quartz syntax that describes the schedule for a job. See [Cron Trigger](http://www.quartz-scheduler.org/documentation/quartz-2.3.0/tutorials/crontrigger.html) for details. This field is required.',
    )
    timezone_id: str = Field(
        ...,
        description='A Java timezone ID. The schedule for a job is resolved with respect to this timezone. See [Java TimeZone](https://docs.oracle.com/javase/7/docs/api/java/util/TimeZone.html) for details. This field is required.',
    )


class JobsTasksConditionTask(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    left: str = Field(
        ...,
        description='The left operand of the condition task. Can be either a string value or a job state or parameter reference.',
    )
    op: str = Field(
        ...,
        description='* `EQUAL_TO`, `NOT_EQUAL` operators perform string comparison of their operands. This means that `“12.0” == “12”` will evaluate to `false`.\n* `GREATER_THAN`, `GREATER_THAN_OR_EQUAL`, `LESS_THAN`, `LESS_THAN_OR_EQUAL` operators perform numeric comparison of their operands. `“12.0” >= “12”` will evaluate to `true`, `“10.0” >= “12”` will evaluate to `false`.\n\nThe boolean comparison to task values can be implemented with operators `EQUAL_TO`, `NOT_EQUAL`. If a task value was set to a boolean value, it will be serialized to `“true”` or `“false”` for the comparison.',
    )
    right: str = Field(
        ...,
        description='The right operand of the condition task. Can be either a string value or a job state or parameter reference.',
    )


class JobsTasksDbtTask(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    catalog: Optional[str] = Field(
        None,
        description='Optional name of the catalog to use. The value is the top level in the 3-level namespace of Unity Catalog (catalog / schema / relation). The catalog value can only be specified if a warehouse_id is specified. Requires dbt-databricks >= 1.1.1.',
    )
    commands: List[str] = Field(
        ...,
        description='A list of dbt commands to execute. All commands must start with `dbt`. This parameter must not be empty. A maximum of up to 10 commands can be provided.',
    )
    profiles_directory: Optional[str] = Field(
        None,
        description='Optional (relative) path to the profiles directory. Can only be specified if no warehouse_id is specified. If no warehouse_id is specified and this folder is unset, the root directory is used.',
    )
    project_directory: Optional[str] = Field(
        None,
        description='Path to the project directory. Optional for Git sourced tasks, in which\ncase if no value is provided, the root of the Git repository is used.',
    )
    schema_: Optional[str] = Field(
        None,
        alias='schema',
        description='Optional schema to write to. This parameter is only used when a warehouse_id is also provided. If not provided, the `default` schema is used.',
    )
    source: Optional[str] = Field(
        None,
        description='Optional location type of the project directory. When set to `WORKSPACE`, the project will be retrieved\nfrom the local Databricks workspace. When set to `GIT`, the project will be retrieved from a Git repository\ndefined in `git_source`. If the value is empty, the task will use `GIT` if `git_source` is defined and `WORKSPACE` otherwise.\n\n* `WORKSPACE`: Project is located in Databricks workspace.\n* `GIT`: Project is located in cloud Git provider.',
    )
    warehouse_id: Optional[str] = Field(
        None,
        description='ID of the SQL warehouse to connect to. If provided, we automatically generate and provide the profile and connection details to dbt. It can be overridden on a per-command basis by using the `--profiles-dir` command line argument.',
    )


class JobsTasksDependsOn(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    outcome: Optional[str] = Field(
        None,
        description='Can only be specified on condition task dependencies. The outcome of the dependent task that must be met for this task to run.',
    )
    task_key: str = Field(..., description='The name of the task this task depends on.')


class JobsTasksEmailNotifications(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    no_alert_for_skipped_runs: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If true, do not send email to recipients specified in `on_failure` if the run is skipped.',
    )
    on_duration_warning_threshold_exceeded: Optional[List[str]] = Field(
        None,
        description='A list of email addresses to be notified when the duration of a run exceeds the threshold specified for the `RUN_DURATION_SECONDS` metric in the `health` field. If no rule for the `RUN_DURATION_SECONDS` metric is specified in the `health` field for the job, notifications are not sent.',
    )
    on_failure: Optional[List[str]] = Field(
        None,
        description='A list of email addresses to be notified when a run unsuccessfully completes. A run is considered to have completed unsuccessfully if it ends with an `INTERNAL_ERROR` `life_cycle_state` or a `FAILED`, or `TIMED_OUT` result_state. If this is not specified on job creation, reset, or update the list is empty, and notifications are not sent.',
    )
    on_start: Optional[List[str]] = Field(
        None,
        description='A list of email addresses to be notified when a run begins. If not specified on job creation, reset, or update, the list is empty, and notifications are not sent.',
    )
    on_streaming_backlog_exceeded: Optional[List[str]] = Field(
        None,
        description='A list of email addresses to notify when any streaming backlog thresholds are exceeded for any stream.\nStreaming backlog thresholds can be set in the `health` field using the following metrics: `STREAMING_BACKLOG_BYTES`, `STREAMING_BACKLOG_RECORDS`, `STREAMING_BACKLOG_SECONDS`, or `STREAMING_BACKLOG_FILES`.\nAlerting is based on the 10-minute average of these metrics. If the issue persists, notifications are resent every 30 minutes.',
    )
    on_success: Optional[List[str]] = Field(
        None,
        description='A list of email addresses to be notified when a run successfully completes. A run is considered to have completed successfully if it ends with a `TERMINATED` `life_cycle_state` and a `SUCCESS` result_state. If not specified on job creation, reset, or update, the list is empty, and notifications are not sent.',
    )


class JobsTasksForEachTask(BaseModel):
    inputs: str
    concurrency: int
    task: JobsTasks



class JobsTasksHealthRules(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    metric: str
    op: str
    value: Union[
        float,
        constr(
            pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
        ),
    ] = Field(
        ...,
        description='Specifies the threshold value that the health metric should obey to satisfy the health rule.',
    )


class JobsTasksHealth(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    rules: Optional[List[JobsTasksHealthRules]] = None


class JobsTasksLibrariesCran(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    package: str = Field(..., description='The name of the CRAN package to install.')
    repo: Optional[str] = Field(
        None,
        description='The repository where the package can be found. If not specified, the default CRAN repo is used.',
    )


class JobsTasksLibrariesMaven(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    coordinates: str = Field(
        ...,
        description='Gradle-style maven coordinates. For example: "org.jsoup:jsoup:1.7.2".',
    )
    exclusions: Optional[List[str]] = Field(
        None,
        description='List of dependences to exclude. For example: `["slf4j:slf4j", "*:hadoop-client"]`.\n\nMaven dependency exclusions:\nhttps://maven.apache.org/guides/introduction/introduction-to-optional-and-excludes-dependencies.html.',
    )
    repo: Optional[str] = Field(
        None,
        description='Maven repo to install the Maven package from. If omitted, both Maven Central Repository\nand Spark Packages are searched.',
    )


class JobsTasksLibrariesPypi(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    package: str = Field(
        ...,
        description='The name of the pypi package to install. An optional exact version specification is also\nsupported. Examples: "simplejson" and "simplejson==3.8.0".',
    )
    repo: Optional[str] = Field(
        None,
        description='The repository where the package can be found. If not specified, the default pip index is\nused.',
    )


class JobsTasksLibraries(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    cran: Optional[JobsTasksLibrariesCran] = None
    egg: Optional[str] = Field(
        None,
        description='Deprecated. URI of the egg library to install. Installing Python egg files is deprecated and is not supported in Databricks Runtime 14.0 and above.',
    )
    jar: Optional[str] = Field(
        None,
        description='URI of the JAR library to install. Supported URIs include Workspace paths, Unity Catalog Volumes paths, and S3 URIs.\nFor example: `{ "jar": "/Workspace/path/to/library.jar" }`, `{ "jar" : "/Volumes/path/to/library.jar" }` or\n`{ "jar": "s3://my-bucket/library.jar" }`.\nIf S3 is used, please make sure the cluster has read access on the library. You may need to\nlaunch the cluster with an IAM role to access the S3 URI.',
    )
    maven: Optional[JobsTasksLibrariesMaven] = None
    pypi: Optional[JobsTasksLibrariesPypi] = None
    requirements: Optional[str] = Field(
        None,
        description='URI of the requirements.txt file to install. Only Workspace paths and Unity Catalog Volumes paths are supported.\nFor example: `{ "requirements": "/Workspace/path/to/requirements.txt" }` or `{ "requirements" : "/Volumes/path/to/requirements.txt" }`',
    )
    whl: Optional[str] = Field(
        None,
        description='URI of the wheel library to install. Supported URIs include Workspace paths, Unity Catalog Volumes paths, and S3 URIs.\nFor example: `{ "whl": "/Workspace/path/to/library.whl" }`, `{ "whl" : "/Volumes/path/to/library.whl" }` or\n`{ "whl": "s3://my-bucket/library.whl" }`.\nIf S3 is used, please make sure the cluster has read access on the library. You may need to\nlaunch the cluster with an IAM role to access the S3 URI.',
    )


class JobsTasksNewClusterAutoscale(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    max_workers: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='The maximum number of workers to which the cluster can scale up when overloaded.\nNote that `max_workers` must be strictly greater than `min_workers`.',
    )
    min_workers: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='The minimum number of workers to which the cluster can scale down when underutilized.\nIt is also the initial number of workers the cluster will have after creation.',
    )


class JobsTasksNewClusterAwsAttributes(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    availability: Optional[str] = None
    ebs_volume_count: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='The number of volumes launched for each instance. Users can choose up to 10 volumes.\nThis feature is only enabled for supported node types. Legacy node types cannot specify\ncustom EBS volumes.\nFor node types with no instance store, at least one EBS volume needs to be specified;\notherwise, cluster creation will fail.\n\nThese EBS volumes will be mounted at `/ebs0`, `/ebs1`, and etc.\nInstance store volumes will be mounted at `/local_disk0`, `/local_disk1`, and etc.\n\nIf EBS volumes are attached, Databricks will configure Spark to use only the EBS volumes for\nscratch storage because heterogenously sized scratch devices can lead to inefficient disk\nutilization. If no EBS volumes are attached, Databricks will configure Spark to use instance\nstore volumes.\n\nPlease note that if EBS volumes are specified, then the Spark configuration `spark.local.dir`\nwill be overridden.',
    )
    ebs_volume_iops: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If using gp3 volumes, what IOPS to use for the disk. If this is not set, the maximum performance of a gp2 volume with the same volume size will be used.',
    )
    ebs_volume_size: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='The size of each EBS volume (in GiB) launched for each instance. For general purpose\nSSD, this value must be within the range 100 - 4096. For throughput optimized HDD,\nthis value must be within the range 500 - 4096.',
    )
    ebs_volume_throughput: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If using gp3 volumes, what throughput to use for the disk. If this is not set, the maximum performance of a gp2 volume with the same volume size will be used.',
    )
    ebs_volume_type: Optional[str] = None
    first_on_demand: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='The first `first_on_demand` nodes of the cluster will be placed on on-demand instances.\nIf this value is greater than 0, the cluster driver node in particular will be placed on an\non-demand instance. If this value is greater than or equal to the current cluster size, all\nnodes will be placed on on-demand instances. If this value is less than the current cluster\nsize, `first_on_demand` nodes will be placed on on-demand instances and the remainder will\nbe placed on `availability` instances. Note that this value does not affect\ncluster size and cannot currently be mutated over the lifetime of a cluster.',
    )
    instance_profile_arn: Optional[str] = Field(
        None,
        description='Nodes for this cluster will only be placed on AWS instances with this instance profile. If\nommitted, nodes will be placed on instances without an IAM instance profile. The instance\nprofile must have previously been added to the Databricks environment by an account\nadministrator.\n\nThis feature may only be available to certain customer plans.\n\nIf this field is ommitted, we will pull in the default from the conf if it exists.',
    )
    spot_bid_price_percent: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description="The bid price for AWS spot instances, as a percentage of the corresponding instance type's\non-demand price.\nFor example, if this field is set to 50, and the cluster needs a new `r3.xlarge` spot\ninstance, then the bid price is half of the price of\non-demand `r3.xlarge` instances. Similarly, if this field is set to 200, the bid price is twice\nthe price of on-demand `r3.xlarge` instances. If not specified, the default value is 100.\nWhen spot instances are requested for this cluster, only spot instances whose bid price\npercentage matches this field will be considered.\nNote that, for safety, we enforce this field to be no more than 10000.\n\nThe default value and documentation here should be kept consistent with\nCommonConf.defaultSpotBidPricePercent and CommonConf.maxSpotBidPricePercent.",
    )
    zone_id: Optional[str] = Field(
        None,
        description='Identifier for the availability zone/datacenter in which the cluster resides.\nThis string will be of a form like "us-west-2a". The provided availability\nzone must be in the same region as the Databricks deployment. For example, "us-west-2a"\nis not a valid zone id if the Databricks deployment resides in the "us-east-1" region.\nThis is an optional field at cluster creation, and if not specified, a default zone will be used.\nIf the zone specified is "auto", will try to place cluster in a zone with high availability,\nand will retry placement in a different AZ if there is not enough capacity.\nThe list of available zones as well as the default value can be found by using the\n`List Zones` method.',
    )


class JobsTasksNewClusterAzureAttributesLogAnalyticsInfo(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    log_analytics_primary_key: Optional[str] = Field(
        None, description='<needs content added>'
    )
    log_analytics_workspace_id: Optional[str] = Field(
        None, description='<needs content added>'
    )


class JobsTasksNewClusterAzureAttributes(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    availability: Optional[str] = None
    first_on_demand: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='The first `first_on_demand` nodes of the cluster will be placed on on-demand instances.\nThis value should be greater than 0, to make sure the cluster driver node is placed on an\non-demand instance. If this value is greater than or equal to the current cluster size, all\nnodes will be placed on on-demand instances. If this value is less than the current cluster\nsize, `first_on_demand` nodes will be placed on on-demand instances and the remainder will\nbe placed on `availability` instances. Note that this value does not affect\ncluster size and cannot currently be mutated over the lifetime of a cluster.',
    )
    log_analytics_info: Optional[
        JobsTasksNewClusterAzureAttributesLogAnalyticsInfo
    ] = None
    spot_bid_max_price: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='The max bid price to be used for Azure spot instances.\nThe Max price for the bid cannot be higher than the on-demand price of the instance.\nIf not specified, the default value is -1, which specifies that the instance cannot be evicted\non the basis of price, and only on the basis of availability. Further, the value should > 0 or -1.',
    )


class JobsTasksNewClusterClusterLogConfDbfs(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination: str = Field(..., description='dbfs destination, e.g. `dbfs:/my/path`')


class JobsTasksNewClusterClusterLogConfS(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    canned_acl: Optional[str] = Field(
        None,
        description='(Optional) Set canned access control list for the logs, e.g. `bucket-owner-full-control`.\nIf `canned_cal` is set, please make sure the cluster iam role has `s3:PutObjectAcl` permission on\nthe destination bucket and prefix. The full list of possible canned acl can be found at\nhttp://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl.\nPlease also note that by default only the object owner gets full controls. If you are using cross account\nrole for writing data, you may want to set `bucket-owner-full-control` to make bucket owner able to\nread the logs.',
    )
    destination: str = Field(
        ...,
        description='S3 destination, e.g. `s3://my-bucket/some-prefix` Note that logs will be delivered using\ncluster iam role, please make sure you set cluster iam role and the role has write access to the\ndestination. Please also note that you cannot use AWS keys to deliver logs.',
    )
    enable_encryption: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='(Optional) Flag to enable server side encryption, `false` by default.',
    )
    encryption_type: Optional[str] = Field(
        None,
        description='(Optional) The encryption type, it could be `sse-s3` or `sse-kms`. It will be used only when\nencryption is enabled and the default type is `sse-s3`.',
    )
    endpoint: Optional[str] = Field(
        None,
        description='S3 endpoint, e.g. `https://s3-us-west-2.amazonaws.com`. Either region or endpoint needs to be set.\nIf both are set, endpoint will be used.',
    )
    kms_key: Optional[str] = Field(
        None,
        description='(Optional) Kms key which will be used if encryption is enabled and encryption type is set to `sse-kms`.',
    )
    region: Optional[str] = Field(
        None,
        description='S3 region, e.g. `us-west-2`. Either region or endpoint needs to be set. If both are set,\nendpoint will be used.',
    )


class JobsTasksNewClusterClusterLogConf(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    dbfs: Optional[JobsTasksNewClusterClusterLogConfDbfs] = None
    s3: Optional[JobsTasksNewClusterClusterLogConfS] = None


class JobsTasksNewClusterDockerImageBasicAuth(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    password: Optional[str] = Field(None, description='Password of the user')
    username: Optional[str] = Field(None, description='Name of the user')


class JobsTasksNewClusterDockerImage(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    basic_auth: Optional[JobsTasksNewClusterDockerImageBasicAuth] = None
    url: Optional[str] = Field(None, description='URL of the docker image.')


class JobsTasksNewClusterGcpAttributes(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    availability: Optional[str] = None
    boot_disk_size: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(None, description='boot disk size in GB')
    google_service_account: Optional[str] = Field(
        None,
        description='If provided, the cluster will impersonate the google service account when accessing\ngcloud services (like GCS). The google service account\nmust have previously been added to the Databricks environment by an account\nadministrator.',
    )
    local_ssd_count: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If provided, each node (workers and driver) in the cluster will have this number of local SSDs attached. Each local SSD is 375GB in size. Refer to [GCP documentation](https://cloud.google.com/compute/docs/disks/local-ssd#choose_number_local_ssds) for the supported number of local SSDs for each instance type.',
    )
    use_preemptible_executors: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='This field determines whether the spark executors will be scheduled to run on preemptible VMs (when set to true) versus standard compute engine VMs (when set to false; default).\nNote: Soon to be deprecated, use the availability field instead.',
    )
    zone_id: Optional[str] = Field(
        None,
        description='Identifier for the availability zone in which the cluster resides.\nThis can be one of the following:\n- "HA" => High availability, spread nodes across availability zones for a Databricks deployment region [default]\n- "AUTO" => Databricks picks an availability zone to schedule the cluster on.\n- A GCP availability zone => Pick One of the available zones for (machine type + region) from https://cloud.google.com/compute/docs/regions-zones.',
    )


class JobsTasksNewClusterInitScriptsAbfss(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination: str = Field(
        ...,
        description='abfss destination, e.g. `abfss://<container-name>@<storage-account-name>.dfs.core.windows.net/<directory-name>`.',
    )


class JobsTasksNewClusterInitScriptsDbfs(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination: str = Field(..., description='dbfs destination, e.g. `dbfs:/my/path`')


class JobsTasksNewClusterInitScriptsFile(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination: str = Field(
        ..., description='local file destination, e.g. `file:/my/local/file.sh`'
    )


class JobsTasksNewClusterInitScriptsGcs(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination: str = Field(
        ..., description='GCS destination/URI, e.g. `gs://my-bucket/some-prefix`'
    )


class JobsTasksNewClusterInitScriptsS(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    canned_acl: Optional[str] = Field(
        None,
        description='(Optional) Set canned access control list for the logs, e.g. `bucket-owner-full-control`.\nIf `canned_cal` is set, please make sure the cluster iam role has `s3:PutObjectAcl` permission on\nthe destination bucket and prefix. The full list of possible canned acl can be found at\nhttp://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl.\nPlease also note that by default only the object owner gets full controls. If you are using cross account\nrole for writing data, you may want to set `bucket-owner-full-control` to make bucket owner able to\nread the logs.',
    )
    destination: str = Field(
        ...,
        description='S3 destination, e.g. `s3://my-bucket/some-prefix` Note that logs will be delivered using\ncluster iam role, please make sure you set cluster iam role and the role has write access to the\ndestination. Please also note that you cannot use AWS keys to deliver logs.',
    )
    enable_encryption: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='(Optional) Flag to enable server side encryption, `false` by default.',
    )
    encryption_type: Optional[str] = Field(
        None,
        description='(Optional) The encryption type, it could be `sse-s3` or `sse-kms`. It will be used only when\nencryption is enabled and the default type is `sse-s3`.',
    )
    endpoint: Optional[str] = Field(
        None,
        description='S3 endpoint, e.g. `https://s3-us-west-2.amazonaws.com`. Either region or endpoint needs to be set.\nIf both are set, endpoint will be used.',
    )
    kms_key: Optional[str] = Field(
        None,
        description='(Optional) Kms key which will be used if encryption is enabled and encryption type is set to `sse-kms`.',
    )
    region: Optional[str] = Field(
        None,
        description='S3 region, e.g. `us-west-2`. Either region or endpoint needs to be set. If both are set,\nendpoint will be used.',
    )


class JobsTasksNewClusterInitScriptsVolumes(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination: str = Field(
        ...,
        description='Unity Catalog Volumes file destination, e.g. `/Volumes/my-init.sh`',
    )


class JobsTasksNewClusterInitScriptsWorkspace(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination: str = Field(
        ...,
        description='workspace files destination, e.g. `/Users/user1@databricks.com/my-init.sh`',
    )


class JobsTasksNewClusterInitScripts(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    abfss: Optional[JobsTasksNewClusterInitScriptsAbfss] = None
    dbfs: Optional[JobsTasksNewClusterInitScriptsDbfs] = None
    file: Optional[JobsTasksNewClusterInitScriptsFile] = None
    gcs: Optional[JobsTasksNewClusterInitScriptsGcs] = None
    s3: Optional[JobsTasksNewClusterInitScriptsS] = None
    volumes: Optional[JobsTasksNewClusterInitScriptsVolumes] = None
    workspace: Optional[JobsTasksNewClusterInitScriptsWorkspace] = None


class JobsTasksNewClusterWorkloadTypeClients(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    jobs: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(None, description='With jobs set, the cluster can be used for jobs')
    notebooks: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None, description='With notebooks set, this cluster can be used for notebooks'
    )


class JobsTasksNewClusterWorkloadType(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    clients: JobsTasksNewClusterWorkloadTypeClients


class JobsTasksNewCluster(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    apply_policy_default_values: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='When set to true, fixed and default values from the policy will be used for fields that are omitted. When set to false, only fixed values from the policy will be applied.',
    )
    autoscale: Optional[JobsTasksNewClusterAutoscale] = None
    autotermination_minutes: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='Automatically terminates the cluster after it is inactive for this time in minutes. If not set,\nthis cluster will not be automatically terminated. If specified, the threshold must be between\n10 and 10000 minutes.\nUsers can also set this value to 0 to explicitly disable automatic termination.',
    )
    aws_attributes: Optional[JobsTasksNewClusterAwsAttributes] = None
    azure_attributes: Optional[JobsTasksNewClusterAzureAttributes] = None
    cluster_log_conf: Optional[JobsTasksNewClusterClusterLogConf] = None
    cluster_name: Optional[str] = Field(
        None,
        description="Cluster name requested by the user. This doesn't have to be unique.\nIf not specified at creation, the cluster name will be an empty string.\n",
    )
    custom_tags: Optional[Dict[str, str]] = None
    data_security_mode: Optional[
        Literal[
            'LEGACY_TABLE_ACL',
            'LEGACY_PASSTHROUGH',
            'LEGACY_SINGLE_USER',
            'LEGACY_SINGLE_USER_STANDARD',
            'SINGLE_USER',
            'USER_ISOLATION',
            'NONE',
        ]
    ] = Field(
        'SINGLE_USER',
        description='The data security mode to use for clusters. Valid values are ["LEGACY_TABLE_ACL", "LEGACY_PASSTHROUGH", "LEGACY_SINGLE_USER", "LEGACY_SINGLE_USER_STANDARD", "SINGLE_USER", "USER_ISOLATION", "NONE"].',
    )
    docker_image: Optional[JobsTasksNewClusterDockerImage] = None
    driver_instance_pool_id: Optional[str] = Field(
        None,
        description='The optional ID of the instance pool for the driver of the cluster belongs.\nThe pool cluster uses the instance pool with id (instance_pool_id) if the driver pool is not\nassigned.',
    )
    driver_node_type_id: Optional[str] = Field(
        None,
        description='The node type of the Spark driver. Note that this field is optional;\nif unset, the driver node type will be set as the same value\nas `node_type_id` defined above.\n',
    )
    enable_elastic_disk: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='Autoscaling Local Storage: when enabled, this cluster will dynamically acquire additional disk\nspace when its Spark workers are running low on disk space. This feature requires specific AWS\npermissions to function correctly - refer to the User Guide for more details.',
    )
    enable_local_disk_encryption: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(None, description="Whether to enable LUKS on cluster VMs' local disks")
    gcp_attributes: Optional[JobsTasksNewClusterGcpAttributes] = None
    init_scripts: Optional[List[JobsTasksNewClusterInitScripts]] = Field(
        None,
        description='The configuration for storing init scripts. Any number of destinations can be specified. The scripts are executed sequentially in the order provided. If `cluster_log_conf` is specified, init script logs are sent to `<destination>/<cluster-ID>/init_scripts`.',
    )
    instance_pool_id: Optional[str] = Field(
        None,
        description='The optional ID of the instance pool to which the cluster belongs.',
    )
    node_type_id: Optional[str] = Field(
        None,
        description='This field encodes, through a single value, the resources available to each of\nthe Spark nodes in this cluster. For example, the Spark nodes can be provisioned\nand optimized for memory or compute intensive workloads. A list of available node\ntypes can be retrieved by using the :method:clusters/listNodeTypes API call.\n',
    )
    num_workers: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='Number of worker nodes that this cluster should have. A cluster has one Spark Driver\nand `num_workers` Executors for a total of `num_workers` + 1 Spark nodes.\n\nNote: When reading the properties of a cluster, this field reflects the desired number\nof workers rather than the actual current number of workers. For instance, if a cluster\nis resized from 5 to 10 workers, this field will immediately be updated to reflect\nthe target size of 10 workers, whereas the workers listed in `spark_info` will gradually\nincrease from 5 to 10 as the new nodes are provisioned.',
    )
    policy_id: Optional[str] = Field(
        None,
        description='The ID of the cluster policy used to create the cluster if applicable.',
    )
    runtime_engine: Optional[str] = None
    single_user_name: Optional[str] = Field(
        None, description='Single user name if data_security_mode is `SINGLE_USER`'
    )
    spark_conf: Optional[Dict[str, str]] = None
    spark_env_vars: Optional[Dict[str, str]] = None
    spark_version: Optional[str] = Field(
        None,
        description='The Spark version of the cluster, e.g. `3.3.x-scala2.11`.\nA list of available Spark versions can be retrieved by using\nthe :method:clusters/sparkVersions API call.\n',
    )
    ssh_public_keys: Optional[List[str]] = Field(
        None,
        description='SSH public key contents that will be added to each Spark node in this cluster. The\ncorresponding private keys can be used to login with the user name `ubuntu` on port `2200`.\nUp to 10 keys can be specified.',
    )
    workload_type: Optional[JobsTasksNewClusterWorkloadType] = None


class JobsTasksNotebookTask(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    base_parameters: Optional[Dict[str, str]] = None
    notebook_path: str = Field(
        ...,
        description='The path of the notebook to be run in the Databricks workspace or remote repository.\nFor notebooks stored in the Databricks workspace, the path must be absolute and begin with a slash.\nFor notebooks stored in a remote repository, the path must be relative. This field is required.',
    )
    source: Optional[str] = Field(
        None,
        description='Optional location type of the notebook. When set to `WORKSPACE`, the notebook will be retrieved from the local Databricks workspace. When set to `GIT`, the notebook will be retrieved from a Git repository\ndefined in `git_source`. If the value is empty, the task will use `GIT` if `git_source` is defined and `WORKSPACE` otherwise.\n* `WORKSPACE`: Notebook is located in Databricks workspace.\n* `GIT`: Notebook is located in cloud Git provider.',
    )
    warehouse_id: Optional[str] = Field(
        None,
        description='Optional `warehouse_id` to run the notebook on a SQL warehouse. Classic SQL warehouses are NOT supported, please use serverless or pro SQL warehouses.\n\nNote that SQL warehouses only support SQL cells; if the notebook contains non-SQL cells, the run will fail.',
    )


class JobsTasksNotificationSettings(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    alert_on_last_attempt: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If true, do not send notifications to recipients specified in `on_start` for the retried runs and do not send notifications to recipients specified in `on_failure` until the last retry of the run.',
    )
    no_alert_for_canceled_runs: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If true, do not send notifications to recipients specified in `on_failure` if the run is canceled.',
    )
    no_alert_for_skipped_runs: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If true, do not send notifications to recipients specified in `on_failure` if the run is skipped.',
    )


class JobsTasksPipelineTask(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    full_refresh: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None, description='If true, triggers a full refresh on the delta live table.'
    )
    pipeline_id: str = Field(
        ..., description='The full name of the pipeline task to execute.'
    )


class JobsTasksPythonWheelTask(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    entry_point: str = Field(
        ...,
        description='Named entry point to use, if it does not exist in the metadata of the package it executes the function from the package directly using `$packageName.$entryPoint()`',
    )
    named_parameters: Optional[Dict[str, str]] = None
    package_name: str = Field(..., description='Name of the package to execute')
    parameters: Optional[List[str]] = Field(
        None,
        description='Command-line parameters passed to Python wheel task. Leave it empty if `named_parameters` is not null.',
    )


class JobsTasksRunJobTaskPipelineParams(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    full_refresh: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None, description='If true, triggers a full refresh on the delta live table.'
    )


class JobsTasksRunJobTask(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    dbt_commands: Optional[List[str]] = Field(
        None,
        description='An array of commands to execute for jobs with the dbt task, for example `"dbt_commands": ["dbt deps", "dbt seed", "dbt deps", "dbt seed", "dbt run"]`',
    )
    jar_params: Optional[List[str]] = Field(
        None,
        description='A list of parameters for jobs with Spark JAR tasks, for example `"jar_params": ["john doe", "35"]`.\nThe parameters are used to invoke the main function of the main class specified in the Spark JAR task.\nIf not specified upon `run-now`, it defaults to an empty list.\njar_params cannot be specified in conjunction with notebook_params.\nThe JSON representation of this field (for example `{"jar_params":["john doe","35"]}`) cannot exceed 10,000 bytes.\n\nUse [Task parameter variables](/jobs.html\\"#parameter-variables\\") to set parameters containing information about job runs.',
    )
    job_id: Union[
        float,
        constr(
            pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
        ),
    ] = Field(..., description='ID of the job to trigger.')
    job_parameters: Optional[Dict[str, str]] = None
    notebook_params: Optional[Dict[str, str]] = None
    pipeline_params: Optional[JobsTasksRunJobTaskPipelineParams] = None
    python_named_params: Optional[Dict[str, str]] = None
    python_params: Optional[List[str]] = Field(
        None,
        description='A list of parameters for jobs with Python tasks, for example `"python_params": ["john doe", "35"]`.\nThe parameters are passed to Python file as command-line parameters. If specified upon `run-now`, it would overwrite\nthe parameters specified in job setting. The JSON representation of this field (for example `{"python_params":["john doe","35"]}`)\ncannot exceed 10,000 bytes.\n\nUse [Task parameter variables](https://docs.databricks.com/jobs.html#parameter-variables) to set parameters containing information about job runs.\n\nImportant\n\nThese parameters accept only Latin characters (ASCII character set). Using non-ASCII characters returns an error.\nExamples of invalid, non-ASCII characters are Chinese, Japanese kanjis, and emojis.',
    )
    spark_submit_params: Optional[List[str]] = Field(
        None,
        description='A list of parameters for jobs with spark submit task, for example `"spark_submit_params": ["--class", "org.apache.spark.examples.SparkPi"]`.\nThe parameters are passed to spark-submit script as command-line parameters. If specified upon `run-now`, it would overwrite the\nparameters specified in job setting. The JSON representation of this field (for example `{"python_params":["john doe","35"]}`)\ncannot exceed 10,000 bytes.\n\nUse [Task parameter variables](https://docs.databricks.com/jobs.html#parameter-variables) to set parameters containing information about job runs\n\nImportant\n\nThese parameters accept only Latin characters (ASCII character set). Using non-ASCII characters returns an error.\nExamples of invalid, non-ASCII characters are Chinese, Japanese kanjis, and emojis.',
    )
    sql_params: Optional[Dict[str, str]] = None


class JobsTasksSparkJarTask(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    jar_uri: Optional[str] = Field(
        None,
        description='Deprecated since 04/2016. Provide a `jar` through the `libraries` field instead. For an example, see :method:jobs/create.',
    )
    main_class_name: Optional[str] = Field(
        None,
        description='The full name of the class containing the main method to be executed. This class must be contained in a JAR provided as a library.\n\nThe code must use `SparkContext.getOrCreate` to obtain a Spark context; otherwise, runs of the job fail.',
    )
    parameters: Optional[List[str]] = Field(
        None,
        description='Parameters passed to the main method.\n\nUse [Task parameter variables](https://docs.databricks.com/jobs.html#parameter-variables) to set parameters containing information about job runs.',
    )


class JobsTasksSparkPythonTask(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    parameters: Optional[List[str]] = Field(
        None,
        description='Command line parameters passed to the Python file.\n\nUse [Task parameter variables](https://docs.databricks.com/jobs.html#parameter-variables) to set parameters containing information about job runs.',
    )
    python_file: str = Field(
        ...,
        description='The Python file to be executed. Cloud file URIs (such as dbfs:/, s3:/, adls:/, gcs:/) and workspace paths are supported. For python files stored in the Databricks workspace, the path must be absolute and begin with `/`. For files stored in a remote repository, the path must be relative. This field is required.',
    )
    source: Optional[str] = Field(
        None,
        description='Optional location type of the Python file. When set to `WORKSPACE` or not specified, the file will be retrieved from the local\nDatabricks workspace or cloud location (if the `python_file` has a URI format). When set to `GIT`,\nthe Python file will be retrieved from a Git repository defined in `git_source`.\n\n* `WORKSPACE`: The Python file is located in a Databricks workspace or at a cloud filesystem URI.\n* `GIT`: The Python file is located in a remote Git repository.',
    )


class JobsTasksSparkSubmitTask(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    parameters: Optional[List[str]] = Field(
        None,
        description='Command-line parameters passed to spark submit.\n\nUse [Task parameter variables](https://docs.databricks.com/jobs.html#parameter-variables) to set parameters containing information about job runs.',
    )


class JobsTasksSqlTaskAlertSubscriptions(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination_id: Optional[str] = Field(
        None,
        description='The canonical identifier of the destination to receive email notification. This parameter is mutually exclusive with user_name. You cannot set both destination_id and user_name for subscription notifications.',
    )
    user_name: Optional[str] = Field(
        None,
        description='The user name to receive the subscription email. This parameter is mutually exclusive with destination_id. You cannot set both destination_id and user_name for subscription notifications.',
    )


class JobsTasksSqlTaskAlert(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    alert_id: str = Field(..., description='The canonical identifier of the SQL alert.')
    pause_subscriptions: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If true, the alert notifications are not sent to subscribers.',
    )
    subscriptions: Optional[List[JobsTasksSqlTaskAlertSubscriptions]] = Field(
        None, description='If specified, alert notifications are sent to subscribers.'
    )


class JobsTasksSqlTaskDashboardSubscriptions(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination_id: Optional[str] = Field(
        None,
        description='The canonical identifier of the destination to receive email notification. This parameter is mutually exclusive with user_name. You cannot set both destination_id and user_name for subscription notifications.',
    )
    user_name: Optional[str] = Field(
        None,
        description='The user name to receive the subscription email. This parameter is mutually exclusive with destination_id. You cannot set both destination_id and user_name for subscription notifications.',
    )


class JobsTasksSqlTaskDashboard(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    custom_subject: Optional[str] = Field(
        None, description='Subject of the email sent to subscribers of this task.'
    )
    dashboard_id: str = Field(
        ..., description='The canonical identifier of the SQL dashboard.'
    )
    pause_subscriptions: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If true, the dashboard snapshot is not taken, and emails are not sent to subscribers.',
    )
    subscriptions: Optional[List[JobsTasksSqlTaskDashboardSubscriptions]] = Field(
        None, description='If specified, dashboard snapshots are sent to subscriptions.'
    )


class JobsTasksSqlTaskFile(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    path: str = Field(
        ...,
        description='Path of the SQL file. Must be relative if the source is a remote Git repository and absolute for workspace paths.',
    )
    source: Optional[str] = Field(
        None,
        description='Optional location type of the SQL file. When set to `WORKSPACE`, the SQL file will be retrieved\nfrom the local Databricks workspace. When set to `GIT`, the SQL file will be retrieved from a Git repository\ndefined in `git_source`. If the value is empty, the task will use `GIT` if `git_source` is defined and `WORKSPACE` otherwise.\n\n* `WORKSPACE`: SQL file is located in Databricks workspace.\n* `GIT`: SQL file is located in cloud Git provider.',
    )


class JobsTasksSqlTaskQuery(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    query_id: str = Field(..., description='The canonical identifier of the SQL query.')


class JobsTasksSqlTask(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    alert: Optional[JobsTasksSqlTaskAlert] = None
    dashboard: Optional[JobsTasksSqlTaskDashboard] = None
    file: Optional[JobsTasksSqlTaskFile] = None
    parameters: Optional[Dict[str, str]] = None
    query: Optional[JobsTasksSqlTaskQuery] = None
    warehouse_id: str = Field(
        ...,
        description='The canonical identifier of the SQL warehouse. Recommended to use with serverless or pro SQL warehouses. Classic SQL warehouses are only supported for SQL alert, dashboard and query tasks and are limited to scheduled single-task jobs.',
    )


class JobsTasksWebhookNotificationsOnDurationWarningThresholdExceeded(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    id: str


class JobsTasksWebhookNotificationsOnFailure(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    id: str


class JobsTasksWebhookNotificationsOnStart(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    id: str


class JobsTasksWebhookNotificationsOnStreamingBacklogExceeded(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    id: str


class JobsTasksWebhookNotificationsOnSuccess(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    id: str


class JobsTasksWebhookNotifications(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    on_duration_warning_threshold_exceeded: Optional[
        List[JobsTasksWebhookNotificationsOnDurationWarningThresholdExceeded]
    ] = Field(
        None,
        description='An optional list of system notification IDs to call when the duration of a run exceeds the threshold specified for the `RUN_DURATION_SECONDS` metric in the `health` field. A maximum of 3 destinations can be specified for the `on_duration_warning_threshold_exceeded` property.',
    )
    on_failure: Optional[List[JobsTasksWebhookNotificationsOnFailure]] = Field(
        None,
        description='An optional list of system notification IDs to call when the run fails. A maximum of 3 destinations can be specified for the `on_failure` property.',
    )
    on_start: Optional[List[JobsTasksWebhookNotificationsOnStart]] = Field(
        None,
        description='An optional list of system notification IDs to call when the run starts. A maximum of 3 destinations can be specified for the `on_start` property.',
    )
    on_streaming_backlog_exceeded: Optional[
        List[JobsTasksWebhookNotificationsOnStreamingBacklogExceeded]
    ] = Field(
        None,
        description='An optional list of system notification IDs to call when any streaming backlog thresholds are exceeded for any stream.\nStreaming backlog thresholds can be set in the `health` field using the following metrics: `STREAMING_BACKLOG_BYTES`, `STREAMING_BACKLOG_RECORDS`, `STREAMING_BACKLOG_SECONDS`, or `STREAMING_BACKLOG_FILES`.\nAlerting is based on the 10-minute average of these metrics. If the issue persists, notifications are resent every 30 minutes.\nA maximum of 3 destinations can be specified for the `on_streaming_backlog_exceeded` property.',
    )
    on_success: Optional[List[JobsTasksWebhookNotificationsOnSuccess]] = Field(
        None,
        description='An optional list of system notification IDs to call when the run completes successfully. A maximum of 3 destinations can be specified for the `on_success` property.',
    )


class JobsTasks(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    condition_task: Optional[JobsTasksConditionTask] = None
    dbt_task: Optional[JobsTasksDbtTask] = None
    depends_on: Optional[List[JobsTasksDependsOn]] = Field(
        None,
        description='An optional array of objects specifying the dependency graph of the task. All tasks specified in this field must complete before executing this task. The task will run only if the `run_if` condition is true.\nThe key is `task_key`, and the value is the name assigned to the dependent task.',
    )
    description: Optional[str] = Field(
        None, description='An optional description for this task.'
    )
    disable_auto_optimization: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(None, description='An option to disable auto optimization in serverless')
    email_notifications: Optional[JobsTasksEmailNotifications] = None
    environment_key: Optional[str] = Field(
        None,
        description='The key that references an environment spec in a job. This field is required for Python script, Python wheel and dbt tasks when using serverless compute.',
    )
    existing_cluster_id: Optional[str] = Field(
        None,
        description='If existing_cluster_id, the ID of an existing cluster that is used for all runs.\nWhen running jobs or tasks on an existing cluster, you may need to manually restart\nthe cluster if it stops responding. We suggest running jobs and tasks on new clusters for\ngreater reliability',
    )
    for_each_task: Optional[JobsTasksForEachTask] = None
    health: Optional[JobsTasksHealth] = None
    job_cluster_key: Optional[str] = Field(
        None,
        description='If job_cluster_key, this task is executed reusing the cluster specified in `job.settings.job_clusters`.',
    )
    libraries: Optional[List[JobsTasksLibraries]] = Field(
        None,
        description='An optional list of libraries to be installed on the cluster.\nThe default value is an empty list.',
    )
    max_retries: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='An optional maximum number of times to retry an unsuccessful run. A run is considered to be unsuccessful if it completes with the `FAILED` result_state or `INTERNAL_ERROR` `life_cycle_state`. The value `-1` means to retry indefinitely and the value `0` means to never retry.',
    )
    min_retry_interval_millis: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='An optional minimal interval in milliseconds between the start of the failed run and the subsequent retry run. The default behavior is that unsuccessful runs are immediately retried.',
    )
    new_cluster: Optional[JobsTasksNewCluster] = None
    notebook_task: Optional[JobsTasksNotebookTask] = None
    notification_settings: Optional[JobsTasksNotificationSettings] = None
    pipeline_task: Optional[JobsTasksPipelineTask] = None
    python_wheel_task: Optional[JobsTasksPythonWheelTask] = None
    retry_on_timeout: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='An optional policy to specify whether to retry a job when it times out. The default behavior\nis to not retry on timeout.',
    )
    run_if: Optional[str] = Field(
        None,
        description='An optional value specifying the condition determining whether the task is run once its dependencies have been completed.\n\n* `ALL_SUCCESS`: All dependencies have executed and succeeded\n* `AT_LEAST_ONE_SUCCESS`: At least one dependency has succeeded\n* `NONE_FAILED`: None of the dependencies have failed and at least one was executed\n* `ALL_DONE`: All dependencies have been completed\n* `AT_LEAST_ONE_FAILED`: At least one dependency failed\n* `ALL_FAILED`: ALl dependencies have failed',
    )
    run_job_task: Optional[JobsTasksRunJobTask] = None
    spark_jar_task: Optional[JobsTasksSparkJarTask] = None
    spark_python_task: Optional[JobsTasksSparkPythonTask] = None
    spark_submit_task: Optional[JobsTasksSparkSubmitTask] = None
    sql_task: Optional[JobsTasksSqlTask] = None
    task_key: str = Field(
        ...,
        description='A unique name for the task. This field is used to refer to this task from other tasks.\nThis field is required and must be unique within its parent job.\nOn Update or Reset, this field is used to reference the tasks to be updated or reset.',
    )
    timeout_seconds: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='An optional timeout applied to each run of this job task. A value of `0` means no timeout.',
    )
    webhook_notifications: Optional[JobsTasksWebhookNotifications] = None


class JobsTriggerFileArrival(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    min_time_between_triggers_seconds: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If set, the trigger starts a run only after the specified amount of time passed since\nthe last time the trigger fired. The minimum allowed value is 60 seconds',
    )
    url: str = Field(
        ...,
        description='URL to be monitored for file arrivals. The path must point to the root or a subpath of the external location.',
    )
    wait_after_last_change_seconds: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If set, the trigger starts a run only after no file activity has occurred for the specified amount of time.\nThis makes it possible to wait for a batch of incoming files to arrive before triggering a run. The\nminimum allowed value is 60 seconds.',
    )


class JobsTriggerPeriodic(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    interval: Union[
        float,
        constr(
            pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
        ),
    ] = Field(..., description='The interval at which the trigger should run.')
    unit: str = Field(..., description='The unit of time for the interval.')


class JobsTriggerTable(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    condition: Optional[str] = Field(
        None, description='The table(s) condition based on which to trigger a job run.'
    )
    min_time_between_triggers_seconds: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If set, the trigger starts a run only after the specified amount of time has passed since\nthe last time the trigger fired. The minimum allowed value is 60 seconds.',
    )
    table_names: Optional[List[str]] = Field(
        None,
        description='A list of Delta tables to monitor for changes. The table name must be in the format `catalog_name.schema_name.table_name`.',
    )
    wait_after_last_change_seconds: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If set, the trigger starts a run only after no table updates have occurred for the specified time\nand can be used to wait for a series of table updates before triggering a run. The\nminimum allowed value is 60 seconds.',
    )


class JobsTriggerTableUpdate(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    condition: Optional[str] = Field(
        None, description='The table(s) condition based on which to trigger a job run.'
    )
    min_time_between_triggers_seconds: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If set, the trigger starts a run only after the specified amount of time has passed since\nthe last time the trigger fired. The minimum allowed value is 60 seconds.',
    )
    table_names: Optional[List[str]] = Field(
        None,
        description='A list of Delta tables to monitor for changes. The table name must be in the format `catalog_name.schema_name.table_name`.',
    )
    wait_after_last_change_seconds: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If set, the trigger starts a run only after no table updates have occurred for the specified time\nand can be used to wait for a series of table updates before triggering a run. The\nminimum allowed value is 60 seconds.',
    )


class JobsTrigger(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    file_arrival: Optional[JobsTriggerFileArrival] = None
    pause_status: Optional[str] = Field(
        None, description='Whether this trigger is paused or not.'
    )
    periodic: Optional[JobsTriggerPeriodic] = None
    table: Optional[JobsTriggerTable] = None
    table_update: Optional[JobsTriggerTableUpdate] = None


class JobsWebhookNotificationsOnDurationWarningThresholdExceeded(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    id: str


class JobsWebhookNotificationsOnFailure(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    id: str


class JobsWebhookNotificationsOnStart(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    id: str


class JobsWebhookNotificationsOnStreamingBacklogExceeded(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    id: str


class JobsWebhookNotificationsOnSuccess(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    id: str


class JobsWebhookNotifications(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    on_duration_warning_threshold_exceeded: Optional[
        List[JobsWebhookNotificationsOnDurationWarningThresholdExceeded]
    ] = Field(
        None,
        description='An optional list of system notification IDs to call when the duration of a run exceeds the threshold specified for the `RUN_DURATION_SECONDS` metric in the `health` field. A maximum of 3 destinations can be specified for the `on_duration_warning_threshold_exceeded` property.',
    )
    on_failure: Optional[List[JobsWebhookNotificationsOnFailure]] = Field(
        None,
        description='An optional list of system notification IDs to call when the run fails. A maximum of 3 destinations can be specified for the `on_failure` property.',
    )
    on_start: Optional[List[JobsWebhookNotificationsOnStart]] = Field(
        None,
        description='An optional list of system notification IDs to call when the run starts. A maximum of 3 destinations can be specified for the `on_start` property.',
    )
    on_streaming_backlog_exceeded: Optional[
        List[JobsWebhookNotificationsOnStreamingBacklogExceeded]
    ] = Field(
        None,
        description='An optional list of system notification IDs to call when any streaming backlog thresholds are exceeded for any stream.\nStreaming backlog thresholds can be set in the `health` field using the following metrics: `STREAMING_BACKLOG_BYTES`, `STREAMING_BACKLOG_RECORDS`, `STREAMING_BACKLOG_SECONDS`, or `STREAMING_BACKLOG_FILES`.\nAlerting is based on the 10-minute average of these metrics. If the issue persists, notifications are resent every 30 minutes.\nA maximum of 3 destinations can be specified for the `on_streaming_backlog_exceeded` property.',
    )
    on_success: Optional[List[JobsWebhookNotificationsOnSuccess]] = Field(
        None,
        description='An optional list of system notification IDs to call when the run completes successfully. A maximum of 3 destinations can be specified for the `on_success` property.',
    )


class Jobs(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    continuous: Optional[JobsContinuous] = None
    deployment: Optional[JobsDeployment] = None
    description: Optional[str] = Field(
        None,
        description='An optional description for the job. The maximum length is 27700 characters in UTF-8 encoding.',
    )
    edit_mode: Optional[str] = Field(
        None,
        description='Edit mode of the job.\n\n* `UI_LOCKED`: The job is in a locked UI state and cannot be modified.\n* `EDITABLE`: The job is in an editable state and can be modified.',
    )
    email_notifications: Optional[JobsEmailNotifications] = None
    environments: Optional[List[JobsEnvironments]] = Field(
        None,
        description='A list of task execution environment specifications that can be referenced by tasks of this job.',
    )
    format: Optional[str] = Field(
        None,
        description='Used to tell what is the format of the job. This field is ignored in Create/Update/Reset calls. When using the Jobs API 2.1 this value is always set to `"MULTI_TASK"`.',
    )
    git_source: Optional[JobsGitSource] = None
    health: Optional[JobsHealth] = None
    job_clusters: Optional[List[JobsJobClusters]] = Field(
        None,
        description='A list of job cluster specifications that can be shared and reused by tasks of this job. Libraries cannot be declared in a shared job cluster. You must declare dependent libraries in task settings.',
    )
    max_concurrent_runs: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='An optional maximum allowed number of concurrent runs of the job.\nSet this value if you want to be able to execute multiple runs of the same job concurrently.\nThis is useful for example if you trigger your job on a frequent schedule and want to allow consecutive runs to overlap with each other, or if you want to trigger multiple runs which differ by their input parameters.\nThis setting affects only new runs. For example, suppose the job’s concurrency is 4 and there are 4 concurrent active runs. Then setting the concurrency to 3 won’t kill any of the active runs.\nHowever, from then on, new runs are skipped unless there are fewer than 3 active runs.\nThis value cannot exceed 1000. Setting this value to `0` causes all new runs to be skipped.',
    )
    name: Optional[str] = Field(
        None,
        description='An optional name for the job. The maximum length is 4096 bytes in UTF-8 encoding.',
    )
    notification_settings: Optional[JobsNotificationSettings] = None
    parameters: Optional[List[JobsParameters]] = Field(
        None, description='Job-level parameter definitions'
    )
    permissions: Optional[List[JobsPermissions]] = None
    queue: Optional[JobsQueue] = None
    run_as: Optional[JobsRunAs] = None
    schedule: Optional[JobsSchedule] = None
    tags: Optional[Dict[str, str]] = None
    tasks: Optional[List[JobsTasks]] = Field(
        None, description='A list of task specifications to be executed by this job.'
    )
    timeout_seconds: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='An optional timeout applied to each run of this job. A value of `0` means no timeout.',
    )
    trigger: Optional[JobsTrigger] = None
    webhook_notifications: Optional[JobsWebhookNotifications] = None


class ModelServingEndpointsConfigAutoCaptureConfig(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    catalog_name: Optional[str] = Field(
        None,
        description='The name of the catalog in Unity Catalog. NOTE: On update, you cannot change the catalog name if the inference table is already enabled.',
    )
    enabled: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(None, description='Indicates whether the inference table is enabled.')
    schema_name: Optional[str] = Field(
        None,
        description='The name of the schema in Unity Catalog. NOTE: On update, you cannot change the schema name if the inference table is already enabled.',
    )
    table_name_prefix: Optional[str] = Field(
        None,
        description='The prefix of the table in Unity Catalog. NOTE: On update, you cannot change the prefix name if the inference table is already enabled.',
    )


class ModelServingEndpointsConfigServedEntitiesExternalModelAi21labsConfig(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    ai21labs_api_key: Optional[str] = Field(
        None,
        description='The Databricks secret key reference for an AI21 Labs API key. If you prefer to paste your API key directly, see `ai21labs_api_key_plaintext`. You must provide an API key using one of the following fields: `ai21labs_api_key` or `ai21labs_api_key_plaintext`.',
    )
    ai21labs_api_key_plaintext: Optional[str] = Field(
        None,
        description='An AI21 Labs API key provided as a plaintext string. If you prefer to reference your key using Databricks Secrets, see `ai21labs_api_key`. You must provide an API key using one of the following fields: `ai21labs_api_key` or `ai21labs_api_key_plaintext`.',
    )


class ModelServingEndpointsConfigServedEntitiesExternalModelAmazonBedrockConfig(
    BaseModel
):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    aws_access_key_id: Optional[str] = Field(
        None,
        description='The Databricks secret key reference for an AWS access key ID with permissions to interact with Bedrock services. If you prefer to paste your API key directly, see `aws_access_key_id`. You must provide an API key using one of the following fields: `aws_access_key_id` or `aws_access_key_id_plaintext`.',
    )
    aws_access_key_id_plaintext: Optional[str] = Field(
        None,
        description='An AWS access key ID with permissions to interact with Bedrock services provided as a plaintext string. If you prefer to reference your key using Databricks Secrets, see `aws_access_key_id`. You must provide an API key using one of the following fields: `aws_access_key_id` or `aws_access_key_id_plaintext`.',
    )
    aws_region: str = Field(
        ..., description='The AWS region to use. Bedrock has to be enabled there.'
    )
    aws_secret_access_key: Optional[str] = Field(
        None,
        description='The Databricks secret key reference for an AWS secret access key paired with the access key ID, with permissions to interact with Bedrock services. If you prefer to paste your API key directly, see `aws_secret_access_key_plaintext`. You must provide an API key using one of the following fields: `aws_secret_access_key` or `aws_secret_access_key_plaintext`.',
    )
    aws_secret_access_key_plaintext: Optional[str] = Field(
        None,
        description='An AWS secret access key paired with the access key ID, with permissions to interact with Bedrock services provided as a plaintext string. If you prefer to reference your key using Databricks Secrets, see `aws_secret_access_key`. You must provide an API key using one of the following fields: `aws_secret_access_key` or `aws_secret_access_key_plaintext`.',
    )
    bedrock_provider: str = Field(
        ...,
        description='The underlying provider in Amazon Bedrock. Supported values (case insensitive) include: Anthropic, Cohere, AI21Labs, Amazon.',
    )


class ModelServingEndpointsConfigServedEntitiesExternalModelAnthropicConfig(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    anthropic_api_key: Optional[str] = Field(
        None,
        description='The Databricks secret key reference for an Anthropic API key. If you prefer to paste your API key directly, see `anthropic_api_key_plaintext`. You must provide an API key using one of the following fields: `anthropic_api_key` or `anthropic_api_key_plaintext`.',
    )
    anthropic_api_key_plaintext: Optional[str] = Field(
        None,
        description='The Anthropic API key provided as a plaintext string. If you prefer to reference your key using Databricks Secrets, see `anthropic_api_key`. You must provide an API key using one of the following fields: `anthropic_api_key` or `anthropic_api_key_plaintext`.',
    )


class ModelServingEndpointsConfigServedEntitiesExternalModelCohereConfig(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    cohere_api_base: Optional[str] = Field(
        None,
        description='This is an optional field to provide a customized base URL for the Cohere API. \nIf left unspecified, the standard Cohere base URL is used.\n',
    )
    cohere_api_key: Optional[str] = Field(
        None,
        description='The Databricks secret key reference for a Cohere API key. If you prefer to paste your API key directly, see `cohere_api_key_plaintext`. You must provide an API key using one of the following fields: `cohere_api_key` or `cohere_api_key_plaintext`.',
    )
    cohere_api_key_plaintext: Optional[str] = Field(
        None,
        description='The Cohere API key provided as a plaintext string. If you prefer to reference your key using Databricks Secrets, see `cohere_api_key`. You must provide an API key using one of the following fields: `cohere_api_key` or `cohere_api_key_plaintext`.',
    )


class ModelServingEndpointsConfigServedEntitiesExternalModelDatabricksModelServingConfig(
    BaseModel
):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    databricks_api_token: Optional[str] = Field(
        None,
        description='The Databricks secret key reference for a Databricks API token that corresponds to a user or service\nprincipal with Can Query access to the model serving endpoint pointed to by this external model.\nIf you prefer to paste your API key directly, see `databricks_api_token_plaintext`.\nYou must provide an API key using one of the following fields: `databricks_api_token` or `databricks_api_token_plaintext`.\n',
    )
    databricks_api_token_plaintext: Optional[str] = Field(
        None,
        description='The Databricks API token that corresponds to a user or service\nprincipal with Can Query access to the model serving endpoint pointed to by this external model provided as a plaintext string.\nIf you prefer to reference your key using Databricks Secrets, see `databricks_api_token`.\nYou must provide an API key using one of the following fields: `databricks_api_token` or `databricks_api_token_plaintext`.\n',
    )
    databricks_workspace_url: str = Field(
        ...,
        description='The URL of the Databricks workspace containing the model serving endpoint pointed to by this external model.\n',
    )


class ModelServingEndpointsConfigServedEntitiesExternalModelGoogleCloudVertexAiConfig(
    BaseModel
):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    private_key: Optional[str] = Field(
        None,
        description='The Databricks secret key reference for a private key for the service account which has access to the Google Cloud Vertex AI Service. See [Best practices for managing service account keys](https://cloud.google.com/iam/docs/best-practices-for-managing-service-account-keys). If you prefer to paste your API key directly, see `private_key_plaintext`. You must provide an API key using one of the following fields: `private_key` or `private_key_plaintext`',
    )
    private_key_plaintext: Optional[str] = Field(
        None,
        description='The private key for the service account which has access to the Google Cloud Vertex AI Service provided as a plaintext secret. See [Best practices for managing service account keys](https://cloud.google.com/iam/docs/best-practices-for-managing-service-account-keys). If you prefer to reference your key using Databricks Secrets, see `private_key`. You must provide an API key using one of the following fields: `private_key` or `private_key_plaintext`.',
    )
    project_id: Optional[str] = Field(
        None,
        description='This is the Google Cloud project id that the service account is associated with.',
    )
    region: Optional[str] = Field(
        None,
        description='This is the region for the Google Cloud Vertex AI Service. See [supported regions](https://cloud.google.com/vertex-ai/docs/general/locations) for more details. Some models are only available in specific regions.',
    )


class ModelServingEndpointsConfigServedEntitiesExternalModelOpenaiConfig(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    microsoft_entra_client_id: Optional[str] = Field(
        None,
        description='This field is only required for Azure AD OpenAI and is the Microsoft Entra Client ID.\n',
    )
    microsoft_entra_client_secret: Optional[str] = Field(
        None,
        description='The Databricks secret key reference for a client secret used for Microsoft Entra ID authentication.\nIf you prefer to paste your client secret directly, see `microsoft_entra_client_secret_plaintext`.\nYou must provide an API key using one of the following fields: `microsoft_entra_client_secret` or `microsoft_entra_client_secret_plaintext`.\n',
    )
    microsoft_entra_client_secret_plaintext: Optional[str] = Field(
        None,
        description='The client secret used for Microsoft Entra ID authentication provided as a plaintext string.\nIf you prefer to reference your key using Databricks Secrets, see `microsoft_entra_client_secret`.\nYou must provide an API key using one of the following fields: `microsoft_entra_client_secret` or `microsoft_entra_client_secret_plaintext`.\n',
    )
    microsoft_entra_tenant_id: Optional[str] = Field(
        None,
        description='This field is only required for Azure AD OpenAI and is the Microsoft Entra Tenant ID.\n',
    )
    openai_api_base: Optional[str] = Field(
        None,
        description='This is a field to provide a customized base URl for the OpenAI API.\nFor Azure OpenAI, this field is required, and is the base URL for the Azure OpenAI API service\nprovided by Azure.\nFor other OpenAI API types, this field is optional, and if left unspecified, the standard OpenAI base URL is used.\n',
    )
    openai_api_key: Optional[str] = Field(
        None,
        description='The Databricks secret key reference for an OpenAI API key using the OpenAI or Azure service. If you prefer to paste your API key directly, see `openai_api_key_plaintext`. You must provide an API key using one of the following fields: `openai_api_key` or `openai_api_key_plaintext`.',
    )
    openai_api_key_plaintext: Optional[str] = Field(
        None,
        description='The OpenAI API key using the OpenAI or Azure service provided as a plaintext string. If you prefer to reference your key using Databricks Secrets, see `openai_api_key`. You must provide an API key using one of the following fields: `openai_api_key` or `openai_api_key_plaintext`.',
    )
    openai_api_type: Optional[str] = Field(
        None,
        description='This is an optional field to specify the type of OpenAI API to use.\nFor Azure OpenAI, this field is required, and adjust this parameter to represent the preferred security\naccess validation protocol. For access token validation, use azure. For authentication using Azure Active\nDirectory (Azure AD) use, azuread.\n',
    )
    openai_api_version: Optional[str] = Field(
        None,
        description='This is an optional field to specify the OpenAI API version.\nFor Azure OpenAI, this field is required, and is the version of the Azure OpenAI service to\nutilize, specified by a date.\n',
    )
    openai_deployment_name: Optional[str] = Field(
        None,
        description='This field is only required for Azure OpenAI and is the name of the deployment resource for the\nAzure OpenAI service.\n',
    )
    openai_organization: Optional[str] = Field(
        None,
        description='This is an optional field to specify the organization in OpenAI or Azure OpenAI.\n',
    )


class ModelServingEndpointsConfigServedEntitiesExternalModelPalmConfig(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    palm_api_key: Optional[str] = Field(
        None,
        description='The Databricks secret key reference for a PaLM API key. If you prefer to paste your API key directly, see `palm_api_key_plaintext`. You must provide an API key using one of the following fields: `palm_api_key` or `palm_api_key_plaintext`.',
    )
    palm_api_key_plaintext: Optional[str] = Field(
        None,
        description='The PaLM API key provided as a plaintext string. If you prefer to reference your key using Databricks Secrets, see `palm_api_key`. You must provide an API key using one of the following fields: `palm_api_key` or `palm_api_key_plaintext`.',
    )


class ModelServingEndpointsConfigServedEntitiesExternalModel(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    ai21labs_config: Optional[
        ModelServingEndpointsConfigServedEntitiesExternalModelAi21labsConfig
    ] = None
    amazon_bedrock_config: Optional[
        ModelServingEndpointsConfigServedEntitiesExternalModelAmazonBedrockConfig
    ] = None
    anthropic_config: Optional[
        ModelServingEndpointsConfigServedEntitiesExternalModelAnthropicConfig
    ] = None
    cohere_config: Optional[
        ModelServingEndpointsConfigServedEntitiesExternalModelCohereConfig
    ] = None
    databricks_model_serving_config: Optional[
        ModelServingEndpointsConfigServedEntitiesExternalModelDatabricksModelServingConfig
    ] = None
    google_cloud_vertex_ai_config: Optional[
        ModelServingEndpointsConfigServedEntitiesExternalModelGoogleCloudVertexAiConfig
    ] = None
    name: str = Field(..., description='The name of the external model.')
    openai_config: Optional[
        ModelServingEndpointsConfigServedEntitiesExternalModelOpenaiConfig
    ] = None
    palm_config: Optional[
        ModelServingEndpointsConfigServedEntitiesExternalModelPalmConfig
    ] = None
    provider: str = Field(
        ...,
        description='The name of the provider for the external model. Currently, the supported providers are \'ai21labs\', \'anthropic\',\n\'amazon-bedrock\', \'cohere\', \'databricks-model-serving\', \'google-cloud-vertex-ai\', \'openai\', and \'palm\'.",\n',
    )
    task: str = Field(..., description='The task type of the external model.')


class ModelServingEndpointsConfigServedEntities(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    entity_name: Optional[str] = Field(
        None,
        description='The name of the entity to be served. The entity may be a model in the Databricks Model Registry, a model in the Unity Catalog (UC),\nor a function of type FEATURE_SPEC in the UC. If it is a UC object, the full name of the object should be given in the form of\n__catalog_name__.__schema_name__.__model_name__.\n',
    )
    entity_version: Optional[str] = Field(
        None,
        description='The version of the model in Databricks Model Registry to be served or empty if the entity is a FEATURE_SPEC.',
    )
    environment_vars: Optional[Dict[str, str]] = None
    external_model: Optional[
        ModelServingEndpointsConfigServedEntitiesExternalModel
    ] = None
    instance_profile_arn: Optional[str] = Field(
        None,
        description='ARN of the instance profile that the served entity uses to access AWS resources.',
    )
    max_provisioned_throughput: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='The maximum tokens per second that the endpoint can scale up to.',
    )
    min_provisioned_throughput: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='The minimum tokens per second that the endpoint can scale down to.',
    )
    name: Optional[str] = Field(
        None,
        description="The name of a served entity. It must be unique across an endpoint. A served entity name can consist of alphanumeric characters, dashes, and underscores.\nIf not specified for an external model, this field defaults to external_model.name, with '.' and ':' replaced with '-', and if not specified for other\nentities, it defaults to <entity-name>-<entity-version>.\n",
    )
    scale_to_zero_enabled: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='Whether the compute resources for the served entity should scale down to zero.',
    )
    workload_size: Optional[str] = Field(
        None,
        description='The workload size of the served entity. The workload size corresponds to a range of provisioned concurrency that the compute autoscales between.\nA single unit of provisioned concurrency can process one request at a time.\nValid workload sizes are "Small" (4 - 4 provisioned concurrency), "Medium" (8 - 16 provisioned concurrency), and "Large" (16 - 64 provisioned concurrency).\nIf scale-to-zero is enabled, the lower bound of the provisioned concurrency for each workload size is 0.\n',
    )
    workload_type: Optional[str] = Field(
        None,
        description='The workload type of the served entity. The workload type selects which type of compute to use in the endpoint. The default value for this parameter is\n"CPU". For deep learning workloads, GPU acceleration is available by selecting workload types like GPU_SMALL and others.\nSee the available [GPU types](https://docs.databricks.com/machine-learning/model-serving/create-manage-serving-endpoints.html#gpu-workload-types).\n',
    )


class ModelServingEndpointsConfigServedModels(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    environment_vars: Optional[Dict[str, str]] = None
    instance_profile_arn: Optional[str] = Field(
        None,
        description='ARN of the instance profile that the served model will use to access AWS resources.',
    )
    model_name: str = Field(
        ...,
        description='The name of the model in Databricks Model Registry to be served or if the model resides in Unity Catalog, the full name of model,\nin the form of __catalog_name__.__schema_name__.__model_name__.\n',
    )
    model_version: str = Field(
        ...,
        description='The version of the model in Databricks Model Registry or Unity Catalog to be served.',
    )
    name: Optional[str] = Field(
        None,
        description='The name of a served model. It must be unique across an endpoint. If not specified, this field will default to <model-name>-<model-version>.\nA served model name can consist of alphanumeric characters, dashes, and underscores.\n',
    )
    scale_to_zero_enabled: Union[
        bool,
        constr(
            pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
        ),
    ] = Field(
        ...,
        description='Whether the compute resources for the served model should scale down to zero.',
    )
    workload_size: str = Field(
        ...,
        description='The workload size of the served model. The workload size corresponds to a range of provisioned concurrency that the compute will autoscale between.\nA single unit of provisioned concurrency can process one request at a time.\nValid workload sizes are "Small" (4 - 4 provisioned concurrency), "Medium" (8 - 16 provisioned concurrency), and "Large" (16 - 64 provisioned concurrency).\nIf scale-to-zero is enabled, the lower bound of the provisioned concurrency for each workload size will be 0.\n',
    )
    workload_type: Optional[str] = Field(
        None,
        description='The workload type of the served model. The workload type selects which type of compute to use in the endpoint. The default value for this parameter is\n"CPU". For deep learning workloads, GPU acceleration is available by selecting workload types like GPU_SMALL and others.\nSee the available [GPU types](https://docs.databricks.com/machine-learning/model-serving/create-manage-serving-endpoints.html#gpu-workload-types).\n',
    )


class ModelServingEndpointsConfigTrafficConfigRoutes(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    served_model_name: str = Field(
        ...,
        description='The name of the served model this route configures traffic for.',
    )
    traffic_percentage: Union[
        float,
        constr(
            pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
        ),
    ] = Field(
        ...,
        description='The percentage of endpoint traffic to send to this route. It must be an integer between 0 and 100 inclusive.',
    )


class ModelServingEndpointsConfigTrafficConfig(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    routes: Optional[List[ModelServingEndpointsConfigTrafficConfigRoutes]] = Field(
        None,
        description='The list of routes that define traffic to each served entity.',
    )


class ModelServingEndpointsConfig(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    auto_capture_config: Optional[ModelServingEndpointsConfigAutoCaptureConfig] = None
    served_entities: Optional[List[ModelServingEndpointsConfigServedEntities]] = Field(
        None,
        description='A list of served entities for the endpoint to serve. A serving endpoint can have up to 15 served entities.',
    )
    served_models: Optional[List[ModelServingEndpointsConfigServedModels]] = Field(
        None,
        description='(Deprecated, use served_entities instead) A list of served models for the endpoint to serve. A serving endpoint can have up to 15 served models.',
    )
    traffic_config: Optional[ModelServingEndpointsConfigTrafficConfig] = None


class ModelServingEndpointsPermissions(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    group_name: Optional[str] = None
    level: str
    service_principal_name: Optional[str] = None
    user_name: Optional[str] = None


class ModelServingEndpointsRateLimits(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    calls: Union[
        float,
        constr(
            pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
        ),
    ] = Field(
        ...,
        description='Used to specify how many calls are allowed for a key within the renewal_period.',
    )
    key: Optional[str] = Field(
        None,
        description="Key field for a serving endpoint rate limit. Currently, only 'user' and 'endpoint' are supported, with 'endpoint' being the default if not specified.",
    )
    renewal_period: str = Field(
        ...,
        description="Renewal period field for a serving endpoint rate limit. Currently, only 'minute' is supported.",
    )


class ModelServingEndpointsTags(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    key: str = Field(..., description='Key field for a serving endpoint tag.')
    value: Optional[str] = Field(
        None, description='Optional value field for a serving endpoint tag.'
    )


class ModelServingEndpoints(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    config: ModelServingEndpointsConfig
    name: str = Field(
        ...,
        description='The name of the serving endpoint. This field is required and must be unique across a Databricks workspace.\nAn endpoint name can consist of alphanumeric characters, dashes, and underscores.\n',
    )
    permissions: Optional[List[ModelServingEndpointsPermissions]] = None
    rate_limits: Optional[List[ModelServingEndpointsRateLimits]] = Field(
        None,
        description='Rate limits to be applied to the serving endpoint. NOTE: only external and foundation model endpoints are supported as of now.',
    )
    route_optimized: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(None, description='Enable route optimization for the serving endpoint.')
    tags: Optional[List[ModelServingEndpointsTags]] = Field(
        None,
        description='Tags to be attached to the serving endpoint and automatically propagated to billing logs.',
    )


class ModelsLatestVersionsTags(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    key: Optional[str] = Field(None, description='The tag key.')
    value: Optional[str] = Field(None, description='The tag value.')


class ModelsLatestVersions(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    creation_timestamp: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None, description='Timestamp recorded when this `model_version` was created.'
    )
    current_stage: Optional[str] = Field(
        None, description='Current stage for this `model_version`.'
    )
    description: Optional[str] = Field(
        None, description='Description of this `model_version`.'
    )
    last_updated_timestamp: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='Timestamp recorded when metadata for this `model_version` was last updated.',
    )
    name: Optional[str] = Field(None, description='Unique name of the model')
    run_id: Optional[str] = Field(
        None,
        description='MLflow run ID used when creating `model_version`, if `source` was generated by an\nexperiment run stored in MLflow tracking server.',
    )
    run_link: Optional[str] = Field(
        None, description='Run Link: Direct link to the run that generated this version'
    )
    source: Optional[str] = Field(
        None,
        description='URI indicating the location of the source model artifacts, used when creating `model_version`',
    )
    status: Optional[str] = Field(None, description='Current status of `model_version`')
    status_message: Optional[str] = Field(
        None, description='Details on current `status`, if it is pending or failed.'
    )
    tags: Optional[List[ModelsLatestVersionsTags]] = Field(
        None,
        description='Tags: Additional metadata key-value pairs for this `model_version`.',
    )
    user_id: Optional[str] = Field(
        None, description='User that created this `model_version`.'
    )
    version: Optional[str] = Field(None, description="Model's version number.")


class ModelsPermissions(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    group_name: Optional[str] = None
    level: str
    service_principal_name: Optional[str] = None
    user_name: Optional[str] = None


class ModelsTags(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    key: Optional[str] = Field(None, description='The tag key.')
    value: Optional[str] = Field(None, description='The tag value.')


class Models(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    creation_timestamp: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None, description='Timestamp recorded when this `registered_model` was created.'
    )
    description: Optional[str] = Field(
        None, description='Description of this `registered_model`.'
    )
    last_updated_timestamp: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='Timestamp recorded when metadata for this `registered_model` was last updated.',
    )
    latest_versions: Optional[List[ModelsLatestVersions]] = Field(
        None,
        description='Collection of latest model versions for each stage.\nOnly contains models with current `READY` status.',
    )
    name: Optional[str] = Field(None, description='Unique name for the model.')
    permissions: Optional[List[ModelsPermissions]] = None
    tags: Optional[List[ModelsTags]] = Field(
        None,
        description='Tags: Additional metadata key-value pairs for this `registered_model`.',
    )
    user_id: Optional[str] = Field(
        None, description='User that created this `registered_model`'
    )


class PipelinesClustersAutoscale(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    max_workers: Union[
        float,
        constr(
            pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
        ),
    ] = Field(
        ...,
        description='The maximum number of workers to which the cluster can scale up when overloaded. `max_workers` must be strictly greater than `min_workers`.',
    )
    min_workers: Union[
        float,
        constr(
            pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
        ),
    ] = Field(
        ...,
        description='The minimum number of workers the cluster can scale down to when underutilized.\nIt is also the initial number of workers the cluster will have after creation.',
    )
    mode: Optional[str] = Field(
        None,
        description='Databricks Enhanced Autoscaling optimizes cluster utilization by automatically\nallocating cluster resources based on workload volume, with minimal impact to\nthe data processing latency of your pipelines. Enhanced Autoscaling is available\nfor `updates` clusters only. The legacy autoscaling feature is used for `maintenance`\nclusters.\n',
    )


class PipelinesClustersAwsAttributes(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    availability: Optional[str] = None
    ebs_volume_count: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='The number of volumes launched for each instance. Users can choose up to 10 volumes.\nThis feature is only enabled for supported node types. Legacy node types cannot specify\ncustom EBS volumes.\nFor node types with no instance store, at least one EBS volume needs to be specified;\notherwise, cluster creation will fail.\n\nThese EBS volumes will be mounted at `/ebs0`, `/ebs1`, and etc.\nInstance store volumes will be mounted at `/local_disk0`, `/local_disk1`, and etc.\n\nIf EBS volumes are attached, Databricks will configure Spark to use only the EBS volumes for\nscratch storage because heterogenously sized scratch devices can lead to inefficient disk\nutilization. If no EBS volumes are attached, Databricks will configure Spark to use instance\nstore volumes.\n\nPlease note that if EBS volumes are specified, then the Spark configuration `spark.local.dir`\nwill be overridden.',
    )
    ebs_volume_iops: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If using gp3 volumes, what IOPS to use for the disk. If this is not set, the maximum performance of a gp2 volume with the same volume size will be used.',
    )
    ebs_volume_size: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='The size of each EBS volume (in GiB) launched for each instance. For general purpose\nSSD, this value must be within the range 100 - 4096. For throughput optimized HDD,\nthis value must be within the range 500 - 4096.',
    )
    ebs_volume_throughput: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If using gp3 volumes, what throughput to use for the disk. If this is not set, the maximum performance of a gp2 volume with the same volume size will be used.',
    )
    ebs_volume_type: Optional[str] = None
    first_on_demand: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='The first `first_on_demand` nodes of the cluster will be placed on on-demand instances.\nIf this value is greater than 0, the cluster driver node in particular will be placed on an\non-demand instance. If this value is greater than or equal to the current cluster size, all\nnodes will be placed on on-demand instances. If this value is less than the current cluster\nsize, `first_on_demand` nodes will be placed on on-demand instances and the remainder will\nbe placed on `availability` instances. Note that this value does not affect\ncluster size and cannot currently be mutated over the lifetime of a cluster.',
    )
    instance_profile_arn: Optional[str] = Field(
        None,
        description='Nodes for this cluster will only be placed on AWS instances with this instance profile. If\nommitted, nodes will be placed on instances without an IAM instance profile. The instance\nprofile must have previously been added to the Databricks environment by an account\nadministrator.\n\nThis feature may only be available to certain customer plans.\n\nIf this field is ommitted, we will pull in the default from the conf if it exists.',
    )
    spot_bid_price_percent: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description="The bid price for AWS spot instances, as a percentage of the corresponding instance type's\non-demand price.\nFor example, if this field is set to 50, and the cluster needs a new `r3.xlarge` spot\ninstance, then the bid price is half of the price of\non-demand `r3.xlarge` instances. Similarly, if this field is set to 200, the bid price is twice\nthe price of on-demand `r3.xlarge` instances. If not specified, the default value is 100.\nWhen spot instances are requested for this cluster, only spot instances whose bid price\npercentage matches this field will be considered.\nNote that, for safety, we enforce this field to be no more than 10000.\n\nThe default value and documentation here should be kept consistent with\nCommonConf.defaultSpotBidPricePercent and CommonConf.maxSpotBidPricePercent.",
    )
    zone_id: Optional[str] = Field(
        None,
        description='Identifier for the availability zone/datacenter in which the cluster resides.\nThis string will be of a form like "us-west-2a". The provided availability\nzone must be in the same region as the Databricks deployment. For example, "us-west-2a"\nis not a valid zone id if the Databricks deployment resides in the "us-east-1" region.\nThis is an optional field at cluster creation, and if not specified, a default zone will be used.\nIf the zone specified is "auto", will try to place cluster in a zone with high availability,\nand will retry placement in a different AZ if there is not enough capacity.\nThe list of available zones as well as the default value can be found by using the\n`List Zones` method.',
    )


class PipelinesClustersAzureAttributesLogAnalyticsInfo(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    log_analytics_primary_key: Optional[str] = Field(
        None, description='<needs content added>'
    )
    log_analytics_workspace_id: Optional[str] = Field(
        None, description='<needs content added>'
    )


class PipelinesClustersAzureAttributes(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    availability: Optional[str] = None
    first_on_demand: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='The first `first_on_demand` nodes of the cluster will be placed on on-demand instances.\nThis value should be greater than 0, to make sure the cluster driver node is placed on an\non-demand instance. If this value is greater than or equal to the current cluster size, all\nnodes will be placed on on-demand instances. If this value is less than the current cluster\nsize, `first_on_demand` nodes will be placed on on-demand instances and the remainder will\nbe placed on `availability` instances. Note that this value does not affect\ncluster size and cannot currently be mutated over the lifetime of a cluster.',
    )
    log_analytics_info: Optional[
        PipelinesClustersAzureAttributesLogAnalyticsInfo
    ] = None
    spot_bid_max_price: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='The max bid price to be used for Azure spot instances.\nThe Max price for the bid cannot be higher than the on-demand price of the instance.\nIf not specified, the default value is -1, which specifies that the instance cannot be evicted\non the basis of price, and only on the basis of availability. Further, the value should > 0 or -1.',
    )


class PipelinesClustersClusterLogConfDbfs(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination: str = Field(..., description='dbfs destination, e.g. `dbfs:/my/path`')


class PipelinesClustersClusterLogConfS(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    canned_acl: Optional[str] = Field(
        None,
        description='(Optional) Set canned access control list for the logs, e.g. `bucket-owner-full-control`.\nIf `canned_cal` is set, please make sure the cluster iam role has `s3:PutObjectAcl` permission on\nthe destination bucket and prefix. The full list of possible canned acl can be found at\nhttp://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl.\nPlease also note that by default only the object owner gets full controls. If you are using cross account\nrole for writing data, you may want to set `bucket-owner-full-control` to make bucket owner able to\nread the logs.',
    )
    destination: str = Field(
        ...,
        description='S3 destination, e.g. `s3://my-bucket/some-prefix` Note that logs will be delivered using\ncluster iam role, please make sure you set cluster iam role and the role has write access to the\ndestination. Please also note that you cannot use AWS keys to deliver logs.',
    )
    enable_encryption: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='(Optional) Flag to enable server side encryption, `false` by default.',
    )
    encryption_type: Optional[str] = Field(
        None,
        description='(Optional) The encryption type, it could be `sse-s3` or `sse-kms`. It will be used only when\nencryption is enabled and the default type is `sse-s3`.',
    )
    endpoint: Optional[str] = Field(
        None,
        description='S3 endpoint, e.g. `https://s3-us-west-2.amazonaws.com`. Either region or endpoint needs to be set.\nIf both are set, endpoint will be used.',
    )
    kms_key: Optional[str] = Field(
        None,
        description='(Optional) Kms key which will be used if encryption is enabled and encryption type is set to `sse-kms`.',
    )
    region: Optional[str] = Field(
        None,
        description='S3 region, e.g. `us-west-2`. Either region or endpoint needs to be set. If both are set,\nendpoint will be used.',
    )


class PipelinesClustersClusterLogConf(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    dbfs: Optional[PipelinesClustersClusterLogConfDbfs] = None
    s3: Optional[PipelinesClustersClusterLogConfS] = None


class PipelinesClustersGcpAttributes(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    availability: Optional[str] = None
    boot_disk_size: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(None, description='boot disk size in GB')
    google_service_account: Optional[str] = Field(
        None,
        description='If provided, the cluster will impersonate the google service account when accessing\ngcloud services (like GCS). The google service account\nmust have previously been added to the Databricks environment by an account\nadministrator.',
    )
    local_ssd_count: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If provided, each node (workers and driver) in the cluster will have this number of local SSDs attached. Each local SSD is 375GB in size. Refer to [GCP documentation](https://cloud.google.com/compute/docs/disks/local-ssd#choose_number_local_ssds) for the supported number of local SSDs for each instance type.',
    )
    use_preemptible_executors: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='This field determines whether the spark executors will be scheduled to run on preemptible VMs (when set to true) versus standard compute engine VMs (when set to false; default).\nNote: Soon to be deprecated, use the availability field instead.',
    )
    zone_id: Optional[str] = Field(
        None,
        description='Identifier for the availability zone in which the cluster resides.\nThis can be one of the following:\n- "HA" => High availability, spread nodes across availability zones for a Databricks deployment region [default]\n- "AUTO" => Databricks picks an availability zone to schedule the cluster on.\n- A GCP availability zone => Pick One of the available zones for (machine type + region) from https://cloud.google.com/compute/docs/regions-zones.',
    )


class PipelinesClustersInitScriptsAbfss(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination: str = Field(
        ...,
        description='abfss destination, e.g. `abfss://<container-name>@<storage-account-name>.dfs.core.windows.net/<directory-name>`.',
    )


class PipelinesClustersInitScriptsDbfs(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination: str = Field(..., description='dbfs destination, e.g. `dbfs:/my/path`')


class PipelinesClustersInitScriptsFile(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination: str = Field(
        ..., description='local file destination, e.g. `file:/my/local/file.sh`'
    )


class PipelinesClustersInitScriptsGcs(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination: str = Field(
        ..., description='GCS destination/URI, e.g. `gs://my-bucket/some-prefix`'
    )


class PipelinesClustersInitScriptsS(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    canned_acl: Optional[str] = Field(
        None,
        description='(Optional) Set canned access control list for the logs, e.g. `bucket-owner-full-control`.\nIf `canned_cal` is set, please make sure the cluster iam role has `s3:PutObjectAcl` permission on\nthe destination bucket and prefix. The full list of possible canned acl can be found at\nhttp://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl.\nPlease also note that by default only the object owner gets full controls. If you are using cross account\nrole for writing data, you may want to set `bucket-owner-full-control` to make bucket owner able to\nread the logs.',
    )
    destination: str = Field(
        ...,
        description='S3 destination, e.g. `s3://my-bucket/some-prefix` Note that logs will be delivered using\ncluster iam role, please make sure you set cluster iam role and the role has write access to the\ndestination. Please also note that you cannot use AWS keys to deliver logs.',
    )
    enable_encryption: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='(Optional) Flag to enable server side encryption, `false` by default.',
    )
    encryption_type: Optional[str] = Field(
        None,
        description='(Optional) The encryption type, it could be `sse-s3` or `sse-kms`. It will be used only when\nencryption is enabled and the default type is `sse-s3`.',
    )
    endpoint: Optional[str] = Field(
        None,
        description='S3 endpoint, e.g. `https://s3-us-west-2.amazonaws.com`. Either region or endpoint needs to be set.\nIf both are set, endpoint will be used.',
    )
    kms_key: Optional[str] = Field(
        None,
        description='(Optional) Kms key which will be used if encryption is enabled and encryption type is set to `sse-kms`.',
    )
    region: Optional[str] = Field(
        None,
        description='S3 region, e.g. `us-west-2`. Either region or endpoint needs to be set. If both are set,\nendpoint will be used.',
    )


class PipelinesClustersInitScriptsVolumes(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination: str = Field(
        ...,
        description='Unity Catalog Volumes file destination, e.g. `/Volumes/my-init.sh`',
    )


class PipelinesClustersInitScriptsWorkspace(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination: str = Field(
        ...,
        description='workspace files destination, e.g. `/Users/user1@databricks.com/my-init.sh`',
    )


class PipelinesClustersInitScripts(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    abfss: Optional[PipelinesClustersInitScriptsAbfss] = None
    dbfs: Optional[PipelinesClustersInitScriptsDbfs] = None
    file: Optional[PipelinesClustersInitScriptsFile] = None
    gcs: Optional[PipelinesClustersInitScriptsGcs] = None
    s3: Optional[PipelinesClustersInitScriptsS] = None
    volumes: Optional[PipelinesClustersInitScriptsVolumes] = None
    workspace: Optional[PipelinesClustersInitScriptsWorkspace] = None


class PipelinesClusters(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    apply_policy_default_values: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description="Note: This field won't be persisted. Only API users will check this field.",
    )
    autoscale: Optional[PipelinesClustersAutoscale] = None
    aws_attributes: Optional[PipelinesClustersAwsAttributes] = None
    azure_attributes: Optional[PipelinesClustersAzureAttributes] = None
    cluster_log_conf: Optional[PipelinesClustersClusterLogConf] = None
    custom_tags: Optional[Dict[str, str]] = None
    driver_instance_pool_id: Optional[str] = Field(
        None,
        description='The optional ID of the instance pool for the driver of the cluster belongs.\nThe pool cluster uses the instance pool with id (instance_pool_id) if the driver pool is not\nassigned.',
    )
    driver_node_type_id: Optional[str] = Field(
        None,
        description='The node type of the Spark driver.\nNote that this field is optional; if unset, the driver node type will be set as the same value\nas `node_type_id` defined above.',
    )
    enable_local_disk_encryption: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None, description='Whether to enable local disk encryption for the cluster.'
    )
    gcp_attributes: Optional[PipelinesClustersGcpAttributes] = None
    init_scripts: Optional[List[PipelinesClustersInitScripts]] = Field(
        None,
        description='The configuration for storing init scripts. Any number of destinations can be specified. The scripts are executed sequentially in the order provided. If `cluster_log_conf` is specified, init script logs are sent to `<destination>/<cluster-ID>/init_scripts`.',
    )
    instance_pool_id: Optional[str] = Field(
        None,
        description='The optional ID of the instance pool to which the cluster belongs.',
    )
    label: Optional[str] = Field(
        None,
        description='A label for the cluster specification, either `default` to configure the default cluster, or `maintenance` to configure the maintenance cluster. This field is optional. The default value is `default`.',
    )
    node_type_id: Optional[str] = Field(
        None,
        description='This field encodes, through a single value, the resources available to each of\nthe Spark nodes in this cluster. For example, the Spark nodes can be provisioned\nand optimized for memory or compute intensive workloads. A list of available node\ntypes can be retrieved by using the :method:clusters/listNodeTypes API call.\n',
    )
    num_workers: Optional[
        Union[
            float,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='Number of worker nodes that this cluster should have. A cluster has one Spark Driver\nand `num_workers` Executors for a total of `num_workers` + 1 Spark nodes.\n\nNote: When reading the properties of a cluster, this field reflects the desired number\nof workers rather than the actual current number of workers. For instance, if a cluster\nis resized from 5 to 10 workers, this field will immediately be updated to reflect\nthe target size of 10 workers, whereas the workers listed in `spark_info` will gradually\nincrease from 5 to 10 as the new nodes are provisioned.',
    )
    policy_id: Optional[str] = Field(
        None,
        description='The ID of the cluster policy used to create the cluster if applicable.',
    )
    spark_conf: Optional[Dict[str, str]] = None
    spark_env_vars: Optional[Dict[str, str]] = None
    ssh_public_keys: Optional[List[str]] = Field(
        None,
        description='SSH public key contents that will be added to each Spark node in this cluster. The\ncorresponding private keys can be used to login with the user name `ubuntu` on port `2200`.\nUp to 10 keys can be specified.',
    )


class PipelinesDeployment(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    kind: Optional[str] = Field(
        None, description='The deployment method that manages the pipeline.'
    )
    metadata_file_path: Optional[str] = Field(
        None,
        description='The path to the file containing metadata about the deployment.',
    )


class PipelinesFilters(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    exclude: Optional[List[str]] = Field(None, description='Paths to exclude.')
    include: Optional[List[str]] = Field(None, description='Paths to include.')


class PipelinesGatewayDefinition(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    connection_id: Optional[str] = Field(
        None,
        description='Immutable. The Unity Catalog connection this gateway pipeline uses to communicate with the source.',
    )
    gateway_storage_catalog: Optional[str] = Field(
        None,
        description="Required, Immutable. The name of the catalog for the gateway pipeline's storage location.",
    )
    gateway_storage_name: Optional[str] = Field(
        None,
        description='Optional. The Unity Catalog-compatible name for the gateway storage location.\nThis is the destination to use for the data that is extracted by the gateway.\nDelta Live Tables system will automatically create the storage location under the catalog and schema.\n',
    )
    gateway_storage_schema: Optional[str] = Field(
        None,
        description="Required, Immutable. The name of the schema for the gateway pipelines's storage location.",
    )


class PipelinesIngestionDefinitionObjectsSchemaTableConfiguration(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    primary_keys: Optional[List[str]] = Field(
        None, description='The primary key of the table used to apply changes.'
    )
    salesforce_include_formula_fields: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If true, formula fields defined in the table are included in the ingestion. This setting is only valid for the Salesforce connector',
    )
    scd_type: Optional[str] = Field(
        None, description='The SCD type to use to ingest the table.'
    )


class PipelinesIngestionDefinitionObjectsSchema(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination_catalog: Optional[str] = Field(
        None, description='Required. Destination catalog to store tables.'
    )
    destination_schema: Optional[str] = Field(
        None,
        description='Required. Destination schema to store tables in. Tables with the same name as the source tables are created in this destination schema. The pipeline fails If a table with the same name already exists.',
    )
    source_catalog: Optional[str] = Field(
        None,
        description='The source catalog name. Might be optional depending on the type of source.',
    )
    source_schema: Optional[str] = Field(
        None, description='Required. Schema name in the source database.'
    )
    table_configuration: Optional[
        PipelinesIngestionDefinitionObjectsSchemaTableConfiguration
    ] = None


class PipelinesIngestionDefinitionObjectsTableTableConfiguration(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    primary_keys: Optional[List[str]] = Field(
        None, description='The primary key of the table used to apply changes.'
    )
    salesforce_include_formula_fields: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If true, formula fields defined in the table are included in the ingestion. This setting is only valid for the Salesforce connector',
    )
    scd_type: Optional[str] = Field(
        None, description='The SCD type to use to ingest the table.'
    )


class PipelinesIngestionDefinitionObjectsTable(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    destination_catalog: Optional[str] = Field(
        None, description='Required. Destination catalog to store table.'
    )
    destination_schema: Optional[str] = Field(
        None, description='Required. Destination schema to store table.'
    )
    destination_table: Optional[str] = Field(
        None,
        description='Optional. Destination table name. The pipeline fails If a table with that name already exists. If not set, the source table name is used.',
    )
    source_catalog: Optional[str] = Field(
        None,
        description='Source catalog name. Might be optional depending on the type of source.',
    )
    source_schema: Optional[str] = Field(
        None,
        description='Schema name in the source database. Might be optional depending on the type of source.',
    )
    source_table: Optional[str] = Field(
        None, description='Required. Table name in the source database.'
    )
    table_configuration: Optional[
        PipelinesIngestionDefinitionObjectsTableTableConfiguration
    ] = None


class PipelinesIngestionDefinitionObjects(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    schema_: Optional[PipelinesIngestionDefinitionObjectsSchema] = Field(
        None, alias='schema'
    )
    table: Optional[PipelinesIngestionDefinitionObjectsTable] = None


class PipelinesIngestionDefinitionTableConfiguration(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    primary_keys: Optional[List[str]] = Field(
        None, description='The primary key of the table used to apply changes.'
    )
    salesforce_include_formula_fields: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='If true, formula fields defined in the table are included in the ingestion. This setting is only valid for the Salesforce connector',
    )
    scd_type: Optional[str] = Field(
        None, description='The SCD type to use to ingest the table.'
    )


class PipelinesIngestionDefinition(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    connection_name: Optional[str] = Field(
        None,
        description='Immutable. The Unity Catalog connection this ingestion pipeline uses to communicate with the source. Specify either ingestion_gateway_id or connection_name.',
    )
    ingestion_gateway_id: Optional[str] = Field(
        None,
        description='Immutable. Identifier for the ingestion gateway used by this ingestion pipeline to communicate with the source. Specify either ingestion_gateway_id or connection_name.',
    )
    objects: Optional[List[PipelinesIngestionDefinitionObjects]] = Field(
        None,
        description='Required. Settings specifying tables to replicate and the destination for the replicated tables.',
    )
    table_configuration: Optional[PipelinesIngestionDefinitionTableConfiguration] = None


class PipelinesLibrariesFile(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    path: Optional[str] = Field(None, description='The absolute path of the file.')


class PipelinesLibrariesMaven(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    coordinates: str = Field(
        ...,
        description='Gradle-style maven coordinates. For example: "org.jsoup:jsoup:1.7.2".',
    )
    exclusions: Optional[List[str]] = Field(
        None,
        description='List of dependences to exclude. For example: `["slf4j:slf4j", "*:hadoop-client"]`.\n\nMaven dependency exclusions:\nhttps://maven.apache.org/guides/introduction/introduction-to-optional-and-excludes-dependencies.html.',
    )
    repo: Optional[str] = Field(
        None,
        description='Maven repo to install the Maven package from. If omitted, both Maven Central Repository\nand Spark Packages are searched.',
    )


class PipelinesLibrariesNotebook(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    path: Optional[str] = Field(None, description='The absolute path of the notebook.')


class PipelinesLibraries(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    file: Optional[PipelinesLibrariesFile] = None
    jar: Optional[str] = Field(
        None,
        description='URI of the jar to be installed. Currently only DBFS is supported.\n',
    )
    maven: Optional[PipelinesLibrariesMaven] = None
    notebook: Optional[PipelinesLibrariesNotebook] = None
    whl: Optional[str] = Field(None, description='URI of the whl to be installed.')


class PipelinesNotifications(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    alerts: Optional[List[str]] = Field(
        None,
        description='A list of alerts that trigger the sending of notifications to the configured\ndestinations. The supported alerts are:\n\n* `on-update-success`: A pipeline update completes successfully.\n* `on-update-failure`: Each time a pipeline update fails.\n* `on-update-fatal-failure`: A pipeline update fails with a non-retryable (fatal) error.\n* `on-flow-failure`: A single data flow fails.\n',
    )
    email_recipients: Optional[List[str]] = Field(
        None,
        description='A list of email addresses notified when a configured alert is triggered.\n',
    )


class PipelinesPermissions(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    group_name: Optional[str] = None
    level: str
    service_principal_name: Optional[str] = None
    user_name: Optional[str] = None


class PipelinesTriggerCron(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    quartz_cron_schedule: Optional[str] = None
    timezone_id: Optional[str] = None


class PipelinesTriggerManual(BaseModel):
    pass

    class Config:
        extra = "forbid"
        protected_namespaces = ()


class PipelinesTrigger(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    cron: Optional[PipelinesTriggerCron] = None
    manual: Optional[PipelinesTriggerManual] = None


class Pipelines(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    catalog: Optional[str] = Field(
        None,
        description='A catalog in Unity Catalog to publish data from this pipeline to. If `target` is specified, tables in this pipeline are published to a `target` schema inside `catalog` (for example, `catalog`.`target`.`table`). If `target` is not specified, no data is published to Unity Catalog.',
    )
    channel: Optional[str] = Field(
        None, description='DLT Release Channel that specifies which version to use.'
    )
    clusters: Optional[List[PipelinesClusters]] = Field(
        None, description='Cluster settings for this pipeline deployment.'
    )
    configuration: Optional[Dict[str, str]] = None
    continuous: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='Whether the pipeline is continuous or triggered. This replaces `trigger`.',
    )
    deployment: Optional[PipelinesDeployment] = None
    development: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None,
        description='Whether the pipeline is in Development mode. Defaults to false.',
    )
    edition: Optional[str] = Field(None, description='Pipeline product edition.')
    filters: Optional[PipelinesFilters] = None
    gateway_definition: Optional[PipelinesGatewayDefinition] = None
    id: Optional[str] = Field(None, description='Unique identifier for this pipeline.')
    ingestion_definition: Optional[PipelinesIngestionDefinition] = None
    libraries: Optional[List[PipelinesLibraries]] = Field(
        None, description='Libraries or code needed by this deployment.'
    )
    name: Optional[str] = Field(
        None, description='Friendly identifier for this pipeline.'
    )
    notifications: Optional[List[PipelinesNotifications]] = Field(
        None, description='List of notification settings for this pipeline.'
    )
    permissions: Optional[List[PipelinesPermissions]] = None
    photon: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(None, description='Whether Photon is enabled for this pipeline.')
    serverless: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = Field(
        None, description='Whether serverless compute is enabled for this pipeline.'
    )
    storage: Optional[str] = Field(
        None, description='DBFS root directory for storing checkpoints and tables.'
    )
    target: Optional[str] = Field(
        None,
        description='Target schema (database) to add tables in this pipeline to. If not specified, no data is published to the Hive metastore or Unity Catalog. To publish to Unity Catalog, also specify `catalog`.',
    )
    trigger: Optional[PipelinesTrigger] = None


class QualityMonitorsCustomMetrics(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    definition: str
    input_columns: List[str]
    name: str
    output_data_type: str
    type: str


class QualityMonitorsDataClassificationConfig(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    enabled: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = None


class QualityMonitorsInferenceLog(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    granularities: List[str]
    label_col: Optional[str] = None
    model_id_col: str
    prediction_col: str
    prediction_proba_col: Optional[str] = None
    problem_type: str
    timestamp_col: str


class QualityMonitorsNotificationsOnFailure(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    email_addresses: Optional[List[str]] = None


class QualityMonitorsNotificationsOnNewClassificationTagDetected(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    email_addresses: Optional[List[str]] = None


class QualityMonitorsNotifications(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    on_failure: Optional[QualityMonitorsNotificationsOnFailure] = None
    on_new_classification_tag_detected: Optional[
        QualityMonitorsNotificationsOnNewClassificationTagDetected
    ] = None


class QualityMonitorsSchedule(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    pause_status: Optional[str] = None
    quartz_cron_expression: str
    timezone_id: str


class QualityMonitorsSnapshot(BaseModel):
    pass

    class Config:
        extra = "forbid"
        protected_namespaces = ()


class QualityMonitorsTimeSeries(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    granularities: List[str]
    timestamp_col: str


class QualityMonitors(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    assets_dir: str
    baseline_table_name: Optional[str] = None
    custom_metrics: Optional[List[QualityMonitorsCustomMetrics]] = None
    data_classification_config: Optional[QualityMonitorsDataClassificationConfig] = None
    inference_log: Optional[QualityMonitorsInferenceLog] = None
    notifications: Optional[QualityMonitorsNotifications] = None
    output_schema_name: str
    schedule: Optional[QualityMonitorsSchedule] = None
    skip_builtin_dashboard: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = None
    slicing_exprs: Optional[List[str]] = None
    snapshot: Optional[QualityMonitorsSnapshot] = None
    time_series: Optional[QualityMonitorsTimeSeries] = None
    warehouse_id: Optional[str] = None


class RegisteredModelsGrants(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    principal: str
    privileges: List[str]


class RegisteredModels(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    catalog_name: str = Field(
        ...,
        description='The name of the catalog where the schema and the registered model reside',
    )
    comment: Optional[str] = Field(
        None, description='The comment attached to the registered model'
    )
    grants: Optional[List[RegisteredModelsGrants]] = None
    name: str = Field(..., description='The name of the registered model')
    schema_name: str = Field(
        ..., description='The name of the schema where the registered model resides'
    )
    storage_location: Optional[str] = Field(
        None,
        description='The storage location on the cloud under which model version data files are stored',
    )


class SchemasGrants(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    principal: str
    privileges: List[str]


class Schemas(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    catalog_name: str
    comment: Optional[str] = None
    grants: Optional[List[SchemasGrants]] = None
    name: str
    properties: Optional[Dict[str, str]] = None
    storage_root: Optional[str] = None


class Resources(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    experiments: Optional[Dict[str, Experiments]] = None
    jobs: Optional[Dict[str, Jobs]] = None
    model_serving_endpoints: Optional[Dict[str, ModelServingEndpoints]] = None
    models: Optional[Dict[str, Models]] = None
    pipelines: Optional[Dict[str, Pipelines]] = None
    quality_monitors: Optional[Dict[str, QualityMonitors]] = None
    registered_models: Optional[Dict[str, RegisteredModels]] = None
    schemas: Optional[Dict[str, Schemas]] = None


class RunAs(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    service_principal_name: Optional[str] = None
    user_name: Optional[str] = None


class Sync(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    exclude: Optional[List[str]] = None
    include: Optional[List[str]] = None
    paths: Optional[List[str]] = None


class VariablesLookup(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    alert: Optional[str] = None
    cluster: Optional[str] = None
    cluster_policy: Optional[str] = None
    dashboard: Optional[str] = None
    instance_pool: Optional[str] = None
    job: Optional[str] = None
    metastore: Optional[str] = None
    pipeline: Optional[str] = None
    query: Optional[str] = None
    service_principal: Optional[str] = None
    warehouse: Optional[str] = None


class Variables(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    default: Optional[Any] = None
    description: Optional[str] = None
    lookup: Optional[VariablesLookup] = None
    type: Optional[str] = None


class Workspace(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    artifact_path: Optional[str] = None
    auth_type: Optional[str] = None
    azure_client_id: Optional[str] = None
    azure_environment: Optional[str] = None
    azure_login_app_id: Optional[str] = None
    azure_tenant_id: Optional[str] = None
    azure_use_msi: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = None
    azure_workspace_resource_id: Optional[str] = None
    client_id: Optional[str] = None
    file_path: Optional[str] = None
    google_service_account: Optional[str] = None
    host: Optional[str] = None
    profile: Optional[str] = None
    root_path: Optional[str] = None
    state_path: Optional[str] = None


class Targets(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    artifacts: Optional[Dict[str, Artifacts]] = None
    bundle: Optional[Bundle] = None
    compute_id: Optional[str] = None
    default: Optional[
        Union[
            bool,
            constr(
                pattern=r'\$\{([a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\.[a-zA-Z]+([-_]?[a-zA-Z0-9]+)*(\[[0-9]+\])*)*(\[[0-9]+\])*)\}'
            ),
        ]
    ] = None
    git: Optional[Git] = None
    mode: Optional[str] = None
    permissions: Optional[List[Permissions]] = None
    presets: Optional[Presets] = None
    resources: Optional[Resources] = None
    run_as: Optional[RunAs] = None
    sync: Optional[Sync] = None
    variables: Optional[Dict[str, Variables]] = None
    workspace: Optional[Workspace] = None


class DatabricksAssetBundles(BaseModel):
    class Config:
        extra = "forbid"
        protected_namespaces = ()

    artifacts: Optional[Dict[str, Artifacts]] = None
    bundle: Optional[Bundle] = None
    experimental: Optional[Experimental] = None
    include: Optional[List[str]] = None
    permissions: Optional[List[Permissions]] = None
    presets: Optional[Presets] = None
    resources: Optional[Resources] = None
    run_as: Optional[RunAs] = None
    sync: Optional[Sync] = None
    targets: Optional[Dict[str, Targets]] = None
    variables: Optional[Dict[str, Variables]] = None
    workspace: Optional[Workspace] = None
