# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetConsumptionsConsumptionResult',
    'GetInvoicesInvoiceResult',
]

@pulumi.output_type
class GetConsumptionsConsumptionResult(dict):
    def __init__(__self__, *,
                 billed_quantity: builtins.str,
                 category_name: builtins.str,
                 product_name: builtins.str,
                 project_id: builtins.str,
                 sku: builtins.str,
                 unit: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str billed_quantity: The consumed quantity.
        :param builtins.str category_name: The name of the consumption category.
        :param builtins.str product_name: The product name.
        :param builtins.str project_id: `project_id`) The ID of the project the consumption list is associated with.
        :param builtins.str sku: The unique identifier of the product.
        :param builtins.str unit: The unit of consumed quantity.
        :param builtins.str value: The monetary value of the consumption.
        """
        pulumi.set(__self__, "billed_quantity", billed_quantity)
        pulumi.set(__self__, "category_name", category_name)
        pulumi.set(__self__, "product_name", product_name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "sku", sku)
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="billedQuantity")
    def billed_quantity(self) -> builtins.str:
        """
        The consumed quantity.
        """
        return pulumi.get(self, "billed_quantity")

    @property
    @pulumi.getter(name="categoryName")
    def category_name(self) -> builtins.str:
        """
        The name of the consumption category.
        """
        return pulumi.get(self, "category_name")

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> builtins.str:
        """
        The product name.
        """
        return pulumi.get(self, "product_name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        `project_id`) The ID of the project the consumption list is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def sku(self) -> builtins.str:
        """
        The unique identifier of the product.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def unit(self) -> builtins.str:
        """
        The unit of consumed quantity.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The monetary value of the consumption.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetInvoicesInvoiceResult(dict):
    def __init__(__self__, *,
                 billing_period: builtins.str,
                 due_date: builtins.str,
                 id: builtins.str,
                 invoice_type: builtins.str,
                 issued_date: builtins.str,
                 number: builtins.int,
                 organization_name: builtins.str,
                 seller_name: builtins.str,
                 start_date: builtins.str,
                 state: builtins.str,
                 stop_date: builtins.str,
                 total_discount: builtins.str,
                 total_tax: builtins.str,
                 total_taxed: builtins.str,
                 total_undiscount: builtins.str,
                 total_untaxed: builtins.str):
        """
        :param builtins.str billing_period: The billing period of the invoice in the YYYY-MM format.
        :param builtins.str due_date: The payment time limit, set according to the Organization's payment conditions (RFC 3339 format).
        :param builtins.str id: The associated invoice ID.
        :param builtins.str invoice_type: Invoices with the given type are listed. Valid values are `periodic` and `purchase`.
        :param builtins.str issued_date: The date when the invoice was sent to the customer (RFC 3339 format).
        :param builtins.int number: The invoice number.
        :param builtins.str organization_name: The organization name.
        :param builtins.str seller_name: The name of the seller (Scaleway).
        :param builtins.str start_date: The start date of the billing period (RFC 3339 format).
        :param builtins.str state: The state of the invoice.
        :param builtins.str stop_date: The end date of the billing period (RFC 3339 format).
        :param builtins.str total_discount: The total discount amount of the invoice.
        :param builtins.str total_tax: The total tax amount of the invoice.
        :param builtins.str total_taxed: The total amount, taxed.
        :param builtins.str total_undiscount: The total amount of the invoice before applying the discount.
        :param builtins.str total_untaxed: The total amount, untaxed.
        """
        pulumi.set(__self__, "billing_period", billing_period)
        pulumi.set(__self__, "due_date", due_date)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "invoice_type", invoice_type)
        pulumi.set(__self__, "issued_date", issued_date)
        pulumi.set(__self__, "number", number)
        pulumi.set(__self__, "organization_name", organization_name)
        pulumi.set(__self__, "seller_name", seller_name)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "stop_date", stop_date)
        pulumi.set(__self__, "total_discount", total_discount)
        pulumi.set(__self__, "total_tax", total_tax)
        pulumi.set(__self__, "total_taxed", total_taxed)
        pulumi.set(__self__, "total_undiscount", total_undiscount)
        pulumi.set(__self__, "total_untaxed", total_untaxed)

    @property
    @pulumi.getter(name="billingPeriod")
    def billing_period(self) -> builtins.str:
        """
        The billing period of the invoice in the YYYY-MM format.
        """
        return pulumi.get(self, "billing_period")

    @property
    @pulumi.getter(name="dueDate")
    def due_date(self) -> builtins.str:
        """
        The payment time limit, set according to the Organization's payment conditions (RFC 3339 format).
        """
        return pulumi.get(self, "due_date")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The associated invoice ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="invoiceType")
    def invoice_type(self) -> builtins.str:
        """
        Invoices with the given type are listed. Valid values are `periodic` and `purchase`.
        """
        return pulumi.get(self, "invoice_type")

    @property
    @pulumi.getter(name="issuedDate")
    def issued_date(self) -> builtins.str:
        """
        The date when the invoice was sent to the customer (RFC 3339 format).
        """
        return pulumi.get(self, "issued_date")

    @property
    @pulumi.getter
    def number(self) -> builtins.int:
        """
        The invoice number.
        """
        return pulumi.get(self, "number")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> builtins.str:
        """
        The organization name.
        """
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter(name="sellerName")
    def seller_name(self) -> builtins.str:
        """
        The name of the seller (Scaleway).
        """
        return pulumi.get(self, "seller_name")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> builtins.str:
        """
        The start date of the billing period (RFC 3339 format).
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The state of the invoice.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stopDate")
    def stop_date(self) -> builtins.str:
        """
        The end date of the billing period (RFC 3339 format).
        """
        return pulumi.get(self, "stop_date")

    @property
    @pulumi.getter(name="totalDiscount")
    def total_discount(self) -> builtins.str:
        """
        The total discount amount of the invoice.
        """
        return pulumi.get(self, "total_discount")

    @property
    @pulumi.getter(name="totalTax")
    def total_tax(self) -> builtins.str:
        """
        The total tax amount of the invoice.
        """
        return pulumi.get(self, "total_tax")

    @property
    @pulumi.getter(name="totalTaxed")
    def total_taxed(self) -> builtins.str:
        """
        The total amount, taxed.
        """
        return pulumi.get(self, "total_taxed")

    @property
    @pulumi.getter(name="totalUndiscount")
    def total_undiscount(self) -> builtins.str:
        """
        The total amount of the invoice before applying the discount.
        """
        return pulumi.get(self, "total_undiscount")

    @property
    @pulumi.getter(name="totalUntaxed")
    def total_untaxed(self) -> builtins.str:
        """
        The total amount, untaxed.
        """
        return pulumi.get(self, "total_untaxed")


