# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSnapshotResult',
    'AwaitableGetSnapshotResult',
    'get_snapshot',
    'get_snapshot_output',
]

@pulumi.output_type
class GetSnapshotResult:
    """
    A collection of values returned by getSnapshot.
    """
    def __init__(__self__, exports=None, id=None, imports=None, name=None, project_id=None, snapshot_id=None, tags=None, volume_id=None, zone=None):
        if exports and not isinstance(exports, list):
            raise TypeError("Expected argument 'exports' to be a list")
        pulumi.set(__self__, "exports", exports)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if imports and not isinstance(imports, list):
            raise TypeError("Expected argument 'imports' to be a list")
        pulumi.set(__self__, "imports", imports)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if snapshot_id and not isinstance(snapshot_id, str):
            raise TypeError("Expected argument 'snapshot_id' to be a str")
        pulumi.set(__self__, "snapshot_id", snapshot_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if volume_id and not isinstance(volume_id, str):
            raise TypeError("Expected argument 'volume_id' to be a str")
        pulumi.set(__self__, "volume_id", volume_id)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def exports(self) -> Sequence['outputs.GetSnapshotExportResult']:
        return pulumi.get(self, "exports")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def imports(self) -> Sequence['outputs.GetSnapshotImportResult']:
        return pulumi.get(self, "imports")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "volume_id")

    @property
    @pulumi.getter
    def zone(self) -> Optional[builtins.str]:
        return pulumi.get(self, "zone")


class AwaitableGetSnapshotResult(GetSnapshotResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSnapshotResult(
            exports=self.exports,
            id=self.id,
            imports=self.imports,
            name=self.name,
            project_id=self.project_id,
            snapshot_id=self.snapshot_id,
            tags=self.tags,
            volume_id=self.volume_id,
            zone=self.zone)


def get_snapshot(name: Optional[builtins.str] = None,
                 project_id: Optional[builtins.str] = None,
                 snapshot_id: Optional[builtins.str] = None,
                 volume_id: Optional[builtins.str] = None,
                 zone: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSnapshotResult:
    """
    The `block.Snapshot` data source is used to retrieve information about a Block Storage volume snapshot.

    Refer to the Block Storage [product documentation](https://www.scaleway.com/en/docs/block-storage/) and [API documentation](https://www.scaleway.com/en/developers/api/block/) for more information.


    :param builtins.str name: The name of the snapshot. Only one of name or snapshot_id should be specified.
    :param builtins.str project_id: The unique identifier of the Project to which the snapshot is associated.
    :param builtins.str snapshot_id: The unique identifier of the snapshot. Only one of `name` and `snapshot_id` should be specified.
    :param builtins.str volume_id: The unique identifier of the volume from which the snapshot was created.
    :param builtins.str zone: ) The zone in which the snapshot exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['snapshotId'] = snapshot_id
    __args__['volumeId'] = volume_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:block/getSnapshot:getSnapshot', __args__, opts=opts, typ=GetSnapshotResult).value

    return AwaitableGetSnapshotResult(
        exports=pulumi.get(__ret__, 'exports'),
        id=pulumi.get(__ret__, 'id'),
        imports=pulumi.get(__ret__, 'imports'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        snapshot_id=pulumi.get(__ret__, 'snapshot_id'),
        tags=pulumi.get(__ret__, 'tags'),
        volume_id=pulumi.get(__ret__, 'volume_id'),
        zone=pulumi.get(__ret__, 'zone'))
def get_snapshot_output(name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        snapshot_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        volume_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        zone: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSnapshotResult]:
    """
    The `block.Snapshot` data source is used to retrieve information about a Block Storage volume snapshot.

    Refer to the Block Storage [product documentation](https://www.scaleway.com/en/docs/block-storage/) and [API documentation](https://www.scaleway.com/en/developers/api/block/) for more information.


    :param builtins.str name: The name of the snapshot. Only one of name or snapshot_id should be specified.
    :param builtins.str project_id: The unique identifier of the Project to which the snapshot is associated.
    :param builtins.str snapshot_id: The unique identifier of the snapshot. Only one of `name` and `snapshot_id` should be specified.
    :param builtins.str volume_id: The unique identifier of the volume from which the snapshot was created.
    :param builtins.str zone: ) The zone in which the snapshot exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['snapshotId'] = snapshot_id
    __args__['volumeId'] = volume_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:block/getSnapshot:getSnapshot', __args__, opts=opts, typ=GetSnapshotResult)
    return __ret__.apply(lambda __response__: GetSnapshotResult(
        exports=pulumi.get(__response__, 'exports'),
        id=pulumi.get(__response__, 'id'),
        imports=pulumi.get(__response__, 'imports'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id'),
        snapshot_id=pulumi.get(__response__, 'snapshot_id'),
        tags=pulumi.get(__response__, 'tags'),
        volume_id=pulumi.get(__response__, 'volume_id'),
        zone=pulumi.get(__response__, 'zone')))
