# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ContainerArgs', 'Container']

@pulumi.input_type
class ContainerArgs:
    def __init__(__self__, *,
                 namespace_id: pulumi.Input[builtins.str],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 cpu_limit: Optional[pulumi.Input[builtins.int]] = None,
                 deploy: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 health_checks: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerHealthCheckArgs']]]] = None,
                 http_option: Optional[pulumi.Input[builtins.str]] = None,
                 local_storage_limit: Optional[pulumi.Input[builtins.int]] = None,
                 max_concurrency: Optional[pulumi.Input[builtins.int]] = None,
                 max_scale: Optional[pulumi.Input[builtins.int]] = None,
                 memory_limit: Optional[pulumi.Input[builtins.int]] = None,
                 min_scale: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 privacy: Optional[pulumi.Input[builtins.str]] = None,
                 private_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 registry_image: Optional[pulumi.Input[builtins.str]] = None,
                 registry_sha256: Optional[pulumi.Input[builtins.str]] = None,
                 sandbox: Optional[pulumi.Input[builtins.str]] = None,
                 scaling_options: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerScalingOptionArgs']]]] = None,
                 secret_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a Container resource.
        :param pulumi.Input[builtins.str] namespace_id: The Containers namespace ID of the container.
               
               > **Important** Updating the `name` argument will recreate the container.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] args: Arguments passed to the command specified in the "command" field. These override the default arguments from the container image, and behave like command-line parameters.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] commands: Command executed when the container starts. This overrides the default command defined in the container image. This is usually the main executable, or entry point script to run.
        :param pulumi.Input[builtins.int] cpu_limit: The amount of vCPU computing resources to allocate to each container.
        :param pulumi.Input[builtins.bool] deploy: Boolean indicating whether the container is in a production environment.
        :param pulumi.Input[builtins.str] description: The description of the container.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] environment_variables: The [environment variables](https://www.scaleway.com/en/docs/serverless-containers/concepts/#environment-variables) of the container.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerHealthCheckArgs']]] health_checks: Health check configuration block of the container.
        :param pulumi.Input[builtins.str] http_option: Allows both HTTP and HTTPS (`enabled`) or redirect HTTP to HTTPS (`redirected`). Defaults to `enabled`.
        :param pulumi.Input[builtins.int] local_storage_limit: Local storage limit of the container (in MB)
        :param pulumi.Input[builtins.int] max_concurrency: The maximum number of simultaneous requests your container can handle at the same time. Use `scaling_option.concurrent_requests_threshold` instead.
        :param pulumi.Input[builtins.int] max_scale: The maximum number of instances this container can scale to.
        :param pulumi.Input[builtins.int] memory_limit: The memory resources in MB to allocate to each container.
        :param pulumi.Input[builtins.int] min_scale: The minimum number of container instances running continuously.
        :param pulumi.Input[builtins.str] name: The unique name of the container name.
        :param pulumi.Input[builtins.int] port: The port to expose the container.
        :param pulumi.Input[builtins.str] privacy: The privacy type defines the way to authenticate to your container. Please check our dedicated [section](https://www.scaleway.com/en/developers/api/serverless-containers/#protocol-9dd4c8).
        :param pulumi.Input[builtins.str] private_network_id: The ID of the Private Network the container is connected to.
               
               > **Important** This feature is currently in beta and requires a namespace with VPC integration activated by setting the `activate_vpc_integration` attribute to `true`.
               
               Note that if you want to use your own configuration, you must consult our configuration [restrictions](https://www.scaleway.com/en/docs/serverless-containers/reference-content/containers-limitations/#configuration-restrictions) section.
        :param pulumi.Input[builtins.str] protocol: The communication [protocol](https://www.scaleway.com/en/developers/api/serverless-containers/#path-containers-update-an-existing-container) `http1` or `h2c`. Defaults to `http1`.
        :param pulumi.Input[builtins.str] region: (Defaults to provider `region`) The region in which the container was created.
        :param pulumi.Input[builtins.str] registry_image: The registry image address (e.g., `rg.fr-par.scw.cloud/$NAMESPACE/$IMAGE`)
        :param pulumi.Input[builtins.str] registry_sha256: The sha256 of your source registry image, changing it will re-apply the deployment. Can be any string.
        :param pulumi.Input[builtins.str] sandbox: Execution environment of the container.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerScalingOptionArgs']]] scaling_options: Configuration block used to decide when to scale up or down. Possible values:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] secret_environment_variables: The [secret environment variables](https://www.scaleway.com/en/docs/serverless-containers/concepts/#secrets) of the container.
        :param pulumi.Input[builtins.str] status: The container status.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The list of tags associated with the container.
        :param pulumi.Input[builtins.int] timeout: The maximum amount of time in seconds your container can spend processing a request before being stopped. Default to `300` seconds.
        """
        pulumi.set(__self__, "namespace_id", namespace_id)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if cpu_limit is not None:
            pulumi.set(__self__, "cpu_limit", cpu_limit)
        if deploy is not None:
            pulumi.set(__self__, "deploy", deploy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if health_checks is not None:
            pulumi.set(__self__, "health_checks", health_checks)
        if http_option is not None:
            pulumi.set(__self__, "http_option", http_option)
        if local_storage_limit is not None:
            pulumi.set(__self__, "local_storage_limit", local_storage_limit)
        if max_concurrency is not None:
            warnings.warn("""Use scaling_option.concurrent_requests_threshold instead. This attribute will be removed.""", DeprecationWarning)
            pulumi.log.warn("""max_concurrency is deprecated: Use scaling_option.concurrent_requests_threshold instead. This attribute will be removed.""")
        if max_concurrency is not None:
            pulumi.set(__self__, "max_concurrency", max_concurrency)
        if max_scale is not None:
            pulumi.set(__self__, "max_scale", max_scale)
        if memory_limit is not None:
            pulumi.set(__self__, "memory_limit", memory_limit)
        if min_scale is not None:
            pulumi.set(__self__, "min_scale", min_scale)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if privacy is not None:
            pulumi.set(__self__, "privacy", privacy)
        if private_network_id is not None:
            pulumi.set(__self__, "private_network_id", private_network_id)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if registry_image is not None:
            pulumi.set(__self__, "registry_image", registry_image)
        if registry_sha256 is not None:
            pulumi.set(__self__, "registry_sha256", registry_sha256)
        if sandbox is not None:
            pulumi.set(__self__, "sandbox", sandbox)
        if scaling_options is not None:
            pulumi.set(__self__, "scaling_options", scaling_options)
        if secret_environment_variables is not None:
            pulumi.set(__self__, "secret_environment_variables", secret_environment_variables)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> pulumi.Input[builtins.str]:
        """
        The Containers namespace ID of the container.

        > **Important** Updating the `name` argument will recreate the container.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "namespace_id", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Arguments passed to the command specified in the "command" field. These override the default arguments from the container image, and behave like command-line parameters.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Command executed when the container starts. This overrides the default command defined in the container image. This is usually the main executable, or entry point script to run.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter(name="cpuLimit")
    def cpu_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The amount of vCPU computing resources to allocate to each container.
        """
        return pulumi.get(self, "cpu_limit")

    @cpu_limit.setter
    def cpu_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cpu_limit", value)

    @property
    @pulumi.getter
    def deploy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean indicating whether the container is in a production environment.
        """
        return pulumi.get(self, "deploy")

    @deploy.setter
    def deploy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deploy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the container.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The [environment variables](https://www.scaleway.com/en/docs/serverless-containers/concepts/#environment-variables) of the container.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerHealthCheckArgs']]]]:
        """
        Health check configuration block of the container.
        """
        return pulumi.get(self, "health_checks")

    @health_checks.setter
    def health_checks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerHealthCheckArgs']]]]):
        pulumi.set(self, "health_checks", value)

    @property
    @pulumi.getter(name="httpOption")
    def http_option(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Allows both HTTP and HTTPS (`enabled`) or redirect HTTP to HTTPS (`redirected`). Defaults to `enabled`.
        """
        return pulumi.get(self, "http_option")

    @http_option.setter
    def http_option(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "http_option", value)

    @property
    @pulumi.getter(name="localStorageLimit")
    def local_storage_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Local storage limit of the container (in MB)
        """
        return pulumi.get(self, "local_storage_limit")

    @local_storage_limit.setter
    def local_storage_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "local_storage_limit", value)

    @property
    @pulumi.getter(name="maxConcurrency")
    @_utilities.deprecated("""Use scaling_option.concurrent_requests_threshold instead. This attribute will be removed.""")
    def max_concurrency(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of simultaneous requests your container can handle at the same time. Use `scaling_option.concurrent_requests_threshold` instead.
        """
        return pulumi.get(self, "max_concurrency")

    @max_concurrency.setter
    def max_concurrency(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_concurrency", value)

    @property
    @pulumi.getter(name="maxScale")
    def max_scale(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of instances this container can scale to.
        """
        return pulumi.get(self, "max_scale")

    @max_scale.setter
    def max_scale(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_scale", value)

    @property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The memory resources in MB to allocate to each container.
        """
        return pulumi.get(self, "memory_limit")

    @memory_limit.setter
    def memory_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "memory_limit", value)

    @property
    @pulumi.getter(name="minScale")
    def min_scale(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum number of container instances running continuously.
        """
        return pulumi.get(self, "min_scale")

    @min_scale.setter
    def min_scale(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_scale", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique name of the container name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port to expose the container.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def privacy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The privacy type defines the way to authenticate to your container. Please check our dedicated [section](https://www.scaleway.com/en/developers/api/serverless-containers/#protocol-9dd4c8).
        """
        return pulumi.get(self, "privacy")

    @privacy.setter
    def privacy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "privacy", value)

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Private Network the container is connected to.

        > **Important** This feature is currently in beta and requires a namespace with VPC integration activated by setting the `activate_vpc_integration` attribute to `true`.

        Note that if you want to use your own configuration, you must consult our configuration [restrictions](https://www.scaleway.com/en/docs/serverless-containers/reference-content/containers-limitations/#configuration-restrictions) section.
        """
        return pulumi.get(self, "private_network_id")

    @private_network_id.setter
    def private_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_network_id", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The communication [protocol](https://www.scaleway.com/en/developers/api/serverless-containers/#path-containers-update-an-existing-container) `http1` or `h2c`. Defaults to `http1`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Defaults to provider `region`) The region in which the container was created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="registryImage")
    def registry_image(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The registry image address (e.g., `rg.fr-par.scw.cloud/$NAMESPACE/$IMAGE`)
        """
        return pulumi.get(self, "registry_image")

    @registry_image.setter
    def registry_image(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "registry_image", value)

    @property
    @pulumi.getter(name="registrySha256")
    def registry_sha256(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The sha256 of your source registry image, changing it will re-apply the deployment. Can be any string.
        """
        return pulumi.get(self, "registry_sha256")

    @registry_sha256.setter
    def registry_sha256(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "registry_sha256", value)

    @property
    @pulumi.getter
    def sandbox(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Execution environment of the container.
        """
        return pulumi.get(self, "sandbox")

    @sandbox.setter
    def sandbox(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sandbox", value)

    @property
    @pulumi.getter(name="scalingOptions")
    def scaling_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerScalingOptionArgs']]]]:
        """
        Configuration block used to decide when to scale up or down. Possible values:
        """
        return pulumi.get(self, "scaling_options")

    @scaling_options.setter
    def scaling_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerScalingOptionArgs']]]]):
        pulumi.set(self, "scaling_options", value)

    @property
    @pulumi.getter(name="secretEnvironmentVariables")
    def secret_environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The [secret environment variables](https://www.scaleway.com/en/docs/serverless-containers/concepts/#secrets) of the container.
        """
        return pulumi.get(self, "secret_environment_variables")

    @secret_environment_variables.setter
    def secret_environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "secret_environment_variables", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The container status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of tags associated with the container.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum amount of time in seconds your container can spend processing a request before being stopped. Default to `300` seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class _ContainerState:
    def __init__(__self__, *,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 cpu_limit: Optional[pulumi.Input[builtins.int]] = None,
                 cron_status: Optional[pulumi.Input[builtins.str]] = None,
                 deploy: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 error_message: Optional[pulumi.Input[builtins.str]] = None,
                 health_checks: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerHealthCheckArgs']]]] = None,
                 http_option: Optional[pulumi.Input[builtins.str]] = None,
                 local_storage_limit: Optional[pulumi.Input[builtins.int]] = None,
                 max_concurrency: Optional[pulumi.Input[builtins.int]] = None,
                 max_scale: Optional[pulumi.Input[builtins.int]] = None,
                 memory_limit: Optional[pulumi.Input[builtins.int]] = None,
                 min_scale: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 privacy: Optional[pulumi.Input[builtins.str]] = None,
                 private_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 registry_image: Optional[pulumi.Input[builtins.str]] = None,
                 registry_sha256: Optional[pulumi.Input[builtins.str]] = None,
                 sandbox: Optional[pulumi.Input[builtins.str]] = None,
                 scaling_options: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerScalingOptionArgs']]]] = None,
                 secret_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering Container resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] args: Arguments passed to the command specified in the "command" field. These override the default arguments from the container image, and behave like command-line parameters.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] commands: Command executed when the container starts. This overrides the default command defined in the container image. This is usually the main executable, or entry point script to run.
        :param pulumi.Input[builtins.int] cpu_limit: The amount of vCPU computing resources to allocate to each container.
        :param pulumi.Input[builtins.str] cron_status: The cron status of the container.
        :param pulumi.Input[builtins.bool] deploy: Boolean indicating whether the container is in a production environment.
        :param pulumi.Input[builtins.str] description: The description of the container.
        :param pulumi.Input[builtins.str] domain_name: The native domain name of the container
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] environment_variables: The [environment variables](https://www.scaleway.com/en/docs/serverless-containers/concepts/#environment-variables) of the container.
        :param pulumi.Input[builtins.str] error_message: The error message of the container.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerHealthCheckArgs']]] health_checks: Health check configuration block of the container.
        :param pulumi.Input[builtins.str] http_option: Allows both HTTP and HTTPS (`enabled`) or redirect HTTP to HTTPS (`redirected`). Defaults to `enabled`.
        :param pulumi.Input[builtins.int] local_storage_limit: Local storage limit of the container (in MB)
        :param pulumi.Input[builtins.int] max_concurrency: The maximum number of simultaneous requests your container can handle at the same time. Use `scaling_option.concurrent_requests_threshold` instead.
        :param pulumi.Input[builtins.int] max_scale: The maximum number of instances this container can scale to.
        :param pulumi.Input[builtins.int] memory_limit: The memory resources in MB to allocate to each container.
        :param pulumi.Input[builtins.int] min_scale: The minimum number of container instances running continuously.
        :param pulumi.Input[builtins.str] name: The unique name of the container name.
        :param pulumi.Input[builtins.str] namespace_id: The Containers namespace ID of the container.
               
               > **Important** Updating the `name` argument will recreate the container.
        :param pulumi.Input[builtins.int] port: The port to expose the container.
        :param pulumi.Input[builtins.str] privacy: The privacy type defines the way to authenticate to your container. Please check our dedicated [section](https://www.scaleway.com/en/developers/api/serverless-containers/#protocol-9dd4c8).
        :param pulumi.Input[builtins.str] private_network_id: The ID of the Private Network the container is connected to.
               
               > **Important** This feature is currently in beta and requires a namespace with VPC integration activated by setting the `activate_vpc_integration` attribute to `true`.
               
               Note that if you want to use your own configuration, you must consult our configuration [restrictions](https://www.scaleway.com/en/docs/serverless-containers/reference-content/containers-limitations/#configuration-restrictions) section.
        :param pulumi.Input[builtins.str] protocol: The communication [protocol](https://www.scaleway.com/en/developers/api/serverless-containers/#path-containers-update-an-existing-container) `http1` or `h2c`. Defaults to `http1`.
        :param pulumi.Input[builtins.str] region: (Defaults to provider `region`) The region in which the container was created.
        :param pulumi.Input[builtins.str] registry_image: The registry image address (e.g., `rg.fr-par.scw.cloud/$NAMESPACE/$IMAGE`)
        :param pulumi.Input[builtins.str] registry_sha256: The sha256 of your source registry image, changing it will re-apply the deployment. Can be any string.
        :param pulumi.Input[builtins.str] sandbox: Execution environment of the container.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerScalingOptionArgs']]] scaling_options: Configuration block used to decide when to scale up or down. Possible values:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] secret_environment_variables: The [secret environment variables](https://www.scaleway.com/en/docs/serverless-containers/concepts/#secrets) of the container.
        :param pulumi.Input[builtins.str] status: The container status.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The list of tags associated with the container.
        :param pulumi.Input[builtins.int] timeout: The maximum amount of time in seconds your container can spend processing a request before being stopped. Default to `300` seconds.
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if cpu_limit is not None:
            pulumi.set(__self__, "cpu_limit", cpu_limit)
        if cron_status is not None:
            pulumi.set(__self__, "cron_status", cron_status)
        if deploy is not None:
            pulumi.set(__self__, "deploy", deploy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if health_checks is not None:
            pulumi.set(__self__, "health_checks", health_checks)
        if http_option is not None:
            pulumi.set(__self__, "http_option", http_option)
        if local_storage_limit is not None:
            pulumi.set(__self__, "local_storage_limit", local_storage_limit)
        if max_concurrency is not None:
            warnings.warn("""Use scaling_option.concurrent_requests_threshold instead. This attribute will be removed.""", DeprecationWarning)
            pulumi.log.warn("""max_concurrency is deprecated: Use scaling_option.concurrent_requests_threshold instead. This attribute will be removed.""")
        if max_concurrency is not None:
            pulumi.set(__self__, "max_concurrency", max_concurrency)
        if max_scale is not None:
            pulumi.set(__self__, "max_scale", max_scale)
        if memory_limit is not None:
            pulumi.set(__self__, "memory_limit", memory_limit)
        if min_scale is not None:
            pulumi.set(__self__, "min_scale", min_scale)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if privacy is not None:
            pulumi.set(__self__, "privacy", privacy)
        if private_network_id is not None:
            pulumi.set(__self__, "private_network_id", private_network_id)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if registry_image is not None:
            pulumi.set(__self__, "registry_image", registry_image)
        if registry_sha256 is not None:
            pulumi.set(__self__, "registry_sha256", registry_sha256)
        if sandbox is not None:
            pulumi.set(__self__, "sandbox", sandbox)
        if scaling_options is not None:
            pulumi.set(__self__, "scaling_options", scaling_options)
        if secret_environment_variables is not None:
            pulumi.set(__self__, "secret_environment_variables", secret_environment_variables)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Arguments passed to the command specified in the "command" field. These override the default arguments from the container image, and behave like command-line parameters.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Command executed when the container starts. This overrides the default command defined in the container image. This is usually the main executable, or entry point script to run.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter(name="cpuLimit")
    def cpu_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The amount of vCPU computing resources to allocate to each container.
        """
        return pulumi.get(self, "cpu_limit")

    @cpu_limit.setter
    def cpu_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cpu_limit", value)

    @property
    @pulumi.getter(name="cronStatus")
    def cron_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cron status of the container.
        """
        return pulumi.get(self, "cron_status")

    @cron_status.setter
    def cron_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cron_status", value)

    @property
    @pulumi.getter
    def deploy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean indicating whether the container is in a production environment.
        """
        return pulumi.get(self, "deploy")

    @deploy.setter
    def deploy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deploy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the container.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The native domain name of the container
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The [environment variables](https://www.scaleway.com/en/docs/serverless-containers/concepts/#environment-variables) of the container.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The error message of the container.
        """
        return pulumi.get(self, "error_message")

    @error_message.setter
    def error_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "error_message", value)

    @property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerHealthCheckArgs']]]]:
        """
        Health check configuration block of the container.
        """
        return pulumi.get(self, "health_checks")

    @health_checks.setter
    def health_checks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerHealthCheckArgs']]]]):
        pulumi.set(self, "health_checks", value)

    @property
    @pulumi.getter(name="httpOption")
    def http_option(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Allows both HTTP and HTTPS (`enabled`) or redirect HTTP to HTTPS (`redirected`). Defaults to `enabled`.
        """
        return pulumi.get(self, "http_option")

    @http_option.setter
    def http_option(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "http_option", value)

    @property
    @pulumi.getter(name="localStorageLimit")
    def local_storage_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Local storage limit of the container (in MB)
        """
        return pulumi.get(self, "local_storage_limit")

    @local_storage_limit.setter
    def local_storage_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "local_storage_limit", value)

    @property
    @pulumi.getter(name="maxConcurrency")
    @_utilities.deprecated("""Use scaling_option.concurrent_requests_threshold instead. This attribute will be removed.""")
    def max_concurrency(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of simultaneous requests your container can handle at the same time. Use `scaling_option.concurrent_requests_threshold` instead.
        """
        return pulumi.get(self, "max_concurrency")

    @max_concurrency.setter
    def max_concurrency(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_concurrency", value)

    @property
    @pulumi.getter(name="maxScale")
    def max_scale(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of instances this container can scale to.
        """
        return pulumi.get(self, "max_scale")

    @max_scale.setter
    def max_scale(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_scale", value)

    @property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The memory resources in MB to allocate to each container.
        """
        return pulumi.get(self, "memory_limit")

    @memory_limit.setter
    def memory_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "memory_limit", value)

    @property
    @pulumi.getter(name="minScale")
    def min_scale(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum number of container instances running continuously.
        """
        return pulumi.get(self, "min_scale")

    @min_scale.setter
    def min_scale(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_scale", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique name of the container name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Containers namespace ID of the container.

        > **Important** Updating the `name` argument will recreate the container.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace_id", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port to expose the container.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def privacy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The privacy type defines the way to authenticate to your container. Please check our dedicated [section](https://www.scaleway.com/en/developers/api/serverless-containers/#protocol-9dd4c8).
        """
        return pulumi.get(self, "privacy")

    @privacy.setter
    def privacy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "privacy", value)

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Private Network the container is connected to.

        > **Important** This feature is currently in beta and requires a namespace with VPC integration activated by setting the `activate_vpc_integration` attribute to `true`.

        Note that if you want to use your own configuration, you must consult our configuration [restrictions](https://www.scaleway.com/en/docs/serverless-containers/reference-content/containers-limitations/#configuration-restrictions) section.
        """
        return pulumi.get(self, "private_network_id")

    @private_network_id.setter
    def private_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_network_id", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The communication [protocol](https://www.scaleway.com/en/developers/api/serverless-containers/#path-containers-update-an-existing-container) `http1` or `h2c`. Defaults to `http1`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Defaults to provider `region`) The region in which the container was created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="registryImage")
    def registry_image(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The registry image address (e.g., `rg.fr-par.scw.cloud/$NAMESPACE/$IMAGE`)
        """
        return pulumi.get(self, "registry_image")

    @registry_image.setter
    def registry_image(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "registry_image", value)

    @property
    @pulumi.getter(name="registrySha256")
    def registry_sha256(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The sha256 of your source registry image, changing it will re-apply the deployment. Can be any string.
        """
        return pulumi.get(self, "registry_sha256")

    @registry_sha256.setter
    def registry_sha256(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "registry_sha256", value)

    @property
    @pulumi.getter
    def sandbox(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Execution environment of the container.
        """
        return pulumi.get(self, "sandbox")

    @sandbox.setter
    def sandbox(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sandbox", value)

    @property
    @pulumi.getter(name="scalingOptions")
    def scaling_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerScalingOptionArgs']]]]:
        """
        Configuration block used to decide when to scale up or down. Possible values:
        """
        return pulumi.get(self, "scaling_options")

    @scaling_options.setter
    def scaling_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerScalingOptionArgs']]]]):
        pulumi.set(self, "scaling_options", value)

    @property
    @pulumi.getter(name="secretEnvironmentVariables")
    def secret_environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The [secret environment variables](https://www.scaleway.com/en/docs/serverless-containers/concepts/#secrets) of the container.
        """
        return pulumi.get(self, "secret_environment_variables")

    @secret_environment_variables.setter
    def secret_environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "secret_environment_variables", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The container status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of tags associated with the container.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum amount of time in seconds your container can spend processing a request before being stopped. Default to `300` seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout", value)


warnings.warn("""scaleway.index/container.Container has been deprecated in favor of scaleway.containers/container.Container""", DeprecationWarning)


@pulumi.type_token("scaleway:index/container:Container")
class Container(pulumi.CustomResource):
    warnings.warn("""scaleway.index/container.Container has been deprecated in favor of scaleway.containers/container.Container""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 cpu_limit: Optional[pulumi.Input[builtins.int]] = None,
                 deploy: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 health_checks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerHealthCheckArgs', 'ContainerHealthCheckArgsDict']]]]] = None,
                 http_option: Optional[pulumi.Input[builtins.str]] = None,
                 local_storage_limit: Optional[pulumi.Input[builtins.int]] = None,
                 max_concurrency: Optional[pulumi.Input[builtins.int]] = None,
                 max_scale: Optional[pulumi.Input[builtins.int]] = None,
                 memory_limit: Optional[pulumi.Input[builtins.int]] = None,
                 min_scale: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 privacy: Optional[pulumi.Input[builtins.str]] = None,
                 private_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 registry_image: Optional[pulumi.Input[builtins.str]] = None,
                 registry_sha256: Optional[pulumi.Input[builtins.str]] = None,
                 sandbox: Optional[pulumi.Input[builtins.str]] = None,
                 scaling_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerScalingOptionArgs', 'ContainerScalingOptionArgsDict']]]]] = None,
                 secret_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        The `containers.Container` resource allows you to create and manage [Serverless Containers](https://www.scaleway.com/en/docs/serverless/containers/).

        Refer to the Serverless Containers [product documentation](https://www.scaleway.com/en/docs/serverless/containers/) and [API documentation](https://www.scaleway.com/en/developers/api/serverless-containers/) for more information.

        For more information on the limitations of Serverless Containers, refer to the [dedicated documentation](https://www.scaleway.com/en/docs/serverless-containers/reference-content/containers-limitations/).

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.containers.Namespace("main",
            name="my-ns-test",
            description="test container")
        main_container = scaleway.containers.Container("main",
            name="my-container-02",
            description="environment variables test",
            tags=[
                "tag1",
                "tag2",
            ],
            namespace_id=main.id,
            registry_image=main.registry_endpoint.apply(lambda registry_endpoint: f"{registry_endpoint}/alpine:test"),
            port=9997,
            cpu_limit=140,
            memory_limit=256,
            min_scale=3,
            max_scale=5,
            timeout=600,
            max_concurrency=80,
            privacy="private",
            protocol="http1",
            deploy=True,
            commands=[
                "bash",
                "-c",
                "script.sh",
            ],
            args=[
                "some",
                "args",
            ],
            environment_variables={
                "foo": "var",
            },
            secret_environment_variables={
                "key": "secret",
            })
        ```

        ## Protocols

        The following protocols are supported:

        * `h2c`: HTTP/2 over TCP.
        * `http1`: Hypertext Transfer Protocol.

        > **Important:** Refer to the official [Apache documentation](https://httpd.apache.org/docs/2.4/howto/http2.html) for more information.

        ## Privacy

        By default, creating a container will make it `public`, meaning that anybody knowing the endpoint can execute it.

        A container can be made `private` with the privacy parameter.

        Refer to the [technical information](https://www.scaleway.com/en/developers/api/serverless-containers/#protocol-9dd4c8) for more information on container authentication.

        ## Memory and vCPUs configuration

        The vCPU represents a portion of the underlying, physical CPU that is assigned to a particular virtual machine (VM).

        You can determine the computing resources to allocate to each container.

        The `memory_limit` (in MB) must correspond with the right amount of vCPU. Refer to the table below to determine the right memory/vCPU combination.

        | Memory (in MB) | vCPU |
        |----------------|------|
        | 128            | 70m  |
        | 256            | 140m |
        | 512            | 280m |
        | 1024           | 560m |
        | 2048           | 1120 |
        | 3072           | 1680 |
        | 4096           | 2240 |

        ~>**Important:** Make sure to select the right resources, as you will be billed based on compute usage over time and the number of Containers executions.
        Refer to the [Serverless Containers pricing](https://www.scaleway.com/en/docs/faq/serverless-containers/#prices) for more information.

        ## Health check configuration

        Custom health checks can be configured on the container.

        It's possible to specify the HTTP path that the probe will listen to and the number of failures before considering the container as unhealthy.
        During a deployment, if a newly created container fails to pass the health check, the deployment is aborted.
        As a result, lowering this value can help to reduce the time it takes to detect a failed deployment.
        The period between health checks is also configurable.

        Example:

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.containers.Container("main",
            name="my-container-02",
            namespace_id=main_scaleway_container_namespace["id"],
            health_checks=[{
                "https": [{
                    "path": "/ping",
                }],
                "failure_threshold": 40,
                "interval": "5s",
            }])
        ```

        ~>**Important:** Another probe type can be set to TCP with the API, but currently the SDK has not been updated with this parameter.
        This is why the only probe that can be used here is the HTTP probe.
        Refer to the [Serverless Containers pricing](https://www.scaleway.com/en/docs/faq/serverless-containers/#prices) for more information.

        ## Scaling option configuration

        Scaling option block configuration allows you to choose which parameter will scale up/down containers.
        Options are number of concurrent requests, CPU or memory usage.
        It replaces current `max_concurrency` that has been deprecated.

        Example:

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.containers.Container("main",
            name="my-container-02",
            namespace_id=main_scaleway_container_namespace["id"],
            scaling_options=[{
                "concurrent_requests_threshold": 15,
            }])
        ```

        ~>**Important**: A maximum of one of these parameters may be set. Also, when `cpu_usage_threshold` or `memory_usage_threshold` are used, `min_scale` can't be set to 0.
        Refer to the [API Reference](https://www.scaleway.com/en/developers/api/serverless-containers/#path-containers-create-a-new-container) for more information.

        ## Import

        Containers can be imported using, `{region}/{id}`, as shown below:

        bash

        ```sh
        $ pulumi import scaleway:index/container:Container main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] args: Arguments passed to the command specified in the "command" field. These override the default arguments from the container image, and behave like command-line parameters.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] commands: Command executed when the container starts. This overrides the default command defined in the container image. This is usually the main executable, or entry point script to run.
        :param pulumi.Input[builtins.int] cpu_limit: The amount of vCPU computing resources to allocate to each container.
        :param pulumi.Input[builtins.bool] deploy: Boolean indicating whether the container is in a production environment.
        :param pulumi.Input[builtins.str] description: The description of the container.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] environment_variables: The [environment variables](https://www.scaleway.com/en/docs/serverless-containers/concepts/#environment-variables) of the container.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerHealthCheckArgs', 'ContainerHealthCheckArgsDict']]]] health_checks: Health check configuration block of the container.
        :param pulumi.Input[builtins.str] http_option: Allows both HTTP and HTTPS (`enabled`) or redirect HTTP to HTTPS (`redirected`). Defaults to `enabled`.
        :param pulumi.Input[builtins.int] local_storage_limit: Local storage limit of the container (in MB)
        :param pulumi.Input[builtins.int] max_concurrency: The maximum number of simultaneous requests your container can handle at the same time. Use `scaling_option.concurrent_requests_threshold` instead.
        :param pulumi.Input[builtins.int] max_scale: The maximum number of instances this container can scale to.
        :param pulumi.Input[builtins.int] memory_limit: The memory resources in MB to allocate to each container.
        :param pulumi.Input[builtins.int] min_scale: The minimum number of container instances running continuously.
        :param pulumi.Input[builtins.str] name: The unique name of the container name.
        :param pulumi.Input[builtins.str] namespace_id: The Containers namespace ID of the container.
               
               > **Important** Updating the `name` argument will recreate the container.
        :param pulumi.Input[builtins.int] port: The port to expose the container.
        :param pulumi.Input[builtins.str] privacy: The privacy type defines the way to authenticate to your container. Please check our dedicated [section](https://www.scaleway.com/en/developers/api/serverless-containers/#protocol-9dd4c8).
        :param pulumi.Input[builtins.str] private_network_id: The ID of the Private Network the container is connected to.
               
               > **Important** This feature is currently in beta and requires a namespace with VPC integration activated by setting the `activate_vpc_integration` attribute to `true`.
               
               Note that if you want to use your own configuration, you must consult our configuration [restrictions](https://www.scaleway.com/en/docs/serverless-containers/reference-content/containers-limitations/#configuration-restrictions) section.
        :param pulumi.Input[builtins.str] protocol: The communication [protocol](https://www.scaleway.com/en/developers/api/serverless-containers/#path-containers-update-an-existing-container) `http1` or `h2c`. Defaults to `http1`.
        :param pulumi.Input[builtins.str] region: (Defaults to provider `region`) The region in which the container was created.
        :param pulumi.Input[builtins.str] registry_image: The registry image address (e.g., `rg.fr-par.scw.cloud/$NAMESPACE/$IMAGE`)
        :param pulumi.Input[builtins.str] registry_sha256: The sha256 of your source registry image, changing it will re-apply the deployment. Can be any string.
        :param pulumi.Input[builtins.str] sandbox: Execution environment of the container.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerScalingOptionArgs', 'ContainerScalingOptionArgsDict']]]] scaling_options: Configuration block used to decide when to scale up or down. Possible values:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] secret_environment_variables: The [secret environment variables](https://www.scaleway.com/en/docs/serverless-containers/concepts/#secrets) of the container.
        :param pulumi.Input[builtins.str] status: The container status.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The list of tags associated with the container.
        :param pulumi.Input[builtins.int] timeout: The maximum amount of time in seconds your container can spend processing a request before being stopped. Default to `300` seconds.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContainerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `containers.Container` resource allows you to create and manage [Serverless Containers](https://www.scaleway.com/en/docs/serverless/containers/).

        Refer to the Serverless Containers [product documentation](https://www.scaleway.com/en/docs/serverless/containers/) and [API documentation](https://www.scaleway.com/en/developers/api/serverless-containers/) for more information.

        For more information on the limitations of Serverless Containers, refer to the [dedicated documentation](https://www.scaleway.com/en/docs/serverless-containers/reference-content/containers-limitations/).

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.containers.Namespace("main",
            name="my-ns-test",
            description="test container")
        main_container = scaleway.containers.Container("main",
            name="my-container-02",
            description="environment variables test",
            tags=[
                "tag1",
                "tag2",
            ],
            namespace_id=main.id,
            registry_image=main.registry_endpoint.apply(lambda registry_endpoint: f"{registry_endpoint}/alpine:test"),
            port=9997,
            cpu_limit=140,
            memory_limit=256,
            min_scale=3,
            max_scale=5,
            timeout=600,
            max_concurrency=80,
            privacy="private",
            protocol="http1",
            deploy=True,
            commands=[
                "bash",
                "-c",
                "script.sh",
            ],
            args=[
                "some",
                "args",
            ],
            environment_variables={
                "foo": "var",
            },
            secret_environment_variables={
                "key": "secret",
            })
        ```

        ## Protocols

        The following protocols are supported:

        * `h2c`: HTTP/2 over TCP.
        * `http1`: Hypertext Transfer Protocol.

        > **Important:** Refer to the official [Apache documentation](https://httpd.apache.org/docs/2.4/howto/http2.html) for more information.

        ## Privacy

        By default, creating a container will make it `public`, meaning that anybody knowing the endpoint can execute it.

        A container can be made `private` with the privacy parameter.

        Refer to the [technical information](https://www.scaleway.com/en/developers/api/serverless-containers/#protocol-9dd4c8) for more information on container authentication.

        ## Memory and vCPUs configuration

        The vCPU represents a portion of the underlying, physical CPU that is assigned to a particular virtual machine (VM).

        You can determine the computing resources to allocate to each container.

        The `memory_limit` (in MB) must correspond with the right amount of vCPU. Refer to the table below to determine the right memory/vCPU combination.

        | Memory (in MB) | vCPU |
        |----------------|------|
        | 128            | 70m  |
        | 256            | 140m |
        | 512            | 280m |
        | 1024           | 560m |
        | 2048           | 1120 |
        | 3072           | 1680 |
        | 4096           | 2240 |

        ~>**Important:** Make sure to select the right resources, as you will be billed based on compute usage over time and the number of Containers executions.
        Refer to the [Serverless Containers pricing](https://www.scaleway.com/en/docs/faq/serverless-containers/#prices) for more information.

        ## Health check configuration

        Custom health checks can be configured on the container.

        It's possible to specify the HTTP path that the probe will listen to and the number of failures before considering the container as unhealthy.
        During a deployment, if a newly created container fails to pass the health check, the deployment is aborted.
        As a result, lowering this value can help to reduce the time it takes to detect a failed deployment.
        The period between health checks is also configurable.

        Example:

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.containers.Container("main",
            name="my-container-02",
            namespace_id=main_scaleway_container_namespace["id"],
            health_checks=[{
                "https": [{
                    "path": "/ping",
                }],
                "failure_threshold": 40,
                "interval": "5s",
            }])
        ```

        ~>**Important:** Another probe type can be set to TCP with the API, but currently the SDK has not been updated with this parameter.
        This is why the only probe that can be used here is the HTTP probe.
        Refer to the [Serverless Containers pricing](https://www.scaleway.com/en/docs/faq/serverless-containers/#prices) for more information.

        ## Scaling option configuration

        Scaling option block configuration allows you to choose which parameter will scale up/down containers.
        Options are number of concurrent requests, CPU or memory usage.
        It replaces current `max_concurrency` that has been deprecated.

        Example:

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.containers.Container("main",
            name="my-container-02",
            namespace_id=main_scaleway_container_namespace["id"],
            scaling_options=[{
                "concurrent_requests_threshold": 15,
            }])
        ```

        ~>**Important**: A maximum of one of these parameters may be set. Also, when `cpu_usage_threshold` or `memory_usage_threshold` are used, `min_scale` can't be set to 0.
        Refer to the [API Reference](https://www.scaleway.com/en/developers/api/serverless-containers/#path-containers-create-a-new-container) for more information.

        ## Import

        Containers can be imported using, `{region}/{id}`, as shown below:

        bash

        ```sh
        $ pulumi import scaleway:index/container:Container main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param ContainerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContainerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 cpu_limit: Optional[pulumi.Input[builtins.int]] = None,
                 deploy: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 health_checks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerHealthCheckArgs', 'ContainerHealthCheckArgsDict']]]]] = None,
                 http_option: Optional[pulumi.Input[builtins.str]] = None,
                 local_storage_limit: Optional[pulumi.Input[builtins.int]] = None,
                 max_concurrency: Optional[pulumi.Input[builtins.int]] = None,
                 max_scale: Optional[pulumi.Input[builtins.int]] = None,
                 memory_limit: Optional[pulumi.Input[builtins.int]] = None,
                 min_scale: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 privacy: Optional[pulumi.Input[builtins.str]] = None,
                 private_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 registry_image: Optional[pulumi.Input[builtins.str]] = None,
                 registry_sha256: Optional[pulumi.Input[builtins.str]] = None,
                 sandbox: Optional[pulumi.Input[builtins.str]] = None,
                 scaling_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerScalingOptionArgs', 'ContainerScalingOptionArgsDict']]]]] = None,
                 secret_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        pulumi.log.warn("""Container is deprecated: scaleway.index/container.Container has been deprecated in favor of scaleway.containers/container.Container""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContainerArgs.__new__(ContainerArgs)

            __props__.__dict__["args"] = args
            __props__.__dict__["commands"] = commands
            __props__.__dict__["cpu_limit"] = cpu_limit
            __props__.__dict__["deploy"] = deploy
            __props__.__dict__["description"] = description
            __props__.__dict__["environment_variables"] = environment_variables
            __props__.__dict__["health_checks"] = health_checks
            __props__.__dict__["http_option"] = http_option
            __props__.__dict__["local_storage_limit"] = local_storage_limit
            __props__.__dict__["max_concurrency"] = max_concurrency
            __props__.__dict__["max_scale"] = max_scale
            __props__.__dict__["memory_limit"] = memory_limit
            __props__.__dict__["min_scale"] = min_scale
            __props__.__dict__["name"] = name
            if namespace_id is None and not opts.urn:
                raise TypeError("Missing required property 'namespace_id'")
            __props__.__dict__["namespace_id"] = namespace_id
            __props__.__dict__["port"] = port
            __props__.__dict__["privacy"] = privacy
            __props__.__dict__["private_network_id"] = private_network_id
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["region"] = region
            __props__.__dict__["registry_image"] = registry_image
            __props__.__dict__["registry_sha256"] = registry_sha256
            __props__.__dict__["sandbox"] = sandbox
            __props__.__dict__["scaling_options"] = scaling_options
            __props__.__dict__["secret_environment_variables"] = None if secret_environment_variables is None else pulumi.Output.secret(secret_environment_variables)
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["cron_status"] = None
            __props__.__dict__["domain_name"] = None
            __props__.__dict__["error_message"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secretEnvironmentVariables"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Container, __self__).__init__(
            'scaleway:index/container:Container',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            args: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            commands: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            cpu_limit: Optional[pulumi.Input[builtins.int]] = None,
            cron_status: Optional[pulumi.Input[builtins.str]] = None,
            deploy: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            domain_name: Optional[pulumi.Input[builtins.str]] = None,
            environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            error_message: Optional[pulumi.Input[builtins.str]] = None,
            health_checks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerHealthCheckArgs', 'ContainerHealthCheckArgsDict']]]]] = None,
            http_option: Optional[pulumi.Input[builtins.str]] = None,
            local_storage_limit: Optional[pulumi.Input[builtins.int]] = None,
            max_concurrency: Optional[pulumi.Input[builtins.int]] = None,
            max_scale: Optional[pulumi.Input[builtins.int]] = None,
            memory_limit: Optional[pulumi.Input[builtins.int]] = None,
            min_scale: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            namespace_id: Optional[pulumi.Input[builtins.str]] = None,
            port: Optional[pulumi.Input[builtins.int]] = None,
            privacy: Optional[pulumi.Input[builtins.str]] = None,
            private_network_id: Optional[pulumi.Input[builtins.str]] = None,
            protocol: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            registry_image: Optional[pulumi.Input[builtins.str]] = None,
            registry_sha256: Optional[pulumi.Input[builtins.str]] = None,
            sandbox: Optional[pulumi.Input[builtins.str]] = None,
            scaling_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerScalingOptionArgs', 'ContainerScalingOptionArgsDict']]]]] = None,
            secret_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            timeout: Optional[pulumi.Input[builtins.int]] = None) -> 'Container':
        """
        Get an existing Container resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] args: Arguments passed to the command specified in the "command" field. These override the default arguments from the container image, and behave like command-line parameters.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] commands: Command executed when the container starts. This overrides the default command defined in the container image. This is usually the main executable, or entry point script to run.
        :param pulumi.Input[builtins.int] cpu_limit: The amount of vCPU computing resources to allocate to each container.
        :param pulumi.Input[builtins.str] cron_status: The cron status of the container.
        :param pulumi.Input[builtins.bool] deploy: Boolean indicating whether the container is in a production environment.
        :param pulumi.Input[builtins.str] description: The description of the container.
        :param pulumi.Input[builtins.str] domain_name: The native domain name of the container
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] environment_variables: The [environment variables](https://www.scaleway.com/en/docs/serverless-containers/concepts/#environment-variables) of the container.
        :param pulumi.Input[builtins.str] error_message: The error message of the container.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerHealthCheckArgs', 'ContainerHealthCheckArgsDict']]]] health_checks: Health check configuration block of the container.
        :param pulumi.Input[builtins.str] http_option: Allows both HTTP and HTTPS (`enabled`) or redirect HTTP to HTTPS (`redirected`). Defaults to `enabled`.
        :param pulumi.Input[builtins.int] local_storage_limit: Local storage limit of the container (in MB)
        :param pulumi.Input[builtins.int] max_concurrency: The maximum number of simultaneous requests your container can handle at the same time. Use `scaling_option.concurrent_requests_threshold` instead.
        :param pulumi.Input[builtins.int] max_scale: The maximum number of instances this container can scale to.
        :param pulumi.Input[builtins.int] memory_limit: The memory resources in MB to allocate to each container.
        :param pulumi.Input[builtins.int] min_scale: The minimum number of container instances running continuously.
        :param pulumi.Input[builtins.str] name: The unique name of the container name.
        :param pulumi.Input[builtins.str] namespace_id: The Containers namespace ID of the container.
               
               > **Important** Updating the `name` argument will recreate the container.
        :param pulumi.Input[builtins.int] port: The port to expose the container.
        :param pulumi.Input[builtins.str] privacy: The privacy type defines the way to authenticate to your container. Please check our dedicated [section](https://www.scaleway.com/en/developers/api/serverless-containers/#protocol-9dd4c8).
        :param pulumi.Input[builtins.str] private_network_id: The ID of the Private Network the container is connected to.
               
               > **Important** This feature is currently in beta and requires a namespace with VPC integration activated by setting the `activate_vpc_integration` attribute to `true`.
               
               Note that if you want to use your own configuration, you must consult our configuration [restrictions](https://www.scaleway.com/en/docs/serverless-containers/reference-content/containers-limitations/#configuration-restrictions) section.
        :param pulumi.Input[builtins.str] protocol: The communication [protocol](https://www.scaleway.com/en/developers/api/serverless-containers/#path-containers-update-an-existing-container) `http1` or `h2c`. Defaults to `http1`.
        :param pulumi.Input[builtins.str] region: (Defaults to provider `region`) The region in which the container was created.
        :param pulumi.Input[builtins.str] registry_image: The registry image address (e.g., `rg.fr-par.scw.cloud/$NAMESPACE/$IMAGE`)
        :param pulumi.Input[builtins.str] registry_sha256: The sha256 of your source registry image, changing it will re-apply the deployment. Can be any string.
        :param pulumi.Input[builtins.str] sandbox: Execution environment of the container.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerScalingOptionArgs', 'ContainerScalingOptionArgsDict']]]] scaling_options: Configuration block used to decide when to scale up or down. Possible values:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] secret_environment_variables: The [secret environment variables](https://www.scaleway.com/en/docs/serverless-containers/concepts/#secrets) of the container.
        :param pulumi.Input[builtins.str] status: The container status.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The list of tags associated with the container.
        :param pulumi.Input[builtins.int] timeout: The maximum amount of time in seconds your container can spend processing a request before being stopped. Default to `300` seconds.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContainerState.__new__(_ContainerState)

        __props__.__dict__["args"] = args
        __props__.__dict__["commands"] = commands
        __props__.__dict__["cpu_limit"] = cpu_limit
        __props__.__dict__["cron_status"] = cron_status
        __props__.__dict__["deploy"] = deploy
        __props__.__dict__["description"] = description
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["environment_variables"] = environment_variables
        __props__.__dict__["error_message"] = error_message
        __props__.__dict__["health_checks"] = health_checks
        __props__.__dict__["http_option"] = http_option
        __props__.__dict__["local_storage_limit"] = local_storage_limit
        __props__.__dict__["max_concurrency"] = max_concurrency
        __props__.__dict__["max_scale"] = max_scale
        __props__.__dict__["memory_limit"] = memory_limit
        __props__.__dict__["min_scale"] = min_scale
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace_id"] = namespace_id
        __props__.__dict__["port"] = port
        __props__.__dict__["privacy"] = privacy
        __props__.__dict__["private_network_id"] = private_network_id
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["region"] = region
        __props__.__dict__["registry_image"] = registry_image
        __props__.__dict__["registry_sha256"] = registry_sha256
        __props__.__dict__["sandbox"] = sandbox
        __props__.__dict__["scaling_options"] = scaling_options
        __props__.__dict__["secret_environment_variables"] = secret_environment_variables
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["timeout"] = timeout
        return Container(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def args(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Arguments passed to the command specified in the "command" field. These override the default arguments from the container image, and behave like command-line parameters.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def commands(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Command executed when the container starts. This overrides the default command defined in the container image. This is usually the main executable, or entry point script to run.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter(name="cpuLimit")
    def cpu_limit(self) -> pulumi.Output[builtins.int]:
        """
        The amount of vCPU computing resources to allocate to each container.
        """
        return pulumi.get(self, "cpu_limit")

    @property
    @pulumi.getter(name="cronStatus")
    def cron_status(self) -> pulumi.Output[builtins.str]:
        """
        The cron status of the container.
        """
        return pulumi.get(self, "cron_status")

    @property
    @pulumi.getter
    def deploy(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Boolean indicating whether the container is in a production environment.
        """
        return pulumi.get(self, "deploy")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the container.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[builtins.str]:
        """
        The native domain name of the container
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The [environment variables](https://www.scaleway.com/en/docs/serverless-containers/concepts/#environment-variables) of the container.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> pulumi.Output[builtins.str]:
        """
        The error message of the container.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> pulumi.Output[Sequence['outputs.ContainerHealthCheck']]:
        """
        Health check configuration block of the container.
        """
        return pulumi.get(self, "health_checks")

    @property
    @pulumi.getter(name="httpOption")
    def http_option(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Allows both HTTP and HTTPS (`enabled`) or redirect HTTP to HTTPS (`redirected`). Defaults to `enabled`.
        """
        return pulumi.get(self, "http_option")

    @property
    @pulumi.getter(name="localStorageLimit")
    def local_storage_limit(self) -> pulumi.Output[builtins.int]:
        """
        Local storage limit of the container (in MB)
        """
        return pulumi.get(self, "local_storage_limit")

    @property
    @pulumi.getter(name="maxConcurrency")
    @_utilities.deprecated("""Use scaling_option.concurrent_requests_threshold instead. This attribute will be removed.""")
    def max_concurrency(self) -> pulumi.Output[builtins.int]:
        """
        The maximum number of simultaneous requests your container can handle at the same time. Use `scaling_option.concurrent_requests_threshold` instead.
        """
        return pulumi.get(self, "max_concurrency")

    @property
    @pulumi.getter(name="maxScale")
    def max_scale(self) -> pulumi.Output[builtins.int]:
        """
        The maximum number of instances this container can scale to.
        """
        return pulumi.get(self, "max_scale")

    @property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> pulumi.Output[builtins.int]:
        """
        The memory resources in MB to allocate to each container.
        """
        return pulumi.get(self, "memory_limit")

    @property
    @pulumi.getter(name="minScale")
    def min_scale(self) -> pulumi.Output[builtins.int]:
        """
        The minimum number of container instances running continuously.
        """
        return pulumi.get(self, "min_scale")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The unique name of the container name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> pulumi.Output[builtins.str]:
        """
        The Containers namespace ID of the container.

        > **Important** Updating the `name` argument will recreate the container.
        """
        return pulumi.get(self, "namespace_id")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[builtins.int]:
        """
        The port to expose the container.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def privacy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The privacy type defines the way to authenticate to your container. Please check our dedicated [section](https://www.scaleway.com/en/developers/api/serverless-containers/#protocol-9dd4c8).
        """
        return pulumi.get(self, "privacy")

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the Private Network the container is connected to.

        > **Important** This feature is currently in beta and requires a namespace with VPC integration activated by setting the `activate_vpc_integration` attribute to `true`.

        Note that if you want to use your own configuration, you must consult our configuration [restrictions](https://www.scaleway.com/en/docs/serverless-containers/reference-content/containers-limitations/#configuration-restrictions) section.
        """
        return pulumi.get(self, "private_network_id")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The communication [protocol](https://www.scaleway.com/en/developers/api/serverless-containers/#path-containers-update-an-existing-container) `http1` or `h2c`. Defaults to `http1`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        (Defaults to provider `region`) The region in which the container was created.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="registryImage")
    def registry_image(self) -> pulumi.Output[builtins.str]:
        """
        The registry image address (e.g., `rg.fr-par.scw.cloud/$NAMESPACE/$IMAGE`)
        """
        return pulumi.get(self, "registry_image")

    @property
    @pulumi.getter(name="registrySha256")
    def registry_sha256(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The sha256 of your source registry image, changing it will re-apply the deployment. Can be any string.
        """
        return pulumi.get(self, "registry_sha256")

    @property
    @pulumi.getter
    def sandbox(self) -> pulumi.Output[builtins.str]:
        """
        Execution environment of the container.
        """
        return pulumi.get(self, "sandbox")

    @property
    @pulumi.getter(name="scalingOptions")
    def scaling_options(self) -> pulumi.Output[Sequence['outputs.ContainerScalingOption']]:
        """
        Configuration block used to decide when to scale up or down. Possible values:
        """
        return pulumi.get(self, "scaling_options")

    @property
    @pulumi.getter(name="secretEnvironmentVariables")
    def secret_environment_variables(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The [secret environment variables](https://www.scaleway.com/en/docs/serverless-containers/concepts/#secrets) of the container.
        """
        return pulumi.get(self, "secret_environment_variables")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The container status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The list of tags associated with the container.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[builtins.int]:
        """
        The maximum amount of time in seconds your container can spend processing a request before being stopped. Default to `300` seconds.
        """
        return pulumi.get(self, "timeout")

