# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DatabaseBackupArgs', 'DatabaseBackup']

@pulumi.input_type
class DatabaseBackupArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[builtins.str],
                 instance_id: pulumi.Input[builtins.str],
                 expires_at: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a DatabaseBackup resource.
        :param pulumi.Input[builtins.str] database_name: Name of the database of this backup.
        :param pulumi.Input[builtins.str] instance_id: UUID of the Database Instance.
               
               > **Important:** Updates to `instance_id` will recreate the backup.
        :param pulumi.Input[builtins.str] expires_at: Expiration date (Format ISO 8601).
               
               > **Important:** `expires_at` cannot be removed after being set.
        :param pulumi.Input[builtins.str] name: Name of the database (e.g. `my-database`).
        :param pulumi.Input[builtins.str] region: `region`) The region in which the resource exists.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "instance_id", instance_id)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the database of this backup.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[builtins.str]:
        """
        UUID of the Database Instance.

        > **Important:** Updates to `instance_id` will recreate the backup.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Expiration date (Format ISO 8601).

        > **Important:** `expires_at` cannot be removed after being set.
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expires_at", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the database (e.g. `my-database`).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`) The region in which the resource exists.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DatabaseBackupState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 size: Optional[pulumi.Input[builtins.int]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatabaseBackup resources.
        :param pulumi.Input[builtins.str] created_at: Creation date (Format ISO 8601).
        :param pulumi.Input[builtins.str] database_name: Name of the database of this backup.
        :param pulumi.Input[builtins.str] expires_at: Expiration date (Format ISO 8601).
               
               > **Important:** `expires_at` cannot be removed after being set.
        :param pulumi.Input[builtins.str] instance_id: UUID of the Database Instance.
               
               > **Important:** Updates to `instance_id` will recreate the backup.
        :param pulumi.Input[builtins.str] instance_name: Name of the instance of the backup.
        :param pulumi.Input[builtins.str] name: Name of the database (e.g. `my-database`).
        :param pulumi.Input[builtins.str] region: `region`) The region in which the resource exists.
        :param pulumi.Input[builtins.int] size: Size of the backup (in bytes).
        :param pulumi.Input[builtins.str] updated_at: Updated date (Format ISO 8601).
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation date (Format ISO 8601).
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the database of this backup.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Expiration date (Format ISO 8601).

        > **Important:** `expires_at` cannot be removed after being set.
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expires_at", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        UUID of the Database Instance.

        > **Important:** Updates to `instance_id` will recreate the backup.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the instance of the backup.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the database (e.g. `my-database`).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`) The region in which the resource exists.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Size of the backup (in bytes).
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Updated date (Format ISO 8601).
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)


warnings.warn("""scaleway.index/databasebackup.DatabaseBackup has been deprecated in favor of scaleway.databases/databasebackup.DatabaseBackup""", DeprecationWarning)


@pulumi.type_token("scaleway:index/databaseBackup:DatabaseBackup")
class DatabaseBackup(pulumi.CustomResource):
    warnings.warn("""scaleway.index/databasebackup.DatabaseBackup has been deprecated in favor of scaleway.databases/databasebackup.DatabaseBackup""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages database backups.
        For more information, refer to the [API documentation](https://www.scaleway.com/en/developers/api/managed-database-postgre-mysql/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.Instance("main",
            name="test-rdb",
            node_type="DB-DEV-S",
            engine="PostgreSQL-15",
            is_ha_cluster=True,
            disable_backup=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret")
        main_database = scaleway.databases.Database("main",
            instance_id=main.id,
            name="database")
        main_database_backup = scaleway.databases.DatabaseBackup("main",
            instance_id=main.id,
            database_name=main_database.name)
        ```

        ### With expiration

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.DatabaseBackup("main",
            instance_id=main_scaleway_rdb_instance["id"],
            database_name=main_scaleway_rdb_database["name"],
            expires_at="2022-06-16T07:48:44Z")
        ```

        ## Import

        Databases can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/databaseBackup:DatabaseBackup mybackup fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] database_name: Name of the database of this backup.
        :param pulumi.Input[builtins.str] expires_at: Expiration date (Format ISO 8601).
               
               > **Important:** `expires_at` cannot be removed after being set.
        :param pulumi.Input[builtins.str] instance_id: UUID of the Database Instance.
               
               > **Important:** Updates to `instance_id` will recreate the backup.
        :param pulumi.Input[builtins.str] name: Name of the database (e.g. `my-database`).
        :param pulumi.Input[builtins.str] region: `region`) The region in which the resource exists.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseBackupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages database backups.
        For more information, refer to the [API documentation](https://www.scaleway.com/en/developers/api/managed-database-postgre-mysql/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.Instance("main",
            name="test-rdb",
            node_type="DB-DEV-S",
            engine="PostgreSQL-15",
            is_ha_cluster=True,
            disable_backup=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret")
        main_database = scaleway.databases.Database("main",
            instance_id=main.id,
            name="database")
        main_database_backup = scaleway.databases.DatabaseBackup("main",
            instance_id=main.id,
            database_name=main_database.name)
        ```

        ### With expiration

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.DatabaseBackup("main",
            instance_id=main_scaleway_rdb_instance["id"],
            database_name=main_scaleway_rdb_database["name"],
            expires_at="2022-06-16T07:48:44Z")
        ```

        ## Import

        Databases can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/databaseBackup:DatabaseBackup mybackup fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseBackupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseBackupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""DatabaseBackup is deprecated: scaleway.index/databasebackup.DatabaseBackup has been deprecated in favor of scaleway.databases/databasebackup.DatabaseBackup""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseBackupArgs.__new__(DatabaseBackupArgs)

            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["expires_at"] = expires_at
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["created_at"] = None
            __props__.__dict__["instance_name"] = None
            __props__.__dict__["size"] = None
            __props__.__dict__["updated_at"] = None
        super(DatabaseBackup, __self__).__init__(
            'scaleway:index/databaseBackup:DatabaseBackup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            database_name: Optional[pulumi.Input[builtins.str]] = None,
            expires_at: Optional[pulumi.Input[builtins.str]] = None,
            instance_id: Optional[pulumi.Input[builtins.str]] = None,
            instance_name: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            size: Optional[pulumi.Input[builtins.int]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None) -> 'DatabaseBackup':
        """
        Get an existing DatabaseBackup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] created_at: Creation date (Format ISO 8601).
        :param pulumi.Input[builtins.str] database_name: Name of the database of this backup.
        :param pulumi.Input[builtins.str] expires_at: Expiration date (Format ISO 8601).
               
               > **Important:** `expires_at` cannot be removed after being set.
        :param pulumi.Input[builtins.str] instance_id: UUID of the Database Instance.
               
               > **Important:** Updates to `instance_id` will recreate the backup.
        :param pulumi.Input[builtins.str] instance_name: Name of the instance of the backup.
        :param pulumi.Input[builtins.str] name: Name of the database (e.g. `my-database`).
        :param pulumi.Input[builtins.str] region: `region`) The region in which the resource exists.
        :param pulumi.Input[builtins.int] size: Size of the backup (in bytes).
        :param pulumi.Input[builtins.str] updated_at: Updated date (Format ISO 8601).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseBackupState.__new__(_DatabaseBackupState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["expires_at"] = expires_at
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["size"] = size
        __props__.__dict__["updated_at"] = updated_at
        return DatabaseBackup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Creation date (Format ISO 8601).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the database of this backup.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Expiration date (Format ISO 8601).

        > **Important:** `expires_at` cannot be removed after being set.
        """
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[builtins.str]:
        """
        UUID of the Database Instance.

        > **Important:** Updates to `instance_id` will recreate the backup.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the instance of the backup.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the database (e.g. `my-database`).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        `region`) The region in which the resource exists.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[builtins.int]:
        """
        Size of the backup (in bytes).
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        Updated date (Format ISO 8601).
        """
        return pulumi.get(self, "updated_at")

