# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AclArgs', 'Acl']

@pulumi.input_type
class AclArgs:
    def __init__(__self__, *,
                 acl_rules: pulumi.Input[Sequence[pulumi.Input['AclAclRuleArgs']]],
                 instance_id: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Acl resource.
        :param pulumi.Input[Sequence[pulumi.Input['AclAclRuleArgs']]] acl_rules: A list of ACLs (structure is described below)
        :param pulumi.Input[builtins.str] instance_id: UUID of the Database Instance.
               
               > **Important:** Updates to `instance_id` will recreate the Database ACL.
        :param pulumi.Input[builtins.str] region: `region`) The region in which the Database Instance should be created.
        """
        pulumi.set(__self__, "acl_rules", acl_rules)
        pulumi.set(__self__, "instance_id", instance_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="aclRules")
    def acl_rules(self) -> pulumi.Input[Sequence[pulumi.Input['AclAclRuleArgs']]]:
        """
        A list of ACLs (structure is described below)
        """
        return pulumi.get(self, "acl_rules")

    @acl_rules.setter
    def acl_rules(self, value: pulumi.Input[Sequence[pulumi.Input['AclAclRuleArgs']]]):
        pulumi.set(self, "acl_rules", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[builtins.str]:
        """
        UUID of the Database Instance.

        > **Important:** Updates to `instance_id` will recreate the Database ACL.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`) The region in which the Database Instance should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AclState:
    def __init__(__self__, *,
                 acl_rules: Optional[pulumi.Input[Sequence[pulumi.Input['AclAclRuleArgs']]]] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Acl resources.
        :param pulumi.Input[Sequence[pulumi.Input['AclAclRuleArgs']]] acl_rules: A list of ACLs (structure is described below)
        :param pulumi.Input[builtins.str] instance_id: UUID of the Database Instance.
               
               > **Important:** Updates to `instance_id` will recreate the Database ACL.
        :param pulumi.Input[builtins.str] region: `region`) The region in which the Database Instance should be created.
        """
        if acl_rules is not None:
            pulumi.set(__self__, "acl_rules", acl_rules)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="aclRules")
    def acl_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclAclRuleArgs']]]]:
        """
        A list of ACLs (structure is described below)
        """
        return pulumi.get(self, "acl_rules")

    @acl_rules.setter
    def acl_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclAclRuleArgs']]]]):
        pulumi.set(self, "acl_rules", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        UUID of the Database Instance.

        > **Important:** Updates to `instance_id` will recreate the Database ACL.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`) The region in which the Database Instance should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("scaleway:databases/acl:Acl")
class Acl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AclAclRuleArgs', 'AclAclRuleArgsDict']]]]] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Database instance authorized IPs.
        For more information refer to the [API documentation](https://www.scaleway.com/en/developers/api/managed-database-postgre-mysql/#acl-rules-allowed-ips).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.Instance("main",
            name="test-rdb",
            node_type="DB-DEV-S",
            engine="PostgreSQL-15",
            is_ha_cluster=True,
            disable_backup=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret")
        main_acl = scaleway.databases.Acl("main",
            instance_id=main.id,
            acl_rules=[{
                "ip": "1.2.3.4/32",
                "description": "foo",
            }])
        ```

        ## Import

        Database Instance can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:databases/acl:Acl acl01 fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AclAclRuleArgs', 'AclAclRuleArgsDict']]]] acl_rules: A list of ACLs (structure is described below)
        :param pulumi.Input[builtins.str] instance_id: UUID of the Database Instance.
               
               > **Important:** Updates to `instance_id` will recreate the Database ACL.
        :param pulumi.Input[builtins.str] region: `region`) The region in which the Database Instance should be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AclArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Database instance authorized IPs.
        For more information refer to the [API documentation](https://www.scaleway.com/en/developers/api/managed-database-postgre-mysql/#acl-rules-allowed-ips).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.Instance("main",
            name="test-rdb",
            node_type="DB-DEV-S",
            engine="PostgreSQL-15",
            is_ha_cluster=True,
            disable_backup=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret")
        main_acl = scaleway.databases.Acl("main",
            instance_id=main.id,
            acl_rules=[{
                "ip": "1.2.3.4/32",
                "description": "foo",
            }])
        ```

        ## Import

        Database Instance can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:databases/acl:Acl acl01 fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param AclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AclAclRuleArgs', 'AclAclRuleArgsDict']]]]] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AclArgs.__new__(AclArgs)

            if acl_rules is None and not opts.urn:
                raise TypeError("Missing required property 'acl_rules'")
            __props__.__dict__["acl_rules"] = acl_rules
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["region"] = region
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/databaseAcl:DatabaseAcl")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Acl, __self__).__init__(
            'scaleway:databases/acl:Acl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AclAclRuleArgs', 'AclAclRuleArgsDict']]]]] = None,
            instance_id: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None) -> 'Acl':
        """
        Get an existing Acl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AclAclRuleArgs', 'AclAclRuleArgsDict']]]] acl_rules: A list of ACLs (structure is described below)
        :param pulumi.Input[builtins.str] instance_id: UUID of the Database Instance.
               
               > **Important:** Updates to `instance_id` will recreate the Database ACL.
        :param pulumi.Input[builtins.str] region: `region`) The region in which the Database Instance should be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AclState.__new__(_AclState)

        __props__.__dict__["acl_rules"] = acl_rules
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["region"] = region
        return Acl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aclRules")
    def acl_rules(self) -> pulumi.Output[Sequence['outputs.AclAclRule']]:
        """
        A list of ACLs (structure is described below)
        """
        return pulumi.get(self, "acl_rules")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[builtins.str]:
        """
        UUID of the Database Instance.

        > **Important:** Updates to `instance_id` will recreate the Database ACL.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        `region`) The region in which the Database Instance should be created.
        """
        return pulumi.get(self, "region")

