# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetZoneResult',
    'AwaitableGetZoneResult',
    'get_zone',
    'get_zone_output',
]

@pulumi.output_type
class GetZoneResult:
    """
    A collection of values returned by getZone.
    """
    def __init__(__self__, domain=None, id=None, message=None, ns=None, ns_defaults=None, ns_masters=None, project_id=None, status=None, subdomain=None, updated_at=None):
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if message and not isinstance(message, str):
            raise TypeError("Expected argument 'message' to be a str")
        pulumi.set(__self__, "message", message)
        if ns and not isinstance(ns, list):
            raise TypeError("Expected argument 'ns' to be a list")
        pulumi.set(__self__, "ns", ns)
        if ns_defaults and not isinstance(ns_defaults, list):
            raise TypeError("Expected argument 'ns_defaults' to be a list")
        pulumi.set(__self__, "ns_defaults", ns_defaults)
        if ns_masters and not isinstance(ns_masters, list):
            raise TypeError("Expected argument 'ns_masters' to be a list")
        pulumi.set(__self__, "ns_masters", ns_masters)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subdomain and not isinstance(subdomain, str):
            raise TypeError("Expected argument 'subdomain' to be a str")
        pulumi.set(__self__, "subdomain", subdomain)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def domain(self) -> Optional[builtins.str]:
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        Message associated with the domain zone (typically used for status or error messages).
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def ns(self) -> Sequence[builtins.str]:
        """
        The list of name servers for the zone.
        """
        return pulumi.get(self, "ns")

    @property
    @pulumi.getter(name="nsDefaults")
    def ns_defaults(self) -> Sequence[builtins.str]:
        """
        The default list of name servers for the zone.
        """
        return pulumi.get(self, "ns_defaults")

    @property
    @pulumi.getter(name="nsMasters")
    def ns_masters(self) -> Sequence[builtins.str]:
        """
        The master list of name servers for the zone.
        """
        return pulumi.get(self, "ns_masters")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The status of the domain zone.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def subdomain(self) -> Optional[builtins.str]:
        return pulumi.get(self, "subdomain")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> builtins.str:
        """
        The date and time of the last update to the DNS zone.
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetZoneResult(GetZoneResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZoneResult(
            domain=self.domain,
            id=self.id,
            message=self.message,
            ns=self.ns,
            ns_defaults=self.ns_defaults,
            ns_masters=self.ns_masters,
            project_id=self.project_id,
            status=self.status,
            subdomain=self.subdomain,
            updated_at=self.updated_at)


def get_zone(domain: Optional[builtins.str] = None,
             project_id: Optional[builtins.str] = None,
             subdomain: Optional[builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZoneResult:
    """
    Use this data source to access information about an existing resource.

    :param builtins.str domain: The primary domain name where the DNS zone is located. This is a mandatory field.
    :param builtins.str project_id: ). The ID of the Scaleway Project associated with the domain. If not specified, it defaults to the `project_id` set in the provider configuration.
    :param builtins.str subdomain: The subdomain (or zone name) within the primary domain. This is a mandatory field.
    """
    __args__ = dict()
    __args__['domain'] = domain
    __args__['projectId'] = project_id
    __args__['subdomain'] = subdomain
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:domain/getZone:getZone', __args__, opts=opts, typ=GetZoneResult).value

    return AwaitableGetZoneResult(
        domain=pulumi.get(__ret__, 'domain'),
        id=pulumi.get(__ret__, 'id'),
        message=pulumi.get(__ret__, 'message'),
        ns=pulumi.get(__ret__, 'ns'),
        ns_defaults=pulumi.get(__ret__, 'ns_defaults'),
        ns_masters=pulumi.get(__ret__, 'ns_masters'),
        project_id=pulumi.get(__ret__, 'project_id'),
        status=pulumi.get(__ret__, 'status'),
        subdomain=pulumi.get(__ret__, 'subdomain'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_zone_output(domain: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                    project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                    subdomain: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZoneResult]:
    """
    Use this data source to access information about an existing resource.

    :param builtins.str domain: The primary domain name where the DNS zone is located. This is a mandatory field.
    :param builtins.str project_id: ). The ID of the Scaleway Project associated with the domain. If not specified, it defaults to the `project_id` set in the provider configuration.
    :param builtins.str subdomain: The subdomain (or zone name) within the primary domain. This is a mandatory field.
    """
    __args__ = dict()
    __args__['domain'] = domain
    __args__['projectId'] = project_id
    __args__['subdomain'] = subdomain
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:domain/getZone:getZone', __args__, opts=opts, typ=GetZoneResult)
    return __ret__.apply(lambda __response__: GetZoneResult(
        domain=pulumi.get(__response__, 'domain'),
        id=pulumi.get(__response__, 'id'),
        message=pulumi.get(__response__, 'message'),
        ns=pulumi.get(__response__, 'ns'),
        ns_defaults=pulumi.get(__response__, 'ns_defaults'),
        ns_masters=pulumi.get(__response__, 'ns_masters'),
        project_id=pulumi.get(__response__, 'project_id'),
        status=pulumi.get(__response__, 'status'),
        subdomain=pulumi.get(__response__, 'subdomain'),
        updated_at=pulumi.get(__response__, 'updated_at')))
