# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'TriggerNatsArgs',
    'TriggerNatsArgsDict',
    'TriggerSqsArgs',
    'TriggerSqsArgsDict',
]

MYPY = False

if not MYPY:
    class TriggerNatsArgsDict(TypedDict):
        subject: pulumi.Input[builtins.str]
        """
        The subject to listen to.
        """
        account_id: NotRequired[pulumi.Input[builtins.str]]
        """
        unique identifier of the Messaging and Queuing NATS account.
        """
        project_id: NotRequired[pulumi.Input[builtins.str]]
        """
        THe ID of the project that contains the Messaging and Queuing NATS account (defaults to provider `project_id`)
        """
        region: NotRequired[pulumi.Input[builtins.str]]
        """
        Region where the Messaging and Queuing NATS account is enabled (defaults to provider `region`)
        """
elif False:
    TriggerNatsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerNatsArgs:
    def __init__(__self__, *,
                 subject: pulumi.Input[builtins.str],
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] subject: The subject to listen to.
        :param pulumi.Input[builtins.str] account_id: unique identifier of the Messaging and Queuing NATS account.
        :param pulumi.Input[builtins.str] project_id: THe ID of the project that contains the Messaging and Queuing NATS account (defaults to provider `project_id`)
        :param pulumi.Input[builtins.str] region: Region where the Messaging and Queuing NATS account is enabled (defaults to provider `region`)
        """
        pulumi.set(__self__, "subject", subject)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def subject(self) -> pulumi.Input[builtins.str]:
        """
        The subject to listen to.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subject", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        unique identifier of the Messaging and Queuing NATS account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        THe ID of the project that contains the Messaging and Queuing NATS account (defaults to provider `project_id`)
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where the Messaging and Queuing NATS account is enabled (defaults to provider `region`)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


if not MYPY:
    class TriggerSqsArgsDict(TypedDict):
        queue: pulumi.Input[builtins.str]
        """
        The name of the SQS queue.
        """
        namespace_id: NotRequired[pulumi.Input[builtins.str]]
        """
        ID of the Messaging and Queuing namespace. This argument is deprecated.
        """
        project_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the project in which SQS is enabled, (defaults to provider `project_id`)
        """
        region: NotRequired[pulumi.Input[builtins.str]]
        """
        Region where SQS is enabled (defaults to provider `region`)
        """
elif False:
    TriggerSqsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerSqsArgs:
    def __init__(__self__, *,
                 queue: pulumi.Input[builtins.str],
                 namespace_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] queue: The name of the SQS queue.
        :param pulumi.Input[builtins.str] namespace_id: ID of the Messaging and Queuing namespace. This argument is deprecated.
        :param pulumi.Input[builtins.str] project_id: The ID of the project in which SQS is enabled, (defaults to provider `project_id`)
        :param pulumi.Input[builtins.str] region: Region where SQS is enabled (defaults to provider `region`)
        """
        pulumi.set(__self__, "queue", queue)
        if namespace_id is not None:
            warnings.warn("""The 'namespace_id' field is deprecated and will be removed in the next major version. It is no longer necessary to specify it""", DeprecationWarning)
            pulumi.log.warn("""namespace_id is deprecated: The 'namespace_id' field is deprecated and will be removed in the next major version. It is no longer necessary to specify it""")
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def queue(self) -> pulumi.Input[builtins.str]:
        """
        The name of the SQS queue.
        """
        return pulumi.get(self, "queue")

    @queue.setter
    def queue(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "queue", value)

    @property
    @pulumi.getter(name="namespaceId")
    @_utilities.deprecated("""The 'namespace_id' field is deprecated and will be removed in the next major version. It is no longer necessary to specify it""")
    def namespace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the Messaging and Queuing namespace. This argument is deprecated.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which SQS is enabled, (defaults to provider `project_id`)
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where SQS is enabled (defaults to provider `region`)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


