# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetDatabaseBackupResult',
    'AwaitableGetDatabaseBackupResult',
    'get_database_backup',
    'get_database_backup_output',
]

warnings.warn("""scaleway.index/getdatabasebackup.getDatabaseBackup has been deprecated in favor of scaleway.databases/getdatabasebackup.getDatabaseBackup""", DeprecationWarning)

@pulumi.output_type
class GetDatabaseBackupResult:
    """
    A collection of values returned by getDatabaseBackup.
    """
    def __init__(__self__, backup_id=None, created_at=None, database_name=None, expires_at=None, id=None, instance_id=None, instance_name=None, name=None, project_id=None, region=None, size=None, updated_at=None):
        if backup_id and not isinstance(backup_id, str):
            raise TypeError("Expected argument 'backup_id' to be a str")
        pulumi.set(__self__, "backup_id", backup_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if database_name and not isinstance(database_name, str):
            raise TypeError("Expected argument 'database_name' to be a str")
        pulumi.set(__self__, "database_name", database_name)
        if expires_at and not isinstance(expires_at, str):
            raise TypeError("Expected argument 'expires_at' to be a str")
        pulumi.set(__self__, "expires_at", expires_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if instance_name and not isinstance(instance_name, str):
            raise TypeError("Expected argument 'instance_name' to be a str")
        pulumi.set(__self__, "instance_name", instance_name)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if size and not isinstance(size, int):
            raise TypeError("Expected argument 'size' to be a int")
        pulumi.set(__self__, "size", size)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> builtins.str:
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> builtins.str:
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def size(self) -> builtins.int:
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> builtins.str:
        return pulumi.get(self, "updated_at")


class AwaitableGetDatabaseBackupResult(GetDatabaseBackupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseBackupResult(
            backup_id=self.backup_id,
            created_at=self.created_at,
            database_name=self.database_name,
            expires_at=self.expires_at,
            id=self.id,
            instance_id=self.instance_id,
            instance_name=self.instance_name,
            name=self.name,
            project_id=self.project_id,
            region=self.region,
            size=self.size,
            updated_at=self.updated_at)


def get_database_backup(backup_id: Optional[builtins.str] = None,
                        instance_id: Optional[builtins.str] = None,
                        name: Optional[builtins.str] = None,
                        project_id: Optional[builtins.str] = None,
                        region: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseBackupResult:
    """
    Gets information about an RDB backup.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    find_by_name = scaleway.databases.get_database_backup(name="mybackup")
    find_by_name_and_instance = scaleway.databases.get_database_backup(name="mybackup",
        instance_id="11111111-1111-1111-1111-111111111111")
    find_by_id = scaleway.databases.get_database_backup(backup_id="11111111-1111-1111-1111-111111111111")
    ```


    :param builtins.str backup_id: The backup ID.
    :param builtins.str instance_id: The Database Instance ID.
    :param builtins.str name: The name of the RDB instance.
           
           > **Note** You must specify at least one: `name` and/or `backup_id`.
    :param builtins.str project_id: The ID of the project the Database Backup is associated with.
    :param builtins.str region: `region`) The region in which the Database Backup is associated with.
    """
    pulumi.log.warn("""get_database_backup is deprecated: scaleway.index/getdatabasebackup.getDatabaseBackup has been deprecated in favor of scaleway.databases/getdatabasebackup.getDatabaseBackup""")
    __args__ = dict()
    __args__['backupId'] = backup_id
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:index/getDatabaseBackup:getDatabaseBackup', __args__, opts=opts, typ=GetDatabaseBackupResult).value

    return AwaitableGetDatabaseBackupResult(
        backup_id=pulumi.get(__ret__, 'backup_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        database_name=pulumi.get(__ret__, 'database_name'),
        expires_at=pulumi.get(__ret__, 'expires_at'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        instance_name=pulumi.get(__ret__, 'instance_name'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        region=pulumi.get(__ret__, 'region'),
        size=pulumi.get(__ret__, 'size'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_database_backup_output(backup_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               instance_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatabaseBackupResult]:
    """
    Gets information about an RDB backup.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    find_by_name = scaleway.databases.get_database_backup(name="mybackup")
    find_by_name_and_instance = scaleway.databases.get_database_backup(name="mybackup",
        instance_id="11111111-1111-1111-1111-111111111111")
    find_by_id = scaleway.databases.get_database_backup(backup_id="11111111-1111-1111-1111-111111111111")
    ```


    :param builtins.str backup_id: The backup ID.
    :param builtins.str instance_id: The Database Instance ID.
    :param builtins.str name: The name of the RDB instance.
           
           > **Note** You must specify at least one: `name` and/or `backup_id`.
    :param builtins.str project_id: The ID of the project the Database Backup is associated with.
    :param builtins.str region: `region`) The region in which the Database Backup is associated with.
    """
    pulumi.log.warn("""get_database_backup is deprecated: scaleway.index/getdatabasebackup.getDatabaseBackup has been deprecated in favor of scaleway.databases/getdatabasebackup.getDatabaseBackup""")
    __args__ = dict()
    __args__['backupId'] = backup_id
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:index/getDatabaseBackup:getDatabaseBackup', __args__, opts=opts, typ=GetDatabaseBackupResult)
    return __ret__.apply(lambda __response__: GetDatabaseBackupResult(
        backup_id=pulumi.get(__response__, 'backup_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        database_name=pulumi.get(__response__, 'database_name'),
        expires_at=pulumi.get(__response__, 'expires_at'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        instance_name=pulumi.get(__response__, 'instance_name'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id'),
        region=pulumi.get(__response__, 'region'),
        size=pulumi.get(__response__, 'size'),
        updated_at=pulumi.get(__response__, 'updated_at')))
