# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetObjectBucketResult',
    'AwaitableGetObjectBucketResult',
    'get_object_bucket',
    'get_object_bucket_output',
]

warnings.warn("""scaleway.index/getobjectbucket.getObjectBucket has been deprecated in favor of scaleway.object/getbucket.getBucket""", DeprecationWarning)

@pulumi.output_type
class GetObjectBucketResult:
    """
    A collection of values returned by getObjectBucket.
    """
    def __init__(__self__, acl=None, api_endpoint=None, cors_rules=None, endpoint=None, force_destroy=None, id=None, lifecycle_rules=None, name=None, object_lock_enabled=None, project_id=None, region=None, tags=None, versionings=None):
        if acl and not isinstance(acl, str):
            raise TypeError("Expected argument 'acl' to be a str")
        pulumi.set(__self__, "acl", acl)
        if api_endpoint and not isinstance(api_endpoint, str):
            raise TypeError("Expected argument 'api_endpoint' to be a str")
        pulumi.set(__self__, "api_endpoint", api_endpoint)
        if cors_rules and not isinstance(cors_rules, list):
            raise TypeError("Expected argument 'cors_rules' to be a list")
        pulumi.set(__self__, "cors_rules", cors_rules)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if force_destroy and not isinstance(force_destroy, bool):
            raise TypeError("Expected argument 'force_destroy' to be a bool")
        pulumi.set(__self__, "force_destroy", force_destroy)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_rules and not isinstance(lifecycle_rules, list):
            raise TypeError("Expected argument 'lifecycle_rules' to be a list")
        pulumi.set(__self__, "lifecycle_rules", lifecycle_rules)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if object_lock_enabled and not isinstance(object_lock_enabled, bool):
            raise TypeError("Expected argument 'object_lock_enabled' to be a bool")
        pulumi.set(__self__, "object_lock_enabled", object_lock_enabled)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if versionings and not isinstance(versionings, list):
            raise TypeError("Expected argument 'versionings' to be a list")
        pulumi.set(__self__, "versionings", versionings)

    @property
    @pulumi.getter
    def acl(self) -> builtins.str:
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter(name="apiEndpoint")
    def api_endpoint(self) -> builtins.str:
        return pulumi.get(self, "api_endpoint")

    @property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> Sequence['outputs.GetObjectBucketCorsRuleResult']:
        return pulumi.get(self, "cors_rules")

    @property
    @pulumi.getter
    def endpoint(self) -> builtins.str:
        """
        The endpoint URL of the bucket
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> builtins.bool:
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleRules")
    def lifecycle_rules(self) -> Sequence['outputs.GetObjectBucketLifecycleRuleResult']:
        return pulumi.get(self, "lifecycle_rules")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectLockEnabled")
    def object_lock_enabled(self) -> builtins.bool:
        return pulumi.get(self, "object_lock_enabled")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def versionings(self) -> Sequence['outputs.GetObjectBucketVersioningResult']:
        return pulumi.get(self, "versionings")


class AwaitableGetObjectBucketResult(GetObjectBucketResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetObjectBucketResult(
            acl=self.acl,
            api_endpoint=self.api_endpoint,
            cors_rules=self.cors_rules,
            endpoint=self.endpoint,
            force_destroy=self.force_destroy,
            id=self.id,
            lifecycle_rules=self.lifecycle_rules,
            name=self.name,
            object_lock_enabled=self.object_lock_enabled,
            project_id=self.project_id,
            region=self.region,
            tags=self.tags,
            versionings=self.versionings)


def get_object_bucket(name: Optional[builtins.str] = None,
                      project_id: Optional[builtins.str] = None,
                      region: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetObjectBucketResult:
    """
    The `object.Bucket` data source is used to retrieve information about an Object Storage bucket.

    Refer to the Object Storage [documentation](https://www.scaleway.com/en/docs/object-storage/how-to/create-a-bucket/) for more information.

    ## Retrieve an Object Storage bucket

    The following commands allow you to:

    - retrieve a bucket by its name
    - retrieve a bucket by its ID

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    main = scaleway.object.Bucket("main",
        name="bucket.test.com",
        tags={
            "foo": "bar",
        })
    selected = scaleway.object.get_bucket_output(name=main.id)
    ```

    ## Retrieve a bucket from a specific project

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    selected = scaleway.object.get_bucket(name="bucket.test.com",
        project_id="11111111-1111-1111-1111-111111111111")
    ```


    :param builtins.str project_id: `project_id`) The ID of the project with which the bucket is associated.
    :param builtins.str region: `region`) The region in which the bucket exists.
    """
    pulumi.log.warn("""get_object_bucket is deprecated: scaleway.index/getobjectbucket.getObjectBucket has been deprecated in favor of scaleway.object/getbucket.getBucket""")
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:index/getObjectBucket:getObjectBucket', __args__, opts=opts, typ=GetObjectBucketResult).value

    return AwaitableGetObjectBucketResult(
        acl=pulumi.get(__ret__, 'acl'),
        api_endpoint=pulumi.get(__ret__, 'api_endpoint'),
        cors_rules=pulumi.get(__ret__, 'cors_rules'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        force_destroy=pulumi.get(__ret__, 'force_destroy'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_rules=pulumi.get(__ret__, 'lifecycle_rules'),
        name=pulumi.get(__ret__, 'name'),
        object_lock_enabled=pulumi.get(__ret__, 'object_lock_enabled'),
        project_id=pulumi.get(__ret__, 'project_id'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'),
        versionings=pulumi.get(__ret__, 'versionings'))
def get_object_bucket_output(name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetObjectBucketResult]:
    """
    The `object.Bucket` data source is used to retrieve information about an Object Storage bucket.

    Refer to the Object Storage [documentation](https://www.scaleway.com/en/docs/object-storage/how-to/create-a-bucket/) for more information.

    ## Retrieve an Object Storage bucket

    The following commands allow you to:

    - retrieve a bucket by its name
    - retrieve a bucket by its ID

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    main = scaleway.object.Bucket("main",
        name="bucket.test.com",
        tags={
            "foo": "bar",
        })
    selected = scaleway.object.get_bucket_output(name=main.id)
    ```

    ## Retrieve a bucket from a specific project

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    selected = scaleway.object.get_bucket(name="bucket.test.com",
        project_id="11111111-1111-1111-1111-111111111111")
    ```


    :param builtins.str project_id: `project_id`) The ID of the project with which the bucket is associated.
    :param builtins.str region: `region`) The region in which the bucket exists.
    """
    pulumi.log.warn("""get_object_bucket is deprecated: scaleway.index/getobjectbucket.getObjectBucket has been deprecated in favor of scaleway.object/getbucket.getBucket""")
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:index/getObjectBucket:getObjectBucket', __args__, opts=opts, typ=GetObjectBucketResult)
    return __ret__.apply(lambda __response__: GetObjectBucketResult(
        acl=pulumi.get(__response__, 'acl'),
        api_endpoint=pulumi.get(__response__, 'api_endpoint'),
        cors_rules=pulumi.get(__response__, 'cors_rules'),
        endpoint=pulumi.get(__response__, 'endpoint'),
        force_destroy=pulumi.get(__response__, 'force_destroy'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_rules=pulumi.get(__response__, 'lifecycle_rules'),
        name=pulumi.get(__response__, 'name'),
        object_lock_enabled=pulumi.get(__response__, 'object_lock_enabled'),
        project_id=pulumi.get(__response__, 'project_id'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags'),
        versionings=pulumi.get(__response__, 'versionings')))
