# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ImageAdditionalVolume',
    'PrivateNicPrivateIp',
    'SecurityGroupInboundRule',
    'SecurityGroupOutboundRule',
    'SecurityGroupRulesInboundRule',
    'SecurityGroupRulesOutboundRule',
    'ServerPrivateIp',
    'ServerPrivateNetwork',
    'ServerPublicIp',
    'ServerRootVolume',
    'SnapshotImport',
    'GetPrivateNicPrivateIpResult',
    'GetSecurityGroupInboundRuleResult',
    'GetSecurityGroupOutboundRuleResult',
    'GetServerPrivateIpResult',
    'GetServerPrivateNetworkResult',
    'GetServerPublicIpResult',
    'GetServerRootVolumeResult',
    'GetServersServerResult',
    'GetServersServerPublicIpResult',
    'GetSnapshotImportResult',
]

@pulumi.output_type
class ImageAdditionalVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationDate":
            suggest = "creation_date"
        elif key == "exportUri":
            suggest = "export_uri"
        elif key == "modificationDate":
            suggest = "modification_date"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageAdditionalVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageAdditionalVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageAdditionalVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 creation_date: Optional[builtins.str] = None,
                 export_uri: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 modification_date: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 organization: Optional[builtins.str] = None,
                 project: Optional[builtins.str] = None,
                 server: Optional[Mapping[str, builtins.str]] = None,
                 size: Optional[builtins.int] = None,
                 state: Optional[builtins.str] = None,
                 tags: Optional[Sequence[builtins.str]] = None,
                 volume_type: Optional[builtins.str] = None,
                 zone: Optional[builtins.str] = None):
        """
        :param builtins.str creation_date: Date of the volume creation.
        :param builtins.str export_uri: The export URI of the volume.
        :param builtins.str id: ID of the server containing the volume.
        :param builtins.str modification_date: Date of volume latest update.
        :param builtins.str name: The name of the image. If not provided it will be randomly generated.
        :param builtins.str organization: The organization ID the volume is associated with.
        :param builtins.str project: ID of the project the volume is associated with
        :param Mapping[str, builtins.str] server: Description of the server containing the volume (in case the image is a backup from a server).
        :param builtins.int size: The size of the volume.
        :param builtins.str state: State of the volume.
        :param Sequence[builtins.str] tags: A list of tags to apply to the image.
        :param builtins.str volume_type: The type of volume, possible values are `l_ssd` and `b_ssd`.
        :param builtins.str zone: The zone in which the image should be created.
        """
        if creation_date is not None:
            pulumi.set(__self__, "creation_date", creation_date)
        if export_uri is not None:
            pulumi.set(__self__, "export_uri", export_uri)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if modification_date is not None:
            pulumi.set(__self__, "modification_date", modification_date)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> Optional[builtins.str]:
        """
        Date of the volume creation.
        """
        return pulumi.get(self, "creation_date")

    @property
    @pulumi.getter(name="exportUri")
    def export_uri(self) -> Optional[builtins.str]:
        """
        The export URI of the volume.
        """
        return pulumi.get(self, "export_uri")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        ID of the server containing the volume.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="modificationDate")
    def modification_date(self) -> Optional[builtins.str]:
        """
        Date of volume latest update.
        """
        return pulumi.get(self, "modification_date")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the image. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def organization(self) -> Optional[builtins.str]:
        """
        The organization ID the volume is associated with.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        """
        ID of the project the volume is associated with
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def server(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Description of the server containing the volume (in case the image is a backup from a server).
        """
        return pulumi.get(self, "server")

    @property
    @pulumi.getter
    def size(self) -> Optional[builtins.int]:
        """
        The size of the volume.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        State of the volume.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of tags to apply to the image.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[builtins.str]:
        """
        The type of volume, possible values are `l_ssd` and `b_ssd`.
        """
        return pulumi.get(self, "volume_type")

    @property
    @pulumi.getter
    def zone(self) -> Optional[builtins.str]:
        """
        The zone in which the image should be created.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class PrivateNicPrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None):
        """
        :param builtins.str address: The private IP address.
        :param builtins.str id: The ID of the IP address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        The private IP address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class SecurityGroupInboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"
        elif key == "portRange":
            suggest = "port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGroupInboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGroupInboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGroupInboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: builtins.str,
                 ip: Optional[builtins.str] = None,
                 ip_range: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 port_range: Optional[builtins.str] = None,
                 protocol: Optional[builtins.str] = None):
        """
        :param builtins.str action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param builtins.str ip: The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param builtins.str ip_range: The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param builtins.int port: The port this rule applies to. If no `port` nor `port_range` are specified, the rule will apply to all port. Only one of `port` and `port_range` should be specified.
        :param builtins.str port_range: Computed port range for this rule (e.g: 1-1024, 22-22)
        :param builtins.str protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Ip address is deprecated. Please use ip_range instead""")
    def ip(self) -> Optional[builtins.str]:
        """
        The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[builtins.str]:
        """
        The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port this rule applies to. If no `port` nor `port_range` are specified, the rule will apply to all port. Only one of `port` and `port_range` should be specified.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[builtins.str]:
        """
        Computed port range for this rule (e.g: 1-1024, 22-22)
        """
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[builtins.str]:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class SecurityGroupOutboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"
        elif key == "portRange":
            suggest = "port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGroupOutboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGroupOutboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGroupOutboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: builtins.str,
                 ip: Optional[builtins.str] = None,
                 ip_range: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 port_range: Optional[builtins.str] = None,
                 protocol: Optional[builtins.str] = None):
        """
        :param builtins.str action: Action when rule match request (drop or accept)
        :param builtins.str ip: Ip address for this rule (e.g: 1.1.1.1). Only one of ip or ip_range should be provided
        :param builtins.str ip_range: Ip range for this rule (e.g: 192.168.1.0/24). Only one of ip or ip_range should be provided
        :param builtins.int port: Network port for this rule
        :param builtins.str port_range: Computed port range for this rule (e.g: 1-1024, 22-22)
        :param builtins.str protocol: Protocol for this rule (TCP, UDP, ICMP or ANY)
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        Action when rule match request (drop or accept)
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Ip address is deprecated. Please use ip_range instead""")
    def ip(self) -> Optional[builtins.str]:
        """
        Ip address for this rule (e.g: 1.1.1.1). Only one of ip or ip_range should be provided
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[builtins.str]:
        """
        Ip range for this rule (e.g: 192.168.1.0/24). Only one of ip or ip_range should be provided
        """
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        Network port for this rule
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[builtins.str]:
        """
        Computed port range for this rule (e.g: 1-1024, 22-22)
        """
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[builtins.str]:
        """
        Protocol for this rule (TCP, UDP, ICMP or ANY)
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class SecurityGroupRulesInboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"
        elif key == "portRange":
            suggest = "port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGroupRulesInboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGroupRulesInboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGroupRulesInboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: builtins.str,
                 ip: Optional[builtins.str] = None,
                 ip_range: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 port_range: Optional[builtins.str] = None,
                 protocol: Optional[builtins.str] = None):
        """
        :param builtins.str action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param builtins.str ip: The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param builtins.str ip_range: The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param builtins.int port: The port this rule apply to. If no port is specified, rule will apply to all port.
        :param builtins.str port_range: Computed port range for this rule (e.g: 1-1024, 22-22)
        :param builtins.str protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Ip address is deprecated. Please use ip_range instead""")
    def ip(self) -> Optional[builtins.str]:
        """
        The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[builtins.str]:
        """
        The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port this rule apply to. If no port is specified, rule will apply to all port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[builtins.str]:
        """
        Computed port range for this rule (e.g: 1-1024, 22-22)
        """
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[builtins.str]:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class SecurityGroupRulesOutboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"
        elif key == "portRange":
            suggest = "port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGroupRulesOutboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGroupRulesOutboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGroupRulesOutboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: builtins.str,
                 ip: Optional[builtins.str] = None,
                 ip_range: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 port_range: Optional[builtins.str] = None,
                 protocol: Optional[builtins.str] = None):
        """
        :param builtins.str action: Action when rule match request (drop or accept)
        :param builtins.str ip: Ip address for this rule (e.g: 1.1.1.1). Only one of ip or ip_range should be provided
        :param builtins.str ip_range: Ip range for this rule (e.g: 192.168.1.0/24). Only one of ip or ip_range should be provided
        :param builtins.int port: Network port for this rule
        :param builtins.str port_range: Computed port range for this rule (e.g: 1-1024, 22-22)
        :param builtins.str protocol: Protocol for this rule (TCP, UDP, ICMP or ANY)
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        Action when rule match request (drop or accept)
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Ip address is deprecated. Please use ip_range instead""")
    def ip(self) -> Optional[builtins.str]:
        """
        Ip address for this rule (e.g: 1.1.1.1). Only one of ip or ip_range should be provided
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[builtins.str]:
        """
        Ip range for this rule (e.g: 192.168.1.0/24). Only one of ip or ip_range should be provided
        """
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        Network port for this rule
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[builtins.str]:
        """
        Computed port range for this rule (e.g: 1-1024, 22-22)
        """
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[builtins.str]:
        """
        Protocol for this rule (TCP, UDP, ICMP or ANY)
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class ServerPrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None):
        """
        :param builtins.str address: The private IP address.
        :param builtins.str id: The ID of the IP address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        The private IP address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ServerPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pnId":
            suggest = "pn_id"
        elif key == "macAddress":
            suggest = "mac_address"
        elif key == "pnicId":
            suggest = "pnic_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pn_id: builtins.str,
                 mac_address: Optional[builtins.str] = None,
                 pnic_id: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None,
                 zone: Optional[builtins.str] = None):
        """
        :param builtins.str pn_id: The Private Network ID
        :param builtins.str mac_address: MAC address of the NIC
        :param builtins.str pnic_id: The ID of the NIC
        :param builtins.str status: The private NIC state
        :param builtins.str zone: `zone`) The zone in which the server should be created.
        """
        pulumi.set(__self__, "pn_id", pn_id)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if pnic_id is not None:
            pulumi.set(__self__, "pnic_id", pnic_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> builtins.str:
        """
        The Private Network ID
        """
        return pulumi.get(self, "pn_id")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[builtins.str]:
        """
        MAC address of the NIC
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter(name="pnicId")
    def pnic_id(self) -> Optional[builtins.str]:
        """
        The ID of the NIC
        """
        return pulumi.get(self, "pnic_id")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        The private NIC state
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def zone(self) -> Optional[builtins.str]:
        """
        `zone`) The zone in which the server should be created.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class ServerPublicIp(dict):
    def __init__(__self__, *,
                 address: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None):
        """
        :param builtins.str address: The address of the IP
        :param builtins.str id: The ID of the IP
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        The address of the IP
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the IP
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ServerRootVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "sbsIops":
            suggest = "sbs_iops"
        elif key == "sizeInGb":
            suggest = "size_in_gb"
        elif key == "volumeId":
            suggest = "volume_id"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerRootVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerRootVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerRootVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot: Optional[builtins.bool] = None,
                 delete_on_termination: Optional[builtins.bool] = None,
                 name: Optional[builtins.str] = None,
                 sbs_iops: Optional[builtins.int] = None,
                 size_in_gb: Optional[builtins.int] = None,
                 volume_id: Optional[builtins.str] = None,
                 volume_type: Optional[builtins.str] = None):
        """
        :param builtins.bool boot: Set the volume where the boot the server
        :param builtins.bool delete_on_termination: Forces deletion of the root volume on instance termination.
        :param builtins.str name: The name of the server.
        :param builtins.int sbs_iops: Choose IOPS of your sbs volume, has to be used with `sbs_volume` for root volume type.
               
               > **Important:** Updates to `root_volume.size_in_gb` will be ignored after the creation of the server.
        :param builtins.int size_in_gb: Size of the root volume in gigabytes.
               To find the right size use [this endpoint](https://www.scaleway.com/en/developers/api/instance/#path-instances-list-all-instances) and
               check the `volumes_constraint.{min|max}_size` (in bytes) for your `commercial_type`.
               Depending on `volume_type`, updates to this field may recreate a new resource.
        :param builtins.str volume_id: The volume ID of the root volume of the server, allows you to create server with an existing volume. If empty, will be computed to a created volume ID.
        :param builtins.str volume_type: Volume type of root volume, can be `l_ssd` or `sbs_volume`, default value depends on server type
        """
        if boot is not None:
            pulumi.set(__self__, "boot", boot)
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sbs_iops is not None:
            pulumi.set(__self__, "sbs_iops", sbs_iops)
        if size_in_gb is not None:
            pulumi.set(__self__, "size_in_gb", size_in_gb)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def boot(self) -> Optional[builtins.bool]:
        """
        Set the volume where the boot the server
        """
        return pulumi.get(self, "boot")

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[builtins.bool]:
        """
        Forces deletion of the root volume on instance termination.
        """
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sbsIops")
    def sbs_iops(self) -> Optional[builtins.int]:
        """
        Choose IOPS of your sbs volume, has to be used with `sbs_volume` for root volume type.

        > **Important:** Updates to `root_volume.size_in_gb` will be ignored after the creation of the server.
        """
        return pulumi.get(self, "sbs_iops")

    @property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> Optional[builtins.int]:
        """
        Size of the root volume in gigabytes.
        To find the right size use [this endpoint](https://www.scaleway.com/en/developers/api/instance/#path-instances-list-all-instances) and
        check the `volumes_constraint.{min|max}_size` (in bytes) for your `commercial_type`.
        Depending on `volume_type`, updates to this field may recreate a new resource.
        """
        return pulumi.get(self, "size_in_gb")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[builtins.str]:
        """
        The volume ID of the root volume of the server, allows you to create server with an existing volume. If empty, will be computed to a created volume ID.
        """
        return pulumi.get(self, "volume_id")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[builtins.str]:
        """
        Volume type of root volume, can be `l_ssd` or `sbs_volume`, default value depends on server type
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class SnapshotImport(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 key: builtins.str):
        """
        :param builtins.str bucket: Bucket name containing [qcow2](https://en.wikipedia.org/wiki/Qcow) to import
        :param builtins.str key: Key of the object to import
               
               > **Note:** The type `unified` could be instantiated on both `l_ssd` and `b_ssd` volumes.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Bucket name containing [qcow2](https://en.wikipedia.org/wiki/Qcow) to import
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Key of the object to import

        > **Note:** The type `unified` could be instantiated on both `l_ssd` and `b_ssd` volumes.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class GetPrivateNicPrivateIpResult(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 id: builtins.str):
        """
        :param builtins.str address: The private IP address
        :param builtins.str id: The ID of the IP address resource
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The private IP address
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the IP address resource
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetSecurityGroupInboundRuleResult(dict):
    def __init__(__self__, *,
                 action: builtins.str,
                 ip: builtins.str,
                 ip_range: builtins.str,
                 port: builtins.int,
                 port_range: builtins.str,
                 protocol: builtins.str):
        """
        :param builtins.str action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param builtins.str ip: The ip this rule apply to.
        :param builtins.str ip_range: The ip range (e.g `192.168.1.0/24`) this rule apply to.
        :param builtins.int port: The port this rule apply to. If no port is specified, rule will apply to all port.
        :param builtins.str port_range: The port range (e.g `22-23`) this rule applies to.
               If no `port` nor `port_range` are specified, rule will apply to all port.
               Only one of `port` and `port_range` should be specified.
        :param builtins.str protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "ip_range", ip_range)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "port_range", port_range)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def ip(self) -> builtins.str:
        """
        The ip this rule apply to.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> builtins.str:
        """
        The ip range (e.g `192.168.1.0/24`) this rule apply to.
        """
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port this rule apply to. If no port is specified, rule will apply to all port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> builtins.str:
        """
        The port range (e.g `22-23`) this rule applies to.
        If no `port` nor `port_range` are specified, rule will apply to all port.
        Only one of `port` and `port_range` should be specified.
        """
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def protocol(self) -> builtins.str:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetSecurityGroupOutboundRuleResult(dict):
    def __init__(__self__, *,
                 action: builtins.str,
                 ip: builtins.str,
                 ip_range: builtins.str,
                 port: builtins.int,
                 port_range: builtins.str,
                 protocol: builtins.str):
        """
        :param builtins.str action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param builtins.str ip: The ip this rule apply to.
        :param builtins.str ip_range: The ip range (e.g `192.168.1.0/24`) this rule apply to.
        :param builtins.int port: The port this rule apply to. If no port is specified, rule will apply to all port.
        :param builtins.str port_range: The port range (e.g `22-23`) this rule applies to.
               If no `port` nor `port_range` are specified, rule will apply to all port.
               Only one of `port` and `port_range` should be specified.
        :param builtins.str protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "ip_range", ip_range)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "port_range", port_range)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def ip(self) -> builtins.str:
        """
        The ip this rule apply to.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> builtins.str:
        """
        The ip range (e.g `192.168.1.0/24`) this rule apply to.
        """
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port this rule apply to. If no port is specified, rule will apply to all port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> builtins.str:
        """
        The port range (e.g `22-23`) this rule applies to.
        If no `port` nor `port_range` are specified, rule will apply to all port.
        Only one of `port` and `port_range` should be specified.
        """
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def protocol(self) -> builtins.str:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetServerPrivateIpResult(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 id: builtins.str):
        """
        :param builtins.str address: The address of the IP
        :param builtins.str id: The ID of the IP
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The address of the IP
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the IP
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetServerPrivateNetworkResult(dict):
    def __init__(__self__, *,
                 mac_address: builtins.str,
                 pn_id: builtins.str,
                 pnic_id: builtins.str,
                 status: builtins.str,
                 zone: builtins.str):
        """
        :param builtins.str mac_address: MAC address of the NIC
        :param builtins.str pn_id: The Private Network ID
        :param builtins.str pnic_id: The ID of the NIC
        :param builtins.str status: The private NIC state
        :param builtins.str zone: `zone`) The zone in which the server exists.
        """
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "pn_id", pn_id)
        pulumi.set(__self__, "pnic_id", pnic_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> builtins.str:
        """
        MAC address of the NIC
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> builtins.str:
        """
        The Private Network ID
        """
        return pulumi.get(self, "pn_id")

    @property
    @pulumi.getter(name="pnicId")
    def pnic_id(self) -> builtins.str:
        """
        The ID of the NIC
        """
        return pulumi.get(self, "pnic_id")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The private NIC state
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def zone(self) -> builtins.str:
        """
        `zone`) The zone in which the server exists.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetServerPublicIpResult(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 id: builtins.str):
        """
        :param builtins.str address: The address of the IP
        :param builtins.str id: The ID of the IP
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The address of the IP
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the IP
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetServerRootVolumeResult(dict):
    def __init__(__self__, *,
                 boot: builtins.bool,
                 delete_on_termination: builtins.bool,
                 name: builtins.str,
                 sbs_iops: builtins.int,
                 size_in_gb: builtins.int,
                 volume_id: builtins.str,
                 volume_type: builtins.str):
        """
        :param builtins.bool boot: Set the volume where the boot the server
        :param builtins.bool delete_on_termination: Forces deletion of the root volume on instance termination.
        :param builtins.str name: The server name. Only one of `name` and `server_id` should be specified.
        :param builtins.int sbs_iops: SBS Volume IOPS, only with volume_type as sbs_volume
        :param builtins.int size_in_gb: Size of the root volume in gigabytes.
        :param builtins.str volume_id: The volume ID of the root volume of the server.
        :param builtins.str volume_type: Volume type of the root volume
        """
        pulumi.set(__self__, "boot", boot)
        pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sbs_iops", sbs_iops)
        pulumi.set(__self__, "size_in_gb", size_in_gb)
        pulumi.set(__self__, "volume_id", volume_id)
        pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def boot(self) -> builtins.bool:
        """
        Set the volume where the boot the server
        """
        return pulumi.get(self, "boot")

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> builtins.bool:
        """
        Forces deletion of the root volume on instance termination.
        """
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The server name. Only one of `name` and `server_id` should be specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sbsIops")
    def sbs_iops(self) -> builtins.int:
        """
        SBS Volume IOPS, only with volume_type as sbs_volume
        """
        return pulumi.get(self, "sbs_iops")

    @property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> builtins.int:
        """
        Size of the root volume in gigabytes.
        """
        return pulumi.get(self, "size_in_gb")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> builtins.str:
        """
        The volume ID of the root volume of the server.
        """
        return pulumi.get(self, "volume_id")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> builtins.str:
        """
        Volume type of the root volume
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class GetServersServerResult(dict):
    def __init__(__self__, *,
                 boot_type: builtins.str,
                 bootscript_id: builtins.str,
                 enable_dynamic_ip: builtins.bool,
                 enable_ipv6: builtins.bool,
                 id: builtins.str,
                 image: builtins.str,
                 ipv6_address: builtins.str,
                 ipv6_gateway: builtins.str,
                 ipv6_prefix_length: builtins.int,
                 name: builtins.str,
                 organization_id: builtins.str,
                 placement_group_id: builtins.str,
                 placement_group_policy_respected: builtins.bool,
                 private_ip: builtins.str,
                 project_id: builtins.str,
                 public_ip: builtins.str,
                 public_ips: Sequence['outputs.GetServersServerPublicIpResult'],
                 security_group_id: builtins.str,
                 state: builtins.str,
                 tags: Sequence[builtins.str],
                 type: builtins.str,
                 zone: builtins.str):
        """
        :param builtins.str boot_type: The boot Type of the server. Possible values are: `local`, `bootscript` or `rescue`.
        :param builtins.bool enable_dynamic_ip: If true a dynamic IP will be attached to the server.
        :param builtins.bool enable_ipv6: Determines if IPv6 is enabled for the server.
        :param builtins.str id: The ID of the IP
        :param builtins.str image: The UUID or the label of the base image used by the server.
        :param builtins.str ipv6_address: The default ipv6 address routed to the server. ( Only set when enable_ipv6 is set to true )
        :param builtins.str ipv6_gateway: The ipv6 gateway address. ( Only set when enable_ipv6 is set to true )
        :param builtins.int ipv6_prefix_length: The prefix length of the ipv6 subnet routed to the server. ( Only set when enable_ipv6 is set to true )
        :param builtins.str name: The server name used as filter. Servers with a name like it are listed.
        :param builtins.str organization_id: The organization ID the server is associated with.
        :param builtins.str placement_group_id: The [placement group](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) the server is attached to.
        :param builtins.str private_ip: The Scaleway internal IP address of the server.
        :param builtins.str project_id: The ID of the project the server is associated with.
        :param builtins.str public_ip: The public IP address of the server.
        :param Sequence['GetServersServerPublicIpArgs'] public_ips: The list of public IPs of the server
        :param builtins.str security_group_id: The [security group](https://developers.scaleway.com/en/products/instance/api/#security-groups-8d7f89) the server is attached to.
        :param builtins.str state: The state of the server. Possible values are: `started`, `stopped` or `standby`.
        :param Sequence[builtins.str] tags: List of tags used as filter. Servers with these exact tags are listed.
        :param builtins.str type: The commercial type of the server.
        :param builtins.str zone: `zone`) The zone in which servers exist.
        """
        pulumi.set(__self__, "boot_type", boot_type)
        pulumi.set(__self__, "bootscript_id", bootscript_id)
        pulumi.set(__self__, "enable_dynamic_ip", enable_dynamic_ip)
        pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        pulumi.set(__self__, "ipv6_gateway", ipv6_gateway)
        pulumi.set(__self__, "ipv6_prefix_length", ipv6_prefix_length)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "placement_group_id", placement_group_id)
        pulumi.set(__self__, "placement_group_policy_respected", placement_group_policy_respected)
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "public_ip", public_ip)
        pulumi.set(__self__, "public_ips", public_ips)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="bootType")
    def boot_type(self) -> builtins.str:
        """
        The boot Type of the server. Possible values are: `local`, `bootscript` or `rescue`.
        """
        return pulumi.get(self, "boot_type")

    @property
    @pulumi.getter(name="bootscriptId")
    @_utilities.deprecated("""bootscript are not supported""")
    def bootscript_id(self) -> builtins.str:
        return pulumi.get(self, "bootscript_id")

    @property
    @pulumi.getter(name="enableDynamicIp")
    def enable_dynamic_ip(self) -> builtins.bool:
        """
        If true a dynamic IP will be attached to the server.
        """
        return pulumi.get(self, "enable_dynamic_ip")

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> builtins.bool:
        """
        Determines if IPv6 is enabled for the server.
        """
        return pulumi.get(self, "enable_ipv6")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the IP
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def image(self) -> builtins.str:
        """
        The UUID or the label of the base image used by the server.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> builtins.str:
        """
        The default ipv6 address routed to the server. ( Only set when enable_ipv6 is set to true )
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter(name="ipv6Gateway")
    def ipv6_gateway(self) -> builtins.str:
        """
        The ipv6 gateway address. ( Only set when enable_ipv6 is set to true )
        """
        return pulumi.get(self, "ipv6_gateway")

    @property
    @pulumi.getter(name="ipv6PrefixLength")
    def ipv6_prefix_length(self) -> builtins.int:
        """
        The prefix length of the ipv6 subnet routed to the server. ( Only set when enable_ipv6 is set to true )
        """
        return pulumi.get(self, "ipv6_prefix_length")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The server name used as filter. Servers with a name like it are listed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> builtins.str:
        """
        The organization ID the server is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> builtins.str:
        """
        The [placement group](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) the server is attached to.
        """
        return pulumi.get(self, "placement_group_id")

    @property
    @pulumi.getter(name="placementGroupPolicyRespected")
    def placement_group_policy_respected(self) -> builtins.bool:
        return pulumi.get(self, "placement_group_policy_respected")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> builtins.str:
        """
        The Scaleway internal IP address of the server.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        The ID of the project the server is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="publicIp")
    @_utilities.deprecated("""Use public_ips instead""")
    def public_ip(self) -> builtins.str:
        """
        The public IP address of the server.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> Sequence['outputs.GetServersServerPublicIpResult']:
        """
        The list of public IPs of the server
        """
        return pulumi.get(self, "public_ips")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> builtins.str:
        """
        The [security group](https://developers.scaleway.com/en/products/instance/api/#security-groups-8d7f89) the server is attached to.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The state of the server. Possible values are: `started`, `stopped` or `standby`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[builtins.str]:
        """
        List of tags used as filter. Servers with these exact tags are listed.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The commercial type of the server.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def zone(self) -> builtins.str:
        """
        `zone`) The zone in which servers exist.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetServersServerPublicIpResult(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 id: builtins.str):
        """
        :param builtins.str address: The address of the IP
        :param builtins.str id: The ID of the IP
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The address of the IP
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the IP
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetSnapshotImportResult(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 key: builtins.str):
        """
        :param builtins.str bucket: Bucket containing qcow
        :param builtins.str key: Key of the qcow file in the specified bucket
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Bucket containing qcow
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Key of the qcow file in the specified bucket
        """
        return pulumi.get(self, "key")


