# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DeviceCertificate',
    'DeviceMessageFilters',
    'DeviceMessageFiltersPublish',
    'DeviceMessageFiltersSubscribe',
    'RouteDatabase',
    'RouteRest',
    'RouteS3',
    'GetDeviceCertificateResult',
    'GetDeviceMessageFilterResult',
    'GetDeviceMessageFilterPublishResult',
    'GetDeviceMessageFilterSubscribeResult',
]

@pulumi.output_type
class DeviceCertificate(dict):
    def __init__(__self__, *,
                 crt: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None):
        """
        :param builtins.str crt: X509 PEM encoded certificate of the device
        :param builtins.str key: The private key of the device, in case it is generated by Scaleway.
        """
        if crt is not None:
            pulumi.set(__self__, "crt", crt)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def crt(self) -> Optional[builtins.str]:
        """
        X509 PEM encoded certificate of the device
        """
        return pulumi.get(self, "crt")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        The private key of the device, in case it is generated by Scaleway.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class DeviceMessageFilters(dict):
    def __init__(__self__, *,
                 publish: Optional['outputs.DeviceMessageFiltersPublish'] = None,
                 subscribe: Optional['outputs.DeviceMessageFiltersSubscribe'] = None):
        """
        :param 'DeviceMessageFiltersPublishArgs' publish: Rules used to restrict topics the device can publish to.
        :param 'DeviceMessageFiltersSubscribeArgs' subscribe: Rules used to restrict topics the device can subscribe to.
        """
        if publish is not None:
            pulumi.set(__self__, "publish", publish)
        if subscribe is not None:
            pulumi.set(__self__, "subscribe", subscribe)

    @property
    @pulumi.getter
    def publish(self) -> Optional['outputs.DeviceMessageFiltersPublish']:
        """
        Rules used to restrict topics the device can publish to.
        """
        return pulumi.get(self, "publish")

    @property
    @pulumi.getter
    def subscribe(self) -> Optional['outputs.DeviceMessageFiltersSubscribe']:
        """
        Rules used to restrict topics the device can subscribe to.
        """
        return pulumi.get(self, "subscribe")


@pulumi.output_type
class DeviceMessageFiltersPublish(dict):
    def __init__(__self__, *,
                 policy: Optional[builtins.str] = None,
                 topics: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str policy: Filtering policy (eg `accept` or `reject`)
        :param Sequence[builtins.str] topics: List of topics to match (eg `foo/bar/+/baz/#`)
        """
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)

    @property
    @pulumi.getter
    def policy(self) -> Optional[builtins.str]:
        """
        Filtering policy (eg `accept` or `reject`)
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def topics(self) -> Optional[Sequence[builtins.str]]:
        """
        List of topics to match (eg `foo/bar/+/baz/#`)
        """
        return pulumi.get(self, "topics")


@pulumi.output_type
class DeviceMessageFiltersSubscribe(dict):
    def __init__(__self__, *,
                 policy: Optional[builtins.str] = None,
                 topics: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str policy: Same as publish rules.
        :param Sequence[builtins.str] topics: Same as publish rules.
               
               - `certificate.crt` - (Optional) The certificate of the device, either generated by Scaleway or provided.
               
               > **Important:** Updates to `certificate.crt` will disconnect connected devices and the previous certificate will be deleted and won't be recoverable.
        """
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)

    @property
    @pulumi.getter
    def policy(self) -> Optional[builtins.str]:
        """
        Same as publish rules.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def topics(self) -> Optional[Sequence[builtins.str]]:
        """
        Same as publish rules.

        - `certificate.crt` - (Optional) The certificate of the device, either generated by Scaleway or provided.

        > **Important:** Updates to `certificate.crt` will disconnect connected devices and the previous certificate will be deleted and won't be recoverable.
        """
        return pulumi.get(self, "topics")


@pulumi.output_type
class RouteDatabase(dict):
    def __init__(__self__, *,
                 dbname: builtins.str,
                 host: builtins.str,
                 password: builtins.str,
                 port: builtins.int,
                 query: builtins.str,
                 username: builtins.str):
        """
        :param builtins.str dbname: The database name (e.g. `measurements`).
        :param builtins.str host: The database hostname. Can be an IP or a FQDN.
        :param builtins.str password: The database password.
        :param builtins.int port: The database port (e.g. `5432`)
        :param builtins.str query: The SQL query that will be executed when receiving a message ($TOPIC and $PAYLOAD variables are available, see documentation, e.g. `INSERT INTO mytable(date, topic, value) VALUES (NOW(), $TOPIC, $PAYLOAD)`).
        :param builtins.str username: The database username.
        """
        pulumi.set(__self__, "dbname", dbname)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def dbname(self) -> builtins.str:
        """
        The database name (e.g. `measurements`).
        """
        return pulumi.get(self, "dbname")

    @property
    @pulumi.getter
    def host(self) -> builtins.str:
        """
        The database hostname. Can be an IP or a FQDN.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        """
        The database password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The database port (e.g. `5432`)
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def query(self) -> builtins.str:
        """
        The SQL query that will be executed when receiving a message ($TOPIC and $PAYLOAD variables are available, see documentation, e.g. `INSERT INTO mytable(date, topic, value) VALUES (NOW(), $TOPIC, $PAYLOAD)`).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        The database username.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class RouteRest(dict):
    def __init__(__self__, *,
                 headers: Mapping[str, builtins.str],
                 uri: builtins.str,
                 verb: builtins.str):
        """
        :param Mapping[str, builtins.str] headers: a map of the extra headers to send with the HTTP call (e.g. `X-Header = Value`).
        :param builtins.str uri: The URI of the Rest endpoint (e.g. `https://internal.mycompany.com/ingest/mqttdata`).
        :param builtins.str verb: The HTTP Verb used to call Rest URI (e.g. `post`).
        """
        pulumi.set(__self__, "headers", headers)
        pulumi.set(__self__, "uri", uri)
        pulumi.set(__self__, "verb", verb)

    @property
    @pulumi.getter
    def headers(self) -> Mapping[str, builtins.str]:
        """
        a map of the extra headers to send with the HTTP call (e.g. `X-Header = Value`).
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        The URI of the Rest endpoint (e.g. `https://internal.mycompany.com/ingest/mqttdata`).
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def verb(self) -> builtins.str:
        """
        The HTTP Verb used to call Rest URI (e.g. `post`).
        """
        return pulumi.get(self, "verb")


@pulumi.output_type
class RouteS3(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "bucketRegion":
            suggest = "bucket_region"
        elif key == "objectPrefix":
            suggest = "object_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouteS3. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouteS3.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouteS3.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: builtins.str,
                 bucket_region: builtins.str,
                 strategy: builtins.str,
                 object_prefix: Optional[builtins.str] = None):
        """
        :param builtins.str bucket_name: The name of the S3 route's destination bucket (e.g. `my-object-storage`).
        :param builtins.str bucket_region: The region of the S3 route's destination bucket (e.g. `fr-par`).
        :param builtins.str strategy: How the S3 route's objects will be created (e.g. `per_topic`). See [documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for behaviour details.
        :param builtins.str object_prefix: The string to prefix object names with (e.g. `mykeyprefix-`).
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "bucket_region", bucket_region)
        pulumi.set(__self__, "strategy", strategy)
        if object_prefix is not None:
            pulumi.set(__self__, "object_prefix", object_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        """
        The name of the S3 route's destination bucket (e.g. `my-object-storage`).
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="bucketRegion")
    def bucket_region(self) -> builtins.str:
        """
        The region of the S3 route's destination bucket (e.g. `fr-par`).
        """
        return pulumi.get(self, "bucket_region")

    @property
    @pulumi.getter
    def strategy(self) -> builtins.str:
        """
        How the S3 route's objects will be created (e.g. `per_topic`). See [documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for behaviour details.
        """
        return pulumi.get(self, "strategy")

    @property
    @pulumi.getter(name="objectPrefix")
    def object_prefix(self) -> Optional[builtins.str]:
        """
        The string to prefix object names with (e.g. `mykeyprefix-`).
        """
        return pulumi.get(self, "object_prefix")


@pulumi.output_type
class GetDeviceCertificateResult(dict):
    def __init__(__self__, *,
                 crt: builtins.str,
                 key: builtins.str):
        """
        :param builtins.str crt: X509 PEM encoded certificate of the device
        :param builtins.str key: X509 PEM encoded key of the device
        """
        pulumi.set(__self__, "crt", crt)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def crt(self) -> builtins.str:
        """
        X509 PEM encoded certificate of the device
        """
        return pulumi.get(self, "crt")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        X509 PEM encoded key of the device
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class GetDeviceMessageFilterResult(dict):
    def __init__(__self__, *,
                 publishes: Sequence['outputs.GetDeviceMessageFilterPublishResult'],
                 subscribes: Sequence['outputs.GetDeviceMessageFilterSubscribeResult']):
        """
        :param Sequence['GetDeviceMessageFilterPublishArgs'] publishes: Rule to restrict topics the device can publish to
        :param Sequence['GetDeviceMessageFilterSubscribeArgs'] subscribes: Rule to restrict topics the device can subscribe to
        """
        pulumi.set(__self__, "publishes", publishes)
        pulumi.set(__self__, "subscribes", subscribes)

    @property
    @pulumi.getter
    def publishes(self) -> Sequence['outputs.GetDeviceMessageFilterPublishResult']:
        """
        Rule to restrict topics the device can publish to
        """
        return pulumi.get(self, "publishes")

    @property
    @pulumi.getter
    def subscribes(self) -> Sequence['outputs.GetDeviceMessageFilterSubscribeResult']:
        """
        Rule to restrict topics the device can subscribe to
        """
        return pulumi.get(self, "subscribes")


@pulumi.output_type
class GetDeviceMessageFilterPublishResult(dict):
    def __init__(__self__, *,
                 policy: builtins.str,
                 topics: Sequence[builtins.str]):
        """
        :param builtins.str policy: Publish message filter policy
        :param Sequence[builtins.str] topics: List of topics in the set
        """
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "topics", topics)

    @property
    @pulumi.getter
    def policy(self) -> builtins.str:
        """
        Publish message filter policy
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def topics(self) -> Sequence[builtins.str]:
        """
        List of topics in the set
        """
        return pulumi.get(self, "topics")


@pulumi.output_type
class GetDeviceMessageFilterSubscribeResult(dict):
    def __init__(__self__, *,
                 policy: builtins.str,
                 topics: Sequence[builtins.str]):
        """
        :param builtins.str policy: Subscribe message filter policy
        :param Sequence[builtins.str] topics: List of topics in the set
        """
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "topics", topics)

    @property
    @pulumi.getter
    def policy(self) -> builtins.str:
        """
        Subscribe message filter policy
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def topics(self) -> Sequence[builtins.str]:
        """
        List of topics in the set
        """
        return pulumi.get(self, "topics")


