# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['MnqSnsArgs', 'MnqSns']

@pulumi.input_type
class MnqSnsArgs:
    def __init__(__self__, *,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a MnqSns resource.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project in which SNS will be enabled.
        :param pulumi.Input[builtins.str] region: `region`). The region
               in which SNS will be enabled.
        """
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project in which SNS will be enabled.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`). The region
        in which SNS will be enabled.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _MnqSnsState:
    def __init__(__self__, *,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering MnqSns resources.
        :param pulumi.Input[builtins.str] endpoint: The endpoint of the SNS service for this Project.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project in which SNS will be enabled.
        :param pulumi.Input[builtins.str] region: `region`). The region
               in which SNS will be enabled.
        """
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint of the SNS service for this Project.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project in which SNS will be enabled.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`). The region
        in which SNS will be enabled.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


warnings.warn("""scaleway.index/mnqsns.MnqSns has been deprecated in favor of scaleway.mnq/sns.Sns""", DeprecationWarning)


@pulumi.type_token("scaleway:index/mnqSns:MnqSns")
class MnqSns(pulumi.CustomResource):
    warnings.warn("""scaleway.index/mnqsns.MnqSns has been deprecated in favor of scaleway.mnq/sns.Sns""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Activates Scaleway Messaging and Queuing SNS in a Project.
        For further information, see
        our [main documentation](https://www.scaleway.com/en/docs/messaging/reference-content/sns-overview/).

        ## Example Usage

        ### Basic

        Activate SNS in the default Project

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.mnq.Sns("main")
        ```

        Activate SNS in a specific Project

        ```python
        import pulumi
        import pulumi_scaleway as scaleway
        import pulumiverse_scaleway as scaleway

        project = scaleway.account.get_project(name="default")
        # For specific Project in default region
        for_project = scaleway.mnq.Sns("for_project", project_id=project.id)
        ```

        ## Import

        SNS status can be imported using `{region}/{project_id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/mnqSns:MnqSns main fr-par/11111111111111111111111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project in which SNS will be enabled.
        :param pulumi.Input[builtins.str] region: `region`). The region
               in which SNS will be enabled.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[MnqSnsArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Activates Scaleway Messaging and Queuing SNS in a Project.
        For further information, see
        our [main documentation](https://www.scaleway.com/en/docs/messaging/reference-content/sns-overview/).

        ## Example Usage

        ### Basic

        Activate SNS in the default Project

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.mnq.Sns("main")
        ```

        Activate SNS in a specific Project

        ```python
        import pulumi
        import pulumi_scaleway as scaleway
        import pulumiverse_scaleway as scaleway

        project = scaleway.account.get_project(name="default")
        # For specific Project in default region
        for_project = scaleway.mnq.Sns("for_project", project_id=project.id)
        ```

        ## Import

        SNS status can be imported using `{region}/{project_id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/mnqSns:MnqSns main fr-par/11111111111111111111111111111111
        ```

        :param str resource_name: The name of the resource.
        :param MnqSnsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MnqSnsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""MnqSns is deprecated: scaleway.index/mnqsns.MnqSns has been deprecated in favor of scaleway.mnq/sns.Sns""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MnqSnsArgs.__new__(MnqSnsArgs)

            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["endpoint"] = None
        super(MnqSns, __self__).__init__(
            'scaleway:index/mnqSns:MnqSns',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            endpoint: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None) -> 'MnqSns':
        """
        Get an existing MnqSns resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] endpoint: The endpoint of the SNS service for this Project.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project in which SNS will be enabled.
        :param pulumi.Input[builtins.str] region: `region`). The region
               in which SNS will be enabled.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MnqSnsState.__new__(_MnqSnsState)

        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        return MnqSns(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The endpoint of the SNS service for this Project.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        `project_id`) The ID of the project in which SNS will be enabled.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        `region`). The region
        in which SNS will be enabled.
        """
        return pulumi.get(self, "region")

