# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 node_number: pulumi.Input[builtins.int],
                 node_type: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePrivateIpArgs']]]] = None,
                 private_network: Optional[pulumi.Input['InstancePrivateNetworkArgs']] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 public_network: Optional[pulumi.Input['InstancePublicNetworkArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 volume_size_in_gb: Optional[pulumi.Input[builtins.int]] = None,
                 volume_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[builtins.int] node_number: Number of nodes in the instance
        :param pulumi.Input[builtins.str] node_type: The type of MongoDB® intance to create.
        :param pulumi.Input[builtins.str] name: Name of the MongoDB® instance.
        :param pulumi.Input[builtins.str] password: Password of the user.
        :param pulumi.Input[Sequence[pulumi.Input['InstancePrivateIpArgs']]] private_ips: The private IPv4 address associated with the instance.
        :param pulumi.Input['InstancePrivateNetworkArgs'] private_network: Private Network endpoints of the Database Instance.
        :param pulumi.Input[builtins.str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input['InstancePublicNetworkArgs'] public_network: Public network endpoint configuration (no arguments).
               > **Important** If neither private_network nor public_network is specified, a public network endpoint is created by default.
        :param pulumi.Input[builtins.str] region: The region you want to attach the resource to
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] settings: Map of settings to define for the instance.
        :param pulumi.Input[builtins.str] snapshot_id: Snapshot ID to restore the MongoDB® instance from.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: List of tags attached to the MongoDB® instance.
        :param pulumi.Input[builtins.str] user_name: Name of the user created when the intance is created.
        :param pulumi.Input[builtins.str] version: MongoDB® version of the instance.
        :param pulumi.Input[builtins.int] volume_size_in_gb: Volume size in GB.
        :param pulumi.Input[builtins.str] volume_type: Volume type of the instance.
        """
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "node_type", node_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if public_network is not None:
            pulumi.set(__self__, "public_network", public_network)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if volume_size_in_gb is not None:
            pulumi.set(__self__, "volume_size_in_gb", volume_size_in_gb)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> pulumi.Input[builtins.int]:
        """
        Number of nodes in the instance
        """
        return pulumi.get(self, "node_number")

    @node_number.setter
    def node_number(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "node_number", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of MongoDB® intance to create.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the MongoDB® instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Password of the user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePrivateIpArgs']]]]:
        """
        The private IPv4 address associated with the instance.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePrivateIpArgs']]]]):
        pulumi.set(self, "private_ips", value)

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[pulumi.Input['InstancePrivateNetworkArgs']]:
        """
        Private Network endpoints of the Database Instance.
        """
        return pulumi.get(self, "private_network")

    @private_network.setter
    def private_network(self, value: Optional[pulumi.Input['InstancePrivateNetworkArgs']]):
        pulumi.set(self, "private_network", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The project_id you want to attach the resource to
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="publicNetwork")
    def public_network(self) -> Optional[pulumi.Input['InstancePublicNetworkArgs']]:
        """
        Public network endpoint configuration (no arguments).
        > **Important** If neither private_network nor public_network is specified, a public network endpoint is created by default.
        """
        return pulumi.get(self, "public_network")

    @public_network.setter
    def public_network(self, value: Optional[pulumi.Input['InstancePublicNetworkArgs']]):
        pulumi.set(self, "public_network", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region you want to attach the resource to
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of settings to define for the instance.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Snapshot ID to restore the MongoDB® instance from.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of tags attached to the MongoDB® instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the user created when the intance is created.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        MongoDB® version of the instance.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="volumeSizeInGb")
    def volume_size_in_gb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Volume size in GB.
        """
        return pulumi.get(self, "volume_size_in_gb")

    @volume_size_in_gb.setter
    def volume_size_in_gb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "volume_size_in_gb", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Volume type of the instance.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_number: Optional[pulumi.Input[builtins.int]] = None,
                 node_type: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePrivateIpArgs']]]] = None,
                 private_network: Optional[pulumi.Input['InstancePrivateNetworkArgs']] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 public_network: Optional[pulumi.Input['InstancePublicNetworkArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tls_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 volume_size_in_gb: Optional[pulumi.Input[builtins.int]] = None,
                 volume_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[builtins.str] created_at: The date and time of the creation of the MongoDB® instance.
        :param pulumi.Input[builtins.str] name: Name of the MongoDB® instance.
        :param pulumi.Input[builtins.int] node_number: Number of nodes in the instance
        :param pulumi.Input[builtins.str] node_type: The type of MongoDB® intance to create.
        :param pulumi.Input[builtins.str] password: Password of the user.
        :param pulumi.Input[Sequence[pulumi.Input['InstancePrivateIpArgs']]] private_ips: The private IPv4 address associated with the instance.
        :param pulumi.Input['InstancePrivateNetworkArgs'] private_network: Private Network endpoints of the Database Instance.
        :param pulumi.Input[builtins.str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input['InstancePublicNetworkArgs'] public_network: Public network endpoint configuration (no arguments).
               > **Important** If neither private_network nor public_network is specified, a public network endpoint is created by default.
        :param pulumi.Input[builtins.str] region: The region you want to attach the resource to
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] settings: Map of settings to define for the instance.
        :param pulumi.Input[builtins.str] snapshot_id: Snapshot ID to restore the MongoDB® instance from.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: List of tags attached to the MongoDB® instance.
        :param pulumi.Input[builtins.str] tls_certificate: The PEM-encoded TLS certificate for the MongoDB® instance, if available.
        :param pulumi.Input[builtins.str] updated_at: The date and time of the last update of the MongoDB® instance.
        :param pulumi.Input[builtins.str] user_name: Name of the user created when the intance is created.
        :param pulumi.Input[builtins.str] version: MongoDB® version of the instance.
        :param pulumi.Input[builtins.int] volume_size_in_gb: Volume size in GB.
        :param pulumi.Input[builtins.str] volume_type: Volume type of the instance.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_number is not None:
            pulumi.set(__self__, "node_number", node_number)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if public_network is not None:
            pulumi.set(__self__, "public_network", public_network)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_certificate is not None:
            pulumi.set(__self__, "tls_certificate", tls_certificate)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if volume_size_in_gb is not None:
            pulumi.set(__self__, "volume_size_in_gb", volume_size_in_gb)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time of the creation of the MongoDB® instance.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the MongoDB® instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of nodes in the instance
        """
        return pulumi.get(self, "node_number")

    @node_number.setter
    def node_number(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "node_number", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of MongoDB® intance to create.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Password of the user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePrivateIpArgs']]]]:
        """
        The private IPv4 address associated with the instance.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePrivateIpArgs']]]]):
        pulumi.set(self, "private_ips", value)

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[pulumi.Input['InstancePrivateNetworkArgs']]:
        """
        Private Network endpoints of the Database Instance.
        """
        return pulumi.get(self, "private_network")

    @private_network.setter
    def private_network(self, value: Optional[pulumi.Input['InstancePrivateNetworkArgs']]):
        pulumi.set(self, "private_network", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The project_id you want to attach the resource to
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="publicNetwork")
    def public_network(self) -> Optional[pulumi.Input['InstancePublicNetworkArgs']]:
        """
        Public network endpoint configuration (no arguments).
        > **Important** If neither private_network nor public_network is specified, a public network endpoint is created by default.
        """
        return pulumi.get(self, "public_network")

    @public_network.setter
    def public_network(self, value: Optional[pulumi.Input['InstancePublicNetworkArgs']]):
        pulumi.set(self, "public_network", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region you want to attach the resource to
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of settings to define for the instance.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Snapshot ID to restore the MongoDB® instance from.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of tags attached to the MongoDB® instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tlsCertificate")
    def tls_certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The PEM-encoded TLS certificate for the MongoDB® instance, if available.
        """
        return pulumi.get(self, "tls_certificate")

    @tls_certificate.setter
    def tls_certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tls_certificate", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time of the last update of the MongoDB® instance.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the user created when the intance is created.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        MongoDB® version of the instance.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="volumeSizeInGb")
    def volume_size_in_gb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Volume size in GB.
        """
        return pulumi.get(self, "volume_size_in_gb")

    @volume_size_in_gb.setter
    def volume_size_in_gb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "volume_size_in_gb", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Volume type of the instance.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.type_token("scaleway:mongodb/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_number: Optional[pulumi.Input[builtins.int]] = None,
                 node_type: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstancePrivateIpArgs', 'InstancePrivateIpArgsDict']]]]] = None,
                 private_network: Optional[pulumi.Input[Union['InstancePrivateNetworkArgs', 'InstancePrivateNetworkArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 public_network: Optional[pulumi.Input[Union['InstancePublicNetworkArgs', 'InstancePublicNetworkArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 volume_size_in_gb: Optional[pulumi.Input[builtins.int]] = None,
                 volume_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway MongoDB® instance.
        For more information refer to the [product documentation](https://www.scaleway.com/en/docs/managed-mongodb-databases/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.mongodb.Instance("main",
            name="test-mongodb-basic1",
            version="7.0.12",
            node_type="MGDB-PLAY2-NANO",
            node_number=1,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            volume_size_in_gb=5)
        ```

        ### Private Network

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn01 = scaleway.network.PrivateNetwork("pn01",
            name="my_private_network",
            region="fr-par")
        main = scaleway.mongodb.Instance("main",
            name="test-mongodb-basic1",
            version="7.0.12",
            node_type="MGDB-PLAY2-NANO",
            node_number=1,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            volume_size_in_gb=5,
            private_network={
                "pn_id": pn02["id"],
            })
        ```

        ### Private Network and Public Network

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn01 = scaleway.network.PrivateNetwork("pn01",
            name="my_private_network",
            region="fr-par")
        main = scaleway.mongodb.Instance("main",
            name="test-mongodb-basic1",
            version="7.0.12",
            node_type="MGDB-PLAY2-NANO",
            node_number=1,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            volume_size_in_gb=5,
            private_network={
                "pn_id": pn02["id"],
            },
            public_network={})
        ```

        ### Restore From Snapshot

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        restored_instance = scaleway.mongodb.Instance("restored_instance",
            snapshot_id=pn["idscalewayMongodbSnapshot"]["mainSnapshot"]["id"],
            name="restored-mongodb-from-snapshot",
            node_type="MGDB-PLAY2-NANO",
            node_number=1)
        ```

        ## Import

        MongoDB® instance can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:mongodb/instance:Instance main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: Name of the MongoDB® instance.
        :param pulumi.Input[builtins.int] node_number: Number of nodes in the instance
        :param pulumi.Input[builtins.str] node_type: The type of MongoDB® intance to create.
        :param pulumi.Input[builtins.str] password: Password of the user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstancePrivateIpArgs', 'InstancePrivateIpArgsDict']]]] private_ips: The private IPv4 address associated with the instance.
        :param pulumi.Input[Union['InstancePrivateNetworkArgs', 'InstancePrivateNetworkArgsDict']] private_network: Private Network endpoints of the Database Instance.
        :param pulumi.Input[builtins.str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[Union['InstancePublicNetworkArgs', 'InstancePublicNetworkArgsDict']] public_network: Public network endpoint configuration (no arguments).
               > **Important** If neither private_network nor public_network is specified, a public network endpoint is created by default.
        :param pulumi.Input[builtins.str] region: The region you want to attach the resource to
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] settings: Map of settings to define for the instance.
        :param pulumi.Input[builtins.str] snapshot_id: Snapshot ID to restore the MongoDB® instance from.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: List of tags attached to the MongoDB® instance.
        :param pulumi.Input[builtins.str] user_name: Name of the user created when the intance is created.
        :param pulumi.Input[builtins.str] version: MongoDB® version of the instance.
        :param pulumi.Input[builtins.int] volume_size_in_gb: Volume size in GB.
        :param pulumi.Input[builtins.str] volume_type: Volume type of the instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway MongoDB® instance.
        For more information refer to the [product documentation](https://www.scaleway.com/en/docs/managed-mongodb-databases/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.mongodb.Instance("main",
            name="test-mongodb-basic1",
            version="7.0.12",
            node_type="MGDB-PLAY2-NANO",
            node_number=1,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            volume_size_in_gb=5)
        ```

        ### Private Network

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn01 = scaleway.network.PrivateNetwork("pn01",
            name="my_private_network",
            region="fr-par")
        main = scaleway.mongodb.Instance("main",
            name="test-mongodb-basic1",
            version="7.0.12",
            node_type="MGDB-PLAY2-NANO",
            node_number=1,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            volume_size_in_gb=5,
            private_network={
                "pn_id": pn02["id"],
            })
        ```

        ### Private Network and Public Network

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn01 = scaleway.network.PrivateNetwork("pn01",
            name="my_private_network",
            region="fr-par")
        main = scaleway.mongodb.Instance("main",
            name="test-mongodb-basic1",
            version="7.0.12",
            node_type="MGDB-PLAY2-NANO",
            node_number=1,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            volume_size_in_gb=5,
            private_network={
                "pn_id": pn02["id"],
            },
            public_network={})
        ```

        ### Restore From Snapshot

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        restored_instance = scaleway.mongodb.Instance("restored_instance",
            snapshot_id=pn["idscalewayMongodbSnapshot"]["mainSnapshot"]["id"],
            name="restored-mongodb-from-snapshot",
            node_type="MGDB-PLAY2-NANO",
            node_number=1)
        ```

        ## Import

        MongoDB® instance can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:mongodb/instance:Instance main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_number: Optional[pulumi.Input[builtins.int]] = None,
                 node_type: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstancePrivateIpArgs', 'InstancePrivateIpArgsDict']]]]] = None,
                 private_network: Optional[pulumi.Input[Union['InstancePrivateNetworkArgs', 'InstancePrivateNetworkArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 public_network: Optional[pulumi.Input[Union['InstancePublicNetworkArgs', 'InstancePublicNetworkArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 volume_size_in_gb: Optional[pulumi.Input[builtins.int]] = None,
                 volume_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["name"] = name
            if node_number is None and not opts.urn:
                raise TypeError("Missing required property 'node_number'")
            __props__.__dict__["node_number"] = node_number
            if node_type is None and not opts.urn:
                raise TypeError("Missing required property 'node_type'")
            __props__.__dict__["node_type"] = node_type
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["private_ips"] = private_ips
            __props__.__dict__["private_network"] = private_network
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["public_network"] = public_network
            __props__.__dict__["region"] = region
            __props__.__dict__["settings"] = settings
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_name"] = user_name
            __props__.__dict__["version"] = version
            __props__.__dict__["volume_size_in_gb"] = volume_size_in_gb
            __props__.__dict__["volume_type"] = volume_type
            __props__.__dict__["created_at"] = None
            __props__.__dict__["tls_certificate"] = None
            __props__.__dict__["updated_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/mongoDbInstance:MongoDbInstance")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'scaleway:mongodb/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            node_number: Optional[pulumi.Input[builtins.int]] = None,
            node_type: Optional[pulumi.Input[builtins.str]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstancePrivateIpArgs', 'InstancePrivateIpArgsDict']]]]] = None,
            private_network: Optional[pulumi.Input[Union['InstancePrivateNetworkArgs', 'InstancePrivateNetworkArgsDict']]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            public_network: Optional[pulumi.Input[Union['InstancePublicNetworkArgs', 'InstancePublicNetworkArgsDict']]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tls_certificate: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None,
            user_name: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None,
            volume_size_in_gb: Optional[pulumi.Input[builtins.int]] = None,
            volume_type: Optional[pulumi.Input[builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] created_at: The date and time of the creation of the MongoDB® instance.
        :param pulumi.Input[builtins.str] name: Name of the MongoDB® instance.
        :param pulumi.Input[builtins.int] node_number: Number of nodes in the instance
        :param pulumi.Input[builtins.str] node_type: The type of MongoDB® intance to create.
        :param pulumi.Input[builtins.str] password: Password of the user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstancePrivateIpArgs', 'InstancePrivateIpArgsDict']]]] private_ips: The private IPv4 address associated with the instance.
        :param pulumi.Input[Union['InstancePrivateNetworkArgs', 'InstancePrivateNetworkArgsDict']] private_network: Private Network endpoints of the Database Instance.
        :param pulumi.Input[builtins.str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[Union['InstancePublicNetworkArgs', 'InstancePublicNetworkArgsDict']] public_network: Public network endpoint configuration (no arguments).
               > **Important** If neither private_network nor public_network is specified, a public network endpoint is created by default.
        :param pulumi.Input[builtins.str] region: The region you want to attach the resource to
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] settings: Map of settings to define for the instance.
        :param pulumi.Input[builtins.str] snapshot_id: Snapshot ID to restore the MongoDB® instance from.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: List of tags attached to the MongoDB® instance.
        :param pulumi.Input[builtins.str] tls_certificate: The PEM-encoded TLS certificate for the MongoDB® instance, if available.
        :param pulumi.Input[builtins.str] updated_at: The date and time of the last update of the MongoDB® instance.
        :param pulumi.Input[builtins.str] user_name: Name of the user created when the intance is created.
        :param pulumi.Input[builtins.str] version: MongoDB® version of the instance.
        :param pulumi.Input[builtins.int] volume_size_in_gb: Volume size in GB.
        :param pulumi.Input[builtins.str] volume_type: Volume type of the instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["name"] = name
        __props__.__dict__["node_number"] = node_number
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["password"] = password
        __props__.__dict__["private_ips"] = private_ips
        __props__.__dict__["private_network"] = private_network
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["public_network"] = public_network
        __props__.__dict__["region"] = region
        __props__.__dict__["settings"] = settings
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tls_certificate"] = tls_certificate
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["user_name"] = user_name
        __props__.__dict__["version"] = version
        __props__.__dict__["volume_size_in_gb"] = volume_size_in_gb
        __props__.__dict__["volume_type"] = volume_type
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of the creation of the MongoDB® instance.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the MongoDB® instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> pulumi.Output[builtins.int]:
        """
        Number of nodes in the instance
        """
        return pulumi.get(self, "node_number")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of MongoDB® intance to create.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Password of the user.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> pulumi.Output[Sequence['outputs.InstancePrivateIp']]:
        """
        The private IPv4 address associated with the instance.
        """
        return pulumi.get(self, "private_ips")

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> pulumi.Output[Optional['outputs.InstancePrivateNetwork']]:
        """
        Private Network endpoints of the Database Instance.
        """
        return pulumi.get(self, "private_network")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        The project_id you want to attach the resource to
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="publicNetwork")
    def public_network(self) -> pulumi.Output['outputs.InstancePublicNetwork']:
        """
        Public network endpoint configuration (no arguments).
        > **Important** If neither private_network nor public_network is specified, a public network endpoint is created by default.
        """
        return pulumi.get(self, "public_network")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The region you want to attach the resource to
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of settings to define for the instance.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Snapshot ID to restore the MongoDB® instance from.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of tags attached to the MongoDB® instance.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tlsCertificate")
    def tls_certificate(self) -> pulumi.Output[builtins.str]:
        """
        The PEM-encoded TLS certificate for the MongoDB® instance, if available.
        """
        return pulumi.get(self, "tls_certificate")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of the last update of the MongoDB® instance.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of the user created when the intance is created.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        MongoDB® version of the instance.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="volumeSizeInGb")
    def volume_size_in_gb(self) -> pulumi.Output[builtins.int]:
        """
        Volume size in GB.
        """
        return pulumi.get(self, "volume_size_in_gb")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Volume type of the instance.
        """
        return pulumi.get(self, "volume_type")

