# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'BucketAclAccessControlPolicyArgs',
    'BucketAclAccessControlPolicyArgsDict',
    'BucketAclAccessControlPolicyGrantArgs',
    'BucketAclAccessControlPolicyGrantArgsDict',
    'BucketAclAccessControlPolicyGrantGranteeArgs',
    'BucketAclAccessControlPolicyGrantGranteeArgsDict',
    'BucketAclAccessControlPolicyOwnerArgs',
    'BucketAclAccessControlPolicyOwnerArgsDict',
    'BucketCorsRuleArgs',
    'BucketCorsRuleArgsDict',
    'BucketLifecycleRuleArgs',
    'BucketLifecycleRuleArgsDict',
    'BucketLifecycleRuleExpirationArgs',
    'BucketLifecycleRuleExpirationArgsDict',
    'BucketLifecycleRuleTransitionArgs',
    'BucketLifecycleRuleTransitionArgsDict',
    'BucketLockConfigurationRuleArgs',
    'BucketLockConfigurationRuleArgsDict',
    'BucketLockConfigurationRuleDefaultRetentionArgs',
    'BucketLockConfigurationRuleDefaultRetentionArgsDict',
    'BucketVersioningArgs',
    'BucketVersioningArgsDict',
    'BucketWebsiteConfigurationErrorDocumentArgs',
    'BucketWebsiteConfigurationErrorDocumentArgsDict',
    'BucketWebsiteConfigurationIndexDocumentArgs',
    'BucketWebsiteConfigurationIndexDocumentArgsDict',
]

MYPY = False

if not MYPY:
    class BucketAclAccessControlPolicyArgsDict(TypedDict):
        owner: pulumi.Input['BucketAclAccessControlPolicyOwnerArgsDict']
        """
        Configuration block of the bucket project owner's display organization ID.
        """
        grants: NotRequired[pulumi.Input[Sequence[pulumi.Input['BucketAclAccessControlPolicyGrantArgsDict']]]]
elif False:
    BucketAclAccessControlPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BucketAclAccessControlPolicyArgs:
    def __init__(__self__, *,
                 owner: pulumi.Input['BucketAclAccessControlPolicyOwnerArgs'],
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input['BucketAclAccessControlPolicyGrantArgs']]]] = None):
        """
        :param pulumi.Input['BucketAclAccessControlPolicyOwnerArgs'] owner: Configuration block of the bucket project owner's display organization ID.
        """
        pulumi.set(__self__, "owner", owner)
        if grants is not None:
            pulumi.set(__self__, "grants", grants)

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Input['BucketAclAccessControlPolicyOwnerArgs']:
        """
        Configuration block of the bucket project owner's display organization ID.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: pulumi.Input['BucketAclAccessControlPolicyOwnerArgs']):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketAclAccessControlPolicyGrantArgs']]]]:
        return pulumi.get(self, "grants")

    @grants.setter
    def grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketAclAccessControlPolicyGrantArgs']]]]):
        pulumi.set(self, "grants", value)


if not MYPY:
    class BucketAclAccessControlPolicyGrantArgsDict(TypedDict):
        permission: pulumi.Input[builtins.str]
        """
        Logging permissions assigned to the grantee for the bucket.
        """
        grantee: NotRequired[pulumi.Input['BucketAclAccessControlPolicyGrantGranteeArgsDict']]
        """
        Configuration block for the project being granted permissions.
        """
elif False:
    BucketAclAccessControlPolicyGrantArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BucketAclAccessControlPolicyGrantArgs:
    def __init__(__self__, *,
                 permission: pulumi.Input[builtins.str],
                 grantee: Optional[pulumi.Input['BucketAclAccessControlPolicyGrantGranteeArgs']] = None):
        """
        :param pulumi.Input[builtins.str] permission: Logging permissions assigned to the grantee for the bucket.
        :param pulumi.Input['BucketAclAccessControlPolicyGrantGranteeArgs'] grantee: Configuration block for the project being granted permissions.
        """
        pulumi.set(__self__, "permission", permission)
        if grantee is not None:
            pulumi.set(__self__, "grantee", grantee)

    @property
    @pulumi.getter
    def permission(self) -> pulumi.Input[builtins.str]:
        """
        Logging permissions assigned to the grantee for the bucket.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "permission", value)

    @property
    @pulumi.getter
    def grantee(self) -> Optional[pulumi.Input['BucketAclAccessControlPolicyGrantGranteeArgs']]:
        """
        Configuration block for the project being granted permissions.
        """
        return pulumi.get(self, "grantee")

    @grantee.setter
    def grantee(self, value: Optional[pulumi.Input['BucketAclAccessControlPolicyGrantGranteeArgs']]):
        pulumi.set(self, "grantee", value)


if not MYPY:
    class BucketAclAccessControlPolicyGrantGranteeArgsDict(TypedDict):
        display_name: NotRequired[pulumi.Input[builtins.str]]
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        The `region`, `bucket` and `acl` separated by (`/`).
        """
        type: NotRequired[pulumi.Input[builtins.str]]
        """
        Type of grantee. Valid values: `CanonicalUser`, `Group`
        """
        uri: NotRequired[pulumi.Input[builtins.str]]
        """
        The uri of the grantee if you are granting permissions to a predefined group.
        """
elif False:
    BucketAclAccessControlPolicyGrantGranteeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BucketAclAccessControlPolicyGrantGranteeArgs:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 id: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 uri: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] id: The `region`, `bucket` and `acl` separated by (`/`).
        :param pulumi.Input[builtins.str] type: Type of grantee. Valid values: `CanonicalUser`, `Group`
        :param pulumi.Input[builtins.str] uri: The uri of the grantee if you are granting permissions to a predefined group.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The `region`, `bucket` and `acl` separated by (`/`).
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of grantee. Valid values: `CanonicalUser`, `Group`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The uri of the grantee if you are granting permissions to a predefined group.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uri", value)


if not MYPY:
    class BucketAclAccessControlPolicyOwnerArgsDict(TypedDict):
        id: pulumi.Input[builtins.str]
        """
        The `region`, `bucket` and `acl` separated by (`/`).
        """
        display_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The project ID of the grantee.
        """
elif False:
    BucketAclAccessControlPolicyOwnerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BucketAclAccessControlPolicyOwnerArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[builtins.str],
                 display_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] id: The `region`, `bucket` and `acl` separated by (`/`).
        :param pulumi.Input[builtins.str] display_name: The project ID of the grantee.
        """
        pulumi.set(__self__, "id", id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[builtins.str]:
        """
        The `region`, `bucket` and `acl` separated by (`/`).
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The project ID of the grantee.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)


if not MYPY:
    class BucketCorsRuleArgsDict(TypedDict):
        allowed_methods: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        Specifies which methods are allowed (`GET`, `PUT`, `POST`, `DELETE` or `HEAD`).
        """
        allowed_origins: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        Specifies which origins are allowed.
        """
        allowed_headers: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Specifies which headers are allowed.
        """
        expose_headers: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Specifies header exposure in the response.
        """
        max_age_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies time in seconds that the browser can cache the response for a preflight request.
        """
elif False:
    BucketCorsRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BucketCorsRuleArgs:
    def __init__(__self__, *,
                 allowed_methods: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 allowed_origins: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 allowed_headers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 expose_headers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 max_age_seconds: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_methods: Specifies which methods are allowed (`GET`, `PUT`, `POST`, `DELETE` or `HEAD`).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_origins: Specifies which origins are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_headers: Specifies which headers are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] expose_headers: Specifies header exposure in the response.
        :param pulumi.Input[builtins.int] max_age_seconds: Specifies time in seconds that the browser can cache the response for a preflight request.
        """
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Specifies which methods are allowed (`GET`, `PUT`, `POST`, `DELETE` or `HEAD`).
        """
        return pulumi.get(self, "allowed_methods")

    @allowed_methods.setter
    def allowed_methods(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "allowed_methods", value)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Specifies which origins are allowed.
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "allowed_origins", value)

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies which headers are allowed.
        """
        return pulumi.get(self, "allowed_headers")

    @allowed_headers.setter
    def allowed_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_headers", value)

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies header exposure in the response.
        """
        return pulumi.get(self, "expose_headers")

    @expose_headers.setter
    def expose_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "expose_headers", value)

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies time in seconds that the browser can cache the response for a preflight request.
        """
        return pulumi.get(self, "max_age_seconds")

    @max_age_seconds.setter
    def max_age_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_age_seconds", value)


if not MYPY:
    class BucketLifecycleRuleArgsDict(TypedDict):
        enabled: pulumi.Input[builtins.bool]
        """
        The element value can be either Enabled or Disabled. If a rule is disabled, Scaleway Object Storage does not perform any of the actions defined in the rule.
        """
        abort_incomplete_multipart_upload_days: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.

        > **Important:** Avoid using `prefix` for `AbortIncompleteMultipartUpload`, as any incomplete multipart upload will be billed
        """
        expiration: NotRequired[pulumi.Input['BucketLifecycleRuleExpirationArgsDict']]
        """
        Specifies a period in the object's expire
        """
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        """
        prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        Object key prefix identifying one or more objects to which the rule applies.
        """
        tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Specifies object tags key and value.
        """
        transitions: NotRequired[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleTransitionArgsDict']]]]
        """
        Define when objects transition to another storage class
        """
elif False:
    BucketLifecycleRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BucketLifecycleRuleArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool],
                 abort_incomplete_multipart_upload_days: Optional[pulumi.Input[builtins.int]] = None,
                 expiration: Optional[pulumi.Input['BucketLifecycleRuleExpirationArgs']] = None,
                 id: Optional[pulumi.Input[builtins.str]] = None,
                 prefix: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 transitions: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleTransitionArgs']]]] = None):
        """
        :param pulumi.Input[builtins.bool] enabled: The element value can be either Enabled or Disabled. If a rule is disabled, Scaleway Object Storage does not perform any of the actions defined in the rule.
        :param pulumi.Input[builtins.int] abort_incomplete_multipart_upload_days: Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.
               
               > **Important:** Avoid using `prefix` for `AbortIncompleteMultipartUpload`, as any incomplete multipart upload will be billed
        :param pulumi.Input['BucketLifecycleRuleExpirationArgs'] expiration: Specifies a period in the object's expire
        :param pulumi.Input[builtins.str] id: Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        :param pulumi.Input[builtins.str] prefix: Object key prefix identifying one or more objects to which the rule applies.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Specifies object tags key and value.
        :param pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleTransitionArgs']]] transitions: Define when objects transition to another storage class
        """
        pulumi.set(__self__, "enabled", enabled)
        if abort_incomplete_multipart_upload_days is not None:
            pulumi.set(__self__, "abort_incomplete_multipart_upload_days", abort_incomplete_multipart_upload_days)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transitions is not None:
            pulumi.set(__self__, "transitions", transitions)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        The element value can be either Enabled or Disabled. If a rule is disabled, Scaleway Object Storage does not perform any of the actions defined in the rule.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="abortIncompleteMultipartUploadDays")
    def abort_incomplete_multipart_upload_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.

        > **Important:** Avoid using `prefix` for `AbortIncompleteMultipartUpload`, as any incomplete multipart upload will be billed
        """
        return pulumi.get(self, "abort_incomplete_multipart_upload_days")

    @abort_incomplete_multipart_upload_days.setter
    def abort_incomplete_multipart_upload_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "abort_incomplete_multipart_upload_days", value)

    @property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input['BucketLifecycleRuleExpirationArgs']]:
        """
        Specifies a period in the object's expire
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input['BucketLifecycleRuleExpirationArgs']]):
        pulumi.set(self, "expiration", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Object key prefix identifying one or more objects to which the rule applies.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Specifies object tags key and value.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def transitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleTransitionArgs']]]]:
        """
        Define when objects transition to another storage class
        """
        return pulumi.get(self, "transitions")

    @transitions.setter
    def transitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleTransitionArgs']]]]):
        pulumi.set(self, "transitions", value)


if not MYPY:
    class BucketLifecycleRuleExpirationArgsDict(TypedDict):
        days: pulumi.Input[builtins.int]
        """
        Specifies the number of days after object creation when the specific rule action takes effect.
        """
elif False:
    BucketLifecycleRuleExpirationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BucketLifecycleRuleExpirationArgs:
    def __init__(__self__, *,
                 days: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.int] days: Specifies the number of days after object creation when the specific rule action takes effect.
        """
        pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def days(self) -> pulumi.Input[builtins.int]:
        """
        Specifies the number of days after object creation when the specific rule action takes effect.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "days", value)


if not MYPY:
    class BucketLifecycleRuleTransitionArgsDict(TypedDict):
        storage_class: pulumi.Input[builtins.str]
        """
        Specifies the Scaleway [storage class](https://www.scaleway.com/en/docs/object-storage/concepts/#storage-class) `STANDARD`, `GLACIER`, `ONEZONE_IA`  to which you want the object to transition.


        > **Important:**  If versioning is enabled, this rule only deletes the current version of an object.
        > **Important:**  If versioning is enabled, this rule only deletes the current version of an object.


        > **Important:**  `ONEZONE_IA` is only available in `fr-par` region. The storage class `GLACIER` is not available in `pl-waw` region.
        > **Important:**  `ONEZONE_IA` is only available in `fr-par` region. The storage class `GLACIER` is not available in `pl-waw` region.
        """
        days: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies the number of days after object creation when the specific rule action takes effect.
        """
elif False:
    BucketLifecycleRuleTransitionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BucketLifecycleRuleTransitionArgs:
    def __init__(__self__, *,
                 storage_class: pulumi.Input[builtins.str],
                 days: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] storage_class: Specifies the Scaleway [storage class](https://www.scaleway.com/en/docs/object-storage/concepts/#storage-class) `STANDARD`, `GLACIER`, `ONEZONE_IA`  to which you want the object to transition.
               
               
               > **Important:**  If versioning is enabled, this rule only deletes the current version of an object.
               > **Important:**  If versioning is enabled, this rule only deletes the current version of an object.
               
               
               > **Important:**  `ONEZONE_IA` is only available in `fr-par` region. The storage class `GLACIER` is not available in `pl-waw` region.
               > **Important:**  `ONEZONE_IA` is only available in `fr-par` region. The storage class `GLACIER` is not available in `pl-waw` region.
        :param pulumi.Input[builtins.int] days: Specifies the number of days after object creation when the specific rule action takes effect.
        """
        pulumi.set(__self__, "storage_class", storage_class)
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the Scaleway [storage class](https://www.scaleway.com/en/docs/object-storage/concepts/#storage-class) `STANDARD`, `GLACIER`, `ONEZONE_IA`  to which you want the object to transition.


        > **Important:**  If versioning is enabled, this rule only deletes the current version of an object.
        > **Important:**  If versioning is enabled, this rule only deletes the current version of an object.


        > **Important:**  `ONEZONE_IA` is only available in `fr-par` region. The storage class `GLACIER` is not available in `pl-waw` region.
        > **Important:**  `ONEZONE_IA` is only available in `fr-par` region. The storage class `GLACIER` is not available in `pl-waw` region.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "storage_class", value)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of days after object creation when the specific rule action takes effect.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "days", value)


if not MYPY:
    class BucketLockConfigurationRuleArgsDict(TypedDict):
        default_retention: pulumi.Input['BucketLockConfigurationRuleDefaultRetentionArgsDict']
        """
        The default retention for the lock.
        """
elif False:
    BucketLockConfigurationRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BucketLockConfigurationRuleArgs:
    def __init__(__self__, *,
                 default_retention: pulumi.Input['BucketLockConfigurationRuleDefaultRetentionArgs']):
        """
        :param pulumi.Input['BucketLockConfigurationRuleDefaultRetentionArgs'] default_retention: The default retention for the lock.
        """
        pulumi.set(__self__, "default_retention", default_retention)

    @property
    @pulumi.getter(name="defaultRetention")
    def default_retention(self) -> pulumi.Input['BucketLockConfigurationRuleDefaultRetentionArgs']:
        """
        The default retention for the lock.
        """
        return pulumi.get(self, "default_retention")

    @default_retention.setter
    def default_retention(self, value: pulumi.Input['BucketLockConfigurationRuleDefaultRetentionArgs']):
        pulumi.set(self, "default_retention", value)


if not MYPY:
    class BucketLockConfigurationRuleDefaultRetentionArgsDict(TypedDict):
        mode: pulumi.Input[builtins.str]
        """
        The default object lock retention mode you want to apply to new objects placed in the specified bucket. Valid values are `GOVERNANCE` or `COMPLIANCE`. Refer to the [dedicated documentation](https://www.scaleway.com/en/docs/object-storage/api-cli/object-lock/#retention-modes) for more information on retention modes.
        """
        days: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of days you want to specify for the default retention period.
        """
        years: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of years you want to specify for the default retention period.
        """
elif False:
    BucketLockConfigurationRuleDefaultRetentionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BucketLockConfigurationRuleDefaultRetentionArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[builtins.str],
                 days: Optional[pulumi.Input[builtins.int]] = None,
                 years: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] mode: The default object lock retention mode you want to apply to new objects placed in the specified bucket. Valid values are `GOVERNANCE` or `COMPLIANCE`. Refer to the [dedicated documentation](https://www.scaleway.com/en/docs/object-storage/api-cli/object-lock/#retention-modes) for more information on retention modes.
        :param pulumi.Input[builtins.int] days: The number of days you want to specify for the default retention period.
        :param pulumi.Input[builtins.int] years: The number of years you want to specify for the default retention period.
        """
        pulumi.set(__self__, "mode", mode)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if years is not None:
            pulumi.set(__self__, "years", years)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[builtins.str]:
        """
        The default object lock retention mode you want to apply to new objects placed in the specified bucket. Valid values are `GOVERNANCE` or `COMPLIANCE`. Refer to the [dedicated documentation](https://www.scaleway.com/en/docs/object-storage/api-cli/object-lock/#retention-modes) for more information on retention modes.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of days you want to specify for the default retention period.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter
    def years(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of years you want to specify for the default retention period.
        """
        return pulumi.get(self, "years")

    @years.setter
    def years(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "years", value)


if not MYPY:
    class BucketVersioningArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
        """
elif False:
    BucketVersioningArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BucketVersioningArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] enabled: Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class BucketWebsiteConfigurationErrorDocumentArgsDict(TypedDict):
        key: pulumi.Input[builtins.str]
        """
        The object key name to use when a 4XX class error occurs.
        """
elif False:
    BucketWebsiteConfigurationErrorDocumentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BucketWebsiteConfigurationErrorDocumentArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] key: The object key name to use when a 4XX class error occurs.
        """
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        The object key name to use when a 4XX class error occurs.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)


if not MYPY:
    class BucketWebsiteConfigurationIndexDocumentArgsDict(TypedDict):
        suffix: pulumi.Input[builtins.str]
        """
        A suffix that is appended to a request targeting a specific directory on the website endpoint.

        > **Important:** The suffix must not be empty and must not include a slash character. The routing is not supported.
        """
elif False:
    BucketWebsiteConfigurationIndexDocumentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BucketWebsiteConfigurationIndexDocumentArgs:
    def __init__(__self__, *,
                 suffix: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] suffix: A suffix that is appended to a request targeting a specific directory on the website endpoint.
               
               > **Important:** The suffix must not be empty and must not include a slash character. The routing is not supported.
        """
        pulumi.set(__self__, "suffix", suffix)

    @property
    @pulumi.getter
    def suffix(self) -> pulumi.Input[builtins.str]:
        """
        A suffix that is appended to a request targeting a specific directory on the website endpoint.

        > **Important:** The suffix must not be empty and must not include a slash character. The routing is not supported.
        """
        return pulumi.get(self, "suffix")

    @suffix.setter
    def suffix(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "suffix", value)


