# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 node_type: pulumi.Input[builtins.str],
                 password: pulumi.Input[builtins.str],
                 user_name: pulumi.Input[builtins.str],
                 version: pulumi.Input[builtins.str],
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAclArgs']]]] = None,
                 cluster_size: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPrivateIpArgs']]]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPrivateNetworkArgs']]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 public_network: Optional[pulumi.Input['ClusterPublicNetworkArgs']] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tls_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[builtins.str] node_type: The type of Redis™ cluster you want to create (e.g. `RED1-M`).
               
               > **Important:** Updates to `node_type` will migrate the Redis™ cluster to the desired `node_type`. Keep in mind that
               you cannot downgrade a Redis™ cluster.
        :param pulumi.Input[builtins.str] password: Password for the first user of the Redis™ cluster.
        :param pulumi.Input[builtins.str] user_name: Identifier for the first user of the Redis™ cluster.
        :param pulumi.Input[builtins.str] version: Redis™ cluster's version (e.g. `6.2.7`).
               
               > **Important:** Updates to `version` will migrate the Redis™ cluster to the desired `version`. Keep in mind that you
               cannot downgrade a Redis™ cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterAclArgs']]] acls: List of acl rules, this is cluster's authorized IPs. More details on the ACL section.
        :param pulumi.Input[builtins.int] cluster_size: The number of nodes in the Redis™ cluster.
               
               > **Important:**
               
               - Cluster_size = 1 for Standalone mode (single node).
               
               - Cluster_size = 2 for High Availability (HA) mode, with 1 main node and 1 standby node.
               
               - Cluster_size >= 3 for Cluster mode, which requires a minimum of 1 main node and 2 secondary nodes.
               
               > **Important:** If you are using the cluster mode (>=3 nodes), you can set a bigger `cluster_size` than you initially
               did, it will migrate the Redis™ cluster but keep in mind that you cannot downgrade a Redis™ cluster, so setting a smaller
               `cluster_size` will destroy and recreate your cluster.
               
               > **Important:** If you are using the Standalone mode (1 node), setting a bigger `cluster_size` will destroy and
               recreate your cluster as you will be switching to the cluster mode.
        :param pulumi.Input[builtins.str] name: The name of the Redis™ cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterPrivateIpArgs']]] private_ips: The list of private IPv4 addresses associated with the resource.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterPrivateNetworkArgs']]] private_networks: Describes the Private Network you want to connect to your cluster. If not set, a public
               network will be provided. More details on the Private Network section
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the Redis™ cluster is
               associated with.
        :param pulumi.Input['ClusterPublicNetworkArgs'] public_network: (Optional) Public network details. Only one of `private_network` and `public_network` may be set.
               > The `public_network` block exports:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] settings: Map of settings for Redis™ cluster. Available settings can be found by listing Redis™ versions
               with scaleway API or CLI
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the Redis™ cluster.
        :param pulumi.Input[builtins.bool] tls_enabled: Whether TLS is enabled or not.
               
               > The changes on `tls_enabled` will force the resource creation.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which the
               Redis™ cluster should be created.
        """
        pulumi.set(__self__, "node_type", node_type)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "user_name", user_name)
        pulumi.set(__self__, "version", version)
        if acls is not None:
            pulumi.set(__self__, "acls", acls)
        if cluster_size is not None:
            pulumi.set(__self__, "cluster_size", cluster_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if private_networks is not None:
            pulumi.set(__self__, "private_networks", private_networks)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if public_network is not None:
            pulumi.set(__self__, "public_network", public_network)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_enabled is not None:
            pulumi.set(__self__, "tls_enabled", tls_enabled)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of Redis™ cluster you want to create (e.g. `RED1-M`).

        > **Important:** Updates to `node_type` will migrate the Redis™ cluster to the desired `node_type`. Keep in mind that
        you cannot downgrade a Redis™ cluster.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        Password for the first user of the Redis™ cluster.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[builtins.str]:
        """
        Identifier for the first user of the Redis™ cluster.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[builtins.str]:
        """
        Redis™ cluster's version (e.g. `6.2.7`).

        > **Important:** Updates to `version` will migrate the Redis™ cluster to the desired `version`. Keep in mind that you
        cannot downgrade a Redis™ cluster.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def acls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAclArgs']]]]:
        """
        List of acl rules, this is cluster's authorized IPs. More details on the ACL section.
        """
        return pulumi.get(self, "acls")

    @acls.setter
    def acls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAclArgs']]]]):
        pulumi.set(self, "acls", value)

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of nodes in the Redis™ cluster.

        > **Important:**

        - Cluster_size = 1 for Standalone mode (single node).

        - Cluster_size = 2 for High Availability (HA) mode, with 1 main node and 1 standby node.

        - Cluster_size >= 3 for Cluster mode, which requires a minimum of 1 main node and 2 secondary nodes.

        > **Important:** If you are using the cluster mode (>=3 nodes), you can set a bigger `cluster_size` than you initially
        did, it will migrate the Redis™ cluster but keep in mind that you cannot downgrade a Redis™ cluster, so setting a smaller
        `cluster_size` will destroy and recreate your cluster.

        > **Important:** If you are using the Standalone mode (1 node), setting a bigger `cluster_size` will destroy and
        recreate your cluster as you will be switching to the cluster mode.
        """
        return pulumi.get(self, "cluster_size")

    @cluster_size.setter
    def cluster_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cluster_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Redis™ cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPrivateIpArgs']]]]:
        """
        The list of private IPv4 addresses associated with the resource.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPrivateIpArgs']]]]):
        pulumi.set(self, "private_ips", value)

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPrivateNetworkArgs']]]]:
        """
        Describes the Private Network you want to connect to your cluster. If not set, a public
        network will be provided. More details on the Private Network section
        """
        return pulumi.get(self, "private_networks")

    @private_networks.setter
    def private_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPrivateNetworkArgs']]]]):
        pulumi.set(self, "private_networks", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project the Redis™ cluster is
        associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="publicNetwork")
    def public_network(self) -> Optional[pulumi.Input['ClusterPublicNetworkArgs']]:
        """
        (Optional) Public network details. Only one of `private_network` and `public_network` may be set.
        > The `public_network` block exports:
        """
        return pulumi.get(self, "public_network")

    @public_network.setter
    def public_network(self, value: Optional[pulumi.Input['ClusterPublicNetworkArgs']]):
        pulumi.set(self, "public_network", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of settings for Redis™ cluster. Available settings can be found by listing Redis™ versions
        with scaleway API or CLI
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags associated with the Redis™ cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether TLS is enabled or not.

        > The changes on `tls_enabled` will force the resource creation.
        """
        return pulumi.get(self, "tls_enabled")

    @tls_enabled.setter
    def tls_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tls_enabled", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `zone`) The zone in which the
        Redis™ cluster should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAclArgs']]]] = None,
                 certificate: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_size: Optional[pulumi.Input[builtins.int]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_type: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPrivateIpArgs']]]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPrivateNetworkArgs']]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 public_network: Optional[pulumi.Input['ClusterPublicNetworkArgs']] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tls_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterAclArgs']]] acls: List of acl rules, this is cluster's authorized IPs. More details on the ACL section.
        :param pulumi.Input[builtins.str] certificate: The PEM of the certificate used by redis, only when `tls_enabled` is true
        :param pulumi.Input[builtins.int] cluster_size: The number of nodes in the Redis™ cluster.
               
               > **Important:**
               
               - Cluster_size = 1 for Standalone mode (single node).
               
               - Cluster_size = 2 for High Availability (HA) mode, with 1 main node and 1 standby node.
               
               - Cluster_size >= 3 for Cluster mode, which requires a minimum of 1 main node and 2 secondary nodes.
               
               > **Important:** If you are using the cluster mode (>=3 nodes), you can set a bigger `cluster_size` than you initially
               did, it will migrate the Redis™ cluster but keep in mind that you cannot downgrade a Redis™ cluster, so setting a smaller
               `cluster_size` will destroy and recreate your cluster.
               
               > **Important:** If you are using the Standalone mode (1 node), setting a bigger `cluster_size` will destroy and
               recreate your cluster as you will be switching to the cluster mode.
        :param pulumi.Input[builtins.str] created_at: The date and time of creation of the Redis™ cluster.
        :param pulumi.Input[builtins.str] name: The name of the Redis™ cluster.
        :param pulumi.Input[builtins.str] node_type: The type of Redis™ cluster you want to create (e.g. `RED1-M`).
               
               > **Important:** Updates to `node_type` will migrate the Redis™ cluster to the desired `node_type`. Keep in mind that
               you cannot downgrade a Redis™ cluster.
        :param pulumi.Input[builtins.str] password: Password for the first user of the Redis™ cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterPrivateIpArgs']]] private_ips: The list of private IPv4 addresses associated with the resource.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterPrivateNetworkArgs']]] private_networks: Describes the Private Network you want to connect to your cluster. If not set, a public
               network will be provided. More details on the Private Network section
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the Redis™ cluster is
               associated with.
        :param pulumi.Input['ClusterPublicNetworkArgs'] public_network: (Optional) Public network details. Only one of `private_network` and `public_network` may be set.
               > The `public_network` block exports:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] settings: Map of settings for Redis™ cluster. Available settings can be found by listing Redis™ versions
               with scaleway API or CLI
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the Redis™ cluster.
        :param pulumi.Input[builtins.bool] tls_enabled: Whether TLS is enabled or not.
               
               > The changes on `tls_enabled` will force the resource creation.
        :param pulumi.Input[builtins.str] updated_at: The date and time of the last update of the Redis™ cluster.
        :param pulumi.Input[builtins.str] user_name: Identifier for the first user of the Redis™ cluster.
        :param pulumi.Input[builtins.str] version: Redis™ cluster's version (e.g. `6.2.7`).
               
               > **Important:** Updates to `version` will migrate the Redis™ cluster to the desired `version`. Keep in mind that you
               cannot downgrade a Redis™ cluster.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which the
               Redis™ cluster should be created.
        """
        if acls is not None:
            pulumi.set(__self__, "acls", acls)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if cluster_size is not None:
            pulumi.set(__self__, "cluster_size", cluster_size)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if private_networks is not None:
            pulumi.set(__self__, "private_networks", private_networks)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if public_network is not None:
            pulumi.set(__self__, "public_network", public_network)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_enabled is not None:
            pulumi.set(__self__, "tls_enabled", tls_enabled)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def acls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAclArgs']]]]:
        """
        List of acl rules, this is cluster's authorized IPs. More details on the ACL section.
        """
        return pulumi.get(self, "acls")

    @acls.setter
    def acls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAclArgs']]]]):
        pulumi.set(self, "acls", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The PEM of the certificate used by redis, only when `tls_enabled` is true
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of nodes in the Redis™ cluster.

        > **Important:**

        - Cluster_size = 1 for Standalone mode (single node).

        - Cluster_size = 2 for High Availability (HA) mode, with 1 main node and 1 standby node.

        - Cluster_size >= 3 for Cluster mode, which requires a minimum of 1 main node and 2 secondary nodes.

        > **Important:** If you are using the cluster mode (>=3 nodes), you can set a bigger `cluster_size` than you initially
        did, it will migrate the Redis™ cluster but keep in mind that you cannot downgrade a Redis™ cluster, so setting a smaller
        `cluster_size` will destroy and recreate your cluster.

        > **Important:** If you are using the Standalone mode (1 node), setting a bigger `cluster_size` will destroy and
        recreate your cluster as you will be switching to the cluster mode.
        """
        return pulumi.get(self, "cluster_size")

    @cluster_size.setter
    def cluster_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cluster_size", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time of creation of the Redis™ cluster.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Redis™ cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of Redis™ cluster you want to create (e.g. `RED1-M`).

        > **Important:** Updates to `node_type` will migrate the Redis™ cluster to the desired `node_type`. Keep in mind that
        you cannot downgrade a Redis™ cluster.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Password for the first user of the Redis™ cluster.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPrivateIpArgs']]]]:
        """
        The list of private IPv4 addresses associated with the resource.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPrivateIpArgs']]]]):
        pulumi.set(self, "private_ips", value)

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPrivateNetworkArgs']]]]:
        """
        Describes the Private Network you want to connect to your cluster. If not set, a public
        network will be provided. More details on the Private Network section
        """
        return pulumi.get(self, "private_networks")

    @private_networks.setter
    def private_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPrivateNetworkArgs']]]]):
        pulumi.set(self, "private_networks", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project the Redis™ cluster is
        associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="publicNetwork")
    def public_network(self) -> Optional[pulumi.Input['ClusterPublicNetworkArgs']]:
        """
        (Optional) Public network details. Only one of `private_network` and `public_network` may be set.
        > The `public_network` block exports:
        """
        return pulumi.get(self, "public_network")

    @public_network.setter
    def public_network(self, value: Optional[pulumi.Input['ClusterPublicNetworkArgs']]):
        pulumi.set(self, "public_network", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of settings for Redis™ cluster. Available settings can be found by listing Redis™ versions
        with scaleway API or CLI
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags associated with the Redis™ cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether TLS is enabled or not.

        > The changes on `tls_enabled` will force the resource creation.
        """
        return pulumi.get(self, "tls_enabled")

    @tls_enabled.setter
    def tls_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tls_enabled", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time of the last update of the Redis™ cluster.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier for the first user of the Redis™ cluster.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Redis™ cluster's version (e.g. `6.2.7`).

        > **Important:** Updates to `version` will migrate the Redis™ cluster to the desired `version`. Keep in mind that you
        cannot downgrade a Redis™ cluster.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `zone`) The zone in which the
        Redis™ cluster should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("scaleway:redis/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterAclArgs', 'ClusterAclArgsDict']]]]] = None,
                 cluster_size: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_type: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterPrivateIpArgs', 'ClusterPrivateIpArgsDict']]]]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterPrivateNetworkArgs', 'ClusterPrivateNetworkArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 public_network: Optional[pulumi.Input[Union['ClusterPublicNetworkArgs', 'ClusterPublicNetworkArgsDict']]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tls_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Redis™ clusters.
        For more information refer to the [API documentation](https://www.scaleway.com/en/developers/api/managed-database-redis).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.redis.Cluster("main",
            name="test_redis_basic",
            version="6.2.7",
            node_type="RED1-MICRO",
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            tags=[
                "test",
                "redis",
            ],
            cluster_size=1,
            tls_enabled=True,
            acls=[{
                "ip": "0.0.0.0/0",
                "description": "Allow all",
            }])
        ```

        ### With settings

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.redis.Cluster("main",
            name="test_redis_basic",
            version="6.2.7",
            node_type="RED1-MICRO",
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            settings={
                "maxclients": "1000",
                "tcp-keepalive": "120",
            })
        ```

        ### With a Private Network

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn = scaleway.network.PrivateNetwork("pn", name="private-network")
        main = scaleway.redis.Cluster("main",
            name="test_redis_endpoints",
            version="6.2.7",
            node_type="RED1-MICRO",
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            cluster_size=1,
            private_networks=[{
                "id": pn.id,
                "service_ips": ["10.12.1.1/20"],
            }],
            opts = pulumi.ResourceOptions(depends_on=[pn]))
        ```

        ## Import

        Redis™ cluster can be imported using the `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:redis/cluster:Cluster main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterAclArgs', 'ClusterAclArgsDict']]]] acls: List of acl rules, this is cluster's authorized IPs. More details on the ACL section.
        :param pulumi.Input[builtins.int] cluster_size: The number of nodes in the Redis™ cluster.
               
               > **Important:**
               
               - Cluster_size = 1 for Standalone mode (single node).
               
               - Cluster_size = 2 for High Availability (HA) mode, with 1 main node and 1 standby node.
               
               - Cluster_size >= 3 for Cluster mode, which requires a minimum of 1 main node and 2 secondary nodes.
               
               > **Important:** If you are using the cluster mode (>=3 nodes), you can set a bigger `cluster_size` than you initially
               did, it will migrate the Redis™ cluster but keep in mind that you cannot downgrade a Redis™ cluster, so setting a smaller
               `cluster_size` will destroy and recreate your cluster.
               
               > **Important:** If you are using the Standalone mode (1 node), setting a bigger `cluster_size` will destroy and
               recreate your cluster as you will be switching to the cluster mode.
        :param pulumi.Input[builtins.str] name: The name of the Redis™ cluster.
        :param pulumi.Input[builtins.str] node_type: The type of Redis™ cluster you want to create (e.g. `RED1-M`).
               
               > **Important:** Updates to `node_type` will migrate the Redis™ cluster to the desired `node_type`. Keep in mind that
               you cannot downgrade a Redis™ cluster.
        :param pulumi.Input[builtins.str] password: Password for the first user of the Redis™ cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterPrivateIpArgs', 'ClusterPrivateIpArgsDict']]]] private_ips: The list of private IPv4 addresses associated with the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterPrivateNetworkArgs', 'ClusterPrivateNetworkArgsDict']]]] private_networks: Describes the Private Network you want to connect to your cluster. If not set, a public
               network will be provided. More details on the Private Network section
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the Redis™ cluster is
               associated with.
        :param pulumi.Input[Union['ClusterPublicNetworkArgs', 'ClusterPublicNetworkArgsDict']] public_network: (Optional) Public network details. Only one of `private_network` and `public_network` may be set.
               > The `public_network` block exports:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] settings: Map of settings for Redis™ cluster. Available settings can be found by listing Redis™ versions
               with scaleway API or CLI
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the Redis™ cluster.
        :param pulumi.Input[builtins.bool] tls_enabled: Whether TLS is enabled or not.
               
               > The changes on `tls_enabled` will force the resource creation.
        :param pulumi.Input[builtins.str] user_name: Identifier for the first user of the Redis™ cluster.
        :param pulumi.Input[builtins.str] version: Redis™ cluster's version (e.g. `6.2.7`).
               
               > **Important:** Updates to `version` will migrate the Redis™ cluster to the desired `version`. Keep in mind that you
               cannot downgrade a Redis™ cluster.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which the
               Redis™ cluster should be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Redis™ clusters.
        For more information refer to the [API documentation](https://www.scaleway.com/en/developers/api/managed-database-redis).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.redis.Cluster("main",
            name="test_redis_basic",
            version="6.2.7",
            node_type="RED1-MICRO",
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            tags=[
                "test",
                "redis",
            ],
            cluster_size=1,
            tls_enabled=True,
            acls=[{
                "ip": "0.0.0.0/0",
                "description": "Allow all",
            }])
        ```

        ### With settings

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.redis.Cluster("main",
            name="test_redis_basic",
            version="6.2.7",
            node_type="RED1-MICRO",
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            settings={
                "maxclients": "1000",
                "tcp-keepalive": "120",
            })
        ```

        ### With a Private Network

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn = scaleway.network.PrivateNetwork("pn", name="private-network")
        main = scaleway.redis.Cluster("main",
            name="test_redis_endpoints",
            version="6.2.7",
            node_type="RED1-MICRO",
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            cluster_size=1,
            private_networks=[{
                "id": pn.id,
                "service_ips": ["10.12.1.1/20"],
            }],
            opts = pulumi.ResourceOptions(depends_on=[pn]))
        ```

        ## Import

        Redis™ cluster can be imported using the `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:redis/cluster:Cluster main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterAclArgs', 'ClusterAclArgsDict']]]]] = None,
                 cluster_size: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_type: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterPrivateIpArgs', 'ClusterPrivateIpArgsDict']]]]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterPrivateNetworkArgs', 'ClusterPrivateNetworkArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 public_network: Optional[pulumi.Input[Union['ClusterPublicNetworkArgs', 'ClusterPublicNetworkArgsDict']]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tls_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["acls"] = acls
            __props__.__dict__["cluster_size"] = cluster_size
            __props__.__dict__["name"] = name
            if node_type is None and not opts.urn:
                raise TypeError("Missing required property 'node_type'")
            __props__.__dict__["node_type"] = node_type
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["private_ips"] = private_ips
            __props__.__dict__["private_networks"] = private_networks
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["public_network"] = public_network
            __props__.__dict__["settings"] = settings
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tls_enabled"] = tls_enabled
            if user_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_name'")
            __props__.__dict__["user_name"] = user_name
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["zone"] = zone
            __props__.__dict__["certificate"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/redisCluster:RedisCluster")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Cluster, __self__).__init__(
            'scaleway:redis/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterAclArgs', 'ClusterAclArgsDict']]]]] = None,
            certificate: Optional[pulumi.Input[builtins.str]] = None,
            cluster_size: Optional[pulumi.Input[builtins.int]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            node_type: Optional[pulumi.Input[builtins.str]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterPrivateIpArgs', 'ClusterPrivateIpArgsDict']]]]] = None,
            private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterPrivateNetworkArgs', 'ClusterPrivateNetworkArgsDict']]]]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            public_network: Optional[pulumi.Input[Union['ClusterPublicNetworkArgs', 'ClusterPublicNetworkArgsDict']]] = None,
            settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tls_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None,
            user_name: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterAclArgs', 'ClusterAclArgsDict']]]] acls: List of acl rules, this is cluster's authorized IPs. More details on the ACL section.
        :param pulumi.Input[builtins.str] certificate: The PEM of the certificate used by redis, only when `tls_enabled` is true
        :param pulumi.Input[builtins.int] cluster_size: The number of nodes in the Redis™ cluster.
               
               > **Important:**
               
               - Cluster_size = 1 for Standalone mode (single node).
               
               - Cluster_size = 2 for High Availability (HA) mode, with 1 main node and 1 standby node.
               
               - Cluster_size >= 3 for Cluster mode, which requires a minimum of 1 main node and 2 secondary nodes.
               
               > **Important:** If you are using the cluster mode (>=3 nodes), you can set a bigger `cluster_size` than you initially
               did, it will migrate the Redis™ cluster but keep in mind that you cannot downgrade a Redis™ cluster, so setting a smaller
               `cluster_size` will destroy and recreate your cluster.
               
               > **Important:** If you are using the Standalone mode (1 node), setting a bigger `cluster_size` will destroy and
               recreate your cluster as you will be switching to the cluster mode.
        :param pulumi.Input[builtins.str] created_at: The date and time of creation of the Redis™ cluster.
        :param pulumi.Input[builtins.str] name: The name of the Redis™ cluster.
        :param pulumi.Input[builtins.str] node_type: The type of Redis™ cluster you want to create (e.g. `RED1-M`).
               
               > **Important:** Updates to `node_type` will migrate the Redis™ cluster to the desired `node_type`. Keep in mind that
               you cannot downgrade a Redis™ cluster.
        :param pulumi.Input[builtins.str] password: Password for the first user of the Redis™ cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterPrivateIpArgs', 'ClusterPrivateIpArgsDict']]]] private_ips: The list of private IPv4 addresses associated with the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterPrivateNetworkArgs', 'ClusterPrivateNetworkArgsDict']]]] private_networks: Describes the Private Network you want to connect to your cluster. If not set, a public
               network will be provided. More details on the Private Network section
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the Redis™ cluster is
               associated with.
        :param pulumi.Input[Union['ClusterPublicNetworkArgs', 'ClusterPublicNetworkArgsDict']] public_network: (Optional) Public network details. Only one of `private_network` and `public_network` may be set.
               > The `public_network` block exports:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] settings: Map of settings for Redis™ cluster. Available settings can be found by listing Redis™ versions
               with scaleway API or CLI
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the Redis™ cluster.
        :param pulumi.Input[builtins.bool] tls_enabled: Whether TLS is enabled or not.
               
               > The changes on `tls_enabled` will force the resource creation.
        :param pulumi.Input[builtins.str] updated_at: The date and time of the last update of the Redis™ cluster.
        :param pulumi.Input[builtins.str] user_name: Identifier for the first user of the Redis™ cluster.
        :param pulumi.Input[builtins.str] version: Redis™ cluster's version (e.g. `6.2.7`).
               
               > **Important:** Updates to `version` will migrate the Redis™ cluster to the desired `version`. Keep in mind that you
               cannot downgrade a Redis™ cluster.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which the
               Redis™ cluster should be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["acls"] = acls
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["cluster_size"] = cluster_size
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["name"] = name
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["password"] = password
        __props__.__dict__["private_ips"] = private_ips
        __props__.__dict__["private_networks"] = private_networks
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["public_network"] = public_network
        __props__.__dict__["settings"] = settings
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tls_enabled"] = tls_enabled
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["user_name"] = user_name
        __props__.__dict__["version"] = version
        __props__.__dict__["zone"] = zone
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acls(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterAcl']]]:
        """
        List of acl rules, this is cluster's authorized IPs. More details on the ACL section.
        """
        return pulumi.get(self, "acls")

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[builtins.str]:
        """
        The PEM of the certificate used by redis, only when `tls_enabled` is true
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> pulumi.Output[builtins.int]:
        """
        The number of nodes in the Redis™ cluster.

        > **Important:**

        - Cluster_size = 1 for Standalone mode (single node).

        - Cluster_size = 2 for High Availability (HA) mode, with 1 main node and 1 standby node.

        - Cluster_size >= 3 for Cluster mode, which requires a minimum of 1 main node and 2 secondary nodes.

        > **Important:** If you are using the cluster mode (>=3 nodes), you can set a bigger `cluster_size` than you initially
        did, it will migrate the Redis™ cluster but keep in mind that you cannot downgrade a Redis™ cluster, so setting a smaller
        `cluster_size` will destroy and recreate your cluster.

        > **Important:** If you are using the Standalone mode (1 node), setting a bigger `cluster_size` will destroy and
        recreate your cluster as you will be switching to the cluster mode.
        """
        return pulumi.get(self, "cluster_size")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of creation of the Redis™ cluster.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Redis™ cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of Redis™ cluster you want to create (e.g. `RED1-M`).

        > **Important:** Updates to `node_type` will migrate the Redis™ cluster to the desired `node_type`. Keep in mind that
        you cannot downgrade a Redis™ cluster.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[builtins.str]:
        """
        Password for the first user of the Redis™ cluster.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> pulumi.Output[Sequence['outputs.ClusterPrivateIp']]:
        """
        The list of private IPv4 addresses associated with the resource.
        """
        return pulumi.get(self, "private_ips")

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterPrivateNetwork']]]:
        """
        Describes the Private Network you want to connect to your cluster. If not set, a public
        network will be provided. More details on the Private Network section
        """
        return pulumi.get(self, "private_networks")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        `project_id`) The ID of the project the Redis™ cluster is
        associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="publicNetwork")
    def public_network(self) -> pulumi.Output['outputs.ClusterPublicNetwork']:
        """
        (Optional) Public network details. Only one of `private_network` and `public_network` may be set.
        > The `public_network` block exports:
        """
        return pulumi.get(self, "public_network")

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of settings for Redis™ cluster. Available settings can be found by listing Redis™ versions
        with scaleway API or CLI
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The tags associated with the Redis™ cluster.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether TLS is enabled or not.

        > The changes on `tls_enabled` will force the resource creation.
        """
        return pulumi.get(self, "tls_enabled")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of the last update of the Redis™ cluster.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[builtins.str]:
        """
        Identifier for the first user of the Redis™ cluster.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        Redis™ cluster's version (e.g. `6.2.7`).

        > **Important:** Updates to `version` will migrate the Redis™ cluster to the desired `version`. Keep in mind that you
        cannot downgrade a Redis™ cluster.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        `zone`) The zone in which the
        Redis™ cluster should be created.
        """
        return pulumi.get(self, "zone")

