# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetClusterResult',
    'AwaitableGetClusterResult',
    'get_cluster',
    'get_cluster_output',
]

@pulumi.output_type
class GetClusterResult:
    """
    A collection of values returned by getCluster.
    """
    def __init__(__self__, acls=None, certificate=None, cluster_id=None, cluster_size=None, created_at=None, id=None, name=None, node_type=None, password=None, private_ips=None, private_networks=None, project_id=None, public_networks=None, settings=None, tags=None, tls_enabled=None, updated_at=None, user_name=None, version=None, zone=None):
        if acls and not isinstance(acls, list):
            raise TypeError("Expected argument 'acls' to be a list")
        pulumi.set(__self__, "acls", acls)
        if certificate and not isinstance(certificate, str):
            raise TypeError("Expected argument 'certificate' to be a str")
        pulumi.set(__self__, "certificate", certificate)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_size and not isinstance(cluster_size, int):
            raise TypeError("Expected argument 'cluster_size' to be a int")
        pulumi.set(__self__, "cluster_size", cluster_size)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if node_type and not isinstance(node_type, str):
            raise TypeError("Expected argument 'node_type' to be a str")
        pulumi.set(__self__, "node_type", node_type)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if private_ips and not isinstance(private_ips, list):
            raise TypeError("Expected argument 'private_ips' to be a list")
        pulumi.set(__self__, "private_ips", private_ips)
        if private_networks and not isinstance(private_networks, list):
            raise TypeError("Expected argument 'private_networks' to be a list")
        pulumi.set(__self__, "private_networks", private_networks)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if public_networks and not isinstance(public_networks, list):
            raise TypeError("Expected argument 'public_networks' to be a list")
        pulumi.set(__self__, "public_networks", public_networks)
        if settings and not isinstance(settings, dict):
            raise TypeError("Expected argument 'settings' to be a dict")
        pulumi.set(__self__, "settings", settings)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tls_enabled and not isinstance(tls_enabled, bool):
            raise TypeError("Expected argument 'tls_enabled' to be a bool")
        pulumi.set(__self__, "tls_enabled", tls_enabled)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if user_name and not isinstance(user_name, str):
            raise TypeError("Expected argument 'user_name' to be a str")
        pulumi.set(__self__, "user_name", user_name)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def acls(self) -> Sequence['outputs.GetClusterAclResult']:
        """
        List of acl rules.
        """
        return pulumi.get(self, "acls")

    @property
    @pulumi.getter
    def certificate(self) -> builtins.str:
        """
        The PEM of the certificate used by redis, only when `tls_enabled` is true.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> builtins.int:
        """
        The number of nodes in the Redis Cluster.
        """
        return pulumi.get(self, "cluster_size")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        The date and time of creation of the Redis Cluster.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> builtins.str:
        """
        The type of Redis Cluster (e.g. `RED1-M`).
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        """
        Password of the first user of the Redis Cluster.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Sequence['outputs.GetClusterPrivateIpResult']:
        return pulumi.get(self, "private_ips")

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> Sequence['outputs.GetClusterPrivateNetworkResult']:
        """
        List of private networks endpoints of the Redis Cluster.
        """
        return pulumi.get(self, "private_networks")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="publicNetworks")
    def public_networks(self) -> Sequence['outputs.GetClusterPublicNetworkResult']:
        """
        Public network details.
        """
        return pulumi.get(self, "public_networks")

    @property
    @pulumi.getter
    def settings(self) -> Mapping[str, builtins.str]:
        """
        Map of settings for redis cluster.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[builtins.str]:
        """
        The tags associated with the Redis Cluster.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> builtins.bool:
        """
        Whether TLS is enabled or not.
        """
        return pulumi.get(self, "tls_enabled")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> builtins.str:
        """
        The date and time of the last update of the Redis Cluster.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> builtins.str:
        """
        The first user of the Redis Cluster.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Redis's Cluster version (e.g. `6.2.7`).
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def zone(self) -> Optional[builtins.str]:
        return pulumi.get(self, "zone")


class AwaitableGetClusterResult(GetClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterResult(
            acls=self.acls,
            certificate=self.certificate,
            cluster_id=self.cluster_id,
            cluster_size=self.cluster_size,
            created_at=self.created_at,
            id=self.id,
            name=self.name,
            node_type=self.node_type,
            password=self.password,
            private_ips=self.private_ips,
            private_networks=self.private_networks,
            project_id=self.project_id,
            public_networks=self.public_networks,
            settings=self.settings,
            tags=self.tags,
            tls_enabled=self.tls_enabled,
            updated_at=self.updated_at,
            user_name=self.user_name,
            version=self.version,
            zone=self.zone)


def get_cluster(cluster_id: Optional[builtins.str] = None,
                name: Optional[builtins.str] = None,
                project_id: Optional[builtins.str] = None,
                zone: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterResult:
    """
    Gets information about a Redis™ cluster.

    For further information refer to the Managed Database for Redis™ [API documentation](https://developers.scaleway.com/en/products/redis/api/v1alpha1/#clusters-a85816).


    :param builtins.str cluster_id: The Redis cluster ID.
           
           > **Note** You must specify at least one: `name` and/or `cluster_id`.
    :param builtins.str name: The name of the Redis cluster.
    :param builtins.str project_id: The ID of the project the Redis cluster is associated with.
    :param builtins.str zone: `region`) The zone in which the server exists.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:redis/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult).value

    return AwaitableGetClusterResult(
        acls=pulumi.get(__ret__, 'acls'),
        certificate=pulumi.get(__ret__, 'certificate'),
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        cluster_size=pulumi.get(__ret__, 'cluster_size'),
        created_at=pulumi.get(__ret__, 'created_at'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        node_type=pulumi.get(__ret__, 'node_type'),
        password=pulumi.get(__ret__, 'password'),
        private_ips=pulumi.get(__ret__, 'private_ips'),
        private_networks=pulumi.get(__ret__, 'private_networks'),
        project_id=pulumi.get(__ret__, 'project_id'),
        public_networks=pulumi.get(__ret__, 'public_networks'),
        settings=pulumi.get(__ret__, 'settings'),
        tags=pulumi.get(__ret__, 'tags'),
        tls_enabled=pulumi.get(__ret__, 'tls_enabled'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        user_name=pulumi.get(__ret__, 'user_name'),
        version=pulumi.get(__ret__, 'version'),
        zone=pulumi.get(__ret__, 'zone'))
def get_cluster_output(cluster_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       zone: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterResult]:
    """
    Gets information about a Redis™ cluster.

    For further information refer to the Managed Database for Redis™ [API documentation](https://developers.scaleway.com/en/products/redis/api/v1alpha1/#clusters-a85816).


    :param builtins.str cluster_id: The Redis cluster ID.
           
           > **Note** You must specify at least one: `name` and/or `cluster_id`.
    :param builtins.str name: The name of the Redis cluster.
    :param builtins.str project_id: The ID of the project the Redis cluster is associated with.
    :param builtins.str zone: `region`) The zone in which the server exists.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:redis/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult)
    return __ret__.apply(lambda __response__: GetClusterResult(
        acls=pulumi.get(__response__, 'acls'),
        certificate=pulumi.get(__response__, 'certificate'),
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        cluster_size=pulumi.get(__response__, 'cluster_size'),
        created_at=pulumi.get(__response__, 'created_at'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        node_type=pulumi.get(__response__, 'node_type'),
        password=pulumi.get(__response__, 'password'),
        private_ips=pulumi.get(__response__, 'private_ips'),
        private_networks=pulumi.get(__response__, 'private_networks'),
        project_id=pulumi.get(__response__, 'project_id'),
        public_networks=pulumi.get(__response__, 'public_networks'),
        settings=pulumi.get(__response__, 'settings'),
        tags=pulumi.get(__response__, 'tags'),
        tls_enabled=pulumi.get(__response__, 'tls_enabled'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        user_name=pulumi.get(__response__, 'user_name'),
        version=pulumi.get(__response__, 'version'),
        zone=pulumi.get(__response__, 'zone')))
