# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BlockedListArgs', 'BlockedList']

@pulumi.input_type
class BlockedListArgs:
    def __init__(__self__, *,
                 domain_id: pulumi.Input[builtins.str],
                 email: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 reason: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a BlockedList resource.
        :param pulumi.Input[builtins.str] domain_id: The ID of the domain affected by the blocklist. Must be in the format `{region}/{domain_id}`.
        :param pulumi.Input[builtins.str] email: The email address to block.
        :param pulumi.Input[builtins.str] type: Type of the blocklist. Possible values are:
        :param pulumi.Input[builtins.str] project_id: The ID of the project this blocklist belongs to. Defaults to the provider's project ID.
        :param pulumi.Input[builtins.str] reason: Reason for blocking the email address.
        :param pulumi.Input[builtins.str] region: The region in which the blocklist is created. Defaults to the provider's region.
        """
        pulumi.set(__self__, "domain_id", domain_id)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "type", type)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the domain affected by the blocklist. Must be in the format `{region}/{domain_id}`.
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_id", value)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[builtins.str]:
        """
        The email address to block.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Type of the blocklist. Possible values are:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project this blocklist belongs to. Defaults to the provider's project ID.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Reason for blocking the email address.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which the blocklist is created. Defaults to the provider's region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _BlockedListState:
    def __init__(__self__, *,
                 domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 reason: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering BlockedList resources.
        :param pulumi.Input[builtins.str] domain_id: The ID of the domain affected by the blocklist. Must be in the format `{region}/{domain_id}`.
        :param pulumi.Input[builtins.str] email: The email address to block.
        :param pulumi.Input[builtins.str] project_id: The ID of the project this blocklist belongs to. Defaults to the provider's project ID.
        :param pulumi.Input[builtins.str] reason: Reason for blocking the email address.
        :param pulumi.Input[builtins.str] region: The region in which the blocklist is created. Defaults to the provider's region.
        :param pulumi.Input[builtins.str] type: Type of the blocklist. Possible values are:
        """
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the domain affected by the blocklist. Must be in the format `{region}/{domain_id}`.
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_id", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The email address to block.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project this blocklist belongs to. Defaults to the provider's project ID.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Reason for blocking the email address.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which the blocklist is created. Defaults to the provider's region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of the blocklist. Possible values are:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("scaleway:tem/blockedList:BlockedList")
class BlockedList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 reason: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages blocklisted email addresses for a Scaleway Transactional Email Domain.
        For more information refer to the [API documentation](https://www.scaleway.com/en/developers/api/transactional-email/#post-transactional-email-v1alpha1-regions-region-blocklists).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        test = scaleway.tem.BlockedList("test",
            domain_id="fr-par/12345678-1234-1234-1234-123456789abc",
            email="spam@example.com",
            type="mailbox_full",
            reason="Spam detected",
            region="fr-par")
        ```

        ## Import

        Blocklists can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:tem/blockedList:BlockedList test fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] domain_id: The ID of the domain affected by the blocklist. Must be in the format `{region}/{domain_id}`.
        :param pulumi.Input[builtins.str] email: The email address to block.
        :param pulumi.Input[builtins.str] project_id: The ID of the project this blocklist belongs to. Defaults to the provider's project ID.
        :param pulumi.Input[builtins.str] reason: Reason for blocking the email address.
        :param pulumi.Input[builtins.str] region: The region in which the blocklist is created. Defaults to the provider's region.
        :param pulumi.Input[builtins.str] type: Type of the blocklist. Possible values are:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BlockedListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages blocklisted email addresses for a Scaleway Transactional Email Domain.
        For more information refer to the [API documentation](https://www.scaleway.com/en/developers/api/transactional-email/#post-transactional-email-v1alpha1-regions-region-blocklists).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        test = scaleway.tem.BlockedList("test",
            domain_id="fr-par/12345678-1234-1234-1234-123456789abc",
            email="spam@example.com",
            type="mailbox_full",
            reason="Spam detected",
            region="fr-par")
        ```

        ## Import

        Blocklists can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:tem/blockedList:BlockedList test fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param BlockedListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BlockedListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 reason: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BlockedListArgs.__new__(BlockedListArgs)

            if domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'domain_id'")
            __props__.__dict__["domain_id"] = domain_id
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["reason"] = reason
            __props__.__dict__["region"] = region
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(BlockedList, __self__).__init__(
            'scaleway:tem/blockedList:BlockedList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain_id: Optional[pulumi.Input[builtins.str]] = None,
            email: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            reason: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'BlockedList':
        """
        Get an existing BlockedList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] domain_id: The ID of the domain affected by the blocklist. Must be in the format `{region}/{domain_id}`.
        :param pulumi.Input[builtins.str] email: The email address to block.
        :param pulumi.Input[builtins.str] project_id: The ID of the project this blocklist belongs to. Defaults to the provider's project ID.
        :param pulumi.Input[builtins.str] reason: Reason for blocking the email address.
        :param pulumi.Input[builtins.str] region: The region in which the blocklist is created. Defaults to the provider's region.
        :param pulumi.Input[builtins.str] type: Type of the blocklist. Possible values are:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BlockedListState.__new__(_BlockedListState)

        __props__.__dict__["domain_id"] = domain_id
        __props__.__dict__["email"] = email
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["reason"] = reason
        __props__.__dict__["region"] = region
        __props__.__dict__["type"] = type
        return BlockedList(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the domain affected by the blocklist. Must be in the format `{region}/{domain_id}`.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[builtins.str]:
        """
        The email address to block.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project this blocklist belongs to. Defaults to the provider's project ID.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def reason(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Reason for blocking the email address.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The region in which the blocklist is created. Defaults to the provider's region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Type of the blocklist. Possible values are:
        """
        return pulumi.get(self, "type")

