"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from typing import Mapping, Optional, Union

from friendli.core import models, utils
from friendli.core._hooks import HookContext
from friendli.core.types import UNSET, OptionalNullable
from friendli.core.utils import get_security_from_env
from friendli.core.utils.unmarshal_json_response import unmarshal_json_response

from .basesdk import AsyncSDK, BaseSDK, SyncSDK


class BaseAudio(BaseSDK):
    pass


class SyncAudio(BaseAudio, SyncSDK):
    def transcribe(
        self,
        *,
        file: Union[
            models.DedicatedAudioTranscriptionBodyFile,
            models.DedicatedAudioTranscriptionBodyFileTypedDict,
        ],
        model: str,
        x_friendli_team: OptionalNullable[str] = UNSET,
        chunking_strategy: OptionalNullable[
            Union[models.ChunkingStrategy, models.ChunkingStrategyTypedDict]
        ] = UNSET,
        language: OptionalNullable[str] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.DedicatedAudioTranscriptionSuccess:
        """Audio transcriptions

        Given an audio file, the model transcribes it into text.

        :param file: The audio file object (not file name) to transcribe, in one of these formats: mp3, wav, flac, ogg, and many other standard audio formats.
        :param model: ID of target endpoint. If you want to send request to specific adapter, use the format \\"YOUR_ENDPOINT_ID:YOUR_ADAPTER_ROUTE\\". Otherwise, you can just use \\"YOUR_ENDPOINT_ID\\" alone.
        :param x_friendli_team: ID of team to run requests as (optional parameter).
        :param chunking_strategy: Controls how the audio is cut into chunks. When set to `\\"auto\\"`, the server first normalizes loudness and then uses voice activity detection (VAD) to choose boundaries. `server_vad` object can be provided to tweak VAD detection parameters manually. If unset, the audio is transcribed as a single block.
        :param language: The language of the input audio. Supplying the input language in [ISO-639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) (e.g. `en`) format will improve accuracy and latency.
        :param temperature: The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms
        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)
        request = models.DedicatedAudioTranscriptionsRequest(
            x_friendli_team=x_friendli_team,
            dedicated_audio_transcription_body=models.DedicatedAudioTranscriptionBody(
                file=utils.get_pydantic_model(
                    file, models.DedicatedAudioTranscriptionBodyFile
                ),
                model=model,
                chunking_strategy=utils.get_pydantic_model(
                    chunking_strategy, OptionalNullable[models.ChunkingStrategy]
                ),
                language=language,
                temperature=temperature,
            ),
        )
        req = self._build_request(
            method="POST",
            path="/dedicated/v1/audio/transcriptions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.dedicated_audio_transcription_body,
                False,
                False,
                "multipart",
                models.DedicatedAudioTranscriptionBody,
            ),
            timeout_ms=timeout_ms,
        )
        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )
        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])
        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="dedicatedAudioTranscriptions",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.DedicatedAudioTranscriptionSuccess, http_res
            )
        if utils.match_response(http_res, ["422", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        raise models.SDKError("Unexpected response received", http_res)


class AsyncAudio(BaseAudio, AsyncSDK):
    async def transcribe(
        self,
        *,
        file: Union[
            models.DedicatedAudioTranscriptionBodyFile,
            models.DedicatedAudioTranscriptionBodyFileTypedDict,
        ],
        model: str,
        x_friendli_team: OptionalNullable[str] = UNSET,
        chunking_strategy: OptionalNullable[
            Union[models.ChunkingStrategy, models.ChunkingStrategyTypedDict]
        ] = UNSET,
        language: OptionalNullable[str] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.DedicatedAudioTranscriptionSuccess:
        """Audio transcriptions

        Given an audio file, the model transcribes it into text.

        :param file: The audio file object (not file name) to transcribe, in one of these formats: mp3, wav, flac, ogg, and many other standard audio formats.
        :param model: ID of target endpoint. If you want to send request to specific adapter, use the format \\"YOUR_ENDPOINT_ID:YOUR_ADAPTER_ROUTE\\". Otherwise, you can just use \\"YOUR_ENDPOINT_ID\\" alone.
        :param x_friendli_team: ID of team to run requests as (optional parameter).
        :param chunking_strategy: Controls how the audio is cut into chunks. When set to `\\"auto\\"`, the server first normalizes loudness and then uses voice activity detection (VAD) to choose boundaries. `server_vad` object can be provided to tweak VAD detection parameters manually. If unset, the audio is transcribed as a single block.
        :param language: The language of the input audio. Supplying the input language in [ISO-639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) (e.g. `en`) format will improve accuracy and latency.
        :param temperature: The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms
        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)
        request = models.DedicatedAudioTranscriptionsRequest(
            x_friendli_team=x_friendli_team,
            dedicated_audio_transcription_body=models.DedicatedAudioTranscriptionBody(
                file=utils.get_pydantic_model(
                    file, models.DedicatedAudioTranscriptionBodyFile
                ),
                model=model,
                chunking_strategy=utils.get_pydantic_model(
                    chunking_strategy, OptionalNullable[models.ChunkingStrategy]
                ),
                language=language,
                temperature=temperature,
            ),
        )
        req = self._build_request_async(
            method="POST",
            path="/dedicated/v1/audio/transcriptions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.dedicated_audio_transcription_body,
                False,
                False,
                "multipart",
                models.DedicatedAudioTranscriptionBody,
            ),
            timeout_ms=timeout_ms,
        )
        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )
        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])
        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="dedicatedAudioTranscriptions",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.DedicatedAudioTranscriptionSuccess, http_res
            )
        if utils.match_response(http_res, ["422", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        raise models.SDKError("Unexpected response received", http_res)
