"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from friendli.core.container_chat import AsyncContainerChat, SyncContainerChat
from friendli.core.container_completions import (
    AsyncContainerCompletions,
    SyncContainerCompletions,
)
from friendli.core.container_image import AsyncContainerImage, SyncContainerImage
from friendli.core.container_token import AsyncContainerToken, SyncContainerToken

from .basesdk import AsyncSDK, BaseSDK, SyncSDK
from .sdkconfiguration import SDKConfiguration


class BaseContainer(BaseSDK):
    def __init__(self, sdk_config: SDKConfiguration) -> None:
        BaseSDK.__init__(self, sdk_config)
        self.sdk_configuration = sdk_config
        self._init_sdks()

    def _init_sdks(self) -> None: ...


class SyncContainer(BaseContainer, SyncSDK):
    chat: SyncContainerChat
    completions: SyncContainerCompletions
    token: SyncContainerToken
    image: SyncContainerImage

    def _init_sdks(self):
        self.chat = SyncContainerChat(self.sdk_configuration)
        self.completions = SyncContainerCompletions(self.sdk_configuration)
        self.token = SyncContainerToken(self.sdk_configuration)
        self.image = SyncContainerImage(self.sdk_configuration)


class AsyncContainer(BaseContainer, AsyncSDK):
    chat: AsyncContainerChat
    completions: AsyncContainerCompletions
    token: AsyncContainerToken
    image: AsyncContainerImage

    def _init_sdks(self):
        self.chat = AsyncContainerChat(self.sdk_configuration)
        self.completions = AsyncContainerCompletions(self.sdk_configuration)
        self.token = AsyncContainerToken(self.sdk_configuration)
        self.image = AsyncContainerImage(self.sdk_configuration)
