"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from friendli.core.audio import AsyncAudio, SyncAudio
from friendli.core.dedicated_chat import AsyncDedicatedChat, SyncDedicatedChat
from friendli.core.dedicated_completions import (
    AsyncDedicatedCompletions,
    SyncDedicatedCompletions,
)
from friendli.core.dedicated_image import AsyncDedicatedImage, SyncDedicatedImage
from friendli.core.dedicated_token import AsyncDedicatedToken, SyncDedicatedToken
from friendli.core.endpoint import AsyncEndpoint, SyncEndpoint

from .basesdk import AsyncSDK, BaseSDK, SyncSDK
from .sdkconfiguration import SDKConfiguration


class BaseDedicated(BaseSDK):
    def __init__(self, sdk_config: SDKConfiguration) -> None:
        BaseSDK.__init__(self, sdk_config)
        self.sdk_configuration = sdk_config
        self._init_sdks()

    def _init_sdks(self) -> None: ...


class SyncDedicated(BaseDedicated, SyncSDK):
    chat: SyncDedicatedChat
    completions: SyncDedicatedCompletions
    token: SyncDedicatedToken
    image: SyncDedicatedImage
    audio: SyncAudio
    endpoint: SyncEndpoint

    def _init_sdks(self):
        self.chat = SyncDedicatedChat(self.sdk_configuration)
        self.completions = SyncDedicatedCompletions(self.sdk_configuration)
        self.token = SyncDedicatedToken(self.sdk_configuration)
        self.image = SyncDedicatedImage(self.sdk_configuration)
        self.audio = SyncAudio(self.sdk_configuration)
        self.endpoint = SyncEndpoint(self.sdk_configuration)


class AsyncDedicated(BaseDedicated, AsyncSDK):
    chat: AsyncDedicatedChat
    completions: AsyncDedicatedCompletions
    token: AsyncDedicatedToken
    image: AsyncDedicatedImage
    audio: AsyncAudio
    endpoint: AsyncEndpoint

    def _init_sdks(self):
        self.chat = AsyncDedicatedChat(self.sdk_configuration)
        self.completions = AsyncDedicatedCompletions(self.sdk_configuration)
        self.token = AsyncDedicatedToken(self.sdk_configuration)
        self.image = AsyncDedicatedImage(self.sdk_configuration)
        self.audio = AsyncAudio(self.sdk_configuration)
        self.endpoint = AsyncEndpoint(self.sdk_configuration)
