"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

from typing import List, Literal

import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing_extensions import Annotated, NotRequired, TypedDict

from friendli.core.types import (
    UNSET,
    UNSET_SENTINEL,
    BaseModel,
    Nullable,
    OptionalNullable,
)
from friendli.core.utils import validate_const

from .assistantmessagetoolcall import (
    AssistantMessageToolCall,
    AssistantMessageToolCallTypedDict,
)


class AssistantMessageTypedDict(TypedDict):
    role: Literal["assistant"]
    "The role of the messages author."
    content: NotRequired[Nullable[str]]
    "The content of assistant message. Required unless `tool_calls` is specified."
    name: NotRequired[Nullable[str]]
    "The name for the participant to distinguish between participants with the same role."
    tool_calls: NotRequired[Nullable[List[AssistantMessageToolCallTypedDict]]]


class AssistantMessage(BaseModel):
    ROLE: Annotated[
        Annotated[Literal["assistant"], AfterValidator(validate_const("assistant"))],
        pydantic.Field(alias="role"),
    ] = "assistant"
    "The role of the messages author."
    content: OptionalNullable[str] = UNSET
    "The content of assistant message. Required unless `tool_calls` is specified."
    name: OptionalNullable[str] = UNSET
    "The name for the participant to distinguish between participants with the same role."
    tool_calls: OptionalNullable[List[AssistantMessageToolCall]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["content", "name", "tool_calls"]
        nullable_fields = ["content", "name", "tool_calls"]
        null_default_fields = []
        serialized = handler(self)
        m = {}
        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)
            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )
            if (val is not None and val != UNSET_SENTINEL) or (
                val != UNSET_SENTINEL
                and (k not in optional_fields or (optional_nullable and is_set))
            ):
                m[k] = val
        return m
