"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

from typing import Literal

from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict

from friendli.core.types import (
    UNSET,
    UNSET_SENTINEL,
    BaseModel,
    Nullable,
    OptionalNullable,
)

from .chatchoicemessage import ChatChoiceMessage, ChatChoiceMessageTypedDict
from .chatlogprobs import ChatLogprobs, ChatLogprobsTypedDict

ChatChoiceFinishReason = Literal["stop", "length", "tool_calls"]
"Termination condition of the generation. `stop` means the API returned the full chat completions generated by the model without running into any limits.\n`length` means the generation exceeded `max_tokens` or the conversation exceeded the max context length.\n`tool_calls` means the API has generated tool calls.\n"


class ChatChoiceTypedDict(TypedDict):
    finish_reason: ChatChoiceFinishReason
    "Termination condition of the generation. `stop` means the API returned the full chat completions generated by the model without running into any limits.\n    `length` means the generation exceeded `max_tokens` or the conversation exceeded the max context length.\n    `tool_calls` means the API has generated tool calls.\n    "
    index: int
    "The index of the choice in the list of generated choices."
    message: ChatChoiceMessageTypedDict
    logprobs: NotRequired[Nullable[ChatLogprobsTypedDict]]


class ChatChoice(BaseModel):
    finish_reason: ChatChoiceFinishReason
    "Termination condition of the generation. `stop` means the API returned the full chat completions generated by the model without running into any limits.\n    `length` means the generation exceeded `max_tokens` or the conversation exceeded the max context length.\n    `tool_calls` means the API has generated tool calls.\n    "
    index: int
    "The index of the choice in the list of generated choices."
    message: ChatChoiceMessage
    logprobs: OptionalNullable[ChatLogprobs] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["logprobs"]
        nullable_fields = ["logprobs"]
        null_default_fields = []
        serialized = handler(self)
        m = {}
        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)
            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )
            if (val is not None and val != UNSET_SENTINEL) or (
                val != UNSET_SENTINEL
                and (k not in optional_fields or (optional_nullable and is_set))
            ):
                m[k] = val
        return m
