"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

from typing import List

from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict

from friendli.core.types import (
    UNSET,
    UNSET_SENTINEL,
    BaseModel,
    Nullable,
    OptionalNullable,
)

from .toolcallresult import ToolCallResult, ToolCallResultTypedDict


class ChatChoiceMessageTypedDict(TypedDict):
    role: str
    "Role of the generated message author, in this case `assistant`."
    content: NotRequired[Nullable[str]]
    "The contents of the assistant message."
    tool_calls: NotRequired[Nullable[List[ToolCallResultTypedDict]]]


class ChatChoiceMessage(BaseModel):
    role: str
    "Role of the generated message author, in this case `assistant`."
    content: OptionalNullable[str] = UNSET
    "The contents of the assistant message."
    tool_calls: OptionalNullable[List[ToolCallResult]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["content", "tool_calls"]
        nullable_fields = ["content", "tool_calls"]
        null_default_fields = []
        serialized = handler(self)
        m = {}
        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)
            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )
            if (val is not None and val != UNSET_SENTINEL) or (
                val != UNSET_SENTINEL
                and (k not in optional_fields or (optional_nullable and is_set))
            ):
                m[k] = val
        return m
