"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

from typing import List, Literal

from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict

from friendli.core.types import (
    UNSET,
    UNSET_SENTINEL,
    BaseModel,
    Nullable,
    OptionalNullable,
)

from .completionslogprobs import CompletionsLogprobs, CompletionsLogprobsTypedDict

CompletionsChoiceFinishReason = Literal["stop", "length"]
"Termination condition of the generation. `stop` means the API returned the full completions generated by the model without running into any limits. `length` means the generation exceeded `max_tokens` or the conversation exceeded the max context length."


class CompletionsChoiceTypedDict(TypedDict):
    finish_reason: CompletionsChoiceFinishReason
    "Termination condition of the generation. `stop` means the API returned the full completions generated by the model without running into any limits. `length` means the generation exceeded `max_tokens` or the conversation exceeded the max context length."
    index: int
    "The index of the choice in the list of generated choices."
    seed: int
    "Random seed used for the generation."
    text: str
    "Generated text output."
    tokens: List[int]
    "Generated output tokens."
    logprobs: NotRequired[Nullable[CompletionsLogprobsTypedDict]]


class CompletionsChoice(BaseModel):
    finish_reason: CompletionsChoiceFinishReason
    "Termination condition of the generation. `stop` means the API returned the full completions generated by the model without running into any limits. `length` means the generation exceeded `max_tokens` or the conversation exceeded the max context length."
    index: int
    "The index of the choice in the list of generated choices."
    seed: int
    "Random seed used for the generation."
    text: str
    "Generated text output."
    tokens: List[int]
    "Generated output tokens."
    logprobs: OptionalNullable[CompletionsLogprobs] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["logprobs"]
        nullable_fields = ["logprobs"]
        null_default_fields = []
        serialized = handler(self)
        m = {}
        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)
            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )
            if (val is not None and val != UNSET_SENTINEL) or (
                val != UNSET_SENTINEL
                and (k not in optional_fields or (optional_nullable and is_set))
            ):
                m[k] = val
        return m
