"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

from typing import Literal

from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict

from friendli.core.types import (
    UNSET,
    UNSET_SENTINEL,
    BaseModel,
    Nullable,
    OptionalNullable,
)

ContainerImageGenerationBodyResponseFormat = Literal["raw", "jpeg"]
"The format in which the generated image will be returned. One of `raw` and `jpeg`."


class ContainerImageGenerationBodyTypedDict(TypedDict):
    guidance_scale: float
    "Adjusts the alignment of the generated image with the input prompt. Higher values (e.g., 8-10) make the output more faithful to the prompt, while lower values (e.g., 1-5) encourage more creative freedom. This parameter may be irrelevant for certain models, such as `FLUX.Schnell`."
    num_inference_steps: int
    "The number of inference steps to use during image generation. Supported range: [1, 50]."
    prompt: str
    "A text description of the desired image."
    model: NotRequired[Nullable[str]]
    "Routes the request to a specific adapter."
    response_format: NotRequired[Nullable[ContainerImageGenerationBodyResponseFormat]]
    "The format in which the generated image will be returned. One of `raw` and `jpeg`."
    seed: NotRequired[Nullable[int]]
    "The seed to use for image generation."


class ContainerImageGenerationBody(BaseModel):
    guidance_scale: float
    "Adjusts the alignment of the generated image with the input prompt. Higher values (e.g., 8-10) make the output more faithful to the prompt, while lower values (e.g., 1-5) encourage more creative freedom. This parameter may be irrelevant for certain models, such as `FLUX.Schnell`."
    num_inference_steps: int
    "The number of inference steps to use during image generation. Supported range: [1, 50]."
    prompt: str
    "A text description of the desired image."
    model: OptionalNullable[str] = UNSET
    "Routes the request to a specific adapter."
    response_format: OptionalNullable[ContainerImageGenerationBodyResponseFormat] = (
        "jpeg"
    )
    "The format in which the generated image will be returned. One of `raw` and `jpeg`."
    seed: OptionalNullable[int] = UNSET
    "The seed to use for image generation."

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["model", "response_format", "seed"]
        nullable_fields = ["model", "response_format", "seed"]
        null_default_fields = []
        serialized = handler(self)
        m = {}
        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)
            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )
            if (val is not None and val != UNSET_SENTINEL) or (
                val != UNSET_SENTINEL
                and (k not in optional_fields or (optional_nullable and is_set))
            ):
                m[k] = val
        return m
