"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

import pydantic
from typing_extensions import Annotated, TypedDict

from friendli.core.types import BaseModel

from .dedicateddatasetmodality import (
    DedicatedDatasetModality,
    DedicatedDatasetModalityTypedDict,
)


class DatasetInfoTypedDict(TypedDict):
    """Dataset info."""

    created_at: int
    "Unix timestamp (in seconds) of when the dataset was created."
    id: str
    "ID of the dataset."
    modality: DedicatedDatasetModalityTypedDict
    "Dataset modality."
    name: str
    "Name of the dataset."
    updated_at: int
    "Unix timestamp (in seconds) of when the dataset was last modified."


class DatasetInfo(BaseModel):
    """Dataset info."""

    created_at: Annotated[int, pydantic.Field(alias="createdAt")]
    "Unix timestamp (in seconds) of when the dataset was created."
    id: str
    "ID of the dataset."
    modality: DedicatedDatasetModality
    "Dataset modality."
    name: str
    "Name of the dataset."
    updated_at: Annotated[int, pydantic.Field(alias="updatedAt")]
    "Unix timestamp (in seconds) of when the dataset was last modified."
