"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

import io
from typing import IO, Optional, Union

import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict

from friendli.core.types import (
    UNSET,
    UNSET_SENTINEL,
    BaseModel,
    Nullable,
    OptionalNullable,
)
from friendli.core.utils import FieldMetadata, MultipartFormMetadata

from .servervadchunkingstrategy import (
    ServerVadChunkingStrategy,
    ServerVadChunkingStrategyTypedDict,
)


class DedicatedAudioTranscriptionBodyFileTypedDict(TypedDict):
    file_name: str
    content: Union[bytes, IO[bytes], io.BufferedReader]
    content_type: NotRequired[str]


class DedicatedAudioTranscriptionBodyFile(BaseModel):
    file_name: Annotated[
        str, pydantic.Field(alias="fileName"), FieldMetadata(multipart=True)
    ]
    content: Annotated[
        Union[bytes, IO[bytes], io.BufferedReader],
        pydantic.Field(alias=""),
        FieldMetadata(multipart=MultipartFormMetadata(content=True)),
    ]
    content_type: Annotated[
        Optional[str],
        pydantic.Field(alias="Content-Type"),
        FieldMetadata(multipart=True),
    ] = None


ChunkingStrategyTypedDict = TypeAliasType(
    "ChunkingStrategyTypedDict", Union[ServerVadChunkingStrategyTypedDict, str]
)
'Controls how the audio is cut into chunks. When set to `\\"auto\\"`, the server first normalizes loudness and then uses voice activity detection (VAD) to choose boundaries. `server_vad` object can be provided to tweak VAD detection parameters manually. If unset, the audio is transcribed as a single block.'
ChunkingStrategy = TypeAliasType(
    "ChunkingStrategy", Union[ServerVadChunkingStrategy, str]
)
'Controls how the audio is cut into chunks. When set to `\\"auto\\"`, the server first normalizes loudness and then uses voice activity detection (VAD) to choose boundaries. `server_vad` object can be provided to tweak VAD detection parameters manually. If unset, the audio is transcribed as a single block.'


class DedicatedAudioTranscriptionBodyTypedDict(TypedDict):
    file: DedicatedAudioTranscriptionBodyFileTypedDict
    "The audio file object (not file name) to transcribe, in one of these formats: mp3, wav, flac, ogg, and many other standard audio formats."
    model: str
    'ID of target endpoint. If you want to send request to specific adapter, use the format \\"YOUR_ENDPOINT_ID:YOUR_ADAPTER_ROUTE\\". Otherwise, you can just use \\"YOUR_ENDPOINT_ID\\" alone.'
    chunking_strategy: NotRequired[Nullable[ChunkingStrategyTypedDict]]
    'Controls how the audio is cut into chunks. When set to `\\"auto\\"`, the server first normalizes loudness and then uses voice activity detection (VAD) to choose boundaries. `server_vad` object can be provided to tweak VAD detection parameters manually. If unset, the audio is transcribed as a single block.'
    language: NotRequired[Nullable[str]]
    "The language of the input audio. Supplying the input language in [ISO-639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) (e.g. `en`) format will improve accuracy and latency."
    temperature: NotRequired[Nullable[float]]
    "The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic."


class DedicatedAudioTranscriptionBody(BaseModel):
    file: Annotated[
        DedicatedAudioTranscriptionBodyFile,
        FieldMetadata(multipart=MultipartFormMetadata(file=True)),
    ]
    "The audio file object (not file name) to transcribe, in one of these formats: mp3, wav, flac, ogg, and many other standard audio formats."
    model: Annotated[str, FieldMetadata(multipart=True)]
    'ID of target endpoint. If you want to send request to specific adapter, use the format \\"YOUR_ENDPOINT_ID:YOUR_ADAPTER_ROUTE\\". Otherwise, you can just use \\"YOUR_ENDPOINT_ID\\" alone.'
    chunking_strategy: Annotated[
        OptionalNullable[ChunkingStrategy],
        FieldMetadata(multipart=MultipartFormMetadata(json=True)),
    ] = UNSET
    'Controls how the audio is cut into chunks. When set to `\\"auto\\"`, the server first normalizes loudness and then uses voice activity detection (VAD) to choose boundaries. `server_vad` object can be provided to tweak VAD detection parameters manually. If unset, the audio is transcribed as a single block.'
    language: Annotated[OptionalNullable[str], FieldMetadata(multipart=True)] = UNSET
    "The language of the input audio. Supplying the input language in [ISO-639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) (e.g. `en`) format will improve accuracy and latency."
    temperature: Annotated[OptionalNullable[float], FieldMetadata(multipart=True)] = (
        UNSET
    )
    "The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic."

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["chunking_strategy", "language", "temperature"]
        nullable_fields = ["chunking_strategy", "language", "temperature"]
        null_default_fields = []
        serialized = handler(self)
        m = {}
        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)
            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )
            if (val is not None and val != UNSET_SENTINEL) or (
                val != UNSET_SENTINEL
                and (k not in optional_fields or (optional_nullable and is_set))
            ):
                m[k] = val
        return m
