"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict

from friendli.core.types import (
    UNSET,
    UNSET_SENTINEL,
    BaseModel,
    Nullable,
    OptionalNullable,
)

from .autoscalingpolicy import AutoscalingPolicy, AutoscalingPolicyTypedDict
from .endpointadvancedconfig import (
    EndpointAdvancedConfig,
    EndpointAdvancedConfigTypedDict,
)
from .endpointsimplescaleconfig import (
    EndpointSimplescaleConfig,
    EndpointSimplescaleConfigTypedDict,
)


class DedicatedEndpointCreateBodyTypedDict(TypedDict):
    """Dedicated endpoint create request."""

    advanced: EndpointAdvancedConfigTypedDict
    "Endpoint advanced config."
    hf_model_repo: str
    "HF ID of the model."
    instance_option_id: str
    "The ID of the instance option."
    name: str
    "The name of the endpoint."
    project_id: str
    "The ID of the project that owns the endpoint."
    autoscaling_policy: NotRequired[Nullable[AutoscalingPolicyTypedDict]]
    "The auto scaling configuration of the endpoint."
    hf_model_repo_revision: NotRequired[Nullable[str]]
    "HF commit hash of the model."
    initial_version_comment: NotRequired[Nullable[str]]
    "The comment for the initial version."
    simplescale: NotRequired[Nullable[EndpointSimplescaleConfigTypedDict]]
    "The simple scaling configuration of the endpoint."


class DedicatedEndpointCreateBody(BaseModel):
    """Dedicated endpoint create request."""

    advanced: EndpointAdvancedConfig
    "Endpoint advanced config."
    hf_model_repo: Annotated[str, pydantic.Field(alias="hfModelRepo")]
    "HF ID of the model."
    instance_option_id: Annotated[str, pydantic.Field(alias="instanceOptionId")]
    "The ID of the instance option."
    name: str
    "The name of the endpoint."
    project_id: Annotated[str, pydantic.Field(alias="projectId")]
    "The ID of the project that owns the endpoint."
    autoscaling_policy: Annotated[
        OptionalNullable[AutoscalingPolicy], pydantic.Field(alias="autoscalingPolicy")
    ] = UNSET
    "The auto scaling configuration of the endpoint."
    hf_model_repo_revision: Annotated[
        OptionalNullable[str], pydantic.Field(alias="hfModelRepoRevision")
    ] = UNSET
    "HF commit hash of the model."
    initial_version_comment: Annotated[
        OptionalNullable[str], pydantic.Field(alias="initialVersionComment")
    ] = UNSET
    "The comment for the initial version."
    simplescale: OptionalNullable[EndpointSimplescaleConfig] = UNSET
    "The simple scaling configuration of the endpoint."

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "autoscalingPolicy",
            "hfModelRepoRevision",
            "initialVersionComment",
            "simplescale",
        ]
        nullable_fields = [
            "autoscalingPolicy",
            "hfModelRepoRevision",
            "initialVersionComment",
            "simplescale",
        ]
        null_default_fields = []
        serialized = handler(self)
        m = {}
        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)
            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )
            if (val is not None and val != UNSET_SENTINEL) or (
                val != UNSET_SENTINEL
                and (k not in optional_fields or (optional_nullable and is_set))
            ):
                m[k] = val
        return m
