"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict

from friendli.core.types import (
    UNSET,
    UNSET_SENTINEL,
    BaseModel,
    Nullable,
    OptionalNullable,
)


class DedicatedEndpointSpecTypedDict(TypedDict):
    """Dedicated endpoint specification."""

    autoscaling_cooldown: int
    "The cooldown period in seconds between scaling operations."
    autoscaling_max: int
    "The maximum number of replicas allowed."
    autoscaling_min: int
    "The minimum number of replicas to maintain."
    creator_id: str
    "The ID of the user who created the endpoint."
    gpu_type: str
    "The type of GPU to use for the endpoint."
    max_batch_size: int
    "The maximum batch size for inference requests."
    name: str
    "The name of the endpoint."
    num_gpu: int
    "The number of GPUs to use per replica."
    project_id: str
    "The ID of the project that owns the endpoint."
    team_id: str
    "The ID of the team that owns the endpoint."
    tokenizer_add_special_tokens: bool
    "Whether to add special tokens in tokenizer input."
    tokenizer_skip_special_tokens: bool
    "Whether to skip special tokens in tokenizer output."
    curr_replica_cnt: NotRequired[Nullable[int]]
    "The current number of replicas."
    desired_replica_cnt: NotRequired[Nullable[int]]
    "The desired number of replicas."
    instance_id: NotRequired[Nullable[str]]
    "The ID of the instance."
    max_input_length: NotRequired[Nullable[int]]
    "The maximum allowed input length."
    updated_replica_cnt: NotRequired[Nullable[int]]
    "The updated number of replicas."


class DedicatedEndpointSpec(BaseModel):
    """Dedicated endpoint specification."""

    autoscaling_cooldown: Annotated[int, pydantic.Field(alias="autoscalingCooldown")]
    "The cooldown period in seconds between scaling operations."
    autoscaling_max: Annotated[int, pydantic.Field(alias="autoscalingMax")]
    "The maximum number of replicas allowed."
    autoscaling_min: Annotated[int, pydantic.Field(alias="autoscalingMin")]
    "The minimum number of replicas to maintain."
    creator_id: Annotated[str, pydantic.Field(alias="creatorId")]
    "The ID of the user who created the endpoint."
    gpu_type: Annotated[str, pydantic.Field(alias="gpuType")]
    "The type of GPU to use for the endpoint."
    max_batch_size: Annotated[int, pydantic.Field(alias="maxBatchSize")]
    "The maximum batch size for inference requests."
    name: str
    "The name of the endpoint."
    num_gpu: Annotated[int, pydantic.Field(alias="numGpu")]
    "The number of GPUs to use per replica."
    project_id: Annotated[str, pydantic.Field(alias="projectId")]
    "The ID of the project that owns the endpoint."
    team_id: Annotated[str, pydantic.Field(alias="teamId")]
    "The ID of the team that owns the endpoint."
    tokenizer_add_special_tokens: Annotated[
        bool, pydantic.Field(alias="tokenizerAddSpecialTokens")
    ]
    "Whether to add special tokens in tokenizer input."
    tokenizer_skip_special_tokens: Annotated[
        bool, pydantic.Field(alias="tokenizerSkipSpecialTokens")
    ]
    "Whether to skip special tokens in tokenizer output."
    curr_replica_cnt: Annotated[
        OptionalNullable[int], pydantic.Field(alias="currReplicaCnt")
    ] = UNSET
    "The current number of replicas."
    desired_replica_cnt: Annotated[
        OptionalNullable[int], pydantic.Field(alias="desiredReplicaCnt")
    ] = UNSET
    "The desired number of replicas."
    instance_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="instanceId")
    ] = UNSET
    "The ID of the instance."
    max_input_length: Annotated[
        OptionalNullable[int], pydantic.Field(alias="maxInputLength")
    ] = UNSET
    "The maximum allowed input length."
    updated_replica_cnt: Annotated[
        OptionalNullable[int], pydantic.Field(alias="updatedReplicaCnt")
    ] = UNSET
    "The updated number of replicas."

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "currReplicaCnt",
            "desiredReplicaCnt",
            "instanceId",
            "maxInputLength",
            "updatedReplicaCnt",
        ]
        nullable_fields = [
            "currReplicaCnt",
            "desiredReplicaCnt",
            "instanceId",
            "maxInputLength",
            "updatedReplicaCnt",
        ]
        null_default_fields = []
        serialized = handler(self)
        m = {}
        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)
            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )
            if (val is not None and val != UNSET_SENTINEL) or (
                val != UNSET_SENTINEL
                and (k not in optional_fields or (optional_nullable and is_set))
            ):
                m[k] = val
        return m
