"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

from datetime import datetime
from typing import Literal

import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict

from friendli.core.types import (
    UNSET,
    UNSET_SENTINEL,
    BaseModel,
    Nullable,
    OptionalNullable,
)

from .inferencedeploymenterrorcode import InferenceDeploymentErrorCode
from .inferencedeploymentstatus import InferenceDeploymentStatus

Phase = Literal[
    "REQUESTING_VIRTUAL_MACHINE", "DOWNLOADING_MODEL", "ENGINE_INITIALIZING"
]
"The current phase of the endpoint."


class DedicatedEndpointStatusTypedDict(TypedDict):
    """Dedicated endpoint status."""

    created_at: datetime
    "When the endpoint was created."
    status: InferenceDeploymentStatus
    "Status of inference deployment."
    error_code: NotRequired[Nullable[InferenceDeploymentErrorCode]]
    "Error code if deployment failed."
    phase: NotRequired[Nullable[Phase]]
    "The current phase of the endpoint."
    updated_at: NotRequired[Nullable[datetime]]
    "When the endpoint was last updated."


class DedicatedEndpointStatus(BaseModel):
    """Dedicated endpoint status."""

    created_at: Annotated[datetime, pydantic.Field(alias="createdAt")]
    "When the endpoint was created."
    status: InferenceDeploymentStatus
    "Status of inference deployment."
    error_code: Annotated[
        OptionalNullable[InferenceDeploymentErrorCode],
        pydantic.Field(alias="errorCode"),
    ] = UNSET
    "Error code if deployment failed."
    phase: OptionalNullable[Phase] = UNSET
    "The current phase of the endpoint."
    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    "When the endpoint was last updated."

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["errorCode", "phase", "updatedAt"]
        nullable_fields = ["errorCode", "phase", "updatedAt"]
        null_default_fields = []
        serialized = handler(self)
        m = {}
        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)
            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )
            if (val is not None and val != UNSET_SENTINEL) or (
                val != UNSET_SENTINEL
                and (k not in optional_fields or (optional_nullable and is_set))
            ):
                m[k] = val
        return m
