"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict

from friendli.core.types import (
    UNSET,
    UNSET_SENTINEL,
    BaseModel,
    Nullable,
    OptionalNullable,
)

from .autoscalingpolicy import AutoscalingPolicy, AutoscalingPolicyTypedDict
from .endpointadvancedconfig import (
    EndpointAdvancedConfig,
    EndpointAdvancedConfigTypedDict,
)
from .endpointsimplescaleconfig import (
    EndpointSimplescaleConfig,
    EndpointSimplescaleConfigTypedDict,
)


class DedicatedEndpointUpdateBodyTypedDict(TypedDict):
    """Dedicated endpoint update request."""

    advanced: NotRequired[Nullable[EndpointAdvancedConfigTypedDict]]
    "The advanced configuration of the endpoint."
    autoscaling_policy: NotRequired[Nullable[AutoscalingPolicyTypedDict]]
    "The auto scaling configuration of the endpoint."
    hf_model_repo: NotRequired[Nullable[str]]
    "HF ID of the model."
    hf_model_repo_revision: NotRequired[Nullable[str]]
    "HF commit hash of the model."
    instance_option_id: NotRequired[Nullable[str]]
    "The ID of the instance option."
    name: NotRequired[Nullable[str]]
    "The name of the endpoint."
    new_version_comment: NotRequired[Nullable[str]]
    "Comment for the new version."
    simplescale: NotRequired[Nullable[EndpointSimplescaleConfigTypedDict]]
    "The simple scaling configuration of the endpoint."


class DedicatedEndpointUpdateBody(BaseModel):
    """Dedicated endpoint update request."""

    advanced: OptionalNullable[EndpointAdvancedConfig] = UNSET
    "The advanced configuration of the endpoint."
    autoscaling_policy: Annotated[
        OptionalNullable[AutoscalingPolicy], pydantic.Field(alias="autoscalingPolicy")
    ] = UNSET
    "The auto scaling configuration of the endpoint."
    hf_model_repo: Annotated[
        OptionalNullable[str], pydantic.Field(alias="hfModelRepo")
    ] = UNSET
    "HF ID of the model."
    hf_model_repo_revision: Annotated[
        OptionalNullable[str], pydantic.Field(alias="hfModelRepoRevision")
    ] = UNSET
    "HF commit hash of the model."
    instance_option_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="instanceOptionId")
    ] = UNSET
    "The ID of the instance option."
    name: OptionalNullable[str] = UNSET
    "The name of the endpoint."
    new_version_comment: Annotated[
        OptionalNullable[str], pydantic.Field(alias="newVersionComment")
    ] = UNSET
    "Comment for the new version."
    simplescale: OptionalNullable[EndpointSimplescaleConfig] = UNSET
    "The simple scaling configuration of the endpoint."

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "advanced",
            "autoscalingPolicy",
            "hfModelRepo",
            "hfModelRepoRevision",
            "instanceOptionId",
            "name",
            "newVersionComment",
            "simplescale",
        ]
        nullable_fields = [
            "advanced",
            "autoscalingPolicy",
            "hfModelRepo",
            "hfModelRepoRevision",
            "instanceOptionId",
            "name",
            "newVersionComment",
            "simplescale",
        ]
        null_default_fields = []
        serialized = handler(self)
        m = {}
        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)
            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )
            if (val is not None and val != UNSET_SENTINEL) or (
                val != UNSET_SENTINEL
                and (k not in optional_fields or (optional_nullable and is_set))
            ):
                m[k] = val
        return m
