"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

from typing import Dict, Optional

import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict

from friendli.core.types import (
    UNSET,
    UNSET_SENTINEL,
    BaseModel,
    Nullable,
    OptionalNullable,
)

from .dedicatedendpointspec import DedicatedEndpointSpec, DedicatedEndpointSpecTypedDict


class DedicatedEndpointVersionHistoryResponseTypedDict(TypedDict):
    """Dedicated endpoint version history response."""

    data: NotRequired[Dict[str, DedicatedEndpointSpecTypedDict]]
    "The response data containing endpoint versions."
    next_cursor: NotRequired[Nullable[bytes]]
    "The next cursor for pagination."


class DedicatedEndpointVersionHistoryResponse(BaseModel):
    """Dedicated endpoint version history response."""

    data: Optional[Dict[str, DedicatedEndpointSpec]] = None
    "The response data containing endpoint versions."
    next_cursor: Annotated[
        OptionalNullable[bytes], pydantic.Field(alias="nextCursor")
    ] = UNSET
    "The next cursor for pagination."

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["data", "nextCursor"]
        nullable_fields = ["nextCursor"]
        null_default_fields = []
        serialized = handler(self)
        m = {}
        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)
            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )
            if (val is not None and val != UNSET_SENTINEL) or (
                val != UNSET_SENTINEL
                and (k not in optional_fields or (optional_nullable and is_set))
            ):
                m[k] = val
        return m
