"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, TypedDict

from friendli.core.types import UNSET_SENTINEL, BaseModel, Nullable


class DedicatedEndpointWandbArtifactCreateResponseTypedDict(TypedDict):
    """Endpoint create response."""

    endpoint_id: str
    "The ID of the created endpoint."
    endpoint_name: str
    "The name of the created endpoint."
    project_id: str
    "The ID of the project where the endpoint was created."
    project_name: str
    "The name of the project where the endpoint was created."
    team_id: str
    "The ID of the team where the endpoint was created."
    team_name: Nullable[str]
    "The name of the team where the endpoint was created."


class DedicatedEndpointWandbArtifactCreateResponse(BaseModel):
    """Endpoint create response."""

    endpoint_id: Annotated[str, pydantic.Field(alias="endpointId")]
    "The ID of the created endpoint."
    endpoint_name: Annotated[str, pydantic.Field(alias="endpointName")]
    "The name of the created endpoint."
    project_id: Annotated[str, pydantic.Field(alias="projectId")]
    "The ID of the project where the endpoint was created."
    project_name: Annotated[str, pydantic.Field(alias="projectName")]
    "The name of the project where the endpoint was created."
    team_id: Annotated[str, pydantic.Field(alias="teamId")]
    "The ID of the team where the endpoint was created."
    team_name: Annotated[Nullable[str], pydantic.Field(alias="teamName")]
    "The name of the team where the endpoint was created."

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["teamName"]
        null_default_fields = []
        serialized = handler(self)
        m = {}
        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)
            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )
            if (val is not None and val != UNSET_SENTINEL) or (
                val != UNSET_SENTINEL
                and (k not in optional_fields or (optional_nullable and is_set))
            ):
                m[k] = val
        return m
