"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

from typing import Literal

from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict

from friendli.core.types import (
    UNSET,
    UNSET_SENTINEL,
    BaseModel,
    Nullable,
    OptionalNullable,
)

DedicatedImageGenerationBodyResponseFormat = Literal["url", "raw", "png", "jpeg", "jpg"]
"The format in which the generated image(s) will be returned. One of `url(default)`, `raw`, `png`, `jpeg`, and `jpg`."


class DedicatedImageGenerationBodyTypedDict(TypedDict):
    model: str
    'ID of target endpoint. If you want to send request to specific adapter, use the format \\"YOUR_ENDPOINT_ID:YOUR_ADAPTER_ROUTE\\". Otherwise, you can just use \\"YOUR_ENDPOINT_ID\\" alone.'
    num_inference_steps: int
    "The number of inference steps to use during image generation. Supported range: [1, 50]."
    prompt: str
    "A text description of the desired image(s)."
    guidance_scale: NotRequired[Nullable[float]]
    "Adjusts the alignment of the generated image with the input prompt. Higher values (e.g., 8-10) make the output more faithful to the prompt, while lower values (e.g., 1-5) encourage more creative freedom. This parameter may be irrelevant for certain models, such as `FLUX.Schnell`."
    response_format: NotRequired[Nullable[DedicatedImageGenerationBodyResponseFormat]]
    "The format in which the generated image(s) will be returned. One of `url(default)`, `raw`, `png`, `jpeg`, and `jpg`."
    seed: NotRequired[Nullable[int]]
    "The seed to use for image generation."


class DedicatedImageGenerationBody(BaseModel):
    model: str
    'ID of target endpoint. If you want to send request to specific adapter, use the format \\"YOUR_ENDPOINT_ID:YOUR_ADAPTER_ROUTE\\". Otherwise, you can just use \\"YOUR_ENDPOINT_ID\\" alone.'
    num_inference_steps: int
    "The number of inference steps to use during image generation. Supported range: [1, 50]."
    prompt: str
    "A text description of the desired image(s)."
    guidance_scale: OptionalNullable[float] = UNSET
    "Adjusts the alignment of the generated image with the input prompt. Higher values (e.g., 8-10) make the output more faithful to the prompt, while lower values (e.g., 1-5) encourage more creative freedom. This parameter may be irrelevant for certain models, such as `FLUX.Schnell`."
    response_format: OptionalNullable[DedicatedImageGenerationBodyResponseFormat] = (
        "url"
    )
    "The format in which the generated image(s) will be returned. One of `url(default)`, `raw`, `png`, `jpeg`, and `jpg`."
    seed: OptionalNullable[int] = UNSET
    "The seed to use for image generation."

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["guidance_scale", "response_format", "seed"]
        nullable_fields = ["guidance_scale", "response_format", "seed"]
        null_default_fields = []
        serialized = handler(self)
        m = {}
        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)
            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )
            if (val is not None and val != UNSET_SENTINEL) or (
                val != UNSET_SENTINEL
                and (k not in optional_fields or (optional_nullable and is_set))
            ):
                m[k] = val
        return m
