"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

import io
from typing import IO, Literal, Union

import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict

from friendli.core.types import (
    UNSET,
    UNSET_SENTINEL,
    BaseModel,
    Nullable,
    OptionalNullable,
)
from friendli.core.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)

ListSplitsDirection = Literal["asc", "desc"]


class ListSplitsRequestTypedDict(TypedDict):
    dataset_id: str
    "ID of the dataset."
    cursor: NotRequired[Nullable[Union[bytes, IO[bytes], io.BufferedReader]]]
    limit: NotRequired[Nullable[int]]
    direction: NotRequired[Nullable[ListSplitsDirection]]
    version_id: NotRequired[Nullable[str]]
    x_friendli_team: NotRequired[Nullable[str]]
    "ID of team to run requests as (optional parameter)."


class ListSplitsRequest(BaseModel):
    dataset_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    "ID of the dataset."
    cursor: Annotated[
        OptionalNullable[Union[bytes, IO[bytes], io.BufferedReader]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 20
    direction: Annotated[
        OptionalNullable[ListSplitsDirection],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    version_id: Annotated[
        OptionalNullable[str],
        pydantic.Field(alias="versionId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    x_friendli_team: Annotated[
        OptionalNullable[str],
        pydantic.Field(alias="X-Friendli-Team"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = UNSET
    "ID of team to run requests as (optional parameter)."

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "cursor",
            "limit",
            "direction",
            "versionId",
            "X-Friendli-Team",
        ]
        nullable_fields = [
            "cursor",
            "limit",
            "direction",
            "versionId",
            "X-Friendli-Team",
        ]
        null_default_fields = []
        serialized = handler(self)
        m = {}
        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)
            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )
            if (val is not None and val != UNSET_SENTINEL) or (
                val != UNSET_SENTINEL
                and (k not in optional_fields or (optional_nullable and is_set))
            ):
                m[k] = val
        return m
