"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

from typing import Literal

import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing_extensions import Annotated, NotRequired, TypedDict

from friendli.core.types import (
    UNSET,
    UNSET_SENTINEL,
    BaseModel,
    Nullable,
    OptionalNullable,
)
from friendli.core.utils import validate_const


class ToolMessageTypedDict(TypedDict):
    content: str
    "The content of tool message that contains the result of tool calling."
    tool_call_id: str
    "The ID of tool call corresponding to this message."
    role: Literal["tool"]
    "The role of the messages author."
    name: NotRequired[Nullable[str]]
    "An optional name of the tool call corresponding to this message."


class ToolMessage(BaseModel):
    content: str
    "The content of tool message that contains the result of tool calling."
    tool_call_id: str
    "The ID of tool call corresponding to this message."
    ROLE: Annotated[
        Annotated[Literal["tool"], AfterValidator(validate_const("tool"))],
        pydantic.Field(alias="role"),
    ] = "tool"
    "The role of the messages author."
    name: OptionalNullable[str] = UNSET
    "An optional name of the tool call corresponding to this message."

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["name"]
        nullable_fields = ["name"]
        null_default_fields = []
        serialized = handler(self)
        m = {}
        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)
            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )
            if (val is not None and val != UNSET_SENTINEL) or (
                val != UNSET_SENTINEL
                and (k not in optional_fields or (optional_nullable and is_set))
            ):
                m[k] = val
        return m
