"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

from typing import List, Literal, Union

import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict

from friendli.core.types import (
    UNSET,
    UNSET_SENTINEL,
    BaseModel,
    Nullable,
    OptionalNullable,
)
from friendli.core.utils import validate_const

from .usermessagecontentmultimodal import (
    UserMessageContentMultiModal,
    UserMessageContentMultiModalTypedDict,
)

ContentTypedDict = TypeAliasType(
    "ContentTypedDict", Union[str, List[UserMessageContentMultiModalTypedDict]]
)
Content = TypeAliasType("Content", Union[str, List[UserMessageContentMultiModal]])


class UserMessageTypedDict(TypedDict):
    content: ContentTypedDict
    role: Literal["user"]
    "The role of the message's author."
    name: NotRequired[Nullable[str]]
    "The name for the participant to distinguish between participants with the same role."


class UserMessage(BaseModel):
    content: Content
    ROLE: Annotated[
        Annotated[Literal["user"], AfterValidator(validate_const("user"))],
        pydantic.Field(alias="role"),
    ] = "user"
    "The role of the message's author."
    name: OptionalNullable[str] = UNSET
    "The name for the participant to distinguish between participants with the same role."

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["name"]
        nullable_fields = ["name"]
        null_default_fields = []
        serialized = handler(self)
        m = {}
        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)
            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )
            if (val is not None and val != UNSET_SENTINEL) or (
                val != UNSET_SENTINEL
                and (k not in optional_fields or (optional_nullable and is_set))
            ):
                m[k] = val
        return m
