"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from friendli.core.knowledge import AsyncKnowledge, SyncKnowledge
from friendli.core.model import AsyncModel, SyncModel
from friendli.core.serverless_chat import AsyncServerlessChat, SyncServerlessChat
from friendli.core.serverless_completions import (
    AsyncServerlessCompletions,
    SyncServerlessCompletions,
)
from friendli.core.serverless_token import AsyncServerlessToken, SyncServerlessToken
from friendli.core.toolassistedchat import AsyncToolAssistedChat, SyncToolAssistedChat

from .basesdk import AsyncSDK, BaseSDK, SyncSDK
from .sdkconfiguration import SDKConfiguration


class BaseServerless(BaseSDK):
    def __init__(self, sdk_config: SDKConfiguration) -> None:
        BaseSDK.__init__(self, sdk_config)
        self.sdk_configuration = sdk_config
        self._init_sdks()

    def _init_sdks(self) -> None: ...


class SyncServerless(BaseServerless, SyncSDK):
    chat: SyncServerlessChat
    completions: SyncServerlessCompletions
    token: SyncServerlessToken
    tool_assisted_chat: SyncToolAssistedChat
    knowledge: SyncKnowledge
    model: SyncModel

    def _init_sdks(self):
        self.chat = SyncServerlessChat(self.sdk_configuration)
        self.completions = SyncServerlessCompletions(self.sdk_configuration)
        self.token = SyncServerlessToken(self.sdk_configuration)
        self.tool_assisted_chat = SyncToolAssistedChat(self.sdk_configuration)
        self.knowledge = SyncKnowledge(self.sdk_configuration)
        self.model = SyncModel(self.sdk_configuration)


class AsyncServerless(BaseServerless, AsyncSDK):
    chat: AsyncServerlessChat
    completions: AsyncServerlessCompletions
    token: AsyncServerlessToken
    tool_assisted_chat: AsyncToolAssistedChat
    knowledge: AsyncKnowledge
    model: AsyncModel

    def _init_sdks(self):
        self.chat = AsyncServerlessChat(self.sdk_configuration)
        self.completions = AsyncServerlessCompletions(self.sdk_configuration)
        self.token = AsyncServerlessToken(self.sdk_configuration)
        self.tool_assisted_chat = AsyncToolAssistedChat(self.sdk_configuration)
        self.knowledge = AsyncKnowledge(self.sdk_configuration)
        self.model = AsyncModel(self.sdk_configuration)
