"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from typing import Any, Dict, List, Mapping, Optional, Union

from friendli.core import models, utils
from friendli.core._hooks import HookContext
from friendli.core.types import UNSET, OptionalNullable
from friendli.core.utils import eventstreaming, get_security_from_env
from friendli.core.utils.unmarshal_json_response import unmarshal_json_response

from .basesdk import AsyncSDK, BaseSDK, SyncSDK


class BaseToolAssistedChat(BaseSDK):
    pass


class SyncToolAssistedChat(BaseToolAssistedChat, SyncSDK):
    def complete(
        self,
        *,
        messages: Union[List[models.Message], List[models.MessageTypedDict]],
        model: str,
        x_friendli_team: OptionalNullable[str] = UNSET,
        chat_template_kwargs: OptionalNullable[Dict[str, Any]] = UNSET,
        eos_token: OptionalNullable[List[int]] = UNSET,
        frequency_penalty: OptionalNullable[float] = UNSET,
        logit_bias: OptionalNullable[Dict[str, Any]] = UNSET,
        logprobs: OptionalNullable[bool] = UNSET,
        max_tokens: OptionalNullable[int] = UNSET,
        min_p: OptionalNullable[float] = UNSET,
        n: OptionalNullable[int] = UNSET,
        parallel_tool_calls: OptionalNullable[bool] = UNSET,
        presence_penalty: OptionalNullable[float] = UNSET,
        repetition_penalty: OptionalNullable[float] = UNSET,
        resume_generation: Optional[bool] = None,
        seed: OptionalNullable[
            Union[
                models.ServerlessToolAssistedChatCompletionBodySeed,
                models.ServerlessToolAssistedChatCompletionBodySeedTypedDict,
            ]
        ] = UNSET,
        stop: OptionalNullable[List[str]] = UNSET,
        stream: Optional[bool] = False,
        stream_options: OptionalNullable[
            Union[models.StreamOptions, models.StreamOptionsTypedDict]
        ] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        tool_choice: Optional[
            Union[
                models.ServerlessToolAssistedChatCompletionBodyToolChoice,
                models.ServerlessToolAssistedChatCompletionBodyToolChoiceTypedDict,
            ]
        ] = None,
        tools: OptionalNullable[
            Union[
                List[models.ToolAssistedChatTool],
                List[models.ToolAssistedChatToolTypedDict],
            ]
        ] = UNSET,
        top_k: OptionalNullable[int] = UNSET,
        top_logprobs: OptionalNullable[int] = UNSET,
        top_p: OptionalNullable[float] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ContainerChatCompleteSuccess:
        """Tool assisted chat completions

        Given a list of messages forming a conversation, the model generates a response. Additionally, the model can utilize built-in tools for tool calls, enhancing its capability to provide more comprehensive and actionable responses.

        :param messages: A list of messages comprising the conversation so far.
        :param model: Code of the model to use. See [available model list](https://friendli.ai/docs/guides/serverless_endpoints/pricing#text-generation-models).
        :param x_friendli_team: ID of team to run requests as (optional parameter).
        :param chat_template_kwargs: Additional keyword arguments supplied to the template renderer. These parameters will be available for use within the chat template.
        :param eos_token: A list of endpoint sentence tokens.
        :param frequency_penalty: Number between -2.0 and 2.0. Positive values penalizes tokens that have been sampled, taking into account their frequency in the preceding text. This penalization diminishes the model's tendency to reproduce identical lines verbatim.
        :param logit_bias: Accepts a JSON object that maps tokens to an associated bias value. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model.
        :param logprobs: Whether to return log probabilities of the output tokens or not.
        :param max_tokens: The maximum number of tokens to generate. For decoder-only models like GPT, the length of your input tokens plus `max_tokens` should not exceed the model's maximum length (e.g., 2048 for OpenAI GPT-3). For encoder-decoder models like T5 or BlenderBot, `max_tokens` should not exceed the model's maximum output length. This is similar to Hugging Face's [`max_new_tokens`](https://huggingface.co/docs/transformers/v4.26.0/en/main_classes/text_generation#transformers.GenerationConfig.max_new_tokens) argument.
        :param min_p: A scaling factor used to determine the minimum token probability threshold. This threshold is calculated as `min_p` multiplied by the probability of the most likely token. Tokens with probabilities below this scaled threshold are excluded from sampling. Values range from 0.0 (inclusive) to 1.0 (inclusive). Higher values result in stricter filtering, while lower values allow for greater diversity. The default value of 0.0 disables filtering, allowing all tokens to be considered for sampling.
        :param n: The number of independently generated results for the prompt. Defaults to 1. This is similar to Hugging Face's [`num_return_sequences`](https://huggingface.co/docs/transformers/v4.26.0/en/main_classes/text_generation#transformers.GenerationConfig.num_return_sequences) argument.
        :param parallel_tool_calls: Whether to enable parallel function calling.
        :param presence_penalty: Number between -2.0 and 2.0. Positive values penalizes tokens that have been sampled at least once in the existing text.
        :param repetition_penalty: Penalizes tokens that have already appeared in the generated result (plus the input tokens for decoder-only models). Should be positive value (1.0 means no penalty). See [keskar et al., 2019](https://arxiv.org/abs/1909.05858) for more details. This is similar to Hugging Face's [`repetition_penalty`](https://huggingface.co/docs/transformers/v4.26.0/en/main_classes/text_generation#transformers.generationconfig.repetition_penalty) argument.
        :param resume_generation: Enable to continue text generation even after an error occurs during a tool call.  Note that enabling this option may use more tokens, as the system generates additional content to handle errors gracefully. However, if the system fails more than 8 times, the generation will stop regardless.  ***Tip*** This is useful in scenarios where you want to maintain text generation flow despite errors, such as when generating long-form content. The user will not be interrupted by tool call issues, ensuring a smoother experience.
        :param seed: Seed to control random procedure. If nothing is given, random seed is used for sampling, and return the seed along with the generated result. When using the `n` argument, you can pass a list of seed values to control all of the independent generations.
        :param stop: When one of the stop phrases appears in the generation result, the API will stop generation. The stop phrases are excluded from the result. Defaults to empty list.
        :param stream: Whether to stream generation result. When set true, each token will be sent as [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#event_stream_format) once generated.
        :param stream_options: Options related to stream. It can only be used when `stream: true`.
        :param temperature: Sampling temperature. Smaller temperature makes the generation result closer to greedy, argmax (i.e., `top_k = 1`) sampling. Defaults to 1.0. This is similar to Hugging Face's [`temperature`](https://huggingface.co/docs/transformers/v4.26.0/en/main_classes/text_generation#transformers.generationconfig.temperature) argument.
        :param tool_choice: Determines the tool calling behavior of the model. When set to `none`, the model will bypass tool execution and generate a response directly. In `auto` mode (the default), the model dynamically decides whether to call a tool or respond with a message. Alternatively, setting `required` ensures that the model invokes at least one tool before responding to the user. You can also specify a particular tool by `{\\"type\\": \\"function\\", \\"function\\": {\\"name\\": \\"my_function\\"}}`.
        :param tools: A list of tools the model may call. A maximum of 128 functions is supported. Use this to provide a list of functions the model may generate JSON inputs for. For more detailed information about each tool, please refer [here](https://friendli.ai/docs/guides/serverless_endpoints/tool-assisted-api#built-in-tools).
        :param top_k: Limits sampling to the top k tokens with the highest probabilities. Values range from 0 (no filtering) to the model's vocabulary size (inclusive). The default value of 0 applies no filtering, allowing all tokens.
        :param top_logprobs: The number of most likely tokens to return at each token position, each with an associated log probability. `logprobs` must be set to true if this parameter is used.
        :param top_p: Keeps only the smallest set of tokens whose cumulative probabilities reach `top_p` or higher. Values range from 0.0 (exclusive) to 1.0 (inclusive). The default value of 1.0 includes all tokens, allowing maximum diversity.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms
        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)
        request = models.ServerlessToolAssistedChatCompleteRequest(
            x_friendli_team=x_friendli_team,
            serverless_tool_assisted_chat_completion_body=models.ServerlessToolAssistedChatCompletionBody(
                messages=utils.get_pydantic_model(messages, List[models.Message]),
                model=model,
                chat_template_kwargs=chat_template_kwargs,
                eos_token=eos_token,
                frequency_penalty=frequency_penalty,
                logit_bias=logit_bias,
                logprobs=logprobs,
                max_tokens=max_tokens,
                min_p=min_p,
                n=n,
                parallel_tool_calls=parallel_tool_calls,
                presence_penalty=presence_penalty,
                repetition_penalty=repetition_penalty,
                resume_generation=resume_generation,
                seed=seed,
                stop=stop,
                stream=stream,
                stream_options=utils.get_pydantic_model(
                    stream_options, OptionalNullable[models.StreamOptions]
                ),
                temperature=temperature,
                tool_choice=utils.get_pydantic_model(
                    tool_choice,
                    Optional[models.ServerlessToolAssistedChatCompletionBodyToolChoice],
                ),
                tools=utils.get_pydantic_model(
                    tools, OptionalNullable[List[models.ToolAssistedChatTool]]
                ),
                top_k=top_k,
                top_logprobs=top_logprobs,
                top_p=top_p,
            ),
        )
        req = self._build_request(
            method="POST",
            path="/serverless/tools/v1/chat/completions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.serverless_tool_assisted_chat_completion_body,
                False,
                False,
                "json",
                models.ServerlessToolAssistedChatCompletionBody,
            ),
            timeout_ms=timeout_ms,
        )
        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )
        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])
        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="serverlessToolAssistedChatComplete",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.ContainerChatCompleteSuccess, http_res
            )
        if utils.match_response(http_res, ["422", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        raise models.SDKError("Unexpected response received", http_res)

    def stream(
        self,
        *,
        messages: Union[List[models.Message], List[models.MessageTypedDict]],
        model: str,
        x_friendli_team: OptionalNullable[str] = UNSET,
        chat_template_kwargs: OptionalNullable[Dict[str, Any]] = UNSET,
        eos_token: OptionalNullable[List[int]] = UNSET,
        frequency_penalty: OptionalNullable[float] = UNSET,
        logit_bias: OptionalNullable[Dict[str, Any]] = UNSET,
        logprobs: OptionalNullable[bool] = UNSET,
        max_tokens: OptionalNullable[int] = UNSET,
        min_p: OptionalNullable[float] = UNSET,
        n: OptionalNullable[int] = UNSET,
        parallel_tool_calls: OptionalNullable[bool] = UNSET,
        presence_penalty: OptionalNullable[float] = UNSET,
        repetition_penalty: OptionalNullable[float] = UNSET,
        resume_generation: Optional[bool] = None,
        seed: OptionalNullable[
            Union[
                models.ServerlessToolAssistedChatCompletionStreamBodySeed,
                models.ServerlessToolAssistedChatCompletionStreamBodySeedTypedDict,
            ]
        ] = UNSET,
        stop: OptionalNullable[List[str]] = UNSET,
        stream: Optional[bool] = True,
        stream_options: OptionalNullable[
            Union[models.StreamOptions, models.StreamOptionsTypedDict]
        ] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        tool_choice: Optional[
            Union[
                models.ServerlessToolAssistedChatCompletionStreamBodyToolChoice,
                models.ServerlessToolAssistedChatCompletionStreamBodyToolChoiceTypedDict,
            ]
        ] = None,
        tools: OptionalNullable[
            Union[
                List[models.ToolAssistedChatTool],
                List[models.ToolAssistedChatToolTypedDict],
            ]
        ] = UNSET,
        top_k: OptionalNullable[int] = UNSET,
        top_logprobs: OptionalNullable[int] = UNSET,
        top_p: OptionalNullable[float] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> eventstreaming.EventStream[
        models.ServerlessToolAssistedChatCompletionStreamSuccess
    ]:
        """Stream tool assisted chat completions

        Given a list of messages forming a conversation, the model generates a response. Additionally, the model can utilize built-in tools for tool calls, enhancing its capability to provide more comprehensive and actionable responses.

        :param messages: A list of messages comprising the conversation so far.
        :param model: Code of the model to use. See [available model list](https://friendli.ai/docs/guides/serverless_endpoints/pricing#text-generation-models).
        :param x_friendli_team: ID of team to run requests as (optional parameter).
        :param chat_template_kwargs: Additional keyword arguments supplied to the template renderer. These parameters will be available for use within the chat template.
        :param eos_token: A list of endpoint sentence tokens.
        :param frequency_penalty: Number between -2.0 and 2.0. Positive values penalizes tokens that have been sampled, taking into account their frequency in the preceding text. This penalization diminishes the model's tendency to reproduce identical lines verbatim.
        :param logit_bias: Accepts a JSON object that maps tokens to an associated bias value. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model.
        :param logprobs: Whether to return log probabilities of the output tokens or not.
        :param max_tokens: The maximum number of tokens to generate. For decoder-only models like GPT, the length of your input tokens plus `max_tokens` should not exceed the model's maximum length (e.g., 2048 for OpenAI GPT-3). For encoder-decoder models like T5 or BlenderBot, `max_tokens` should not exceed the model's maximum output length. This is similar to Hugging Face's [`max_new_tokens`](https://huggingface.co/docs/transformers/v4.26.0/en/main_classes/text_generation#transformers.GenerationConfig.max_new_tokens) argument.
        :param min_p: A scaling factor used to determine the minimum token probability threshold. This threshold is calculated as `min_p` multiplied by the probability of the most likely token. Tokens with probabilities below this scaled threshold are excluded from sampling. Values range from 0.0 (inclusive) to 1.0 (inclusive). Higher values result in stricter filtering, while lower values allow for greater diversity. The default value of 0.0 disables filtering, allowing all tokens to be considered for sampling.
        :param n: The number of independently generated results for the prompt. Defaults to 1. This is similar to Hugging Face's [`num_return_sequences`](https://huggingface.co/docs/transformers/v4.26.0/en/main_classes/text_generation#transformers.GenerationConfig.num_return_sequences) argument.
        :param parallel_tool_calls: Whether to enable parallel function calling.
        :param presence_penalty: Number between -2.0 and 2.0. Positive values penalizes tokens that have been sampled at least once in the existing text.
        :param repetition_penalty: Penalizes tokens that have already appeared in the generated result (plus the input tokens for decoder-only models). Should be positive value (1.0 means no penalty). See [keskar et al., 2019](https://arxiv.org/abs/1909.05858) for more details. This is similar to Hugging Face's [`repetition_penalty`](https://huggingface.co/docs/transformers/v4.26.0/en/main_classes/text_generation#transformers.generationconfig.repetition_penalty) argument.
        :param resume_generation: Enable to continue text generation even after an error occurs during a tool call.  Note that enabling this option may use more tokens, as the system generates additional content to handle errors gracefully. However, if the system fails more than 8 times, the generation will stop regardless.  ***Tip*** This is useful in scenarios where you want to maintain text generation flow despite errors, such as when generating long-form content. The user will not be interrupted by tool call issues, ensuring a smoother experience.
        :param seed: Seed to control random procedure. If nothing is given, random seed is used for sampling, and return the seed along with the generated result. When using the `n` argument, you can pass a list of seed values to control all of the independent generations.
        :param stop: When one of the stop phrases appears in the generation result, the API will stop generation. The stop phrases are excluded from the result. Defaults to empty list.
        :param stream: Whether to stream generation result. When set true, each token will be sent as [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#event_stream_format) once generated.
        :param stream_options: Options related to stream. It can only be used when `stream: true`.
        :param temperature: Sampling temperature. Smaller temperature makes the generation result closer to greedy, argmax (i.e., `top_k = 1`) sampling. Defaults to 1.0. This is similar to Hugging Face's [`temperature`](https://huggingface.co/docs/transformers/v4.26.0/en/main_classes/text_generation#transformers.generationconfig.temperature) argument.
        :param tool_choice: Determines the tool calling behavior of the model. When set to `none`, the model will bypass tool execution and generate a response directly. In `auto` mode (the default), the model dynamically decides whether to call a tool or respond with a message. Alternatively, setting `required` ensures that the model invokes at least one tool before responding to the user. You can also specify a particular tool by `{\\"type\\": \\"function\\", \\"function\\": {\\"name\\": \\"my_function\\"}}`.
        :param tools: A list of tools the model may call. A maximum of 128 functions is supported. Use this to provide a list of functions the model may generate JSON inputs for. For more detailed information about each tool, please refer [here](https://friendli.ai/docs/guides/serverless_endpoints/tool-assisted-api#built-in-tools).
        :param top_k: Limits sampling to the top k tokens with the highest probabilities. Values range from 0 (no filtering) to the model's vocabulary size (inclusive). The default value of 0 applies no filtering, allowing all tokens.
        :param top_logprobs: The number of most likely tokens to return at each token position, each with an associated log probability. `logprobs` must be set to true if this parameter is used.
        :param top_p: Keeps only the smallest set of tokens whose cumulative probabilities reach `top_p` or higher. Values range from 0.0 (exclusive) to 1.0 (inclusive). The default value of 1.0 includes all tokens, allowing maximum diversity.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms
        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)
        request = models.ServerlessToolAssistedChatStreamRequest(
            x_friendli_team=x_friendli_team,
            serverless_tool_assisted_chat_completion_stream_body=models.ServerlessToolAssistedChatCompletionStreamBody(
                messages=utils.get_pydantic_model(messages, List[models.Message]),
                model=model,
                chat_template_kwargs=chat_template_kwargs,
                eos_token=eos_token,
                frequency_penalty=frequency_penalty,
                logit_bias=logit_bias,
                logprobs=logprobs,
                max_tokens=max_tokens,
                min_p=min_p,
                n=n,
                parallel_tool_calls=parallel_tool_calls,
                presence_penalty=presence_penalty,
                repetition_penalty=repetition_penalty,
                resume_generation=resume_generation,
                seed=seed,
                stop=stop,
                stream=stream,
                stream_options=utils.get_pydantic_model(
                    stream_options, OptionalNullable[models.StreamOptions]
                ),
                temperature=temperature,
                tool_choice=utils.get_pydantic_model(
                    tool_choice,
                    Optional[
                        models.ServerlessToolAssistedChatCompletionStreamBodyToolChoice
                    ],
                ),
                tools=utils.get_pydantic_model(
                    tools, OptionalNullable[List[models.ToolAssistedChatTool]]
                ),
                top_k=top_k,
                top_logprobs=top_logprobs,
                top_p=top_p,
            ),
        )
        req = self._build_request(
            method="POST",
            path="/serverless/tools/v1/chat/completions#stream",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="text/event-stream",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.serverless_tool_assisted_chat_completion_stream_body,
                False,
                False,
                "json",
                models.ServerlessToolAssistedChatCompletionStreamBody,
            ),
            timeout_ms=timeout_ms,
        )
        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )
        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])
        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="serverlessToolAssistedChatStream",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )
        if utils.match_response(http_res, "200", "text/event-stream"):
            return eventstreaming.EventStream(
                http_res,
                lambda raw: utils.unmarshal_json(
                    raw, models.ServerlessToolAssistedChatCompletionStreamSuccess
                ),
                sentinel="[DONE]",
            )
        if utils.match_response(http_res, ["422", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        http_res_text = utils.stream_to_text(http_res)
        raise models.SDKError("Unexpected response received", http_res, http_res_text)


class AsyncToolAssistedChat(BaseToolAssistedChat, AsyncSDK):
    async def complete(
        self,
        *,
        messages: Union[List[models.Message], List[models.MessageTypedDict]],
        model: str,
        x_friendli_team: OptionalNullable[str] = UNSET,
        chat_template_kwargs: OptionalNullable[Dict[str, Any]] = UNSET,
        eos_token: OptionalNullable[List[int]] = UNSET,
        frequency_penalty: OptionalNullable[float] = UNSET,
        logit_bias: OptionalNullable[Dict[str, Any]] = UNSET,
        logprobs: OptionalNullable[bool] = UNSET,
        max_tokens: OptionalNullable[int] = UNSET,
        min_p: OptionalNullable[float] = UNSET,
        n: OptionalNullable[int] = UNSET,
        parallel_tool_calls: OptionalNullable[bool] = UNSET,
        presence_penalty: OptionalNullable[float] = UNSET,
        repetition_penalty: OptionalNullable[float] = UNSET,
        resume_generation: Optional[bool] = None,
        seed: OptionalNullable[
            Union[
                models.ServerlessToolAssistedChatCompletionBodySeed,
                models.ServerlessToolAssistedChatCompletionBodySeedTypedDict,
            ]
        ] = UNSET,
        stop: OptionalNullable[List[str]] = UNSET,
        stream: Optional[bool] = False,
        stream_options: OptionalNullable[
            Union[models.StreamOptions, models.StreamOptionsTypedDict]
        ] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        tool_choice: Optional[
            Union[
                models.ServerlessToolAssistedChatCompletionBodyToolChoice,
                models.ServerlessToolAssistedChatCompletionBodyToolChoiceTypedDict,
            ]
        ] = None,
        tools: OptionalNullable[
            Union[
                List[models.ToolAssistedChatTool],
                List[models.ToolAssistedChatToolTypedDict],
            ]
        ] = UNSET,
        top_k: OptionalNullable[int] = UNSET,
        top_logprobs: OptionalNullable[int] = UNSET,
        top_p: OptionalNullable[float] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ContainerChatCompleteSuccess:
        """Tool assisted chat completions

        Given a list of messages forming a conversation, the model generates a response. Additionally, the model can utilize built-in tools for tool calls, enhancing its capability to provide more comprehensive and actionable responses.

        :param messages: A list of messages comprising the conversation so far.
        :param model: Code of the model to use. See [available model list](https://friendli.ai/docs/guides/serverless_endpoints/pricing#text-generation-models).
        :param x_friendli_team: ID of team to run requests as (optional parameter).
        :param chat_template_kwargs: Additional keyword arguments supplied to the template renderer. These parameters will be available for use within the chat template.
        :param eos_token: A list of endpoint sentence tokens.
        :param frequency_penalty: Number between -2.0 and 2.0. Positive values penalizes tokens that have been sampled, taking into account their frequency in the preceding text. This penalization diminishes the model's tendency to reproduce identical lines verbatim.
        :param logit_bias: Accepts a JSON object that maps tokens to an associated bias value. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model.
        :param logprobs: Whether to return log probabilities of the output tokens or not.
        :param max_tokens: The maximum number of tokens to generate. For decoder-only models like GPT, the length of your input tokens plus `max_tokens` should not exceed the model's maximum length (e.g., 2048 for OpenAI GPT-3). For encoder-decoder models like T5 or BlenderBot, `max_tokens` should not exceed the model's maximum output length. This is similar to Hugging Face's [`max_new_tokens`](https://huggingface.co/docs/transformers/v4.26.0/en/main_classes/text_generation#transformers.GenerationConfig.max_new_tokens) argument.
        :param min_p: A scaling factor used to determine the minimum token probability threshold. This threshold is calculated as `min_p` multiplied by the probability of the most likely token. Tokens with probabilities below this scaled threshold are excluded from sampling. Values range from 0.0 (inclusive) to 1.0 (inclusive). Higher values result in stricter filtering, while lower values allow for greater diversity. The default value of 0.0 disables filtering, allowing all tokens to be considered for sampling.
        :param n: The number of independently generated results for the prompt. Defaults to 1. This is similar to Hugging Face's [`num_return_sequences`](https://huggingface.co/docs/transformers/v4.26.0/en/main_classes/text_generation#transformers.GenerationConfig.num_return_sequences) argument.
        :param parallel_tool_calls: Whether to enable parallel function calling.
        :param presence_penalty: Number between -2.0 and 2.0. Positive values penalizes tokens that have been sampled at least once in the existing text.
        :param repetition_penalty: Penalizes tokens that have already appeared in the generated result (plus the input tokens for decoder-only models). Should be positive value (1.0 means no penalty). See [keskar et al., 2019](https://arxiv.org/abs/1909.05858) for more details. This is similar to Hugging Face's [`repetition_penalty`](https://huggingface.co/docs/transformers/v4.26.0/en/main_classes/text_generation#transformers.generationconfig.repetition_penalty) argument.
        :param resume_generation: Enable to continue text generation even after an error occurs during a tool call.  Note that enabling this option may use more tokens, as the system generates additional content to handle errors gracefully. However, if the system fails more than 8 times, the generation will stop regardless.  ***Tip*** This is useful in scenarios where you want to maintain text generation flow despite errors, such as when generating long-form content. The user will not be interrupted by tool call issues, ensuring a smoother experience.
        :param seed: Seed to control random procedure. If nothing is given, random seed is used for sampling, and return the seed along with the generated result. When using the `n` argument, you can pass a list of seed values to control all of the independent generations.
        :param stop: When one of the stop phrases appears in the generation result, the API will stop generation. The stop phrases are excluded from the result. Defaults to empty list.
        :param stream: Whether to stream generation result. When set true, each token will be sent as [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#event_stream_format) once generated.
        :param stream_options: Options related to stream. It can only be used when `stream: true`.
        :param temperature: Sampling temperature. Smaller temperature makes the generation result closer to greedy, argmax (i.e., `top_k = 1`) sampling. Defaults to 1.0. This is similar to Hugging Face's [`temperature`](https://huggingface.co/docs/transformers/v4.26.0/en/main_classes/text_generation#transformers.generationconfig.temperature) argument.
        :param tool_choice: Determines the tool calling behavior of the model. When set to `none`, the model will bypass tool execution and generate a response directly. In `auto` mode (the default), the model dynamically decides whether to call a tool or respond with a message. Alternatively, setting `required` ensures that the model invokes at least one tool before responding to the user. You can also specify a particular tool by `{\\"type\\": \\"function\\", \\"function\\": {\\"name\\": \\"my_function\\"}}`.
        :param tools: A list of tools the model may call. A maximum of 128 functions is supported. Use this to provide a list of functions the model may generate JSON inputs for. For more detailed information about each tool, please refer [here](https://friendli.ai/docs/guides/serverless_endpoints/tool-assisted-api#built-in-tools).
        :param top_k: Limits sampling to the top k tokens with the highest probabilities. Values range from 0 (no filtering) to the model's vocabulary size (inclusive). The default value of 0 applies no filtering, allowing all tokens.
        :param top_logprobs: The number of most likely tokens to return at each token position, each with an associated log probability. `logprobs` must be set to true if this parameter is used.
        :param top_p: Keeps only the smallest set of tokens whose cumulative probabilities reach `top_p` or higher. Values range from 0.0 (exclusive) to 1.0 (inclusive). The default value of 1.0 includes all tokens, allowing maximum diversity.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms
        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)
        request = models.ServerlessToolAssistedChatCompleteRequest(
            x_friendli_team=x_friendli_team,
            serverless_tool_assisted_chat_completion_body=models.ServerlessToolAssistedChatCompletionBody(
                messages=utils.get_pydantic_model(messages, List[models.Message]),
                model=model,
                chat_template_kwargs=chat_template_kwargs,
                eos_token=eos_token,
                frequency_penalty=frequency_penalty,
                logit_bias=logit_bias,
                logprobs=logprobs,
                max_tokens=max_tokens,
                min_p=min_p,
                n=n,
                parallel_tool_calls=parallel_tool_calls,
                presence_penalty=presence_penalty,
                repetition_penalty=repetition_penalty,
                resume_generation=resume_generation,
                seed=seed,
                stop=stop,
                stream=stream,
                stream_options=utils.get_pydantic_model(
                    stream_options, OptionalNullable[models.StreamOptions]
                ),
                temperature=temperature,
                tool_choice=utils.get_pydantic_model(
                    tool_choice,
                    Optional[models.ServerlessToolAssistedChatCompletionBodyToolChoice],
                ),
                tools=utils.get_pydantic_model(
                    tools, OptionalNullable[List[models.ToolAssistedChatTool]]
                ),
                top_k=top_k,
                top_logprobs=top_logprobs,
                top_p=top_p,
            ),
        )
        req = self._build_request_async(
            method="POST",
            path="/serverless/tools/v1/chat/completions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.serverless_tool_assisted_chat_completion_body,
                False,
                False,
                "json",
                models.ServerlessToolAssistedChatCompletionBody,
            ),
            timeout_ms=timeout_ms,
        )
        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )
        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])
        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="serverlessToolAssistedChatComplete",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.ContainerChatCompleteSuccess, http_res
            )
        if utils.match_response(http_res, ["422", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        raise models.SDKError("Unexpected response received", http_res)

    async def stream(
        self,
        *,
        messages: Union[List[models.Message], List[models.MessageTypedDict]],
        model: str,
        x_friendli_team: OptionalNullable[str] = UNSET,
        chat_template_kwargs: OptionalNullable[Dict[str, Any]] = UNSET,
        eos_token: OptionalNullable[List[int]] = UNSET,
        frequency_penalty: OptionalNullable[float] = UNSET,
        logit_bias: OptionalNullable[Dict[str, Any]] = UNSET,
        logprobs: OptionalNullable[bool] = UNSET,
        max_tokens: OptionalNullable[int] = UNSET,
        min_p: OptionalNullable[float] = UNSET,
        n: OptionalNullable[int] = UNSET,
        parallel_tool_calls: OptionalNullable[bool] = UNSET,
        presence_penalty: OptionalNullable[float] = UNSET,
        repetition_penalty: OptionalNullable[float] = UNSET,
        resume_generation: Optional[bool] = None,
        seed: OptionalNullable[
            Union[
                models.ServerlessToolAssistedChatCompletionStreamBodySeed,
                models.ServerlessToolAssistedChatCompletionStreamBodySeedTypedDict,
            ]
        ] = UNSET,
        stop: OptionalNullable[List[str]] = UNSET,
        stream: Optional[bool] = True,
        stream_options: OptionalNullable[
            Union[models.StreamOptions, models.StreamOptionsTypedDict]
        ] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        tool_choice: Optional[
            Union[
                models.ServerlessToolAssistedChatCompletionStreamBodyToolChoice,
                models.ServerlessToolAssistedChatCompletionStreamBodyToolChoiceTypedDict,
            ]
        ] = None,
        tools: OptionalNullable[
            Union[
                List[models.ToolAssistedChatTool],
                List[models.ToolAssistedChatToolTypedDict],
            ]
        ] = UNSET,
        top_k: OptionalNullable[int] = UNSET,
        top_logprobs: OptionalNullable[int] = UNSET,
        top_p: OptionalNullable[float] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> eventstreaming.EventStreamAsync[
        models.ServerlessToolAssistedChatCompletionStreamSuccess
    ]:
        """Stream tool assisted chat completions

        Given a list of messages forming a conversation, the model generates a response. Additionally, the model can utilize built-in tools for tool calls, enhancing its capability to provide more comprehensive and actionable responses.

        :param messages: A list of messages comprising the conversation so far.
        :param model: Code of the model to use. See [available model list](https://friendli.ai/docs/guides/serverless_endpoints/pricing#text-generation-models).
        :param x_friendli_team: ID of team to run requests as (optional parameter).
        :param chat_template_kwargs: Additional keyword arguments supplied to the template renderer. These parameters will be available for use within the chat template.
        :param eos_token: A list of endpoint sentence tokens.
        :param frequency_penalty: Number between -2.0 and 2.0. Positive values penalizes tokens that have been sampled, taking into account their frequency in the preceding text. This penalization diminishes the model's tendency to reproduce identical lines verbatim.
        :param logit_bias: Accepts a JSON object that maps tokens to an associated bias value. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model.
        :param logprobs: Whether to return log probabilities of the output tokens or not.
        :param max_tokens: The maximum number of tokens to generate. For decoder-only models like GPT, the length of your input tokens plus `max_tokens` should not exceed the model's maximum length (e.g., 2048 for OpenAI GPT-3). For encoder-decoder models like T5 or BlenderBot, `max_tokens` should not exceed the model's maximum output length. This is similar to Hugging Face's [`max_new_tokens`](https://huggingface.co/docs/transformers/v4.26.0/en/main_classes/text_generation#transformers.GenerationConfig.max_new_tokens) argument.
        :param min_p: A scaling factor used to determine the minimum token probability threshold. This threshold is calculated as `min_p` multiplied by the probability of the most likely token. Tokens with probabilities below this scaled threshold are excluded from sampling. Values range from 0.0 (inclusive) to 1.0 (inclusive). Higher values result in stricter filtering, while lower values allow for greater diversity. The default value of 0.0 disables filtering, allowing all tokens to be considered for sampling.
        :param n: The number of independently generated results for the prompt. Defaults to 1. This is similar to Hugging Face's [`num_return_sequences`](https://huggingface.co/docs/transformers/v4.26.0/en/main_classes/text_generation#transformers.GenerationConfig.num_return_sequences) argument.
        :param parallel_tool_calls: Whether to enable parallel function calling.
        :param presence_penalty: Number between -2.0 and 2.0. Positive values penalizes tokens that have been sampled at least once in the existing text.
        :param repetition_penalty: Penalizes tokens that have already appeared in the generated result (plus the input tokens for decoder-only models). Should be positive value (1.0 means no penalty). See [keskar et al., 2019](https://arxiv.org/abs/1909.05858) for more details. This is similar to Hugging Face's [`repetition_penalty`](https://huggingface.co/docs/transformers/v4.26.0/en/main_classes/text_generation#transformers.generationconfig.repetition_penalty) argument.
        :param resume_generation: Enable to continue text generation even after an error occurs during a tool call.  Note that enabling this option may use more tokens, as the system generates additional content to handle errors gracefully. However, if the system fails more than 8 times, the generation will stop regardless.  ***Tip*** This is useful in scenarios where you want to maintain text generation flow despite errors, such as when generating long-form content. The user will not be interrupted by tool call issues, ensuring a smoother experience.
        :param seed: Seed to control random procedure. If nothing is given, random seed is used for sampling, and return the seed along with the generated result. When using the `n` argument, you can pass a list of seed values to control all of the independent generations.
        :param stop: When one of the stop phrases appears in the generation result, the API will stop generation. The stop phrases are excluded from the result. Defaults to empty list.
        :param stream: Whether to stream generation result. When set true, each token will be sent as [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#event_stream_format) once generated.
        :param stream_options: Options related to stream. It can only be used when `stream: true`.
        :param temperature: Sampling temperature. Smaller temperature makes the generation result closer to greedy, argmax (i.e., `top_k = 1`) sampling. Defaults to 1.0. This is similar to Hugging Face's [`temperature`](https://huggingface.co/docs/transformers/v4.26.0/en/main_classes/text_generation#transformers.generationconfig.temperature) argument.
        :param tool_choice: Determines the tool calling behavior of the model. When set to `none`, the model will bypass tool execution and generate a response directly. In `auto` mode (the default), the model dynamically decides whether to call a tool or respond with a message. Alternatively, setting `required` ensures that the model invokes at least one tool before responding to the user. You can also specify a particular tool by `{\\"type\\": \\"function\\", \\"function\\": {\\"name\\": \\"my_function\\"}}`.
        :param tools: A list of tools the model may call. A maximum of 128 functions is supported. Use this to provide a list of functions the model may generate JSON inputs for. For more detailed information about each tool, please refer [here](https://friendli.ai/docs/guides/serverless_endpoints/tool-assisted-api#built-in-tools).
        :param top_k: Limits sampling to the top k tokens with the highest probabilities. Values range from 0 (no filtering) to the model's vocabulary size (inclusive). The default value of 0 applies no filtering, allowing all tokens.
        :param top_logprobs: The number of most likely tokens to return at each token position, each with an associated log probability. `logprobs` must be set to true if this parameter is used.
        :param top_p: Keeps only the smallest set of tokens whose cumulative probabilities reach `top_p` or higher. Values range from 0.0 (exclusive) to 1.0 (inclusive). The default value of 1.0 includes all tokens, allowing maximum diversity.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms
        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)
        request = models.ServerlessToolAssistedChatStreamRequest(
            x_friendli_team=x_friendli_team,
            serverless_tool_assisted_chat_completion_stream_body=models.ServerlessToolAssistedChatCompletionStreamBody(
                messages=utils.get_pydantic_model(messages, List[models.Message]),
                model=model,
                chat_template_kwargs=chat_template_kwargs,
                eos_token=eos_token,
                frequency_penalty=frequency_penalty,
                logit_bias=logit_bias,
                logprobs=logprobs,
                max_tokens=max_tokens,
                min_p=min_p,
                n=n,
                parallel_tool_calls=parallel_tool_calls,
                presence_penalty=presence_penalty,
                repetition_penalty=repetition_penalty,
                resume_generation=resume_generation,
                seed=seed,
                stop=stop,
                stream=stream,
                stream_options=utils.get_pydantic_model(
                    stream_options, OptionalNullable[models.StreamOptions]
                ),
                temperature=temperature,
                tool_choice=utils.get_pydantic_model(
                    tool_choice,
                    Optional[
                        models.ServerlessToolAssistedChatCompletionStreamBodyToolChoice
                    ],
                ),
                tools=utils.get_pydantic_model(
                    tools, OptionalNullable[List[models.ToolAssistedChatTool]]
                ),
                top_k=top_k,
                top_logprobs=top_logprobs,
                top_p=top_p,
            ),
        )
        req = self._build_request_async(
            method="POST",
            path="/serverless/tools/v1/chat/completions#stream",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="text/event-stream",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.serverless_tool_assisted_chat_completion_stream_body,
                False,
                False,
                "json",
                models.ServerlessToolAssistedChatCompletionStreamBody,
            ),
            timeout_ms=timeout_ms,
        )
        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )
        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])
        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="serverlessToolAssistedChatStream",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )
        if utils.match_response(http_res, "200", "text/event-stream"):
            return eventstreaming.EventStreamAsync(
                http_res,
                lambda raw: utils.unmarshal_json(
                    raw, models.ServerlessToolAssistedChatCompletionStreamSuccess
                ),
                sentinel="[DONE]",
            )
        if utils.match_response(http_res, ["422", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.SDKError("Unexpected response received", http_res, http_res_text)
