"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

import sys
from datetime import datetime


def parse_datetime(datetime_string: str) -> datetime:
    """Convert a RFC 3339 / ISO 8601 formatted string into a datetime object.
    Python versions 3.11 and later support parsing RFC 3339 directly with
    datetime.fromisoformat(), but for earlier versions, this function
    encapsulates the necessary extra logic.
    """
    if sys.version_info >= (3, 11):
        return datetime.fromisoformat(datetime_string)
    if datetime_string.endswith("Z"):
        datetime_string = datetime_string[:-1] + "+00:00"
    return datetime.fromisoformat(datetime_string)
