import logging
from importlib.metadata import version

from . import server
from .framework import (
    AllowedTypes,
    Any,
    BasicType,
    Binary,
    BinaryDownloadFailed,
    BinaryTransfer,
    BinaryTransferError,
    BinaryTransferErrorType,
    BinaryTransferHandler,
    BinaryUploadFailed,
    Boolean,
    CancelRequest,
    ChannelOptions,
    Characters,
    ClientMessage,
    CloudMetadata,
    Command,
    CommandConfirmation,
    CommandConfirmationResponse,
    CommandExecution,
    CommandExecutionInfo,
    CommandExecutionNotAccepted,
    CommandExecutionNotFinished,
    CommandExecutionRequest,
    CommandExecutionResponse,
    CommandExecutionStatus,
    CommandExecutionUUID,
    CommandIdentifier,
    CommandParameter,
    CommandResponseRequest,
    Constrained,
    Constraint,
    ContentType,
    ContentTypeParameter,
    Context,
    ContextProxy,
    ConversionError,
    Convertable,
    CreateBinaryRequest,
    CreateBinaryResponse,
    CreateBinaryUploadRequest,
    Custom,
    DataType,
    DataTypeIdentifier,
    Date,
    DecodeError,
    DefinedExecutionError,
    DeleteBinaryRequest,
    DeleteBinaryResponse,
    Deserializer,
    DownloadChunkRequest,
    DownloadChunkResponse,
    Duration,
    Element,
    ElementCount,
    EncodeError,
    EndDocument,
    EndElement,
    ErrorIdentifier,
    Feature,
    FeatureIdentifier,
    FrameworkError,
    FrameworkErrorType,
    FullyQualifiedIdentifier,
    GetBinaryInfoRequest,
    GetBinaryInfoResponse,
    Handler,
    Integer,
    IntermediateResponseIdentifier,
    InvalidBinaryTransferUUID,
    InvalidCommandExecutionUUID,
    InvalidMetadata,
    Length,
    List,
    MaximalElementCount,
    MaximalExclusive,
    MaximalInclusive,
    MaximalLength,
    Message,
    Metadata,
    MetadataIdentifier,
    MetadataRequest,
    MetadataResponse,
    MinimalElementCount,
    MinimalExclusive,
    MinimalInclusive,
    MinimalLength,
    Native,
    NoMetadataAllowed,
    ObservableCommand,
    ObservableCommandResponse,
    ObservableProperty,
    ParameterIdentifier,
    ParseError,
    Pattern,
    Property,
    PropertyIdentifier,
    PropertyRequest,
    PropertyResponse,
    Protobuf,
    Reader,
    Real,
    ResponseIdentifier,
    Schema,
    SchemaType,
    Serializable,
    Serializer,
    Server,
    ServerMessage,
    Set,
    SiLAConnectionError,
    SiLAError,
    SIUnit,
    StartElement,
    Stream,
    String,
    Structure,
    Time,
    Timestamp,
    Timezone,
    Token,
    UndefinedExecutionError,
    Unit,
    UnitComponent,
    UnobservableCommand,
    UnobservableCommandResponse,
    UnobservableProperty,
    UploadChunkRequest,
    UploadChunkResponse,
    ValidationError,
    VersionLevel,
    Void,
    WireType,
    Writer,
    check_display_name,
    check_identifier,
    check_uuid,
    check_version,
    create_channel,
    create_server,
)

logging.getLogger(__name__).addHandler(logging.NullHandler())

__version__ = version("unitelabs_sila")

__all__ = [
    "AllowedTypes",
    "Any",
    "BasicType",
    "Binary",
    "BinaryDownloadFailed",
    "BinaryTransfer",
    "BinaryTransferError",
    "BinaryTransferErrorType",
    "BinaryTransferHandler",
    "BinaryUploadFailed",
    "Boolean",
    "CancelRequest",
    "ChannelOptions",
    "Characters",
    "ClientMessage",
    "CloudMetadata",
    "Command",
    "CommandConfirmation",
    "CommandConfirmationResponse",
    "CommandExecution",
    "CommandExecutionInfo",
    "CommandExecutionNotAccepted",
    "CommandExecutionNotFinished",
    "CommandExecutionRequest",
    "CommandExecutionResponse",
    "CommandExecutionStatus",
    "CommandExecutionUUID",
    "CommandIdentifier",
    "CommandParameter",
    "CommandResponseRequest",
    "Constrained",
    "Constraint",
    "ContentType",
    "ContentTypeParameter",
    "Context",
    "ContextProxy",
    "ConversionError",
    "Convertable",
    "CreateBinaryRequest",
    "CreateBinaryResponse",
    "CreateBinaryUploadRequest",
    "Custom",
    "DataType",
    "DataTypeIdentifier",
    "Date",
    "DecodeError",
    "DefinedExecutionError",
    "DeleteBinaryRequest",
    "DeleteBinaryResponse",
    "Deserializer",
    "DownloadChunkRequest",
    "DownloadChunkResponse",
    "Duration",
    "Element",
    "ElementCount",
    "EncodeError",
    "EndDocument",
    "EndElement",
    "ErrorIdentifier",
    "Feature",
    "FeatureIdentifier",
    "FrameworkError",
    "FrameworkErrorType",
    "FullyQualifiedIdentifier",
    "GetBinaryInfoRequest",
    "GetBinaryInfoResponse",
    "Handler",
    "Integer",
    "IntermediateResponseIdentifier",
    "InvalidBinaryTransferUUID",
    "InvalidCommandExecutionUUID",
    "InvalidMetadata",
    "Length",
    "List",
    "MaximalElementCount",
    "MaximalExclusive",
    "MaximalInclusive",
    "MaximalLength",
    "Message",
    "Metadata",
    "MetadataIdentifier",
    "MetadataRequest",
    "MetadataResponse",
    "MinimalElementCount",
    "MinimalExclusive",
    "MinimalInclusive",
    "MinimalLength",
    "Native",
    "NoMetadataAllowed",
    "ObservableCommand",
    "ObservableCommandResponse",
    "ObservableProperty",
    "ParameterIdentifier",
    "ParseError",
    "Pattern",
    "Property",
    "PropertyIdentifier",
    "PropertyRequest",
    "PropertyResponse",
    "Protobuf",
    "Reader",
    "Real",
    "ResponseIdentifier",
    "SIUnit",
    "Schema",
    "SchemaType",
    "Serializable",
    "Serializer",
    "Server",
    "ServerMessage",
    "Set",
    "SiLAConnectionError",
    "SiLAError",
    "StartElement",
    "Stream",
    "String",
    "Structure",
    "Time",
    "Timestamp",
    "Timezone",
    "Token",
    "UndefinedExecutionError",
    "Unit",
    "UnitComponent",
    "UnobservableCommand",
    "UnobservableCommandResponse",
    "UnobservableProperty",
    "UploadChunkRequest",
    "UploadChunkResponse",
    "ValidationError",
    "VersionLevel",
    "Void",
    "WireType",
    "Writer",
    "check_display_name",
    "check_identifier",
    "check_uuid",
    "check_version",
    "create_channel",
    "create_server",
    "server",
]
