Copyright (c) 2019-2020, RTE (https://www.rte-france.com)

See [AUTHORS.txt](AUTHORS.txt)

This Source Code Form is subject to the terms of the Mozilla Public License, version 2.0.

If a copy of the Mozilla Public License, version 2.0 was not distributed with this file,

you can obtain one at http://mozilla.org/MPL/2.0/.

SPDX-License-Identifier: MPL-2.0

This file is part of Grid2Op, Grid2Op a testbed platform to model sequential decision making in power systems.

# Project dependencies

In this file, we try to recap the licenses of the project on which grid2op depends on. This file is NOT a substitute
for the [LICENSE](LICENSE.md) files that presents the terms of the MPLv2.0 license, license under which this
project is released.

## Base package (required)

|    Package |      License     |
|------------|:----------------:|
| numpy      |    [BSD](https://numpy.org/license.html)           |  
| scipy      | [BSD-3-Clause "New"](https://www.scipy.org/scipylib/license.html)  |
| pandas     | [BSD-3-Clause "New"](https://github.com/pandas-dev/pandas/blob/master/LICENSE) |
| pandapower | [BSD 3-Clause "New"](https://pandapower.readthedocs.io/en/v1.4.1/about/license.html)|
| tqdm       |    [MPL 2.0](https://github.com/tqdm/tqdm/blob/master/LICENCE)       | 
| pathlib    |      [MIT](https://en.wikipedia.org/wiki/MIT_License)         |
| networkx   | [BSD 3-Clause "New"](https://networkx.github.io/documentation/networkx-1.10/reference/legal.html)  |
| requests   |[Apache License 2.0](https://github.com/psf/requests/blob/master/LICENSE)|
| imageio    |   [BSD-2-Clause "Simplified"](https://github.com/imageio/imageio/blob/master/LICENSE)   |
| matplotlib |      [PSF](https://matplotlib.org/3.2.1/users/license.html)         |            

## Optional packages

### Extra package (optional)

|    Package    |      License     |
|---------------|:----------------:|
| nbformat      |    [BSD](https://fr.wikipedia.org/wiki/Licence_BSD) |  
| jupyter-client|  [BSD 3-Clause "New"](https://github.com/jupyter/jupyter/blob/master/LICENSE) |
| jyquickhelper |  [MIT](https://github.com/sdpython/jyquickhelper/blob/master/LICENSE.txt) |

### Optional (optional)

|    Package |      License     |
|------------|:----------------:|
| numba   |     [BSD 2-Clause "Simplified"](https://github.com/numba/numba/blob/master/LICENSE)          |  
| plotly      | [MIT](https://github.com/plotly/plotly.js/blob/master/LICENSE)  |
| seaborn     | [BSD 3-Clause "new"](https://github.com/mwaskom/seaborn/blob/master/LICENSE) |
| pygifsicle  |  [MIT](https://en.wikipedia.org/wiki/MIT_License) | 
| psutil      |  [BSD 3-Clause "new"](https://github.com/giampaolo/psutil/blob/master/LICENSE)|

### deprecated (optional)

|    Package |      License     |
|------------|:----------------:|
| pygame   |       [GNU LGPL v2.1](https://www.gnu.org/copyleft/lesser.html)      |  
| imageio-ffmpeg |  [BSD 2-Clause "Simplified"](https://github.com/imageio/imageio-ffmpeg/blob/master/LICENSE)|

### doc (optional)

|    Package |      License     |
|------------|:----------------:|
| numpydoc | [BSD](https://github.com/numpy/numpydoc/blob/master/LICENSE.txt) |
| sphinx  | [BSD](https://github.com/sphinx-doc/sphinx/blob/3.x/LICENSE)|
| sphinx-rtd-theme | [MIT](https://github.com/readthedocs/sphinx_rtd_theme/blob/master/LICENSE) |
| sphinxcontrib-trio | [MIT or Apache 2](https://github.com/python-trio/sphinxcontrib-trio/blob/master/LICENSE) |
| autodocsumm | [GPL v2](https://github.com/Chilipp/autodocsumm/blob/master/LICENSE)|

### challenge (optional)

|    Package |      License     |
|------------|:----------------:|
| tensorflow | [Apache License 2.0](https://github.com/tensorflow/tensorflow/blob/master/LICENSE) |
| Keras | [MIT](https://github.com/keras-team/keras/blob/master/LICENSE) |
| torch | [BSD 3-Clause "New"](https://github.com/intel/torch/blob/master/LICENSE.md)|
| statsmodels | [BSD](https://github.com/statsmodels/statsmodels/blob/master/LICENSE.txt)|
| scikit-learn | [BSD 3-clauses](https://fr.wikipedia.org/wiki/Licence_BSD) |
| gym | [MIT](https://github.com/openai/gym/blob/master/LICENSE.md) |
