# token_data


<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

## Developer Guide

If you are new to using `nbdev` here are some useful pointers to get you
started.

### Install token_data in Development mode

``` sh
# make sure token_data package is installed in development mode
$ pip install -e .

# make changes under nbs/ directory
# ...

# compile to have changes apply to token_data
$ nbdev_prepare
```

## Usage

### Installation

Install latest from the GitHub
[repository](https://github.com/silvaac/token_data):

``` sh
$ pip install git+https://github.com/silvaac/token_data.git
```

or from [pypi](https://pypi.org/project/token_data/)

``` sh
$ pip install token_data
```

### Documentation

Documentation can be found hosted on this GitHub
[repository](https://github.com/silvaac/token_data)’s
[pages](https://silvaac.github.io/token_data/). Additionally you can
find package manager specific guidelines on
[conda](https://anaconda.org/silvaac/token_data) and
[pypi](https://pypi.org/project/token_data/) respectively.

## How to use

Simple example to pull ETH perpetual price history from Hyperliquid. See
documents for more complex use cases.

``` python
from token_data.hyperliquid import *
from hyperliquid.utils import constants
address, info, exchange = setup(base_url=constants.MAINNET_API_URL, skip_ws=True)
manager = HyperliquidPerpManager(ticker='ETH',update=True, save=False, verbose=True,info=info)
manager.get_data()
```

    Running with account address: 0x143E18B563C4aD6913a9D89C774fE69A54F66cAa
    Running with agent address: 0x0486f56Bf31b2E3B880248dAcd1BFf3C8bdC09e0
    Loaded 5791 rows for ETH from ../data/hyperliquid/perp/ETH_1h.parquet
    Updating ETH from 2025-11-14T21:00:00Z
    Retrieved 47 new rows for ETH
    Added 22 new rows for ETH

<div>
<style scoped>
    .dataframe tbody tr th:only-of-type {
        vertical-align: middle;
    }
&#10;    .dataframe tbody tr th {
        vertical-align: top;
    }
&#10;    .dataframe thead th {
        text-align: right;
    }
</style>

|      | datetime            | open   | high   | low    | close  | volume     | coin |
|------|---------------------|--------|--------|--------|--------|------------|------|
| 0    | 2025-03-19 15:00:00 | 2030.7 | 2056.7 | 2026.0 | 2048.7 | 30206.2723 | ETH  |
| 1    | 2025-03-19 16:00:00 | 2048.7 | 2049.2 | 2035.3 | 2047.4 | 22198.4803 | ETH  |
| 2    | 2025-03-19 17:00:00 | 2047.4 | 2048.9 | 2014.3 | 2026.1 | 35909.8007 | ETH  |
| 3    | 2025-03-19 18:00:00 | 2026.1 | 2059.9 | 1998.0 | 2045.0 | 84148.3569 | ETH  |
| 4    | 2025-03-19 19:00:00 | 2045.1 | 2052.1 | 2020.1 | 2029.7 | 38921.5619 | ETH  |
| ...  | ...                 | ...    | ...    | ...    | ...    | ...        | ...  |
| 5808 | 2025-11-16 15:00:00 | 3172.9 | 3181.5 | 3099.3 | 3105.8 | 24519.9226 | ETH  |
| 5809 | 2025-11-16 16:00:00 | 3105.9 | 3127.5 | 3057.8 | 3062.0 | 43373.1840 | ETH  |
| 5810 | 2025-11-16 17:00:00 | 3061.5 | 3087.7 | 3027.5 | 3079.9 | 57582.5327 | ETH  |
| 5811 | 2025-11-16 18:00:00 | 3080.3 | 3129.2 | 3045.0 | 3061.1 | 48971.9446 | ETH  |
| 5812 | 2025-11-16 19:00:00 | 3061.3 | 3116.6 | 3057.9 | 3102.2 | 14953.9102 | ETH  |

<p>5813 rows × 7 columns</p>
</div>

For coinbase data (only spot prices are supported):

``` python
from token_data.coinbase import *
# Pull data from coinbase and save it to "./data/coinbase" folder. See function for details.
coinbase_to_file(token_list=['OP-USD'],type="parquet",all_tokens=False)
```

    Processing OP-USD
