# This file was auto-generated by Fern from our API Definition.

# isort: skip_file

import typing
from importlib import import_module

if typing.TYPE_CHECKING:
    from .action import (
        Action,
        Action_AuditLogAccess,
        Action_UserAccountCreation,
        Action_UserAccountDeletion,
        Action_UserAccountModification,
        Action_UserLogin,
        Action_UserLogout,
    )
    from .actor import Actor, Actor_ServiceAccount, Actor_User
    from .audit_event import AuditEvent
    from .audit_event_id import AuditEventId
    from .audit_events_response import AuditEventsResponse
    from .audit_log_access import AuditLogAccess
    from .context import Context
    from .external_user_id import ExternalUserId
    from .get_audit_events_request import GetAuditEventsRequest
    from .group import Group
    from .group_id import GroupId
    from .ip_address import IpAddress
    from .resource import Resource, Resource_Group, Resource_UserAccount
    from .service_account import ServiceAccount
    from .service_account_id import ServiceAccountId
    from .tenant_id import TenantId
    from .user import User
    from .user_account import UserAccount
    from .user_account_creation import UserAccountCreation
    from .user_account_deletion import UserAccountDeletion
    from .user_account_modification import UserAccountModification
    from .user_agent import UserAgent
    from .user_id import UserId
    from .user_login import UserLogin
    from .user_logout import UserLogout
_dynamic_imports: typing.Dict[str, str] = {
    "Action": ".action",
    "Action_AuditLogAccess": ".action",
    "Action_UserAccountCreation": ".action",
    "Action_UserAccountDeletion": ".action",
    "Action_UserAccountModification": ".action",
    "Action_UserLogin": ".action",
    "Action_UserLogout": ".action",
    "Actor": ".actor",
    "Actor_ServiceAccount": ".actor",
    "Actor_User": ".actor",
    "AuditEvent": ".audit_event",
    "AuditEventId": ".audit_event_id",
    "AuditEventsResponse": ".audit_events_response",
    "AuditLogAccess": ".audit_log_access",
    "Context": ".context",
    "ExternalUserId": ".external_user_id",
    "GetAuditEventsRequest": ".get_audit_events_request",
    "Group": ".group",
    "GroupId": ".group_id",
    "IpAddress": ".ip_address",
    "Resource": ".resource",
    "Resource_Group": ".resource",
    "Resource_UserAccount": ".resource",
    "ServiceAccount": ".service_account",
    "ServiceAccountId": ".service_account_id",
    "TenantId": ".tenant_id",
    "User": ".user",
    "UserAccount": ".user_account",
    "UserAccountCreation": ".user_account_creation",
    "UserAccountDeletion": ".user_account_deletion",
    "UserAccountModification": ".user_account_modification",
    "UserAgent": ".user_agent",
    "UserId": ".user_id",
    "UserLogin": ".user_login",
    "UserLogout": ".user_logout",
}


def __getattr__(attr_name: str) -> typing.Any:
    module_name = _dynamic_imports.get(attr_name)
    if module_name is None:
        raise AttributeError(f"No {attr_name} found in _dynamic_imports for module name -> {__name__}")
    try:
        module = import_module(module_name, __package__)
        if module_name == f".{attr_name}":
            return module
        else:
            return getattr(module, attr_name)
    except ImportError as e:
        raise ImportError(f"Failed to import {attr_name} from {module_name}: {e}") from e
    except AttributeError as e:
        raise AttributeError(f"Failed to get {attr_name} from {module_name}: {e}") from e


def __dir__():
    lazy_attrs = list(_dynamic_imports.keys())
    return sorted(lazy_attrs)


__all__ = [
    "Action",
    "Action_AuditLogAccess",
    "Action_UserAccountCreation",
    "Action_UserAccountDeletion",
    "Action_UserAccountModification",
    "Action_UserLogin",
    "Action_UserLogout",
    "Actor",
    "Actor_ServiceAccount",
    "Actor_User",
    "AuditEvent",
    "AuditEventId",
    "AuditEventsResponse",
    "AuditLogAccess",
    "Context",
    "ExternalUserId",
    "GetAuditEventsRequest",
    "Group",
    "GroupId",
    "IpAddress",
    "Resource",
    "Resource_Group",
    "Resource_UserAccount",
    "ServiceAccount",
    "ServiceAccountId",
    "TenantId",
    "User",
    "UserAccount",
    "UserAccountCreation",
    "UserAccountDeletion",
    "UserAccountModification",
    "UserAgent",
    "UserId",
    "UserLogin",
    "UserLogout",
]
