# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from .raw_client import AsyncRawIssuesClient, RawIssuesClient
from .types.issue import Issue
from .types.issue_id import IssueId


class IssuesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawIssuesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawIssuesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawIssuesClient
        """
        return self._raw_client

    def get_issue(self, id: IssueId, *, request_options: typing.Optional[RequestOptions] = None) -> Issue:
        """
        Retrieve an issue from Method using its ID

        Parameters
        ----------
        id : IssueId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Issue

        Examples
        --------
        from method_security import MethodClient

        client = MethodClient(
            base_url="https://yourhost.com/path/to/api",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.v1.issues.get_issue(
            id="ri.method.ontology.issue.8c99d39e-4b5f-331c-8119-7d177fb4f498",
        )
        """
        _response = self._raw_client.get_issue(id, request_options=request_options)
        return _response.data


class AsyncIssuesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawIssuesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawIssuesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawIssuesClient
        """
        return self._raw_client

    async def get_issue(self, id: IssueId, *, request_options: typing.Optional[RequestOptions] = None) -> Issue:
        """
        Retrieve an issue from Method using its ID

        Parameters
        ----------
        id : IssueId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Issue

        Examples
        --------
        import asyncio

        from method_security import AsyncMethodClient

        client = AsyncMethodClient(
            base_url="https://yourhost.com/path/to/api",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.v1.issues.get_issue(
                id="ri.method.ontology.issue.8c99d39e-4b5f-331c-8119-7d177fb4f498",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_issue(id, request_options=request_options)
        return _response.data
