# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ....common.types.environment_id import EnvironmentId
from ....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ....core.serialization import FieldMetadata
from ...objects.types.object_id import ObjectId
from .issue_closed_reason import IssueClosedReason
from .issue_id import IssueId
from .issue_severity import IssueSeverity
from .issue_status import IssueStatus


class Issue(UniversalBaseModel):
    id: IssueId
    environment_id: typing_extensions.Annotated[EnvironmentId, FieldMetadata(alias="environmentId")]
    description: str
    status: IssueStatus
    severity: IssueSeverity
    closed_reason: typing_extensions.Annotated[
        typing.Optional[IssueClosedReason], FieldMetadata(alias="closedReason")
    ] = None
    affected_object_id: typing_extensions.Annotated[ObjectId, FieldMetadata(alias="affectedObjectId")]
    affected_object_title: typing_extensions.Annotated[str, FieldMetadata(alias="affectedObjectTitle")]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
