# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectArtifactArgs', 'ConnectArtifact']

@pulumi.input_type
class ConnectArtifactArgs:
    def __init__(__self__, *,
                 cloud: pulumi.Input[_builtins.str],
                 content_format: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 environment: pulumi.Input['ConnectArtifactEnvironmentArgs'],
                 artifact_file: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ConnectArtifact resource.
        :param pulumi.Input[_builtins.str] cloud: Cloud provider where the Connect Artifact archive is uploaded.
        :param pulumi.Input[_builtins.str] content_format: Archive format of the Connect Artifact. Supported formats are `JAR` and `ZIP`.
        :param pulumi.Input[_builtins.str] display_name: The unique name of the Connect Artifact per cloud, environment scope.
        :param pulumi.Input['ConnectArtifactEnvironmentArgs'] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[_builtins.str] artifact_file: The artifact file for Connect Artifact in `JAR` or `ZIP` format. This can be relative or absolute path
        :param pulumi.Input[_builtins.str] description: Description of the Connect Artifact.
        """
        pulumi.set(__self__, "cloud", cloud)
        pulumi.set(__self__, "content_format", content_format)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "environment", environment)
        if artifact_file is not None:
            pulumi.set(__self__, "artifact_file", artifact_file)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> pulumi.Input[_builtins.str]:
        """
        Cloud provider where the Connect Artifact archive is uploaded.
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cloud", value)

    @_builtins.property
    @pulumi.getter(name="contentFormat")
    def content_format(self) -> pulumi.Input[_builtins.str]:
        """
        Archive format of the Connect Artifact. Supported formats are `JAR` and `ZIP`.
        """
        return pulumi.get(self, "content_format")

    @content_format.setter
    def content_format(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "content_format", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The unique name of the Connect Artifact per cloud, environment scope.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Input['ConnectArtifactEnvironmentArgs']:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input['ConnectArtifactEnvironmentArgs']):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="artifactFile")
    def artifact_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The artifact file for Connect Artifact in `JAR` or `ZIP` format. This can be relative or absolute path
        """
        return pulumi.get(self, "artifact_file")

    @artifact_file.setter
    def artifact_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "artifact_file", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the Connect Artifact.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _ConnectArtifactState:
    def __init__(__self__, *,
                 artifact_file: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 content_format: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input['ConnectArtifactEnvironmentArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ConnectArtifact resources.
        :param pulumi.Input[_builtins.str] artifact_file: The artifact file for Connect Artifact in `JAR` or `ZIP` format. This can be relative or absolute path
        :param pulumi.Input[_builtins.str] cloud: Cloud provider where the Connect Artifact archive is uploaded.
        :param pulumi.Input[_builtins.str] content_format: Archive format of the Connect Artifact. Supported formats are `JAR` and `ZIP`.
        :param pulumi.Input[_builtins.str] description: Description of the Connect Artifact.
        :param pulumi.Input[_builtins.str] display_name: The unique name of the Connect Artifact per cloud, environment scope.
        :param pulumi.Input['ConnectArtifactEnvironmentArgs'] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[_builtins.str] status: Status of the Connect Artifact.
        """
        if artifact_file is not None:
            pulumi.set(__self__, "artifact_file", artifact_file)
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if content_format is not None:
            pulumi.set(__self__, "content_format", content_format)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="artifactFile")
    def artifact_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The artifact file for Connect Artifact in `JAR` or `ZIP` format. This can be relative or absolute path
        """
        return pulumi.get(self, "artifact_file")

    @artifact_file.setter
    def artifact_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "artifact_file", value)

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloud provider where the Connect Artifact archive is uploaded.
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud", value)

    @_builtins.property
    @pulumi.getter(name="contentFormat")
    def content_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Archive format of the Connect Artifact. Supported formats are `JAR` and `ZIP`.
        """
        return pulumi.get(self, "content_format")

    @content_format.setter
    def content_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_format", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the Connect Artifact.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of the Connect Artifact per cloud, environment scope.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['ConnectArtifactEnvironmentArgs']]:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['ConnectArtifactEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the Connect Artifact.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("confluentcloud:index/connectArtifact:ConnectArtifact")
class ConnectArtifact(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_file: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 content_format: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[Union['ConnectArtifactEnvironmentArgs', 'ConnectArtifactEnvironmentArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        example = confluentcloud.ConnectArtifact("example",
            display_name="example-connect-artifact",
            cloud="AWS",
            environment={
                "id": "env-123456",
            },
            content_format="JAR",
            artifact_file="path/to/your/artifact.jar",
            description="Example Connect Artifact")
        ```

        ## Import

        You can import a Connect Artifact by using Environment ID, Cloud, and Connect Artifact ID in the format `<Environment ID>/<cloud>/<Connect Artifact ID>`, for example:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/connectArtifact:ConnectArtifact example env-123456/AWS/ca-123456
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] artifact_file: The artifact file for Connect Artifact in `JAR` or `ZIP` format. This can be relative or absolute path
        :param pulumi.Input[_builtins.str] cloud: Cloud provider where the Connect Artifact archive is uploaded.
        :param pulumi.Input[_builtins.str] content_format: Archive format of the Connect Artifact. Supported formats are `JAR` and `ZIP`.
        :param pulumi.Input[_builtins.str] description: Description of the Connect Artifact.
        :param pulumi.Input[_builtins.str] display_name: The unique name of the Connect Artifact per cloud, environment scope.
        :param pulumi.Input[Union['ConnectArtifactEnvironmentArgs', 'ConnectArtifactEnvironmentArgsDict']] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectArtifactArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        example = confluentcloud.ConnectArtifact("example",
            display_name="example-connect-artifact",
            cloud="AWS",
            environment={
                "id": "env-123456",
            },
            content_format="JAR",
            artifact_file="path/to/your/artifact.jar",
            description="Example Connect Artifact")
        ```

        ## Import

        You can import a Connect Artifact by using Environment ID, Cloud, and Connect Artifact ID in the format `<Environment ID>/<cloud>/<Connect Artifact ID>`, for example:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/connectArtifact:ConnectArtifact example env-123456/AWS/ca-123456
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param ConnectArtifactArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectArtifactArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_file: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 content_format: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[Union['ConnectArtifactEnvironmentArgs', 'ConnectArtifactEnvironmentArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectArtifactArgs.__new__(ConnectArtifactArgs)

            __props__.__dict__["artifact_file"] = artifact_file
            if cloud is None and not opts.urn:
                raise TypeError("Missing required property 'cloud'")
            __props__.__dict__["cloud"] = cloud
            if content_format is None and not opts.urn:
                raise TypeError("Missing required property 'content_format'")
            __props__.__dict__["content_format"] = content_format
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            __props__.__dict__["status"] = None
        super(ConnectArtifact, __self__).__init__(
            'confluentcloud:index/connectArtifact:ConnectArtifact',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            artifact_file: Optional[pulumi.Input[_builtins.str]] = None,
            cloud: Optional[pulumi.Input[_builtins.str]] = None,
            content_format: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            environment: Optional[pulumi.Input[Union['ConnectArtifactEnvironmentArgs', 'ConnectArtifactEnvironmentArgsDict']]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'ConnectArtifact':
        """
        Get an existing ConnectArtifact resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] artifact_file: The artifact file for Connect Artifact in `JAR` or `ZIP` format. This can be relative or absolute path
        :param pulumi.Input[_builtins.str] cloud: Cloud provider where the Connect Artifact archive is uploaded.
        :param pulumi.Input[_builtins.str] content_format: Archive format of the Connect Artifact. Supported formats are `JAR` and `ZIP`.
        :param pulumi.Input[_builtins.str] description: Description of the Connect Artifact.
        :param pulumi.Input[_builtins.str] display_name: The unique name of the Connect Artifact per cloud, environment scope.
        :param pulumi.Input[Union['ConnectArtifactEnvironmentArgs', 'ConnectArtifactEnvironmentArgsDict']] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[_builtins.str] status: Status of the Connect Artifact.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectArtifactState.__new__(_ConnectArtifactState)

        __props__.__dict__["artifact_file"] = artifact_file
        __props__.__dict__["cloud"] = cloud
        __props__.__dict__["content_format"] = content_format
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["environment"] = environment
        __props__.__dict__["status"] = status
        return ConnectArtifact(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="artifactFile")
    def artifact_file(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The artifact file for Connect Artifact in `JAR` or `ZIP` format. This can be relative or absolute path
        """
        return pulumi.get(self, "artifact_file")

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> pulumi.Output[_builtins.str]:
        """
        Cloud provider where the Connect Artifact archive is uploaded.
        """
        return pulumi.get(self, "cloud")

    @_builtins.property
    @pulumi.getter(name="contentFormat")
    def content_format(self) -> pulumi.Output[_builtins.str]:
        """
        Archive format of the Connect Artifact. Supported formats are `JAR` and `ZIP`.
        """
        return pulumi.get(self, "content_format")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the Connect Artifact.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The unique name of the Connect Artifact per cloud, environment scope.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output['outputs.ConnectArtifactEnvironment']:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the Connect Artifact.
        """
        return pulumi.get(self, "status")

