# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CustomConnectorPluginArgs', 'CustomConnectorPlugin']

@pulumi.input_type
class CustomConnectorPluginArgs:
    def __init__(__self__, *,
                 connector_class: pulumi.Input[_builtins.str],
                 connector_type: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 filename: pulumi.Input[_builtins.str],
                 cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 documentation_link: Optional[pulumi.Input[_builtins.str]] = None,
                 sensitive_config_properties: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a CustomConnectorPlugin resource.
        :param pulumi.Input[_builtins.str] connector_class: The Java class or alias for the connector. You can get the connector class from the connector documentation provided by the developer.
        :param pulumi.Input[_builtins.str] connector_type: The type of the Custom Connector Plugin. Accepted values are: `SOURCE`, `SINK`.
        :param pulumi.Input[_builtins.str] display_name: The name of the Custom Connector Plugin.
        :param pulumi.Input[_builtins.str] filename: The path to the Custom Connector Plugin archive to be uploaded. Accepted archive formats are: `.jar`, `.zip`.
        :param pulumi.Input[_builtins.str] cloud: Cloud provider where the Custom Connector Plugin archive is uploaded. Defaults to `AWS`. Accepted values are: `AWS`, `AZURE`, `GCP`.
        :param pulumi.Input[_builtins.str] description: The description of the Custom Connector Plugin.
        :param pulumi.Input[_builtins.str] documentation_link: The documentation link of the Custom Connector Plugin.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sensitive_config_properties: The list of sensitive properties. A sensitive property is a connector configuration property that must be hidden after a user enters the property value when setting up the connector, for example, passwords, keys, and tokens. Refer to the developer documentation and add all required and optional sensitive properties that a user could potentially configure for the connector. Marking a property as sensitive ensures that these fields are handled appropriately within the Confluent infrastructure. This includes masking fields, for example in exception logging, and encrypting field values in the underlying data store. You must identify all sensitive properties. Failure to identify sensitive properties can result in the sensitive property value being stored in plain text rather than in encrypted format. Only add connector-specific sensitive properties. Kafka keys, passwords, and service account information should not be entered here.
        """
        pulumi.set(__self__, "connector_class", connector_class)
        pulumi.set(__self__, "connector_type", connector_type)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "filename", filename)
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if documentation_link is not None:
            pulumi.set(__self__, "documentation_link", documentation_link)
        if sensitive_config_properties is not None:
            pulumi.set(__self__, "sensitive_config_properties", sensitive_config_properties)

    @_builtins.property
    @pulumi.getter(name="connectorClass")
    def connector_class(self) -> pulumi.Input[_builtins.str]:
        """
        The Java class or alias for the connector. You can get the connector class from the connector documentation provided by the developer.
        """
        return pulumi.get(self, "connector_class")

    @connector_class.setter
    def connector_class(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connector_class", value)

    @_builtins.property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the Custom Connector Plugin. Accepted values are: `SOURCE`, `SINK`.
        """
        return pulumi.get(self, "connector_type")

    @connector_type.setter
    def connector_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connector_type", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Custom Connector Plugin.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def filename(self) -> pulumi.Input[_builtins.str]:
        """
        The path to the Custom Connector Plugin archive to be uploaded. Accepted archive formats are: `.jar`, `.zip`.
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "filename", value)

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloud provider where the Custom Connector Plugin archive is uploaded. Defaults to `AWS`. Accepted values are: `AWS`, `AZURE`, `GCP`.
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Custom Connector Plugin.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="documentationLink")
    def documentation_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The documentation link of the Custom Connector Plugin.
        """
        return pulumi.get(self, "documentation_link")

    @documentation_link.setter
    def documentation_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "documentation_link", value)

    @_builtins.property
    @pulumi.getter(name="sensitiveConfigProperties")
    def sensitive_config_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of sensitive properties. A sensitive property is a connector configuration property that must be hidden after a user enters the property value when setting up the connector, for example, passwords, keys, and tokens. Refer to the developer documentation and add all required and optional sensitive properties that a user could potentially configure for the connector. Marking a property as sensitive ensures that these fields are handled appropriately within the Confluent infrastructure. This includes masking fields, for example in exception logging, and encrypting field values in the underlying data store. You must identify all sensitive properties. Failure to identify sensitive properties can result in the sensitive property value being stored in plain text rather than in encrypted format. Only add connector-specific sensitive properties. Kafka keys, passwords, and service account information should not be entered here.
        """
        return pulumi.get(self, "sensitive_config_properties")

    @sensitive_config_properties.setter
    def sensitive_config_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sensitive_config_properties", value)


@pulumi.input_type
class _CustomConnectorPluginState:
    def __init__(__self__, *,
                 cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_class: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 documentation_link: Optional[pulumi.Input[_builtins.str]] = None,
                 filename: Optional[pulumi.Input[_builtins.str]] = None,
                 sensitive_config_properties: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering CustomConnectorPlugin resources.
        :param pulumi.Input[_builtins.str] cloud: Cloud provider where the Custom Connector Plugin archive is uploaded. Defaults to `AWS`. Accepted values are: `AWS`, `AZURE`, `GCP`.
        :param pulumi.Input[_builtins.str] connector_class: The Java class or alias for the connector. You can get the connector class from the connector documentation provided by the developer.
        :param pulumi.Input[_builtins.str] connector_type: The type of the Custom Connector Plugin. Accepted values are: `SOURCE`, `SINK`.
        :param pulumi.Input[_builtins.str] description: The description of the Custom Connector Plugin.
        :param pulumi.Input[_builtins.str] display_name: The name of the Custom Connector Plugin.
        :param pulumi.Input[_builtins.str] documentation_link: The documentation link of the Custom Connector Plugin.
        :param pulumi.Input[_builtins.str] filename: The path to the Custom Connector Plugin archive to be uploaded. Accepted archive formats are: `.jar`, `.zip`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sensitive_config_properties: The list of sensitive properties. A sensitive property is a connector configuration property that must be hidden after a user enters the property value when setting up the connector, for example, passwords, keys, and tokens. Refer to the developer documentation and add all required and optional sensitive properties that a user could potentially configure for the connector. Marking a property as sensitive ensures that these fields are handled appropriately within the Confluent infrastructure. This includes masking fields, for example in exception logging, and encrypting field values in the underlying data store. You must identify all sensitive properties. Failure to identify sensitive properties can result in the sensitive property value being stored in plain text rather than in encrypted format. Only add connector-specific sensitive properties. Kafka keys, passwords, and service account information should not be entered here.
        """
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if connector_class is not None:
            pulumi.set(__self__, "connector_class", connector_class)
        if connector_type is not None:
            pulumi.set(__self__, "connector_type", connector_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if documentation_link is not None:
            pulumi.set(__self__, "documentation_link", documentation_link)
        if filename is not None:
            pulumi.set(__self__, "filename", filename)
        if sensitive_config_properties is not None:
            pulumi.set(__self__, "sensitive_config_properties", sensitive_config_properties)

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloud provider where the Custom Connector Plugin archive is uploaded. Defaults to `AWS`. Accepted values are: `AWS`, `AZURE`, `GCP`.
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud", value)

    @_builtins.property
    @pulumi.getter(name="connectorClass")
    def connector_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Java class or alias for the connector. You can get the connector class from the connector documentation provided by the developer.
        """
        return pulumi.get(self, "connector_class")

    @connector_class.setter
    def connector_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connector_class", value)

    @_builtins.property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the Custom Connector Plugin. Accepted values are: `SOURCE`, `SINK`.
        """
        return pulumi.get(self, "connector_type")

    @connector_type.setter
    def connector_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connector_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Custom Connector Plugin.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Custom Connector Plugin.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="documentationLink")
    def documentation_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The documentation link of the Custom Connector Plugin.
        """
        return pulumi.get(self, "documentation_link")

    @documentation_link.setter
    def documentation_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "documentation_link", value)

    @_builtins.property
    @pulumi.getter
    def filename(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the Custom Connector Plugin archive to be uploaded. Accepted archive formats are: `.jar`, `.zip`.
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filename", value)

    @_builtins.property
    @pulumi.getter(name="sensitiveConfigProperties")
    def sensitive_config_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of sensitive properties. A sensitive property is a connector configuration property that must be hidden after a user enters the property value when setting up the connector, for example, passwords, keys, and tokens. Refer to the developer documentation and add all required and optional sensitive properties that a user could potentially configure for the connector. Marking a property as sensitive ensures that these fields are handled appropriately within the Confluent infrastructure. This includes masking fields, for example in exception logging, and encrypting field values in the underlying data store. You must identify all sensitive properties. Failure to identify sensitive properties can result in the sensitive property value being stored in plain text rather than in encrypted format. Only add connector-specific sensitive properties. Kafka keys, passwords, and service account information should not be entered here.
        """
        return pulumi.get(self, "sensitive_config_properties")

    @sensitive_config_properties.setter
    def sensitive_config_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sensitive_config_properties", value)


@pulumi.type_token("confluentcloud:index/customConnectorPlugin:CustomConnectorPlugin")
class CustomConnectorPlugin(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_class: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 documentation_link: Optional[pulumi.Input[_builtins.str]] = None,
                 filename: Optional[pulumi.Input[_builtins.str]] = None,
                 sensitive_config_properties: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        source = confluentcloud.CustomConnectorPlugin("source",
            display_name="Datagen Source Connector Plugin",
            documentation_link="https://www.confluent.io/hub/confluentinc/kafka-connect-datagen",
            connector_class="io.confluent.kafka.connect.datagen.DatagenConnector",
            connector_type="SOURCE",
            sensitive_config_properties=[],
            filename="confluentinc-kafka-connect-datagen-0.6.2.zip")
        ```

        ## Import

        You can import a Custom Connector Plugin by using a Custom Connector Plugin ID, in the format `<Custom Connector Plugin>`. The following example shows how to import a Custom Connector Plugin:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/customConnectorPlugin:CustomConnectorPlugin main ccp-abc123xyz
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cloud: Cloud provider where the Custom Connector Plugin archive is uploaded. Defaults to `AWS`. Accepted values are: `AWS`, `AZURE`, `GCP`.
        :param pulumi.Input[_builtins.str] connector_class: The Java class or alias for the connector. You can get the connector class from the connector documentation provided by the developer.
        :param pulumi.Input[_builtins.str] connector_type: The type of the Custom Connector Plugin. Accepted values are: `SOURCE`, `SINK`.
        :param pulumi.Input[_builtins.str] description: The description of the Custom Connector Plugin.
        :param pulumi.Input[_builtins.str] display_name: The name of the Custom Connector Plugin.
        :param pulumi.Input[_builtins.str] documentation_link: The documentation link of the Custom Connector Plugin.
        :param pulumi.Input[_builtins.str] filename: The path to the Custom Connector Plugin archive to be uploaded. Accepted archive formats are: `.jar`, `.zip`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sensitive_config_properties: The list of sensitive properties. A sensitive property is a connector configuration property that must be hidden after a user enters the property value when setting up the connector, for example, passwords, keys, and tokens. Refer to the developer documentation and add all required and optional sensitive properties that a user could potentially configure for the connector. Marking a property as sensitive ensures that these fields are handled appropriately within the Confluent infrastructure. This includes masking fields, for example in exception logging, and encrypting field values in the underlying data store. You must identify all sensitive properties. Failure to identify sensitive properties can result in the sensitive property value being stored in plain text rather than in encrypted format. Only add connector-specific sensitive properties. Kafka keys, passwords, and service account information should not be entered here.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomConnectorPluginArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        source = confluentcloud.CustomConnectorPlugin("source",
            display_name="Datagen Source Connector Plugin",
            documentation_link="https://www.confluent.io/hub/confluentinc/kafka-connect-datagen",
            connector_class="io.confluent.kafka.connect.datagen.DatagenConnector",
            connector_type="SOURCE",
            sensitive_config_properties=[],
            filename="confluentinc-kafka-connect-datagen-0.6.2.zip")
        ```

        ## Import

        You can import a Custom Connector Plugin by using a Custom Connector Plugin ID, in the format `<Custom Connector Plugin>`. The following example shows how to import a Custom Connector Plugin:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/customConnectorPlugin:CustomConnectorPlugin main ccp-abc123xyz
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param CustomConnectorPluginArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomConnectorPluginArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_class: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 documentation_link: Optional[pulumi.Input[_builtins.str]] = None,
                 filename: Optional[pulumi.Input[_builtins.str]] = None,
                 sensitive_config_properties: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomConnectorPluginArgs.__new__(CustomConnectorPluginArgs)

            __props__.__dict__["cloud"] = cloud
            if connector_class is None and not opts.urn:
                raise TypeError("Missing required property 'connector_class'")
            __props__.__dict__["connector_class"] = connector_class
            if connector_type is None and not opts.urn:
                raise TypeError("Missing required property 'connector_type'")
            __props__.__dict__["connector_type"] = connector_type
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["documentation_link"] = documentation_link
            if filename is None and not opts.urn:
                raise TypeError("Missing required property 'filename'")
            __props__.__dict__["filename"] = filename
            __props__.__dict__["sensitive_config_properties"] = sensitive_config_properties
        super(CustomConnectorPlugin, __self__).__init__(
            'confluentcloud:index/customConnectorPlugin:CustomConnectorPlugin',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud: Optional[pulumi.Input[_builtins.str]] = None,
            connector_class: Optional[pulumi.Input[_builtins.str]] = None,
            connector_type: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            documentation_link: Optional[pulumi.Input[_builtins.str]] = None,
            filename: Optional[pulumi.Input[_builtins.str]] = None,
            sensitive_config_properties: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'CustomConnectorPlugin':
        """
        Get an existing CustomConnectorPlugin resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cloud: Cloud provider where the Custom Connector Plugin archive is uploaded. Defaults to `AWS`. Accepted values are: `AWS`, `AZURE`, `GCP`.
        :param pulumi.Input[_builtins.str] connector_class: The Java class or alias for the connector. You can get the connector class from the connector documentation provided by the developer.
        :param pulumi.Input[_builtins.str] connector_type: The type of the Custom Connector Plugin. Accepted values are: `SOURCE`, `SINK`.
        :param pulumi.Input[_builtins.str] description: The description of the Custom Connector Plugin.
        :param pulumi.Input[_builtins.str] display_name: The name of the Custom Connector Plugin.
        :param pulumi.Input[_builtins.str] documentation_link: The documentation link of the Custom Connector Plugin.
        :param pulumi.Input[_builtins.str] filename: The path to the Custom Connector Plugin archive to be uploaded. Accepted archive formats are: `.jar`, `.zip`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sensitive_config_properties: The list of sensitive properties. A sensitive property is a connector configuration property that must be hidden after a user enters the property value when setting up the connector, for example, passwords, keys, and tokens. Refer to the developer documentation and add all required and optional sensitive properties that a user could potentially configure for the connector. Marking a property as sensitive ensures that these fields are handled appropriately within the Confluent infrastructure. This includes masking fields, for example in exception logging, and encrypting field values in the underlying data store. You must identify all sensitive properties. Failure to identify sensitive properties can result in the sensitive property value being stored in plain text rather than in encrypted format. Only add connector-specific sensitive properties. Kafka keys, passwords, and service account information should not be entered here.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomConnectorPluginState.__new__(_CustomConnectorPluginState)

        __props__.__dict__["cloud"] = cloud
        __props__.__dict__["connector_class"] = connector_class
        __props__.__dict__["connector_type"] = connector_type
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["documentation_link"] = documentation_link
        __props__.__dict__["filename"] = filename
        __props__.__dict__["sensitive_config_properties"] = sensitive_config_properties
        return CustomConnectorPlugin(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> pulumi.Output[_builtins.str]:
        """
        Cloud provider where the Custom Connector Plugin archive is uploaded. Defaults to `AWS`. Accepted values are: `AWS`, `AZURE`, `GCP`.
        """
        return pulumi.get(self, "cloud")

    @_builtins.property
    @pulumi.getter(name="connectorClass")
    def connector_class(self) -> pulumi.Output[_builtins.str]:
        """
        The Java class or alias for the connector. You can get the connector class from the connector documentation provided by the developer.
        """
        return pulumi.get(self, "connector_class")

    @_builtins.property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the Custom Connector Plugin. Accepted values are: `SOURCE`, `SINK`.
        """
        return pulumi.get(self, "connector_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Custom Connector Plugin.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Custom Connector Plugin.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="documentationLink")
    def documentation_link(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The documentation link of the Custom Connector Plugin.
        """
        return pulumi.get(self, "documentation_link")

    @_builtins.property
    @pulumi.getter
    def filename(self) -> pulumi.Output[_builtins.str]:
        """
        The path to the Custom Connector Plugin archive to be uploaded. Accepted archive formats are: `.jar`, `.zip`.
        """
        return pulumi.get(self, "filename")

    @_builtins.property
    @pulumi.getter(name="sensitiveConfigProperties")
    def sensitive_config_properties(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of sensitive properties. A sensitive property is a connector configuration property that must be hidden after a user enters the property value when setting up the connector, for example, passwords, keys, and tokens. Refer to the developer documentation and add all required and optional sensitive properties that a user could potentially configure for the connector. Marking a property as sensitive ensures that these fields are handled appropriately within the Confluent infrastructure. This includes masking fields, for example in exception logging, and encrypting field values in the underlying data store. You must identify all sensitive properties. Failure to identify sensitive properties can result in the sensitive property value being stored in plain text rather than in encrypted format. Only add connector-specific sensitive properties. Kafka keys, passwords, and service account information should not be entered here.
        """
        return pulumi.get(self, "sensitive_config_properties")

