# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DnsRecordArgs', 'DnsRecord']

@pulumi.input_type
class DnsRecordArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[_builtins.str],
                 environment: pulumi.Input['DnsRecordEnvironmentArgs'],
                 gateway: pulumi.Input['DnsRecordGatewayArgs'],
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_access_point: Optional[pulumi.Input['DnsRecordPrivateLinkAccessPointArgs']] = None):
        """
        The set of arguments for constructing a DnsRecord resource.
        :param pulumi.Input[_builtins.str] domain: The fully qualified domain name of the DNS Record.
        :param pulumi.Input['DnsRecordEnvironmentArgs'] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[_builtins.str] display_name: The name of the DNS Record.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "gateway", gateway)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if private_link_access_point is not None:
            pulumi.set(__self__, "private_link_access_point", private_link_access_point)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Input[_builtins.str]:
        """
        The fully qualified domain name of the DNS Record.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Input['DnsRecordEnvironmentArgs']:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input['DnsRecordEnvironmentArgs']):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> pulumi.Input['DnsRecordGatewayArgs']:
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: pulumi.Input['DnsRecordGatewayArgs']):
        pulumi.set(self, "gateway", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the DNS Record.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkAccessPoint")
    def private_link_access_point(self) -> Optional[pulumi.Input['DnsRecordPrivateLinkAccessPointArgs']]:
        return pulumi.get(self, "private_link_access_point")

    @private_link_access_point.setter
    def private_link_access_point(self, value: Optional[pulumi.Input['DnsRecordPrivateLinkAccessPointArgs']]):
        pulumi.set(self, "private_link_access_point", value)


@pulumi.input_type
class _DnsRecordState:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input['DnsRecordEnvironmentArgs']] = None,
                 gateway: Optional[pulumi.Input['DnsRecordGatewayArgs']] = None,
                 private_link_access_point: Optional[pulumi.Input['DnsRecordPrivateLinkAccessPointArgs']] = None):
        """
        Input properties used for looking up and filtering DnsRecord resources.
        :param pulumi.Input[_builtins.str] display_name: The name of the DNS Record.
        :param pulumi.Input[_builtins.str] domain: The fully qualified domain name of the DNS Record.
        :param pulumi.Input['DnsRecordEnvironmentArgs'] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if private_link_access_point is not None:
            pulumi.set(__self__, "private_link_access_point", private_link_access_point)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the DNS Record.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified domain name of the DNS Record.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['DnsRecordEnvironmentArgs']]:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['DnsRecordEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input['DnsRecordGatewayArgs']]:
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input['DnsRecordGatewayArgs']]):
        pulumi.set(self, "gateway", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkAccessPoint")
    def private_link_access_point(self) -> Optional[pulumi.Input['DnsRecordPrivateLinkAccessPointArgs']]:
        return pulumi.get(self, "private_link_access_point")

    @private_link_access_point.setter
    def private_link_access_point(self, value: Optional[pulumi.Input['DnsRecordPrivateLinkAccessPointArgs']]):
        pulumi.set(self, "private_link_access_point", value)


@pulumi.type_token("confluentcloud:index/dnsRecord:DnsRecord")
class DnsRecord(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[Union['DnsRecordEnvironmentArgs', 'DnsRecordEnvironmentArgsDict']]] = None,
                 gateway: Optional[pulumi.Input[Union['DnsRecordGatewayArgs', 'DnsRecordGatewayArgsDict']]] = None,
                 private_link_access_point: Optional[pulumi.Input[Union['DnsRecordPrivateLinkAccessPointArgs', 'DnsRecordPrivateLinkAccessPointArgsDict']]] = None,
                 __props__=None):
        """
        [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

        `DnsRecord` provides a DNS Record resource that enables creating, editing, and deleting DNS Records on Confluent Cloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        development = confluentcloud.Environment("development", display_name="Development")
        main = confluentcloud.DnsRecord("main",
            display_name="dns_record",
            environment={
                "id": development.id,
            },
            domain="example.com",
            gateway={
                "id": main_confluent_network["gateway"][0]["id"],
            },
            private_link_access_point={
                "id": main_confluent_access_point["id"],
            })
        ```

        ## Import

        You can import a DNS Record by using Environment ID and DNS Record ID, in the format `<Environment ID>/<DNS Record ID>`. The following example shows how to import a DNS Record:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/dnsRecord:DnsRecord main env-abc123/dnsrec-abc123
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: The name of the DNS Record.
        :param pulumi.Input[_builtins.str] domain: The fully qualified domain name of the DNS Record.
        :param pulumi.Input[Union['DnsRecordEnvironmentArgs', 'DnsRecordEnvironmentArgsDict']] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DnsRecordArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

        `DnsRecord` provides a DNS Record resource that enables creating, editing, and deleting DNS Records on Confluent Cloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        development = confluentcloud.Environment("development", display_name="Development")
        main = confluentcloud.DnsRecord("main",
            display_name="dns_record",
            environment={
                "id": development.id,
            },
            domain="example.com",
            gateway={
                "id": main_confluent_network["gateway"][0]["id"],
            },
            private_link_access_point={
                "id": main_confluent_access_point["id"],
            })
        ```

        ## Import

        You can import a DNS Record by using Environment ID and DNS Record ID, in the format `<Environment ID>/<DNS Record ID>`. The following example shows how to import a DNS Record:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/dnsRecord:DnsRecord main env-abc123/dnsrec-abc123
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param DnsRecordArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DnsRecordArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[Union['DnsRecordEnvironmentArgs', 'DnsRecordEnvironmentArgsDict']]] = None,
                 gateway: Optional[pulumi.Input[Union['DnsRecordGatewayArgs', 'DnsRecordGatewayArgsDict']]] = None,
                 private_link_access_point: Optional[pulumi.Input[Union['DnsRecordPrivateLinkAccessPointArgs', 'DnsRecordPrivateLinkAccessPointArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DnsRecordArgs.__new__(DnsRecordArgs)

            __props__.__dict__["display_name"] = display_name
            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            if gateway is None and not opts.urn:
                raise TypeError("Missing required property 'gateway'")
            __props__.__dict__["gateway"] = gateway
            __props__.__dict__["private_link_access_point"] = private_link_access_point
        super(DnsRecord, __self__).__init__(
            'confluentcloud:index/dnsRecord:DnsRecord',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            environment: Optional[pulumi.Input[Union['DnsRecordEnvironmentArgs', 'DnsRecordEnvironmentArgsDict']]] = None,
            gateway: Optional[pulumi.Input[Union['DnsRecordGatewayArgs', 'DnsRecordGatewayArgsDict']]] = None,
            private_link_access_point: Optional[pulumi.Input[Union['DnsRecordPrivateLinkAccessPointArgs', 'DnsRecordPrivateLinkAccessPointArgsDict']]] = None) -> 'DnsRecord':
        """
        Get an existing DnsRecord resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: The name of the DNS Record.
        :param pulumi.Input[_builtins.str] domain: The fully qualified domain name of the DNS Record.
        :param pulumi.Input[Union['DnsRecordEnvironmentArgs', 'DnsRecordEnvironmentArgsDict']] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DnsRecordState.__new__(_DnsRecordState)

        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["domain"] = domain
        __props__.__dict__["environment"] = environment
        __props__.__dict__["gateway"] = gateway
        __props__.__dict__["private_link_access_point"] = private_link_access_point
        return DnsRecord(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the DNS Record.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified domain name of the DNS Record.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output['outputs.DnsRecordEnvironment']:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> pulumi.Output['outputs.DnsRecordGateway']:
        return pulumi.get(self, "gateway")

    @_builtins.property
    @pulumi.getter(name="privateLinkAccessPoint")
    def private_link_access_point(self) -> pulumi.Output[Optional['outputs.DnsRecordPrivateLinkAccessPoint']]:
        return pulumi.get(self, "private_link_access_point")

